/*  ksx1001.h - tables for Unicode to EUC-KR (KS X 1001), generated by "backend/tools/gen_eci_mb_h.php"
    from "https://unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/KSC/KSX1001.TXT" */
/*
    libzint - the open source barcode library
    Copyright (C) 2021-2022 Robin Stuart <rstuart114@gmail.com>

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the project nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
    OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
 */
/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef Z_KSX1001_H
#define Z_KSX1001_H

/* Unicode usage bit-flags for URO (U+4E00-U+9FFF) block */
static const unsigned short ksx1001_uro_u[1306] = {
    0x2F8B, 0x4372, 0x2000, 0x0B04, 0xE82C, 0xE340, 0x2800, 0x40C8,
    0x5944, 0x4937, 0x7976, 0x0440, 0x2C93, 0xA3F0, 0x0038, 0x08C5,
    0xEE02, 0x0003, 0x8000, 0x3550, 0xE1C8, 0x1E23, 0x8200, 0xC449,
    0xAD5A, 0x2942, 0xC000, 0x8060, 0x461C, 0xA49A, 0xC003, 0x052A,
    0x2A44, 0xD646, 0x3DDA, 0x0800, 0x8388, 0x1420, 0x0020, 0x0170,
    0x2021, 0x0302, 0x3000, 0x40AC, 0x8620, 0x4462, 0x20A0, 0x8A00,
    0x0253, 0x8004, 0x0402, 0x1484, 0x7BFB, 0x1004, 0x7FA4, 0x11E2,
    0x2441, 0x00A4, 0x1421, 0x20C0, 0x3A50, 0x7000, 0x0002, 0x2743,
    0x45C9, 0x2082, 0x4630, 0x0FC1, 0x3C88, 0x2850, 0x8602, 0xA024,
    0x2388, 0x8806, 0x0E19, 0x4000, 0x22AA, 0xEB64, 0x001C, 0xCD28,
    0xA120, 0x02E1, 0x840B, 0x8200, 0x279B, 0x549E, 0x8141, 0xA0B3,
    0x0010, 0x8508, 0x2061, 0x0800, 0x2F08, 0x08D0, 0xBE3E, 0x010F,
    0xF718, 0xA803, 0x0A41, 0x5B08, 0x0504, 0x0002, 0x0500, 0x382A,
    0x5041, 0x0001, 0x1910, 0x2108, 0x0313, 0x0000, 0x6122, 0x0404,
    0x40D0, 0x1001, 0x8000, 0x4022, 0x8050, 0x4048, 0x0008, 0x1000,
    0x06D1, 0x3700, 0x5E80, 0x0000, 0x00A0, 0x9410, 0x0018, 0x6000,
    0x0240, 0x0090, 0x8000, 0x0054, 0x0000, 0x0008, 0x0900, 0x0010,
    0x0040, 0x0000, 0x5020, 0x1010, 0x2400, 0x4C02, 0x0001, 0x0601,
    0x2918, 0x814C, 0x2100, 0x0801, 0x6485, 0x0003, 0x4452, 0x1021,
    0x0904, 0x0008, 0x000D, 0x0000, 0x4988, 0x8000, 0x0001, 0x1691,
    0x0765, 0x4000, 0x8492, 0x0433, 0x8C00, 0x4592, 0x0016, 0x5220,
    0x0228, 0xD008, 0x4300, 0x4C08, 0x40A2, 0xC32A, 0x9810, 0x2E00,
    0x8000, 0x1670, 0x6E84, 0x4082, 0xC390, 0x04B3, 0x7C85, 0x2118,
    0x041C, 0x02C8, 0x1120, 0x4A00, 0x0A48, 0x361B, 0x5540, 0x8900,
    0x000A, 0x9902, 0x0221, 0x1040, 0x0242, 0x0400, 0x0044, 0x0000,
    0x0000, 0x0C04, 0x0010, 0x0000, 0x1216, 0x0000, 0x0242, 0x0000,
    0x1A20, 0x0040, 0x0400, 0x0000, 0x0009, 0xB5B3, 0x0A18, 0x1523,
    0x9BA0, 0x1FE8, 0x507C, 0x8379, 0x10FD, 0xC09D, 0xDBF6, 0x0560,
    0xEF92, 0x0242, 0x0110, 0xDF02, 0x6961, 0x0822, 0x9035, 0x0202,
    0x0000, 0x0003, 0x1A02, 0x45AA, 0x0001, 0x0200, 0x8101, 0x2851,
    0x6080, 0x02D2, 0x0280, 0x0000, 0x1800, 0x0001, 0x9200, 0x0000,
    0x0880, 0x2000, 0x0405, 0x3500, 0x2000, 0x6044, 0x49E6, 0x609E,
    0x104C, 0x2A42, 0x2820, 0xA148, 0x10B1, 0x8020, 0x000E, 0x7B9C,
    0x8490, 0x14A0, 0x28C1, 0x41E0, 0x0704, 0x8C49, 0x100D, 0x0CC8,
    0x8412, 0x89BA, 0x02C0, 0x1422, 0x5500, 0x0AC0, 0x3EC4, 0x9283,
    0x1CA3, 0x4387, 0x4703, 0x22A0, 0x3028, 0x03C0, 0x0801, 0xA020,
    0x8000, 0x3044, 0x85A3, 0x0000, 0x200E, 0x2225, 0xB73C, 0x0001,
    0x3220, 0x8C50, 0x0099, 0x315D, 0x00A0, 0x9402, 0x0003, 0x0E4B,
    0xE342, 0x8C20, 0x0080, 0xD091, 0x1D94, 0xA328, 0x499C, 0x60C1,
    0x4406, 0x0713, 0x5A90, 0x4444, 0x0F88, 0x0000, 0x0040, 0x95C4,
    0x7581, 0x8447, 0x4402, 0xC053, 0x2B83, 0x0108, 0x4000, 0x9242,
    0x0611, 0x09A6, 0x0800, 0x3222, 0xB384, 0x1BDD, 0xF000, 0xC08A,
    0x0282, 0x0002, 0x8800, 0x6C00, 0x9200, 0x0021, 0x4180, 0x8C84,
    0x1308, 0x0944, 0x07A7, 0x0000, 0x8051, 0x0C41, 0x6002, 0x00D0,
    0xA000, 0x10D0, 0x3004, 0x4400, 0x0000, 0x0100, 0x8201, 0x0700,
    0x0100, 0x440E, 0x6830, 0x0805, 0x64B2, 0x0514, 0x10E6, 0x4414,
    0x0011, 0x2100, 0x9C08, 0xCBC0, 0xE120, 0x40C2, 0x304C, 0x41B4,
    0x10AC, 0x9A83, 0x98B2, 0x3281, 0x9822, 0x0084, 0x3369, 0xBC12,
    0xD6C0, 0xC03B, 0xA1A1, 0x0C53, 0x8A1E, 0xEA00, 0xCBF0, 0x05D8,
    0x4390, 0x21C3, 0x4805, 0x4A1C, 0x02D0, 0x3240, 0x0041, 0xD79D,
    0x2B09, 0xE8B0, 0x7DC0, 0x2452, 0xC240, 0xD04B, 0xA000, 0xC8AB,
    0x8A80, 0x34A9, 0x8000, 0x41C9, 0x8010, 0x241F, 0x9200, 0x487B,
    0x0000, 0x00CC, 0x8406, 0x3300, 0x410F, 0x001B, 0x2000, 0x8040,
    0x8022, 0xA098, 0xA186, 0x006B, 0x2A30, 0x85A4, 0x4181, 0x0604,
    0x6021, 0x0004, 0x0080, 0xA001, 0x0400, 0x46B8, 0xE90F, 0x03A0,
    0x0000, 0x1820, 0x40A0, 0x0810, 0x380A, 0x0001, 0x0500, 0xA800,
    0x0404, 0xC28A, 0x000A, 0x2720, 0x0910, 0x830C, 0x0802, 0x0000,
    0x6211, 0x1080, 0x000C, 0x0808, 0x000C, 0x0C08, 0x0000, 0x0840,
    0x1410, 0x0044, 0x000B, 0x6404, 0x50C0, 0x8001, 0x047E, 0x8984,
    0x0658, 0x4140, 0xC000, 0x94A4, 0xA862, 0x09DC, 0x1800, 0x0000,
    0x8100, 0x000A, 0x0008, 0x4190, 0x4007, 0xE4A1, 0x2501, 0x6445,
    0x11EE, 0x0E7D, 0x4800, 0xFB08, 0x1616, 0x08A8, 0xC92E, 0x0009,
    0x1800, 0x4A82, 0x06A0, 0x6B64, 0x0002, 0x1600, 0x5648, 0x8390,
    0x73A0, 0x002A, 0x8000, 0x0024, 0x88F9, 0x4702, 0x4D02, 0x0FAA,
    0x0000, 0x8E80, 0xB87B, 0x7554, 0x2418, 0xD940, 0xC880, 0x040C,
    0x0000, 0xB041, 0x8C24, 0x0442, 0x5A34, 0x001A, 0x8000, 0xC110,
    0x8046, 0x0032, 0x180D, 0x8106, 0x0002, 0xCD92, 0x6014, 0x7401,
    0x6112, 0x0091, 0xC098, 0x420A, 0x040F, 0x8420, 0x9A13, 0x4002,
    0x8A62, 0xFD22, 0x8188, 0x4080, 0x1000, 0x2103, 0x0808, 0x3101,
    0x4420, 0x0704, 0xB812, 0x0388, 0x8900, 0xA300, 0x0000, 0x2202,
    0x1210, 0x4600, 0x0042, 0x0041, 0x5680, 0x5241, 0x52F0, 0x2000,
    0x8610, 0x8214, 0x1004, 0x4602, 0x430A, 0x8035, 0x60E0, 0xD800,
    0x0041, 0x0801, 0x3400, 0x6C65, 0x11C1, 0xAB04, 0x0286, 0x2204,
    0x0003, 0x0000, 0x9084, 0x0000, 0x4015, 0x0281, 0x0202, 0x3300,
    0x0400, 0x3840, 0x0E20, 0xC0C0, 0x0030, 0x0085, 0x0500, 0x0D25,
    0x4AD0, 0x81D0, 0x2280, 0x020C, 0xB605, 0x6240, 0x2679, 0x6280,
    0x02EA, 0x0808, 0xDD67, 0x8579, 0x081B, 0xDEA0, 0x8735, 0x4000,
    0x0A8C, 0xD100, 0x05AA, 0xA225, 0x8440, 0x1510, 0x404D, 0x0080,
    0x0012, 0x8D22, 0x1968, 0x058F, 0x9080, 0x3A1A, 0x8464, 0x8561,
    0xCCC0, 0x2002, 0x0820, 0x732E, 0x20A4, 0x0B34, 0x0004, 0x1415,
    0x2001, 0x8200, 0x0057, 0x0800, 0x5004, 0x0044, 0x1212, 0x7905,
    0x40D0, 0x0009, 0x4000, 0x8400, 0x054C, 0xD844, 0x409A, 0x5114,
    0x0B12, 0x4000, 0x0201, 0x1580, 0x2001, 0x0800, 0x084A, 0xC200,
    0x0800, 0x4002, 0x3020, 0x9809, 0x0000, 0x1880, 0xE22C, 0x0008,
    0x0004, 0x0004, 0x10E0, 0x0014, 0x8020, 0x2000, 0x9800, 0x1000,
    0x7082, 0x0082, 0x0288, 0x1C00, 0x4C22, 0x0001, 0x9100, 0x0820,
    0x4002, 0x0040, 0x1C00, 0x4400, 0x0383, 0x7CC1, 0x2121, 0x8400,
    0xE002, 0x0002, 0x44C0, 0xE20A, 0x0E03, 0x8126, 0x02D0, 0x0800,
    0x2921, 0x9690, 0x4001, 0xB8C2, 0x6241, 0x0080, 0x0A06, 0xA651,
    0x0112, 0x812C, 0xC600, 0x0400, 0x0CB0, 0xA280, 0xA429, 0x8640,
    0x8000, 0x4A02, 0x3041, 0x0200, 0xBA40, 0x0057, 0x5001, 0x2020,
    0x8880, 0x24B0, 0x2002, 0x0112, 0x02D3, 0x0004, 0x0211, 0x0000,
    0x0080, 0x4004, 0x0C82, 0xE000, 0x3008, 0x0000, 0x1011, 0x0008,
    0x0208, 0x81A4, 0x40A0, 0x420E, 0x0400, 0xC040, 0x0081, 0x4800,
    0x2DF5, 0x0F91, 0xD807, 0x0629, 0x007C, 0x4001, 0x4546, 0x824E,
    0xC000, 0x1008, 0x3005, 0xED36, 0x0C80, 0x6540, 0x930B, 0x0810,
    0x0600, 0xE820, 0xC80A, 0x6082, 0x00CA, 0x4034, 0x2E02, 0x1201,
    0x9004, 0x1948, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0540, 0x1000, 0x0031, 0x4C00, 0x02A5,
    0x5520, 0x4410, 0x0310, 0x2304, 0x5422, 0x8034, 0x0A03, 0x1201,
    0x126B, 0x01A1, 0x2000, 0xA048, 0x0448, 0x4540, 0x8000, 0xE08D,
    0x1AF0, 0x2840, 0x8626, 0x0416, 0x5018, 0x4C00, 0x0032, 0x2112,
    0x05E4, 0x0D00, 0x8A08, 0x4200, 0x4800, 0x0033, 0x0860, 0x8703,
    0x8501, 0x3400, 0x0109, 0xE428, 0x2045, 0x8100, 0x25A8, 0x5C18,
    0x35A0, 0xD804, 0x1C02, 0x02E0, 0x00A1, 0x0200, 0xC050, 0x4146,
    0x6800, 0xA604, 0xF260, 0xBB8A, 0x0000, 0xC8B6, 0x00E2, 0x6002,
    0x023E, 0x0080, 0x8900, 0x0372, 0x8681, 0x0006, 0x0000, 0x0888,
    0x4600, 0x4140, 0x0E04, 0x2000, 0x1622, 0x1048, 0x8A00, 0x2217,
    0x7418, 0x0000, 0x1200, 0x2102, 0x0200, 0x0880, 0x984A, 0x0420,
    0x0000, 0x1211, 0x0002, 0x9904, 0x2A55, 0x0402, 0x5000, 0x1010,
    0x0000, 0x459A, 0xB02A, 0xA000, 0x420A, 0x0208, 0x2708, 0x0000,
    0x8090, 0x0812, 0x8740, 0x0401, 0xE202, 0x3020, 0x0630, 0x8C80,
    0x04C4, 0x04C0, 0x2000, 0x8000, 0x4000, 0xD831, 0x0080, 0x0200,
    0x1400, 0x0008, 0x0218, 0x0000, 0x0880, 0x8A10, 0x2010, 0x4000,
    0x010D, 0x1500, 0x0000, 0x0000, 0x4000, 0x80A0, 0x0140, 0x0150,
    0x2004, 0x8000, 0x0004, 0x0408, 0x0010, 0x0000, 0x9001, 0x4A04,
    0x0020, 0x8000, 0x000C, 0x0842, 0x3041, 0x2A8C, 0x090E, 0xC085,
    0x2906, 0x40C4, 0x0800, 0x0010, 0x8006, 0xB230, 0x0102, 0x2138,
    0x0080, 0x030D, 0x0420, 0x0940, 0x0012, 0x8000, 0x0410, 0x8004,
    0x88CA, 0x0048, 0x0602, 0x2404, 0x0001, 0x0004, 0x0008, 0x0110,
    0x550D, 0xA9C8, 0x2428, 0x0C52, 0x0000, 0x4831, 0x624D, 0x022F,
    0x30A0, 0x4128, 0x057B, 0xD205, 0xA894, 0x1844, 0x6CC2, 0x45C2,
    0x4017, 0x2ED1, 0x1901, 0x0208, 0xC202, 0x1500, 0x9040, 0x2091,
    0x0401, 0x044D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8080, 0x1542, 0x0420, 0x0C02, 0x0600,
    0x1404, 0x6000, 0x9F87, 0xB9D9, 0x059F, 0x540A, 0x245D, 0x3810,
    0x25B0, 0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0850, 0x0099,
    0x0420, 0x0200, 0x0108, 0x4408, 0x9840, 0x2800, 0x810A, 0x0008,
    0x8400, 0x4001, 0x0400, 0x0021, 0x0794, 0x8200, 0x0001, 0x0050,
    0x2482, 0x0000, 0x1C00, 0x0000, 0x3C01, 0x8004, 0x0800, 0x4900,
    0x0228, 0xF83C, 0x86C0, 0xCB08, 0x6230, 0xA000, 0x0004, 0x0000,
    0x0000, 0x1800, 0xA148, 0x0007, 0x4024, 0x0012, 0x2C40, 0x2285,
    0xA96F, 0xE6B3, 0x400F, 0x5126, 0x6C86, 0x723B, 0xE20B, 0xB5A4,
    0x859F, 0x0222, 0x854C, 0x0123, 0x0402, 0x4000, 0x2102, 0x2020,
    0x0004, 0x0224, 0x2080, 0x0004, 0x7E00, 0x0004, 0x1604, 0x01A0,
    0x2A80, 0x1004, 0xD800, 0x0032, 0xFA81, 0x3183, 0x0488, 0x0020,
    0x2000, 0x4087, 0x0000, 0x8410, 0x0221, 0x4880, 0x0074, 0x0000,
    0x0029, 0x114A, 0x0000, 0x02C8, 0x9000, 0x0004, 0x0410, 0x1100,
    0x0010, 0xC501, 0xC957, 0x0000, 0x2D00, 0x0810, 0x4000, 0x5020,
    0x1000, 0x0450, 0x3088, 0x0001, 0x0008, 0x4002, 0x0012, 0x0040,
    0x0010, 0x0100, 0x0820, 0x0120, 0x0010, 0x0806, 0x0000, 0xA000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080,
    0x8A09, 0x011E, 0x2138, 0x1802, 0x0480, 0x1070, 0x0006, 0x0000,
    0x0000, 0x1000, 0x4402, 0x8804, 0x3815, 0xF801, 0x041C, 0x21E9,
    0x6C60, 0x1B30, 0x0588, 0x0882, 0x7AF3, 0x1A60, 0x870C, 0x0AC5,
    0x00C1, 0x524A, 0x0080, 0x2205, 0x0114, 0x5042, 0x2206, 0x0490,
    0xA800, 0x0000, 0x2901, 0x0000, 0x0840, 0x1008, 0x0000, 0x8848,
    0x156F, 0x018F, 0x2000, 0x0B01, 0x7040, 0x4510, 0x88A0, 0x0000,
    0x0000, 0x0000, 0x8100, 0x0002, 0x0090, 0x9800, 0xE006, 0x7010,
    0x1608, 0x4109, 0x0101, 0x0000, 0x3A20, 0x0096, 0x0000, 0x0000,
    0x0000, 0x2240, 0x7120, 0x021A, 0x0002, 0xA227, 0x2000, 0x8002,
    0xC102, 0x0200, 0x0800, 0x00C1, 0x2029, 0x8CA0, 0x0624, 0x0000,
    0x0000, 0x0000, 0x0100, 0x0100, 0x0000, 0x0118, 0x4020, 0x0000,
    0x0000, 0x0400, 0x0480, 0x1002, 0x803E, 0x0410, 0x8000, 0x0000,
    0x4000, 0x8002, 0x4800, 0x0000, 0x0200, 0x0040, 0x0110, 0x0000,
    0x2000, 0x0025, 0x0020, 0x0804, 0x0280, 0x0080, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02A0, 0x0058,
    0x0200, 0x0800, 0x0140, 0x0800, 0x0000, 0x2002, 0x1003, 0x0004,
    0x0000, 0x0000, 0x8200, 0x0010, 0x0010, 0x0080, 0x0000, 0x0704,
    0x0000, 0x4400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA220,
    0x0000, 0xA08C, 0x0020, 0x4830, 0x6008, 0x5912, 0x0100, 0x0010,
    0x4180, 0x0008, 0x0001, 0x0800, 0x4C00, 0x8004, 0x1482, 0x0080,
    0x2000, 0x1021,
};

/* Multibyte indexes for URO (U+4E00-U+9FFF) block */
static const unsigned short ksx1001_uro_mb_ind[1306] = {
      889,   898,   905,   906,   910,   917,   923,   925,
      929,   935,   943,   953,   955,   962,   970,   973,
      978,   985,   987,   988,   994,  1001,  1008,  1010,
     1016,  1025,  1030,  1032,  1035,  1041,  1048,  1052,
     1057,  1062,  1070,  1080,  1081,  1086,  1089,  1090,
     1094,  1097,  1100,  1102,  1107,  1111,  1116,  1119,
     1122,  1127,  1129,  1131,  1135,  1148,  1150,  1160,
     1166,  1170,  1173,  1177,  1180,  1186,  1189,  1190,
     1197,  1204,  1207,  1212,  1219,  1225,  1229,  1233,
     1237,  1242,  1246,  1252,  1253,  1259,  1268,  1271,
     1278,  1282,  1287,  1292,  1294,  1303,  1311,  1315,
     1322,  1323,  1327,  1331,  1332,  1338,  1342,  1353,
     1358,  1367,  1372,  1376,  1382,  1385,  1386,  1388,
     1394,  1398,  1399,  1403,  1406,  1411,  1411,  1416,
     1418,  1422,  1424,  1425,  1428,  1431,  1434,  1435,
     1436,  1442,  1447,  1453,  1453,  1455,  1459,  1461,
     1463,  1465,  1467,  1468,  1471,  1471,  1472,  1474,
     1475,  1476,  1476,  1479,  1481,  1483,  1487,  1488,
     1491,  1496,  1501,  1503,  1505,  1511,  1513,  1518,
     1521,  1524,  1525,  1528,  1528,  1533,  1534,  1535,
     1541,  1548,  1549,  1554,  1559,  1562,  1568,  1571,
     1575,  1578,  1582,  1585,  1589,  1593,  1600,  1604,
     1608,  1609,  1615,  1622,  1625,  1631,  1637,  1645,
     1649,  1653,  1657,  1660,  1663,  1667,  1675,  1680,
     1683,  1685,  1690,  1693,  1695,  1698,  1699,  1701,
     1701,  1701,  1704,  1705,  1705,  1710,  1710,  1713,
     1713,  1717,  1718,  1719,  1719,  1721,  1731,  1735,
     1741,  1748,  1757,  1764,  1772,  1780,  1787,  1799,
     1803,  1813,  1816,  1818,  1826,  1833,  1836,  1842,
     1844,  1844,  1846,  1850,  1857,  1858,  1859,  1862,
     1867,  1870,  1875,  1877,  1877,  1879,  1880,  1883,
     1883,  1885,  1886,  1889,  1893,  1894,  1898,  1906,
     1913,  1917,  1922,  1925,  1930,  1935,  1937,  1940,
     1950,  1954,  1958,  1963,  1968,  1972,  1978,  1982,
     1987,  1991,  1999,  2002,  2006,  2010,  2014,  2022,
     2028,  2035,  2042,  2048,  2052,  2056,  2060,  2062,
     2065,  2066,  2070,  2077,  2077,  2081,  2086,  2096,
     2097,  2101,  2106,  2110,  2118,  2120,  2124,  2126,
     2133,  2140,  2144,  2145,  2151,  2158,  2164,  2171,
     2176,  2180,  2186,  2192,  2196,  2202,  2202,  2203,
     2210,  2217,  2223,  2226,  2232,  2239,  2241,  2242,
     2247,  2251,  2257,  2258,  2263,  2270,  2280,  2284,
     2289,  2292,  2293,  2295,  2299,  2302,  2304,  2307,
     2312,  2316,  2320,  2328,  2328,  2332,  2336,  2339,
     2342,  2344,  2348,  2351,  2353,  2353,  2354,  2357,
     2360,  2361,  2366,  2371,  2374,  2381,  2385,  2391,
     2395,  2397,  2399,  2404,  2411,  2416,  2420,  2425,
     2431,  2436,  2443,  2450,  2455,  2460,  2462,  2470,
     2477,  2484,  2491,  2497,  2503,  2510,  2515,  2524,
     2530,  2535,  2541,  2545,  2551,  2555,  2559,  2561,
     2572,  2578,  2585,  2593,  2598,  2602,  2609,  2611,
     2619,  2623,  2630,  2631,  2637,  2639,  2646,  2649,
     2657,  2657,  2661,  2665,  2669,  2675,  2679,  2680,
     2682,  2685,  2690,  2696,  2701,  2706,  2712,  2716,
     2719,  2723,  2724,  2725,  2728,  2729,  2736,  2745,
     2749,  2749,  2752,  2755,  2757,  2762,  2763,  2765,
     2768,  2770,  2776,  2778,  2783,  2786,  2791,  2793,
     2793,  2798,  2800,  2802,  2804,  2806,  2809,  2809,
     2811,  2814,  2816,  2819,  2823,  2827,  2829,  2836,
     2841,  2846,  2849,  2851,  2857,  2863,  2870,  2872,
     2872,  2874,  2876,  2877,  2881,  2885,  2892,  2896,
     2902,  2910,  2919,  2921,  2929,  2935,  2939,  2947,
     2949,  2951,  2956,  2960,  2968,  2969,  2972,  2978,
     2983,  2990,  2993,  2994,  2996,  3004,  3009,  3014,
     3022,  3022,  3027,  3037,  3045,  3049,  3055,  3059,
     3062,  3062,  3067,  3072,  3075,  3082,  3085,  3086,
     3090,  3094,  3097,  3102,  3106,  3107,  3115,  3119,
     3124,  3129,  3132,  3137,  3141,  3146,  3149,  3156,
     3158,  3164,  3173,  3177,  3179,  3180,  3184,  3186,
     3190,  3193,  3197,  3203,  3207,  3210,  3214,  3214,
     3217,  3220,  3223,  3225,  3227,  3232,  3237,  3244,
     3245,  3249,  3253,  3255,  3259,  3264,  3269,  3274,
     3278,  3280,  3282,  3285,  3293,  3298,  3304,  3308,
     3311,  3313,  3313,  3317,  3317,  3321,  3324,  3326,
     3330,  3331,  3335,  3339,  3343,  3345,  3348,  3350,
     3356,  3362,  3367,  3370,  3373,  3380,  3384,  3392,
     3396,  3402,  3404,  3415,  3423,  3428,  3436,  3444,
     3445,  3450,  3454,  3460,  3466,  3469,  3473,  3478,
     3479,  3481,  3487,  3493,  3500,  3503,  3510,  3515,
     3521,  3527,  3529,  3531,  3540,  3544,  3550,  3551,
     3556,  3558,  3560,  3565,  3566,  3569,  3571,  3575,
     3582,  3586,  3588,  3589,  3591,  3596,  3602,  3607,
     3612,  3617,  3618,  3620,  3624,  3626,  3627,  3631,
     3634,  3635,  3637,  3640,  3645,  3645,  3648,  3655,
     3656,  3657,  3658,  3662,  3664,  3666,  3667,  3670,
     3671,  3676,  3678,  3681,  3684,  3689,  3690,  3693,
     3695,  3697,  3698,  3701,  3703,  3708,  3716,  3720,
     3722,  3726,  3727,  3731,  3737,  3742,  3747,  3751,
     3752,  3757,  3763,  3765,  3772,  3777,  3778,  3782,
     3789,  3792,  3797,  3801,  3802,  3807,  3811,  3817,
     3821,  3822,  3826,  3830,  3831,  3837,  3842,  3845,
     3847,  3850,  3855,  3857,  3860,  3866,  3867,  3870,
     3870,  3871,  3873,  3877,  3880,  3883,  3883,  3886,
     3887,  3889,  3894,  3897,  3902,  3903,  3906,  3908,
     3910,  3920,  3927,  3934,  3939,  3944,  3946,  3952,
     3958,  3960,  3962,  3966,  3976,  3979,  3984,  3991,
     3993,  3995,  4000,  4005,  4009,  4013,  4017,  4022,
     4025,  4028,  4033,  4033,  4033,  4033,  4033,  4033,
     4033,  4033,  4033,  4033,  4036,  4037,  4040,  4043,
     4048,  4053,  4056,  4059,  4063,  4068,  4072,  4076,
     4079,  4086,  4090,  4091,  4095,  4098,  4102,  4103,
     4110,  4117,  4120,  4126,  4130,  4134,  4137,  4140,
     4144,  4150,  4153,  4157,  4159,  4161,  4165,  4168,
     4174,  4178,  4181,  4184,  4190,  4194,  4196,  4202,
     4208,  4214,  4219,  4223,  4227,  4230,  4231,  4235,
     4240,  4243,  4248,  4255,  4264,  4264,  4272,  4276,
     4279,  4285,  4286,  4289,  4295,  4300,  4302,  4302,
     4305,  4308,  4311,  4315,  4316,  4321,  4324,  4327,
     4333,  4339,  4339,  4341,  4344,  4345,  4347,  4353,
     4355,  4355,  4359,  4360,  4365,  4372,  4374,  4376,
     4378,  4378,  4385,  4391,  4393,  4397,  4399,  4404,
     4404,  4407,  4410,  4415,  4417,  4422,  4425,  4429,
     4433,  4437,  4440,  4441,  4442,  4443,  4450,  4451,
     4452,  4454,  4455,  4458,  4458,  4460,  4464,  4466,
     4467,  4471,  4474,  4474,  4474,  4475,  4478,  4480,
     4483,  4485,  4486,  4487,  4489,  4490,  4490,  4493,
     4497,  4498,  4499,  4501,  4504,  4508,  4514,  4519,
     4524,  4529,  4533,  4534,  4535,  4538,  4544,  4546,
     4551,  4552,  4557,  4559,  4562,  4564,  4565,  4567,
     4569,  4575,  4577,  4580,  4583,  4584,  4585,  4586,
     4588,  4595,  4602,  4606,  4611,  4611,  4616,  4623,
     4629,  4633,  4637,  4645,  4651,  4657,  4661,  4668,
     4674,  4679,  4687,  4691,  4693,  4697,  4700,  4703,
     4707,  4709,  4714,  4714,  4714,  4714,  4714,  4714,
     4714,  4714,  4714,  4714,  4716,  4721,  4723,  4726,
     4728,  4731,  4733,  4743,  4753,  4761,  4766,  4773,
     4777,  4783,  4785,  4785,  4785,  4785,  4785,  4788,
     4792,  4794,  4795,  4797,  4800,  4804,  4806,  4810,
     4811,  4813,  4815,  4816,  4818,  4824,  4826,  4827,
     4829,  4833,  4833,  4836,  4836,  4841,  4843,  4844,
     4847,  4850,  4859,  4864,  4870,  4875,  4877,  4878,
     4878,  4878,  4880,  4885,  4888,  4891,  4893,  4897,
     4902,  4912,  4922,  4927,  4933,  4940,  4949,  4956,
     4964,  4973,  4976,  4982,  4986,  4988,  4989,  4992,
     4994,  4995,  4998,  5000,  5001,  5007,  5008,  5012,
     5015,  5019,  5021,  5025,  5028,  5036,  5042,  5045,
     5046,  5047,  5052,  5052,  5055,  5058,  5061,  5065,
     5065,  5068,  5073,  5073,  5077,  5079,  5080,  5082,
     5084,  5085,  5090,  5099,  5099,  5103,  5105,  5106,
     5109,  5110,  5113,  5117,  5118,  5119,  5121,  5123,
     5124,  5125,  5126,  5128,  5130,  5131,  5134,  5134,
     5136,  5136,  5136,  5136,  5136,  5136,  5136,  5136,
     5136,  5136,  5136,  5136,  5136,  5136,  5136,  5136,
     5137,  5142,  5147,  5152,  5155,  5157,  5161,  5163,
     5163,  5163,  5164,  5167,  5170,  5176,  5182,  5186,
     5193,  5199,  5205,  5209,  5212,  5223,  5228,  5234,
     5240,  5243,  5249,  5250,  5254,  5257,  5261,  5265,
     5268,  5271,  5271,  5275,  5275,  5277,  5279,  5279,
     5283,  5292,  5298,  5299,  5303,  5307,  5311,  5315,
     5315,  5315,  5315,  5317,  5318,  5320,  5323,  5328,
     5332,  5336,  5340,  5342,  5342,  5347,  5351,  5351,
     5351,  5351,  5354,  5359,  5363,  5364,  5371,  5372,
     5374,  5378,  5379,  5380,  5383,  5387,  5392,  5396,
     5396,  5396,  5396,  5397,  5398,  5398,  5401,  5403,
     5403,  5403,  5404,  5406,  5408,  5414,  5416,  5417,
     5417,  5418,  5420,  5422,  5422,  5423,  5424,  5426,
     5426,  5427,  5430,  5431,  5433,  5435,  5436,  5436,
     5436,  5436,  5436,  5436,  5436,  5436,  5436,  5439,
     5442,  5443,  5444,  5446,  5447,  5447,  5449,  5452,
     5453,  5453,  5453,  5455,  5456,  5457,  5458,  5458,
     5462,  5462,  5464,  5464,  5464,  5464,  5464,  5464,
     5468,  5468,  5473,  5474,  5478,  5481,  5487,  5488,
     5489,  5492,  5493,  5494,  5495,  5498,  5500,  5504,
     5505,  5506,
};

/* Unicode codepoints sorted */
static const unsigned short ksx1001_u[3607] = {
    0x00A1, 0x00A4, 0x00A7, 0x00A8, 0x00AA, 0x00AD, 0x00AE, 0x00B0,
    0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B6, 0x00B7, 0x00B8, 0x00B9,
    0x00BA, 0x00BC, 0x00BD, 0x00BE, 0x00BF, 0x00C6, 0x00D0, 0x00D7,
    0x00D8, 0x00DE, 0x00DF, 0x00E6, 0x00F0, 0x00F7, 0x00F8, 0x00FE,
    0x0111, 0x0126, 0x0127, 0x0131, 0x0132, 0x0133, 0x0138, 0x013F,
    0x0140, 0x0141, 0x0142, 0x0149, 0x014A, 0x014B, 0x0152, 0x0153,
    0x0166, 0x0167, 0x02C7, 0x02D0, 0x02D8, 0x02D9, 0x02DA, 0x02DB,
    0x02DD, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
    0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F,
    0x03A0, 0x03A1, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8,
    0x03A9, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7,
    0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF,
    0x03C0, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8,
    0x03C9, 0x0401, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415,
    0x0416, 0x0417, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D,
    0x041E, 0x041F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425,
    0x0426, 0x0427, 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D,
    0x042E, 0x042F, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435,
    0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D,
    0x043E, 0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445,
    0x0446, 0x0447, 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D,
    0x044E, 0x044F, 0x0451, 0x2015, 0x2018, 0x2019, 0x201C, 0x201D,
    0x2020, 0x2021, 0x2025, 0x2026, 0x2030, 0x2032, 0x2033, 0x203B,
    0x2074, 0x207F, 0x2081, 0x2082, 0x2083, 0x2084, 0x20AC, 0x2103,
    0x2109, 0x2113, 0x2116, 0x2121, 0x2122, 0x2126, 0x212B, 0x2153,
    0x2154, 0x215B, 0x215C, 0x215D, 0x215E, 0x2160, 0x2161, 0x2162,
    0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 0x2170,
    0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178,
    0x2179, 0x2190, 0x2191, 0x2192, 0x2193, 0x2194, 0x2195, 0x2196,
    0x2197, 0x2198, 0x2199, 0x21D2, 0x21D4, 0x2200, 0x2202, 0x2203,
    0x2207, 0x2208, 0x220B, 0x220F, 0x2211, 0x221A, 0x221D, 0x221E,
    0x2220, 0x2225, 0x2227, 0x2228, 0x2229, 0x222A, 0x222B, 0x222C,
    0x222E, 0x2234, 0x2235, 0x223C, 0x223D, 0x2252, 0x2260, 0x2261,
    0x2264, 0x2265, 0x226A, 0x226B, 0x2282, 0x2283, 0x2286, 0x2287,
    0x2299, 0x22A5, 0x2312, 0x2460, 0x2461, 0x2462, 0x2463, 0x2464,
    0x2465, 0x2466, 0x2467, 0x2468, 0x2469, 0x246A, 0x246B, 0x246C,
    0x246D, 0x246E, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479,
    0x247A, 0x247B, 0x247C, 0x247D, 0x247E, 0x247F, 0x2480, 0x2481,
    0x2482, 0x249C, 0x249D, 0x249E, 0x249F, 0x24A0, 0x24A1, 0x24A2,
    0x24A3, 0x24A4, 0x24A5, 0x24A6, 0x24A7, 0x24A8, 0x24A9, 0x24AA,
    0x24AB, 0x24AC, 0x24AD, 0x24AE, 0x24AF, 0x24B0, 0x24B1, 0x24B2,
    0x24B3, 0x24B4, 0x24B5, 0x24D0, 0x24D1, 0x24D2, 0x24D3, 0x24D4,
    0x24D5, 0x24D6, 0x24D7, 0x24D8, 0x24D9, 0x24DA, 0x24DB, 0x24DC,
    0x24DD, 0x24DE, 0x24DF, 0x24E0, 0x24E1, 0x24E2, 0x24E3, 0x24E4,
    0x24E5, 0x24E6, 0x24E7, 0x24E8, 0x24E9, 0x2500, 0x2501, 0x2502,
    0x2503, 0x250C, 0x250D, 0x250E, 0x250F, 0x2510, 0x2511, 0x2512,
    0x2513, 0x2514, 0x2515, 0x2516, 0x2517, 0x2518, 0x2519, 0x251A,
    0x251B, 0x251C, 0x251D, 0x251E, 0x251F, 0x2520, 0x2521, 0x2522,
    0x2523, 0x2524, 0x2525, 0x2526, 0x2527, 0x2528, 0x2529, 0x252A,
    0x252B, 0x252C, 0x252D, 0x252E, 0x252F, 0x2530, 0x2531, 0x2532,
    0x2533, 0x2534, 0x2535, 0x2536, 0x2537, 0x2538, 0x2539, 0x253A,
    0x253B, 0x253C, 0x253D, 0x253E, 0x253F, 0x2540, 0x2541, 0x2542,
    0x2543, 0x2544, 0x2545, 0x2546, 0x2547, 0x2548, 0x2549, 0x254A,
    0x254B, 0x2592, 0x25A0, 0x25A1, 0x25A3, 0x25A4, 0x25A5, 0x25A6,
    0x25A7, 0x25A8, 0x25A9, 0x25B2, 0x25B3, 0x25B6, 0x25B7, 0x25BC,
    0x25BD, 0x25C0, 0x25C1, 0x25C6, 0x25C7, 0x25C8, 0x25CB, 0x25CE,
    0x25CF, 0x25D0, 0x25D1, 0x2605, 0x2606, 0x260E, 0x260F, 0x261C,
    0x261E, 0x2640, 0x2642, 0x2660, 0x2661, 0x2663, 0x2664, 0x2665,
    0x2667, 0x2668, 0x2669, 0x266A, 0x266C, 0x266D, 0x3000, 0x3001,
    0x3002, 0x3003, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D,
    0x300E, 0x300F, 0x3010, 0x3011, 0x3013, 0x3014, 0x3015, 0x3041,
    0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049,
    0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 0x3051,
    0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059,
    0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F, 0x3060, 0x3061,
    0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069,
    0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F, 0x3070, 0x3071,
    0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079,
    0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 0x3080, 0x3081,
    0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089,
    0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 0x3090, 0x3091,
    0x3092, 0x3093, 0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6,
    0x30A7, 0x30A8, 0x30A9, 0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE,
    0x30AF, 0x30B0, 0x30B1, 0x30B2, 0x30B3, 0x30B4, 0x30B5, 0x30B6,
    0x30B7, 0x30B8, 0x30B9, 0x30BA, 0x30BB, 0x30BC, 0x30BD, 0x30BE,
    0x30BF, 0x30C0, 0x30C1, 0x30C2, 0x30C3, 0x30C4, 0x30C5, 0x30C6,
    0x30C7, 0x30C8, 0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE,
    0x30CF, 0x30D0, 0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6,
    0x30D7, 0x30D8, 0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE,
    0x30DF, 0x30E0, 0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6,
    0x30E7, 0x30E8, 0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE,
    0x30EF, 0x30F0, 0x30F1, 0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6,
    0x3131, 0x3132, 0x3133, 0x3134, 0x3135, 0x3136, 0x3137, 0x3138,
    0x3139, 0x313A, 0x313B, 0x313C, 0x313D, 0x313E, 0x313F, 0x3140,
    0x3141, 0x3142, 0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148,
    0x3149, 0x314A, 0x314B, 0x314C, 0x314D, 0x314E, 0x314F, 0x3150,
    0x3151, 0x3152, 0x3153, 0x3154, 0x3155, 0x3156, 0x3157, 0x3158,
    0x3159, 0x315A, 0x315B, 0x315C, 0x315D, 0x315E, 0x315F, 0x3160,
    0x3161, 0x3162, 0x3163, 0x3164, 0x3165, 0x3166, 0x3167, 0x3168,
    0x3169, 0x316A, 0x316B, 0x316C, 0x316D, 0x316E, 0x316F, 0x3170,
    0x3171, 0x3172, 0x3173, 0x3174, 0x3175, 0x3176, 0x3177, 0x3178,
    0x3179, 0x317A, 0x317B, 0x317C, 0x317D, 0x317E, 0x317F, 0x3180,
    0x3181, 0x3182, 0x3183, 0x3184, 0x3185, 0x3186, 0x3187, 0x3188,
    0x3189, 0x318A, 0x318B, 0x318C, 0x318D, 0x318E, 0x3200, 0x3201,
    0x3202, 0x3203, 0x3204, 0x3205, 0x3206, 0x3207, 0x3208, 0x3209,
    0x320A, 0x320B, 0x320C, 0x320D, 0x320E, 0x320F, 0x3210, 0x3211,
    0x3212, 0x3213, 0x3214, 0x3215, 0x3216, 0x3217, 0x3218, 0x3219,
    0x321A, 0x321B, 0x321C, 0x3260, 0x3261, 0x3262, 0x3263, 0x3264,
    0x3265, 0x3266, 0x3267, 0x3268, 0x3269, 0x326A, 0x326B, 0x326C,
    0x326D, 0x326E, 0x326F, 0x3270, 0x3271, 0x3272, 0x3273, 0x3274,
    0x3275, 0x3276, 0x3277, 0x3278, 0x3279, 0x327A, 0x327B, 0x327E,
    0x327F, 0x3380, 0x3381, 0x3382, 0x3383, 0x3384, 0x3388, 0x3389,
    0x338A, 0x338B, 0x338C, 0x338D, 0x338E, 0x338F, 0x3390, 0x3391,
    0x3392, 0x3393, 0x3394, 0x3395, 0x3396, 0x3397, 0x3398, 0x3399,
    0x339A, 0x339B, 0x339C, 0x339D, 0x339E, 0x339F, 0x33A0, 0x33A1,
    0x33A2, 0x33A3, 0x33A4, 0x33A5, 0x33A6, 0x33A7, 0x33A8, 0x33A9,
    0x33AA, 0x33AB, 0x33AC, 0x33AD, 0x33AE, 0x33AF, 0x33B0, 0x33B1,
    0x33B2, 0x33B3, 0x33B4, 0x33B5, 0x33B6, 0x33B7, 0x33B8, 0x33B9,
    0x33BA, 0x33BB, 0x33BC, 0x33BD, 0x33BE, 0x33BF, 0x33C0, 0x33C1,
    0x33C2, 0x33C3, 0x33C4, 0x33C5, 0x33C6, 0x33C7, 0x33C8, 0x33C9,
    0x33CA, 0x33CF, 0x33D0, 0x33D3, 0x33D6, 0x33D8, 0x33DB, 0x33DC,
    0x33DD, 0xAC00, 0xAC01, 0xAC04, 0xAC07, 0xAC08, 0xAC09, 0xAC0A,
    0xAC10, 0xAC11, 0xAC12, 0xAC13, 0xAC14, 0xAC15, 0xAC16, 0xAC17,
    0xAC19, 0xAC1A, 0xAC1B, 0xAC1C, 0xAC1D, 0xAC20, 0xAC24, 0xAC2C,
    0xAC2D, 0xAC2F, 0xAC30, 0xAC31, 0xAC38, 0xAC39, 0xAC3C, 0xAC40,
    0xAC4B, 0xAC4D, 0xAC54, 0xAC58, 0xAC5C, 0xAC70, 0xAC71, 0xAC74,
    0xAC77, 0xAC78, 0xAC7A, 0xAC80, 0xAC81, 0xAC83, 0xAC84, 0xAC85,
    0xAC86, 0xAC89, 0xAC8A, 0xAC8B, 0xAC8C, 0xAC90, 0xAC94, 0xAC9C,
    0xAC9D, 0xAC9F, 0xACA0, 0xACA1, 0xACA8, 0xACA9, 0xACAA, 0xACAC,
    0xACAF, 0xACB0, 0xACB8, 0xACB9, 0xACBB, 0xACBC, 0xACBD, 0xACC1,
    0xACC4, 0xACC8, 0xACCC, 0xACD5, 0xACD7, 0xACE0, 0xACE1, 0xACE4,
    0xACE7, 0xACE8, 0xACEA, 0xACEC, 0xACEF, 0xACF0, 0xACF1, 0xACF3,
    0xACF5, 0xACF6, 0xACFC, 0xACFD, 0xAD00, 0xAD04, 0xAD06, 0xAD0C,
    0xAD0D, 0xAD0F, 0xAD11, 0xAD18, 0xAD1C, 0xAD20, 0xAD29, 0xAD2C,
    0xAD2D, 0xAD34, 0xAD35, 0xAD38, 0xAD3C, 0xAD44, 0xAD45, 0xAD47,
    0xAD49, 0xAD50, 0xAD54, 0xAD58, 0xAD61, 0xAD63, 0xAD6C, 0xAD6D,
    0xAD70, 0xAD73, 0xAD74, 0xAD75, 0xAD76, 0xAD7B, 0xAD7C, 0xAD7D,
    0xAD7F, 0xAD81, 0xAD82, 0xAD88, 0xAD89, 0xAD8C, 0xAD90, 0xAD9C,
    0xAD9D, 0xADA4, 0xADB7, 0xADC0, 0xADC1, 0xADC4, 0xADC8, 0xADD0,
    0xADD1, 0xADD3, 0xADDC, 0xADE0, 0xADE4, 0xADF8, 0xADF9, 0xADFC,
    0xADFF, 0xAE00, 0xAE01, 0xAE08, 0xAE09, 0xAE0B, 0xAE0D, 0xAE14,
    0xAE30, 0xAE31, 0xAE34, 0xAE37, 0xAE38, 0xAE3A, 0xAE40, 0xAE41,
    0xAE43, 0xAE45, 0xAE46, 0xAE4A, 0xAE4C, 0xAE4D, 0xAE4E, 0xAE50,
    0xAE54, 0xAE56, 0xAE5C, 0xAE5D, 0xAE5F, 0xAE60, 0xAE61, 0xAE65,
    0xAE68, 0xAE69, 0xAE6C, 0xAE70, 0xAE78, 0xAE79, 0xAE7B, 0xAE7C,
    0xAE7D, 0xAE84, 0xAE85, 0xAE8C, 0xAEBC, 0xAEBD, 0xAEBE, 0xAEC0,
    0xAEC4, 0xAECC, 0xAECD, 0xAECF, 0xAED0, 0xAED1, 0xAED8, 0xAED9,
    0xAEDC, 0xAEE8, 0xAEEB, 0xAEED, 0xAEF4, 0xAEF8, 0xAEFC, 0xAF07,
    0xAF08, 0xAF0D, 0xAF10, 0xAF2C, 0xAF2D, 0xAF30, 0xAF32, 0xAF34,
    0xAF3C, 0xAF3D, 0xAF3F, 0xAF41, 0xAF42, 0xAF43, 0xAF48, 0xAF49,
    0xAF50, 0xAF5C, 0xAF5D, 0xAF64, 0xAF65, 0xAF79, 0xAF80, 0xAF84,
    0xAF88, 0xAF90, 0xAF91, 0xAF95, 0xAF9C, 0xAFB8, 0xAFB9, 0xAFBC,
    0xAFC0, 0xAFC7, 0xAFC8, 0xAFC9, 0xAFCB, 0xAFCD, 0xAFCE, 0xAFD4,
    0xAFDC, 0xAFE8, 0xAFE9, 0xAFF0, 0xAFF1, 0xAFF4, 0xAFF8, 0xB000,
    0xB001, 0xB004, 0xB00C, 0xB010, 0xB014, 0xB01C, 0xB01D, 0xB028,
    0xB044, 0xB045, 0xB048, 0xB04A, 0xB04C, 0xB04E, 0xB053, 0xB054,
    0xB055, 0xB057, 0xB059, 0xB05D, 0xB07C, 0xB07D, 0xB080, 0xB084,
    0xB08C, 0xB08D, 0xB08F, 0xB091, 0xB098, 0xB099, 0xB09A, 0xB09C,
    0xB09F, 0xB0A0, 0xB0A1, 0xB0A2, 0xB0A8, 0xB0A9, 0xB0AB, 0xB0AC,
    0xB0AD, 0xB0AE, 0xB0AF, 0xB0B1, 0xB0B3, 0xB0B4, 0xB0B5, 0xB0B8,
    0xB0BC, 0xB0C4, 0xB0C5, 0xB0C7, 0xB0C8, 0xB0C9, 0xB0D0, 0xB0D1,
    0xB0D4, 0xB0D8, 0xB0E0, 0xB0E5, 0xB108, 0xB109, 0xB10B, 0xB10C,
    0xB110, 0xB112, 0xB113, 0xB118, 0xB119, 0xB11B, 0xB11C, 0xB11D,
    0xB123, 0xB124, 0xB125, 0xB128, 0xB12C, 0xB134, 0xB135, 0xB137,
    0xB138, 0xB139, 0xB140, 0xB141, 0xB144, 0xB148, 0xB150, 0xB151,
    0xB154, 0xB155, 0xB158, 0xB15C, 0xB160, 0xB178, 0xB179, 0xB17C,
    0xB180, 0xB182, 0xB188, 0xB189, 0xB18B, 0xB18D, 0xB192, 0xB193,
    0xB194, 0xB198, 0xB19C, 0xB1A8, 0xB1CC, 0xB1D0, 0xB1D4, 0xB1DC,
    0xB1DD, 0xB1DF, 0xB1E8, 0xB1E9, 0xB1EC, 0xB1F0, 0xB1F9, 0xB1FB,
    0xB1FD, 0xB204, 0xB205, 0xB208, 0xB20B, 0xB20C, 0xB214, 0xB215,
    0xB217, 0xB219, 0xB220, 0xB234, 0xB23C, 0xB258, 0xB25C, 0xB260,
    0xB268, 0xB269, 0xB274, 0xB275, 0xB27C, 0xB284, 0xB285, 0xB289,
    0xB290, 0xB291, 0xB294, 0xB298, 0xB299, 0xB29A, 0xB2A0, 0xB2A1,
    0xB2A3, 0xB2A5, 0xB2A6, 0xB2AA, 0xB2AC, 0xB2B0, 0xB2B4, 0xB2C8,
    0xB2C9, 0xB2CC, 0xB2D0, 0xB2D2, 0xB2D8, 0xB2D9, 0xB2DB, 0xB2DD,
    0xB2E2, 0xB2E4, 0xB2E5, 0xB2E6, 0xB2E8, 0xB2EB, 0xB2EC, 0xB2ED,
    0xB2EE, 0xB2EF, 0xB2F3, 0xB2F4, 0xB2F5, 0xB2F7, 0xB2F8, 0xB2F9,
    0xB2FA, 0xB2FB, 0xB2FF, 0xB300, 0xB301, 0xB304, 0xB308, 0xB310,
    0xB311, 0xB313, 0xB314, 0xB315, 0xB31C, 0xB354, 0xB355, 0xB356,
    0xB358, 0xB35B, 0xB35C, 0xB35E, 0xB35F, 0xB364, 0xB365, 0xB367,
    0xB369, 0xB36B, 0xB36E, 0xB370, 0xB371, 0xB374, 0xB378, 0xB380,
    0xB381, 0xB383, 0xB384, 0xB385, 0xB38C, 0xB390, 0xB394, 0xB3A0,
    0xB3A1, 0xB3A8, 0xB3AC, 0xB3C4, 0xB3C5, 0xB3C8, 0xB3CB, 0xB3CC,
    0xB3CE, 0xB3D0, 0xB3D4, 0xB3D5, 0xB3D7, 0xB3D9, 0xB3DB, 0xB3DD,
    0xB3E0, 0xB3E4, 0xB3E8, 0xB3FC, 0xB410, 0xB418, 0xB41C, 0xB420,
    0xB428, 0xB429, 0xB42B, 0xB434, 0xB450, 0xB451, 0xB454, 0xB458,
    0xB460, 0xB461, 0xB463, 0xB465, 0xB46C, 0xB480, 0xB488, 0xB49D,
    0xB4A4, 0xB4A8, 0xB4AC, 0xB4B5, 0xB4B7, 0xB4B9, 0xB4C0, 0xB4C4,
    0xB4C8, 0xB4D0, 0xB4D5, 0xB4DC, 0xB4DD, 0xB4E0, 0xB4E3, 0xB4E4,
    0xB4E6, 0xB4EC, 0xB4ED, 0xB4EF, 0xB4F1, 0xB4F8, 0xB514, 0xB515,
    0xB518, 0xB51B, 0xB51C, 0xB524, 0xB525, 0xB527, 0xB528, 0xB529,
    0xB52A, 0xB530, 0xB531, 0xB534, 0xB538, 0xB540, 0xB541, 0xB543,
    0xB544, 0xB545, 0xB54B, 0xB54C, 0xB54D, 0xB550, 0xB554, 0xB55C,
    0xB55D, 0xB55F, 0xB560, 0xB561, 0xB5A0, 0xB5A1, 0xB5A4, 0xB5A8,
    0xB5AA, 0xB5AB, 0xB5B0, 0xB5B1, 0xB5B3, 0xB5B4, 0xB5B5, 0xB5BB,
    0xB5BC, 0xB5BD, 0xB5C0, 0xB5C4, 0xB5CC, 0xB5CD, 0xB5CF, 0xB5D0,
    0xB5D1, 0xB5D8, 0xB5EC, 0xB610, 0xB611, 0xB614, 0xB618, 0xB625,
    0xB62C, 0xB634, 0xB648, 0xB664, 0xB668, 0xB69C, 0xB69D, 0xB6A0,
    0xB6A4, 0xB6AB, 0xB6AC, 0xB6B1, 0xB6D4, 0xB6F0, 0xB6F4, 0xB6F8,
    0xB700, 0xB701, 0xB705, 0xB728, 0xB729, 0xB72C, 0xB72F, 0xB730,
    0xB738, 0xB739, 0xB73B, 0xB744, 0xB748, 0xB74C, 0xB754, 0xB755,
    0xB760, 0xB764, 0xB768, 0xB770, 0xB771, 0xB773, 0xB775, 0xB77C,
    0xB77D, 0xB780, 0xB784, 0xB78C, 0xB78D, 0xB78F, 0xB790, 0xB791,
    0xB792, 0xB796, 0xB797, 0xB798, 0xB799, 0xB79C, 0xB7A0, 0xB7A8,
    0xB7A9, 0xB7AB, 0xB7AC, 0xB7AD, 0xB7B4, 0xB7B5, 0xB7B8, 0xB7C7,
    0xB7C9, 0xB7EC, 0xB7ED, 0xB7F0, 0xB7F4, 0xB7FC, 0xB7FD, 0xB7FF,
    0xB800, 0xB801, 0xB807, 0xB808, 0xB809, 0xB80C, 0xB810, 0xB818,
    0xB819, 0xB81B, 0xB81D, 0xB824, 0xB825, 0xB828, 0xB82C, 0xB834,
    0xB835, 0xB837, 0xB838, 0xB839, 0xB840, 0xB844, 0xB851, 0xB853,
    0xB85C, 0xB85D, 0xB860, 0xB864, 0xB86C, 0xB86D, 0xB86F, 0xB871,
    0xB878, 0xB87C, 0xB88D, 0xB8A8, 0xB8B0, 0xB8B4, 0xB8B8, 0xB8C0,
    0xB8C1, 0xB8C3, 0xB8C5, 0xB8CC, 0xB8D0, 0xB8D4, 0xB8DD, 0xB8DF,
    0xB8E1, 0xB8E8, 0xB8E9, 0xB8EC, 0xB8F0, 0xB8F8, 0xB8F9, 0xB8FB,
    0xB8FD, 0xB904, 0xB918, 0xB920, 0xB93C, 0xB93D, 0xB940, 0xB944,
    0xB94C, 0xB94F, 0xB951, 0xB958, 0xB959, 0xB95C, 0xB960, 0xB968,
    0xB969, 0xB96B, 0xB96D, 0xB974, 0xB975, 0xB978, 0xB97C, 0xB984,
    0xB985, 0xB987, 0xB989, 0xB98A, 0xB98D, 0xB98E, 0xB9AC, 0xB9AD,
    0xB9B0, 0xB9B4, 0xB9BC, 0xB9BD, 0xB9BF, 0xB9C1, 0xB9C8, 0xB9C9,
    0xB9CC, 0xB9CE, 0xB9CF, 0xB9D0, 0xB9D1, 0xB9D2, 0xB9D8, 0xB9D9,
    0xB9DB, 0xB9DD, 0xB9DE, 0xB9E1, 0xB9E3, 0xB9E4, 0xB9E5, 0xB9E8,
    0xB9EC, 0xB9F4, 0xB9F5, 0xB9F7, 0xB9F8, 0xB9F9, 0xB9FA, 0xBA00,
    0xBA01, 0xBA08, 0xBA15, 0xBA38, 0xBA39, 0xBA3C, 0xBA40, 0xBA42,
    0xBA48, 0xBA49, 0xBA4B, 0xBA4D, 0xBA4E, 0xBA53, 0xBA54, 0xBA55,
    0xBA58, 0xBA5C, 0xBA64, 0xBA65, 0xBA67, 0xBA68, 0xBA69, 0xBA70,
    0xBA71, 0xBA74, 0xBA78, 0xBA83, 0xBA84, 0xBA85, 0xBA87, 0xBA8C,
    0xBAA8, 0xBAA9, 0xBAAB, 0xBAAC, 0xBAB0, 0xBAB2, 0xBAB8, 0xBAB9,
    0xBABB, 0xBABD, 0xBAC4, 0xBAC8, 0xBAD8, 0xBAD9, 0xBAFC, 0xBB00,
    0xBB04, 0xBB0D, 0xBB0F, 0xBB11, 0xBB18, 0xBB1C, 0xBB20, 0xBB29,
    0xBB2B, 0xBB34, 0xBB35, 0xBB36, 0xBB38, 0xBB3B, 0xBB3C, 0xBB3D,
    0xBB3E, 0xBB44, 0xBB45, 0xBB47, 0xBB49, 0xBB4D, 0xBB4F, 0xBB50,
    0xBB54, 0xBB58, 0xBB61, 0xBB63, 0xBB6C, 0xBB88, 0xBB8C, 0xBB90,
    0xBBA4, 0xBBA8, 0xBBAC, 0xBBB4, 0xBBB7, 0xBBC0, 0xBBC4, 0xBBC8,
    0xBBD0, 0xBBD3, 0xBBF8, 0xBBF9, 0xBBFC, 0xBBFF, 0xBC00, 0xBC02,
    0xBC08, 0xBC09, 0xBC0B, 0xBC0C, 0xBC0D, 0xBC0F, 0xBC11, 0xBC14,
    0xBC15, 0xBC16, 0xBC17, 0xBC18, 0xBC1B, 0xBC1C, 0xBC1D, 0xBC1E,
    0xBC1F, 0xBC24, 0xBC25, 0xBC27, 0xBC29, 0xBC2D, 0xBC30, 0xBC31,
    0xBC34, 0xBC38, 0xBC40, 0xBC41, 0xBC43, 0xBC44, 0xBC45, 0xBC49,
    0xBC4C, 0xBC4D, 0xBC50, 0xBC5D, 0xBC84, 0xBC85, 0xBC88, 0xBC8B,
    0xBC8C, 0xBC8E, 0xBC94, 0xBC95, 0xBC97, 0xBC99, 0xBC9A, 0xBCA0,
    0xBCA1, 0xBCA4, 0xBCA7, 0xBCA8, 0xBCB0, 0xBCB1, 0xBCB3, 0xBCB4,
    0xBCB5, 0xBCBC, 0xBCBD, 0xBCC0, 0xBCC4, 0xBCCD, 0xBCCF, 0xBCD0,
    0xBCD1, 0xBCD5, 0xBCD8, 0xBCDC, 0xBCF4, 0xBCF5, 0xBCF6, 0xBCF8,
    0xBCFC, 0xBD04, 0xBD05, 0xBD07, 0xBD09, 0xBD10, 0xBD14, 0xBD24,
    0xBD2C, 0xBD40, 0xBD48, 0xBD49, 0xBD4C, 0xBD50, 0xBD58, 0xBD59,
    0xBD64, 0xBD68, 0xBD80, 0xBD81, 0xBD84, 0xBD87, 0xBD88, 0xBD89,
    0xBD8A, 0xBD90, 0xBD91, 0xBD93, 0xBD95, 0xBD99, 0xBD9A, 0xBD9C,
    0xBDA4, 0xBDB0, 0xBDB8, 0xBDD4, 0xBDD5, 0xBDD8, 0xBDDC, 0xBDE9,
    0xBDF0, 0xBDF4, 0xBDF8, 0xBE00, 0xBE03, 0xBE05, 0xBE0C, 0xBE0D,
    0xBE10, 0xBE14, 0xBE1C, 0xBE1D, 0xBE1F, 0xBE44, 0xBE45, 0xBE48,
    0xBE4C, 0xBE4E, 0xBE54, 0xBE55, 0xBE57, 0xBE59, 0xBE5A, 0xBE5B,
    0xBE60, 0xBE61, 0xBE64, 0xBE68, 0xBE6A, 0xBE70, 0xBE71, 0xBE73,
    0xBE74, 0xBE75, 0xBE7B, 0xBE7C, 0xBE7D, 0xBE80, 0xBE84, 0xBE8C,
    0xBE8D, 0xBE8F, 0xBE90, 0xBE91, 0xBE98, 0xBE99, 0xBEA8, 0xBED0,
    0xBED1, 0xBED4, 0xBED7, 0xBED8, 0xBEE0, 0xBEE3, 0xBEE4, 0xBEE5,
    0xBEEC, 0xBF01, 0xBF08, 0xBF09, 0xBF18, 0xBF19, 0xBF1B, 0xBF1C,
    0xBF1D, 0xBF40, 0xBF41, 0xBF44, 0xBF48, 0xBF50, 0xBF51, 0xBF55,
    0xBF94, 0xBFB0, 0xBFC5, 0xBFCC, 0xBFCD, 0xBFD0, 0xBFD4, 0xBFDC,
    0xBFDF, 0xBFE1, 0xC03C, 0xC051, 0xC058, 0xC05C, 0xC060, 0xC068,
    0xC069, 0xC090, 0xC091, 0xC094, 0xC098, 0xC0A0, 0xC0A1, 0xC0A3,
    0xC0A5, 0xC0AC, 0xC0AD, 0xC0AF, 0xC0B0, 0xC0B3, 0xC0B4, 0xC0B5,
    0xC0B6, 0xC0BC, 0xC0BD, 0xC0BF, 0xC0C0, 0xC0C1, 0xC0C5, 0xC0C8,
    0xC0C9, 0xC0CC, 0xC0D0, 0xC0D8, 0xC0D9, 0xC0DB, 0xC0DC, 0xC0DD,
    0xC0E4, 0xC0E5, 0xC0E8, 0xC0EC, 0xC0F4, 0xC0F5, 0xC0F7, 0xC0F9,
    0xC100, 0xC104, 0xC108, 0xC110, 0xC115, 0xC11C, 0xC11D, 0xC11E,
    0xC11F, 0xC120, 0xC123, 0xC124, 0xC126, 0xC127, 0xC12C, 0xC12D,
    0xC12F, 0xC130, 0xC131, 0xC136, 0xC138, 0xC139, 0xC13C, 0xC140,
    0xC148, 0xC149, 0xC14B, 0xC14C, 0xC14D, 0xC154, 0xC155, 0xC158,
    0xC15C, 0xC164, 0xC165, 0xC167, 0xC168, 0xC169, 0xC170, 0xC174,
    0xC178, 0xC185, 0xC18C, 0xC18D, 0xC18E, 0xC190, 0xC194, 0xC196,
    0xC19C, 0xC19D, 0xC19F, 0xC1A1, 0xC1A5, 0xC1A8, 0xC1A9, 0xC1AC,
    0xC1B0, 0xC1BD, 0xC1C4, 0xC1C8, 0xC1CC, 0xC1D4, 0xC1D7, 0xC1D8,
    0xC1E0, 0xC1E4, 0xC1E8, 0xC1F0, 0xC1F1, 0xC1F3, 0xC1FC, 0xC1FD,
    0xC200, 0xC204, 0xC20C, 0xC20D, 0xC20F, 0xC211, 0xC218, 0xC219,
    0xC21C, 0xC21F, 0xC220, 0xC228, 0xC229, 0xC22B, 0xC22D, 0xC22F,
    0xC231, 0xC232, 0xC234, 0xC248, 0xC250, 0xC251, 0xC254, 0xC258,
    0xC260, 0xC265, 0xC26C, 0xC26D, 0xC270, 0xC274, 0xC27C, 0xC27D,
    0xC27F, 0xC281, 0xC288, 0xC289, 0xC290, 0xC298, 0xC29B, 0xC29D,
    0xC2A4, 0xC2A5, 0xC2A8, 0xC2AC, 0xC2AD, 0xC2B4, 0xC2B5, 0xC2B7,
    0xC2B9, 0xC2DC, 0xC2DD, 0xC2E0, 0xC2E3, 0xC2E4, 0xC2EB, 0xC2EC,
    0xC2ED, 0xC2EF, 0xC2F1, 0xC2F6, 0xC2F8, 0xC2F9, 0xC2FB, 0xC2FC,
    0xC300, 0xC308, 0xC309, 0xC30C, 0xC30D, 0xC313, 0xC314, 0xC315,
    0xC318, 0xC31C, 0xC324, 0xC325, 0xC328, 0xC329, 0xC345, 0xC368,
    0xC369, 0xC36C, 0xC370, 0xC372, 0xC378, 0xC379, 0xC37C, 0xC37D,
    0xC384, 0xC388, 0xC38C, 0xC3C0, 0xC3D8, 0xC3D9, 0xC3DC, 0xC3DF,
    0xC3E0, 0xC3E2, 0xC3E8, 0xC3E9, 0xC3ED, 0xC3F4, 0xC3F5, 0xC3F8,
    0xC408, 0xC410, 0xC424, 0xC42C, 0xC430, 0xC434, 0xC43C, 0xC43D,
    0xC448, 0xC464, 0xC465, 0xC468, 0xC46C, 0xC474, 0xC475, 0xC479,
    0xC480, 0xC494, 0xC49C, 0xC4B8, 0xC4BC, 0xC4E9, 0xC4F0, 0xC4F1,
    0xC4F4, 0xC4F8, 0xC4FA, 0xC4FF, 0xC500, 0xC501, 0xC50C, 0xC510,
    0xC514, 0xC51C, 0xC528, 0xC529, 0xC52C, 0xC530, 0xC538, 0xC539,
    0xC53B, 0xC53D, 0xC544, 0xC545, 0xC548, 0xC549, 0xC54A, 0xC54C,
    0xC54D, 0xC54E, 0xC553, 0xC554, 0xC555, 0xC557, 0xC558, 0xC559,
    0xC55D, 0xC55E, 0xC560, 0xC561, 0xC564, 0xC568, 0xC570, 0xC571,
    0xC573, 0xC574, 0xC575, 0xC57C, 0xC57D, 0xC580, 0xC584, 0xC587,
    0xC58C, 0xC58D, 0xC58F, 0xC591, 0xC595, 0xC597, 0xC598, 0xC59C,
    0xC5A0, 0xC5A9, 0xC5B4, 0xC5B5, 0xC5B8, 0xC5B9, 0xC5BB, 0xC5BC,
    0xC5BD, 0xC5BE, 0xC5C4, 0xC5C5, 0xC5C6, 0xC5C7, 0xC5C8, 0xC5C9,
    0xC5CA, 0xC5CC, 0xC5CE, 0xC5D0, 0xC5D1, 0xC5D4, 0xC5D8, 0xC5E0,
    0xC5E1, 0xC5E3, 0xC5E5, 0xC5EC, 0xC5ED, 0xC5EE, 0xC5F0, 0xC5F4,
    0xC5F6, 0xC5F7, 0xC5FC, 0xC5FD, 0xC5FE, 0xC5FF, 0xC600, 0xC601,
    0xC605, 0xC606, 0xC607, 0xC608, 0xC60C, 0xC610, 0xC618, 0xC619,
    0xC61B, 0xC61C, 0xC624, 0xC625, 0xC628, 0xC62C, 0xC62D, 0xC62E,
    0xC630, 0xC633, 0xC634, 0xC635, 0xC637, 0xC639, 0xC63B, 0xC640,
    0xC641, 0xC644, 0xC648, 0xC650, 0xC651, 0xC653, 0xC654, 0xC655,
    0xC65C, 0xC65D, 0xC660, 0xC66C, 0xC66F, 0xC671, 0xC678, 0xC679,
    0xC67C, 0xC680, 0xC688, 0xC689, 0xC68B, 0xC68D, 0xC694, 0xC695,
    0xC698, 0xC69C, 0xC6A4, 0xC6A5, 0xC6A7, 0xC6A9, 0xC6B0, 0xC6B1,
    0xC6B4, 0xC6B8, 0xC6B9, 0xC6BA, 0xC6C0, 0xC6C1, 0xC6C3, 0xC6C5,
    0xC6CC, 0xC6CD, 0xC6D0, 0xC6D4, 0xC6DC, 0xC6DD, 0xC6E0, 0xC6E1,
    0xC6E8, 0xC6E9, 0xC6EC, 0xC6F0, 0xC6F8, 0xC6F9, 0xC6FD, 0xC704,
    0xC705, 0xC708, 0xC70C, 0xC714, 0xC715, 0xC717, 0xC719, 0xC720,
    0xC721, 0xC724, 0xC728, 0xC730, 0xC731, 0xC733, 0xC735, 0xC737,
    0xC73C, 0xC73D, 0xC740, 0xC744, 0xC74A, 0xC74C, 0xC74D, 0xC74F,
    0xC751, 0xC752, 0xC753, 0xC754, 0xC755, 0xC756, 0xC757, 0xC758,
    0xC75C, 0xC760, 0xC768, 0xC76B, 0xC774, 0xC775, 0xC778, 0xC77C,
    0xC77D, 0xC77E, 0xC783, 0xC784, 0xC785, 0xC787, 0xC788, 0xC789,
    0xC78A, 0xC78E, 0xC790, 0xC791, 0xC794, 0xC796, 0xC797, 0xC798,
    0xC79A, 0xC7A0, 0xC7A1, 0xC7A3, 0xC7A4, 0xC7A5, 0xC7A6, 0xC7AC,
    0xC7AD, 0xC7B0, 0xC7B4, 0xC7BC, 0xC7BD, 0xC7BF, 0xC7C0, 0xC7C1,
    0xC7C8, 0xC7C9, 0xC7CC, 0xC7CE, 0xC7D0, 0xC7D8, 0xC7DD, 0xC7E4,
    0xC7E8, 0xC7EC, 0xC800, 0xC801, 0xC804, 0xC808, 0xC80A, 0xC810,
    0xC811, 0xC813, 0xC815, 0xC816, 0xC81C, 0xC81D, 0xC820, 0xC824,
    0xC82C, 0xC82D, 0xC82F, 0xC831, 0xC838, 0xC83C, 0xC840, 0xC848,
    0xC849, 0xC84C, 0xC84D, 0xC854, 0xC870, 0xC871, 0xC874, 0xC878,
    0xC87A, 0xC880, 0xC881, 0xC883, 0xC885, 0xC886, 0xC887, 0xC88B,
    0xC88C, 0xC88D, 0xC894, 0xC89D, 0xC89F, 0xC8A1, 0xC8A8, 0xC8BC,
    0xC8BD, 0xC8C4, 0xC8C8, 0xC8CC, 0xC8D4, 0xC8D5, 0xC8D7, 0xC8D9,
    0xC8E0, 0xC8E1, 0xC8E4, 0xC8F5, 0xC8FC, 0xC8FD, 0xC900, 0xC904,
    0xC905, 0xC906, 0xC90C, 0xC90D, 0xC90F, 0xC911, 0xC918, 0xC92C,
    0xC934, 0xC950, 0xC951, 0xC954, 0xC958, 0xC960, 0xC961, 0xC963,
    0xC96C, 0xC970, 0xC974, 0xC97C, 0xC988, 0xC989, 0xC98C, 0xC990,
    0xC998, 0xC999, 0xC99B, 0xC99D, 0xC9C0, 0xC9C1, 0xC9C4, 0xC9C7,
    0xC9C8, 0xC9CA, 0xC9D0, 0xC9D1, 0xC9D3, 0xC9D5, 0xC9D6, 0xC9D9,
    0xC9DA, 0xC9DC, 0xC9DD, 0xC9E0, 0xC9E2, 0xC9E4, 0xC9E7, 0xC9EC,
    0xC9ED, 0xC9EF, 0xC9F0, 0xC9F1, 0xC9F8, 0xC9F9, 0xC9FC, 0xCA00,
    0xCA08, 0xCA09, 0xCA0B, 0xCA0C, 0xCA0D, 0xCA14, 0xCA18, 0xCA29,
    0xCA4C, 0xCA4D, 0xCA50, 0xCA54, 0xCA5C, 0xCA5D, 0xCA5F, 0xCA60,
    0xCA61, 0xCA68, 0xCA7D, 0xCA84, 0xCA98, 0xCABC, 0xCABD, 0xCAC0,
    0xCAC4, 0xCACC, 0xCACD, 0xCACF, 0xCAD1, 0xCAD3, 0xCAD8, 0xCAD9,
    0xCAE0, 0xCAEC, 0xCAF4, 0xCB08, 0xCB10, 0xCB14, 0xCB18, 0xCB20,
    0xCB21, 0xCB41, 0xCB48, 0xCB49, 0xCB4C, 0xCB50, 0xCB58, 0xCB59,
    0xCB5D, 0xCB64, 0xCB78, 0xCB79, 0xCB9C, 0xCBB8, 0xCBD4, 0xCBE4,
    0xCBE7, 0xCBE9, 0xCC0C, 0xCC0D, 0xCC10, 0xCC14, 0xCC1C, 0xCC1D,
    0xCC21, 0xCC22, 0xCC27, 0xCC28, 0xCC29, 0xCC2C, 0xCC2E, 0xCC30,
    0xCC38, 0xCC39, 0xCC3B, 0xCC3C, 0xCC3D, 0xCC3E, 0xCC44, 0xCC45,
    0xCC48, 0xCC4C, 0xCC54, 0xCC55, 0xCC57, 0xCC58, 0xCC59, 0xCC60,
    0xCC64, 0xCC66, 0xCC68, 0xCC70, 0xCC75, 0xCC98, 0xCC99, 0xCC9C,
    0xCCA0, 0xCCA8, 0xCCA9, 0xCCAB, 0xCCAC, 0xCCAD, 0xCCB4, 0xCCB5,
    0xCCB8, 0xCCBC, 0xCCC4, 0xCCC5, 0xCCC7, 0xCCC9, 0xCCD0, 0xCCD4,
    0xCCE4, 0xCCEC, 0xCCF0, 0xCD01, 0xCD08, 0xCD09, 0xCD0C, 0xCD10,
    0xCD18, 0xCD19, 0xCD1B, 0xCD1D, 0xCD24, 0xCD28, 0xCD2C, 0xCD39,
    0xCD5C, 0xCD60, 0xCD64, 0xCD6C, 0xCD6D, 0xCD6F, 0xCD71, 0xCD78,
    0xCD88, 0xCD94, 0xCD95, 0xCD98, 0xCD9C, 0xCDA4, 0xCDA5, 0xCDA7,
    0xCDA9, 0xCDB0, 0xCDC4, 0xCDCC, 0xCDD0, 0xCDE8, 0xCDEC, 0xCDF0,
    0xCDF8, 0xCDF9, 0xCDFB, 0xCDFD, 0xCE04, 0xCE08, 0xCE0C, 0xCE14,
    0xCE19, 0xCE20, 0xCE21, 0xCE24, 0xCE28, 0xCE30, 0xCE31, 0xCE33,
    0xCE35, 0xCE58, 0xCE59, 0xCE5C, 0xCE5F, 0xCE60, 0xCE61, 0xCE68,
    0xCE69, 0xCE6B, 0xCE6D, 0xCE74, 0xCE75, 0xCE78, 0xCE7C, 0xCE84,
    0xCE85, 0xCE87, 0xCE89, 0xCE90, 0xCE91, 0xCE94, 0xCE98, 0xCEA0,
    0xCEA1, 0xCEA3, 0xCEA4, 0xCEA5, 0xCEAC, 0xCEAD, 0xCEC1, 0xCEE4,
    0xCEE5, 0xCEE8, 0xCEEB, 0xCEEC, 0xCEF4, 0xCEF5, 0xCEF7, 0xCEF8,
    0xCEF9, 0xCF00, 0xCF01, 0xCF04, 0xCF08, 0xCF10, 0xCF11, 0xCF13,
    0xCF15, 0xCF1C, 0xCF20, 0xCF24, 0xCF2C, 0xCF2D, 0xCF2F, 0xCF30,
    0xCF31, 0xCF38, 0xCF54, 0xCF55, 0xCF58, 0xCF5C, 0xCF64, 0xCF65,
    0xCF67, 0xCF69, 0xCF70, 0xCF71, 0xCF74, 0xCF78, 0xCF80, 0xCF85,
    0xCF8C, 0xCFA1, 0xCFA8, 0xCFB0, 0xCFC4, 0xCFE0, 0xCFE1, 0xCFE4,
    0xCFE8, 0xCFF0, 0xCFF1, 0xCFF3, 0xCFF5, 0xCFFC, 0xD000, 0xD004,
    0xD011, 0xD018, 0xD02D, 0xD034, 0xD035, 0xD038, 0xD03C, 0xD044,
    0xD045, 0xD047, 0xD049, 0xD050, 0xD054, 0xD058, 0xD060, 0xD06C,
    0xD06D, 0xD070, 0xD074, 0xD07C, 0xD07D, 0xD081, 0xD0A4, 0xD0A5,
    0xD0A8, 0xD0AC, 0xD0B4, 0xD0B5, 0xD0B7, 0xD0B9, 0xD0C0, 0xD0C1,
    0xD0C4, 0xD0C8, 0xD0C9, 0xD0D0, 0xD0D1, 0xD0D3, 0xD0D4, 0xD0D5,
    0xD0DC, 0xD0DD, 0xD0E0, 0xD0E4, 0xD0EC, 0xD0ED, 0xD0EF, 0xD0F0,
    0xD0F1, 0xD0F8, 0xD10D, 0xD130, 0xD131, 0xD134, 0xD138, 0xD13A,
    0xD140, 0xD141, 0xD143, 0xD144, 0xD145, 0xD14C, 0xD14D, 0xD150,
    0xD154, 0xD15C, 0xD15D, 0xD15F, 0xD161, 0xD168, 0xD16C, 0xD17C,
    0xD184, 0xD188, 0xD1A0, 0xD1A1, 0xD1A4, 0xD1A8, 0xD1B0, 0xD1B1,
    0xD1B3, 0xD1B5, 0xD1BA, 0xD1BC, 0xD1C0, 0xD1D8, 0xD1F4, 0xD1F8,
    0xD207, 0xD209, 0xD210, 0xD22C, 0xD22D, 0xD230, 0xD234, 0xD23C,
    0xD23D, 0xD23F, 0xD241, 0xD248, 0xD25C, 0xD264, 0xD280, 0xD281,
    0xD284, 0xD288, 0xD290, 0xD291, 0xD295, 0xD29C, 0xD2A0, 0xD2A4,
    0xD2AC, 0xD2B1, 0xD2B8, 0xD2B9, 0xD2BC, 0xD2BF, 0xD2C0, 0xD2C2,
    0xD2C8, 0xD2C9, 0xD2CB, 0xD2D4, 0xD2D8, 0xD2DC, 0xD2E4, 0xD2E5,
    0xD2F0, 0xD2F1, 0xD2F4, 0xD2F8, 0xD300, 0xD301, 0xD303, 0xD305,
    0xD30C, 0xD30D, 0xD30E, 0xD310, 0xD314, 0xD316, 0xD31C, 0xD31D,
    0xD31F, 0xD320, 0xD321, 0xD325, 0xD328, 0xD329, 0xD32C, 0xD330,
    0xD338, 0xD339, 0xD33B, 0xD33C, 0xD33D, 0xD344, 0xD345, 0xD37C,
    0xD37D, 0xD380, 0xD384, 0xD38C, 0xD38D, 0xD38F, 0xD390, 0xD391,
    0xD398, 0xD399, 0xD39C, 0xD3A0, 0xD3A8, 0xD3A9, 0xD3AB, 0xD3AD,
    0xD3B4, 0xD3B8, 0xD3BC, 0xD3C4, 0xD3C5, 0xD3C8, 0xD3C9, 0xD3D0,
    0xD3D8, 0xD3E1, 0xD3E3, 0xD3EC, 0xD3ED, 0xD3F0, 0xD3F4, 0xD3FC,
    0xD3FD, 0xD3FF, 0xD401, 0xD408, 0xD41D, 0xD440, 0xD444, 0xD45C,
    0xD460, 0xD464, 0xD46D, 0xD46F, 0xD478, 0xD479, 0xD47C, 0xD47F,
    0xD480, 0xD482, 0xD488, 0xD489, 0xD48B, 0xD48D, 0xD494, 0xD4A9,
    0xD4CC, 0xD4D0, 0xD4D4, 0xD4DC, 0xD4DF, 0xD4E8, 0xD4EC, 0xD4F0,
    0xD4F8, 0xD4FB, 0xD4FD, 0xD504, 0xD508, 0xD50C, 0xD514, 0xD515,
    0xD517, 0xD53C, 0xD53D, 0xD540, 0xD544, 0xD54C, 0xD54D, 0xD54F,
    0xD551, 0xD558, 0xD559, 0xD55C, 0xD560, 0xD565, 0xD568, 0xD569,
    0xD56B, 0xD56D, 0xD574, 0xD575, 0xD578, 0xD57C, 0xD584, 0xD585,
    0xD587, 0xD588, 0xD589, 0xD590, 0xD5A5, 0xD5C8, 0xD5C9, 0xD5CC,
    0xD5D0, 0xD5D2, 0xD5D8, 0xD5D9, 0xD5DB, 0xD5DD, 0xD5E4, 0xD5E5,
    0xD5E8, 0xD5EC, 0xD5F4, 0xD5F5, 0xD5F7, 0xD5F9, 0xD600, 0xD601,
    0xD604, 0xD608, 0xD610, 0xD611, 0xD613, 0xD614, 0xD615, 0xD61C,
    0xD620, 0xD624, 0xD62D, 0xD638, 0xD639, 0xD63C, 0xD640, 0xD645,
    0xD648, 0xD649, 0xD64B, 0xD64D, 0xD651, 0xD654, 0xD655, 0xD658,
    0xD65C, 0xD667, 0xD669, 0xD670, 0xD671, 0xD674, 0xD683, 0xD685,
    0xD68C, 0xD68D, 0xD690, 0xD694, 0xD69D, 0xD69F, 0xD6A1, 0xD6A8,
    0xD6AC, 0xD6B0, 0xD6B9, 0xD6BB, 0xD6C4, 0xD6C5, 0xD6C8, 0xD6CC,
    0xD6D1, 0xD6D4, 0xD6D7, 0xD6D9, 0xD6E0, 0xD6E4, 0xD6E8, 0xD6F0,
    0xD6F5, 0xD6FC, 0xD6FD, 0xD700, 0xD704, 0xD711, 0xD718, 0xD719,
    0xD71C, 0xD720, 0xD728, 0xD729, 0xD72B, 0xD72D, 0xD734, 0xD735,
    0xD738, 0xD73C, 0xD744, 0xD747, 0xD749, 0xD750, 0xD751, 0xD754,
    0xD756, 0xD757, 0xD758, 0xD759, 0xD760, 0xD761, 0xD763, 0xD765,
    0xD769, 0xD76C, 0xD770, 0xD774, 0xD77C, 0xD77D, 0xD781, 0xD788,
    0xD789, 0xD78C, 0xD790, 0xD798, 0xD799, 0xD79B, 0xD79D, 0xF900,
    0xF901, 0xF902, 0xF903, 0xF904, 0xF905, 0xF906, 0xF907, 0xF908,
    0xF909, 0xF90A, 0xF90B, 0xF90C, 0xF90D, 0xF90E, 0xF90F, 0xF910,
    0xF911, 0xF912, 0xF913, 0xF914, 0xF915, 0xF916, 0xF917, 0xF918,
    0xF919, 0xF91A, 0xF91B, 0xF91C, 0xF91D, 0xF91E, 0xF91F, 0xF920,
    0xF921, 0xF922, 0xF923, 0xF924, 0xF925, 0xF926, 0xF927, 0xF928,
    0xF929, 0xF92A, 0xF92B, 0xF92C, 0xF92D, 0xF92E, 0xF92F, 0xF930,
    0xF931, 0xF932, 0xF933, 0xF934, 0xF935, 0xF936, 0xF937, 0xF938,
    0xF939, 0xF93A, 0xF93B, 0xF93C, 0xF93D, 0xF93E, 0xF93F, 0xF940,
    0xF941, 0xF942, 0xF943, 0xF944, 0xF945, 0xF946, 0xF947, 0xF948,
    0xF949, 0xF94A, 0xF94B, 0xF94C, 0xF94D, 0xF94E, 0xF94F, 0xF950,
    0xF951, 0xF952, 0xF953, 0xF954, 0xF955, 0xF956, 0xF957, 0xF958,
    0xF959, 0xF95A, 0xF95B, 0xF95C, 0xF95D, 0xF95E, 0xF95F, 0xF960,
    0xF961, 0xF962, 0xF963, 0xF964, 0xF965, 0xF966, 0xF967, 0xF968,
    0xF969, 0xF96A, 0xF96B, 0xF96C, 0xF96D, 0xF96E, 0xF96F, 0xF970,
    0xF971, 0xF972, 0xF973, 0xF974, 0xF975, 0xF976, 0xF977, 0xF978,
    0xF979, 0xF97A, 0xF97B, 0xF97C, 0xF97D, 0xF97E, 0xF97F, 0xF980,
    0xF981, 0xF982, 0xF983, 0xF984, 0xF985, 0xF986, 0xF987, 0xF988,
    0xF989, 0xF98A, 0xF98B, 0xF98C, 0xF98D, 0xF98E, 0xF98F, 0xF990,
    0xF991, 0xF992, 0xF993, 0xF994, 0xF995, 0xF996, 0xF997, 0xF998,
    0xF999, 0xF99A, 0xF99B, 0xF99C, 0xF99D, 0xF99E, 0xF99F, 0xF9A0,
    0xF9A1, 0xF9A2, 0xF9A3, 0xF9A4, 0xF9A5, 0xF9A6, 0xF9A7, 0xF9A8,
    0xF9A9, 0xF9AA, 0xF9AB, 0xF9AC, 0xF9AD, 0xF9AE, 0xF9AF, 0xF9B0,
    0xF9B1, 0xF9B2, 0xF9B3, 0xF9B4, 0xF9B5, 0xF9B6, 0xF9B7, 0xF9B8,
    0xF9B9, 0xF9BA, 0xF9BB, 0xF9BC, 0xF9BD, 0xF9BE, 0xF9BF, 0xF9C0,
    0xF9C1, 0xF9C2, 0xF9C3, 0xF9C4, 0xF9C5, 0xF9C6, 0xF9C7, 0xF9C8,
    0xF9C9, 0xF9CA, 0xF9CB, 0xF9CC, 0xF9CD, 0xF9CE, 0xF9CF, 0xF9D0,
    0xF9D1, 0xF9D2, 0xF9D3, 0xF9D4, 0xF9D5, 0xF9D6, 0xF9D7, 0xF9D8,
    0xF9D9, 0xF9DA, 0xF9DB, 0xF9DC, 0xF9DD, 0xF9DE, 0xF9DF, 0xF9E0,
    0xF9E1, 0xF9E2, 0xF9E3, 0xF9E4, 0xF9E5, 0xF9E6, 0xF9E7, 0xF9E8,
    0xF9E9, 0xF9EA, 0xF9EB, 0xF9EC, 0xF9ED, 0xF9EE, 0xF9EF, 0xF9F0,
    0xF9F1, 0xF9F2, 0xF9F3, 0xF9F4, 0xF9F5, 0xF9F6, 0xF9F7, 0xF9F8,
    0xF9F9, 0xF9FA, 0xF9FB, 0xF9FC, 0xF9FD, 0xF9FE, 0xF9FF, 0xFA00,
    0xFA01, 0xFA02, 0xFA03, 0xFA04, 0xFA05, 0xFA06, 0xFA07, 0xFA08,
    0xFA09, 0xFA0A, 0xFA0B, 0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05,
    0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0D,
    0xFF0E, 0xFF0F, 0xFF10, 0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15,
    0xFF16, 0xFF17, 0xFF18, 0xFF19, 0xFF1A, 0xFF1B, 0xFF1C, 0xFF1D,
    0xFF1E, 0xFF1F, 0xFF20, 0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25,
    0xFF26, 0xFF27, 0xFF28, 0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D,
    0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35,
    0xFF36, 0xFF37, 0xFF38, 0xFF39, 0xFF3A, 0xFF3B, 0xFF3C, 0xFF3D,
    0xFF3E, 0xFF3F, 0xFF40, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45,
    0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D,
    0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55,
    0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0xFF5B, 0xFF5C, 0xFF5D,
    0xFF5E, 0xFFE0, 0xFFE1, 0xFFE2, 0xFFE3, 0xFFE5, 0xFFE6,
};

/* Multibyte values sorted in Unicode order */
static const unsigned short ksx1001_mb[8227] = {
    0xA2AE, 0xA2B4, 0xA1D7, 0xA1A7, 0xA8A3, 0xA1A9, 0xA2E7, 0xA1C6,
    0xA1BE, 0xA9F7, 0xA9F8, 0xA2A5, 0xA2D2, 0xA1A4, 0xA2AC, 0xA9F6,
    0xA8AC, 0xA8F9, 0xA8F6, 0xA8FA, 0xA2AF, 0xA8A1, 0xA8A2, 0xA1BF,
    0xA8AA, 0xA8AD, 0xA9AC, 0xA9A1, 0xA9A3, 0xA1C0, 0xA9AA, 0xA9AD,
    0xA9A2, 0xA8A4, 0xA9A4, 0xA9A5, 0xA8A6, 0xA9A6, 0xA9A7, 0xA8A8,
    0xA9A8, 0xA8A9, 0xA9A9, 0xA9B0, 0xA8AF, 0xA9AF, 0xA8AB, 0xA9AB,
    0xA8AE, 0xA9AE, 0xA2A7, 0xA2B0, 0xA2A8, 0xA2AB, 0xA2AA, 0xA2AD,
    0xA2A9, 0xA5C1, 0xA5C2, 0xA5C3, 0xA5C4, 0xA5C5, 0xA5C6, 0xA5C7,
    0xA5C8, 0xA5C9, 0xA5CA, 0xA5CB, 0xA5CC, 0xA5CD, 0xA5CE, 0xA5CF,
    0xA5D0, 0xA5D1, 0xA5D2, 0xA5D3, 0xA5D4, 0xA5D5, 0xA5D6, 0xA5D7,
    0xA5D8, 0xA5E1, 0xA5E2, 0xA5E3, 0xA5E4, 0xA5E5, 0xA5E6, 0xA5E7,
    0xA5E8, 0xA5E9, 0xA5EA, 0xA5EB, 0xA5EC, 0xA5ED, 0xA5EE, 0xA5EF,
    0xA5F0, 0xA5F1, 0xA5F2, 0xA5F3, 0xA5F4, 0xA5F5, 0xA5F6, 0xA5F7,
    0xA5F8, 0xACA7, 0xACA1, 0xACA2, 0xACA3, 0xACA4, 0xACA5, 0xACA6,
    0xACA8, 0xACA9, 0xACAA, 0xACAB, 0xACAC, 0xACAD, 0xACAE, 0xACAF,
    0xACB0, 0xACB1, 0xACB2, 0xACB3, 0xACB4, 0xACB5, 0xACB6, 0xACB7,
    0xACB8, 0xACB9, 0xACBA, 0xACBB, 0xACBC, 0xACBD, 0xACBE, 0xACBF,
    0xACC0, 0xACC1, 0xACD1, 0xACD2, 0xACD3, 0xACD4, 0xACD5, 0xACD6,
    0xACD8, 0xACD9, 0xACDA, 0xACDB, 0xACDC, 0xACDD, 0xACDE, 0xACDF,
    0xACE0, 0xACE1, 0xACE2, 0xACE3, 0xACE4, 0xACE5, 0xACE6, 0xACE7,
    0xACE8, 0xACE9, 0xACEA, 0xACEB, 0xACEC, 0xACED, 0xACEE, 0xACEF,
    0xACF0, 0xACF1, 0xACD7, 0xA1AA, 0xA1AE, 0xA1AF, 0xA1B0, 0xA1B1,
    0xA2D3, 0xA2D4, 0xA1A5, 0xA1A6, 0xA2B6, 0xA1C7, 0xA1C8, 0xA1D8,
    0xA9F9, 0xA9FA, 0xA9FB, 0xA9FC, 0xA9FD, 0xA9FE, 0xA2E6, 0xA1C9,
    0xA2B5, 0xA7A4, 0xA2E0, 0xA2E5, 0xA2E2, 0xA7D9, 0xA1CA, 0xA8F7,
    0xA8F8, 0xA8FB, 0xA8FC, 0xA8FD, 0xA8FE, 0xA5B0, 0xA5B1, 0xA5B2,
    0xA5B3, 0xA5B4, 0xA5B5, 0xA5B6, 0xA5B7, 0xA5B8, 0xA5B9, 0xA5A1,
    0xA5A2, 0xA5A3, 0xA5A4, 0xA5A5, 0xA5A6, 0xA5A7, 0xA5A8, 0xA5A9,
    0xA5AA, 0xA1E7, 0xA1E8, 0xA1E6, 0xA1E9, 0xA1EA, 0xA2D5, 0xA2D8,
    0xA2D6, 0xA2D9, 0xA2D7, 0xA2A1, 0xA2A2, 0xA2A3, 0xA1D3, 0xA2A4,
    0xA1D4, 0xA1F4, 0xA1F5, 0xA2B3, 0xA2B2, 0xA1EE, 0xA1F0, 0xA1C4,
    0xA1D0, 0xA1AB, 0xA1FC, 0xA1FD, 0xA1FB, 0xA1FA, 0xA1F2, 0xA1F3,
    0xA2B1, 0xA1C5, 0xA1F1, 0xA1AD, 0xA1EF, 0xA1D6, 0xA1C1, 0xA1D5,
    0xA1C2, 0xA1C3, 0xA1EC, 0xA1ED, 0xA1F8, 0xA1F9, 0xA1F6, 0xA1F7,
    0xA2C1, 0xA1D1, 0xA1D2, 0xA8E7, 0xA8E8, 0xA8E9, 0xA8EA, 0xA8EB,
    0xA8EC, 0xA8ED, 0xA8EE, 0xA8EF, 0xA8F0, 0xA8F1, 0xA8F2, 0xA8F3,
    0xA8F4, 0xA8F5, 0xA9E7, 0xA9E8, 0xA9E9, 0xA9EA, 0xA9EB, 0xA9EC,
    0xA9ED, 0xA9EE, 0xA9EF, 0xA9F0, 0xA9F1, 0xA9F2, 0xA9F3, 0xA9F4,
    0xA9F5, 0xA9CD, 0xA9CE, 0xA9CF, 0xA9D0, 0xA9D1, 0xA9D2, 0xA9D3,
    0xA9D4, 0xA9D5, 0xA9D6, 0xA9D7, 0xA9D8, 0xA9D9, 0xA9DA, 0xA9DB,
    0xA9DC, 0xA9DD, 0xA9DE, 0xA9DF, 0xA9E0, 0xA9E1, 0xA9E2, 0xA9E3,
    0xA9E4, 0xA9E5, 0xA9E6, 0xA8CD, 0xA8CE, 0xA8CF, 0xA8D0, 0xA8D1,
    0xA8D2, 0xA8D3, 0xA8D4, 0xA8D5, 0xA8D6, 0xA8D7, 0xA8D8, 0xA8D9,
    0xA8DA, 0xA8DB, 0xA8DC, 0xA8DD, 0xA8DE, 0xA8DF, 0xA8E0, 0xA8E1,
    0xA8E2, 0xA8E3, 0xA8E4, 0xA8E5, 0xA8E6, 0xA6A1, 0xA6AC, 0xA6A2,
    0xA6AD, 0xA6A3, 0xA6C8, 0xA6C7, 0xA6AE, 0xA6A4, 0xA6C2, 0xA6C1,
    0xA6AF, 0xA6A6, 0xA6C6, 0xA6C5, 0xA6B1, 0xA6A5, 0xA6C4, 0xA6C3,
    0xA6B0, 0xA6A7, 0xA6BC, 0xA6C9, 0xA6CA, 0xA6B7, 0xA6CB, 0xA6CC,
    0xA6B2, 0xA6A9, 0xA6BE, 0xA6CD, 0xA6CE, 0xA6B9, 0xA6CF, 0xA6D0,
    0xA6B4, 0xA6A8, 0xA6D1, 0xA6D2, 0xA6B8, 0xA6BD, 0xA6D3, 0xA6D4,
    0xA6B3, 0xA6AA, 0xA6D5, 0xA6D6, 0xA6BA, 0xA6BF, 0xA6D7, 0xA6D8,
    0xA6B5, 0xA6AB, 0xA6D9, 0xA6DA, 0xA6BB, 0xA6DB, 0xA6DC, 0xA6C0,
    0xA6DD, 0xA6DE, 0xA6DF, 0xA6E0, 0xA6E1, 0xA6E2, 0xA6E3, 0xA6E4,
    0xA6B6, 0xA2C6, 0xA1E1, 0xA1E0, 0xA2C3, 0xA2C7, 0xA2C8, 0xA2CB,
    0xA2CA, 0xA2C9, 0xA2CC, 0xA1E3, 0xA1E2, 0xA2BA, 0xA2B9, 0xA1E5,
    0xA1E4, 0xA2B8, 0xA2B7, 0xA1DF, 0xA1DE, 0xA2C2, 0xA1DB, 0xA1DD,
    0xA1DC, 0xA2C4, 0xA2C5, 0xA1DA, 0xA1D9, 0xA2CF, 0xA2CE, 0xA2D0,
    0xA2D1, 0xA1CF, 0xA1CE, 0xA2BC, 0xA2BD, 0xA2C0, 0xA2BB, 0xA2BE,
    0xA2BF, 0xA2CD, 0xA2DB, 0xA2DC, 0xA2DD, 0xA2DA, 0xA1A1, 0xA1A2,
    0xA1A3, 0xA1A8, 0xA1B4, 0xA1B5, 0xA1B6, 0xA1B7, 0xA1B8, 0xA1B9,
    0xA1BA, 0xA1BB, 0xA1BC, 0xA1BD, 0xA1EB, 0xA1B2, 0xA1B3, 0xAAA1,
    0xAAA2, 0xAAA3, 0xAAA4, 0xAAA5, 0xAAA6, 0xAAA7, 0xAAA8, 0xAAA9,
    0xAAAA, 0xAAAB, 0xAAAC, 0xAAAD, 0xAAAE, 0xAAAF, 0xAAB0, 0xAAB1,
    0xAAB2, 0xAAB3, 0xAAB4, 0xAAB5, 0xAAB6, 0xAAB7, 0xAAB8, 0xAAB9,
    0xAABA, 0xAABB, 0xAABC, 0xAABD, 0xAABE, 0xAABF, 0xAAC0, 0xAAC1,
    0xAAC2, 0xAAC3, 0xAAC4, 0xAAC5, 0xAAC6, 0xAAC7, 0xAAC8, 0xAAC9,
    0xAACA, 0xAACB, 0xAACC, 0xAACD, 0xAACE, 0xAACF, 0xAAD0, 0xAAD1,
    0xAAD2, 0xAAD3, 0xAAD4, 0xAAD5, 0xAAD6, 0xAAD7, 0xAAD8, 0xAAD9,
    0xAADA, 0xAADB, 0xAADC, 0xAADD, 0xAADE, 0xAADF, 0xAAE0, 0xAAE1,
    0xAAE2, 0xAAE3, 0xAAE4, 0xAAE5, 0xAAE6, 0xAAE7, 0xAAE8, 0xAAE9,
    0xAAEA, 0xAAEB, 0xAAEC, 0xAAED, 0xAAEE, 0xAAEF, 0xAAF0, 0xAAF1,
    0xAAF2, 0xAAF3, 0xABA1, 0xABA2, 0xABA3, 0xABA4, 0xABA5, 0xABA6,
    0xABA7, 0xABA8, 0xABA9, 0xABAA, 0xABAB, 0xABAC, 0xABAD, 0xABAE,
    0xABAF, 0xABB0, 0xABB1, 0xABB2, 0xABB3, 0xABB4, 0xABB5, 0xABB6,
    0xABB7, 0xABB8, 0xABB9, 0xABBA, 0xABBB, 0xABBC, 0xABBD, 0xABBE,
    0xABBF, 0xABC0, 0xABC1, 0xABC2, 0xABC3, 0xABC4, 0xABC5, 0xABC6,
    0xABC7, 0xABC8, 0xABC9, 0xABCA, 0xABCB, 0xABCC, 0xABCD, 0xABCE,
    0xABCF, 0xABD0, 0xABD1, 0xABD2, 0xABD3, 0xABD4, 0xABD5, 0xABD6,
    0xABD7, 0xABD8, 0xABD9, 0xABDA, 0xABDB, 0xABDC, 0xABDD, 0xABDE,
    0xABDF, 0xABE0, 0xABE1, 0xABE2, 0xABE3, 0xABE4, 0xABE5, 0xABE6,
    0xABE7, 0xABE8, 0xABE9, 0xABEA, 0xABEB, 0xABEC, 0xABED, 0xABEE,
    0xABEF, 0xABF0, 0xABF1, 0xABF2, 0xABF3, 0xABF4, 0xABF5, 0xABF6,
    0xA4A1, 0xA4A2, 0xA4A3, 0xA4A4, 0xA4A5, 0xA4A6, 0xA4A7, 0xA4A8,
    0xA4A9, 0xA4AA, 0xA4AB, 0xA4AC, 0xA4AD, 0xA4AE, 0xA4AF, 0xA4B0,
    0xA4B1, 0xA4B2, 0xA4B3, 0xA4B4, 0xA4B5, 0xA4B6, 0xA4B7, 0xA4B8,
    0xA4B9, 0xA4BA, 0xA4BB, 0xA4BC, 0xA4BD, 0xA4BE, 0xA4BF, 0xA4C0,
    0xA4C1, 0xA4C2, 0xA4C3, 0xA4C4, 0xA4C5, 0xA4C6, 0xA4C7, 0xA4C8,
    0xA4C9, 0xA4CA, 0xA4CB, 0xA4CC, 0xA4CD, 0xA4CE, 0xA4CF, 0xA4D0,
    0xA4D1, 0xA4D2, 0xA4D3, 0xA4D4, 0xA4D5, 0xA4D6, 0xA4D7, 0xA4D8,
    0xA4D9, 0xA4DA, 0xA4DB, 0xA4DC, 0xA4DD, 0xA4DE, 0xA4DF, 0xA4E0,
    0xA4E1, 0xA4E2, 0xA4E3, 0xA4E4, 0xA4E5, 0xA4E6, 0xA4E7, 0xA4E8,
    0xA4E9, 0xA4EA, 0xA4EB, 0xA4EC, 0xA4ED, 0xA4EE, 0xA4EF, 0xA4F0,
    0xA4F1, 0xA4F2, 0xA4F3, 0xA4F4, 0xA4F5, 0xA4F6, 0xA4F7, 0xA4F8,
    0xA4F9, 0xA4FA, 0xA4FB, 0xA4FC, 0xA4FD, 0xA4FE, 0xA9B1, 0xA9B2,
    0xA9B3, 0xA9B4, 0xA9B5, 0xA9B6, 0xA9B7, 0xA9B8, 0xA9B9, 0xA9BA,
    0xA9BB, 0xA9BC, 0xA9BD, 0xA9BE, 0xA9BF, 0xA9C0, 0xA9C1, 0xA9C2,
    0xA9C3, 0xA9C4, 0xA9C5, 0xA9C6, 0xA9C7, 0xA9C8, 0xA9C9, 0xA9CA,
    0xA9CB, 0xA9CC, 0xA2DF, 0xA8B1, 0xA8B2, 0xA8B3, 0xA8B4, 0xA8B5,
    0xA8B6, 0xA8B7, 0xA8B8, 0xA8B9, 0xA8BA, 0xA8BB, 0xA8BC, 0xA8BD,
    0xA8BE, 0xA8BF, 0xA8C0, 0xA8C1, 0xA8C2, 0xA8C3, 0xA8C4, 0xA8C5,
    0xA8C6, 0xA8C7, 0xA8C8, 0xA8C9, 0xA8CA, 0xA8CB, 0xA8CC, 0xA2E8,
    0xA2DE, 0xA7C9, 0xA7CA, 0xA7CB, 0xA7CC, 0xA7CD, 0xA7BA, 0xA7BB,
    0xA7DC, 0xA7DD, 0xA7DE, 0xA7B6, 0xA7B7, 0xA7B8, 0xA7D4, 0xA7D5,
    0xA7D6, 0xA7D7, 0xA7D8, 0xA7A1, 0xA7A2, 0xA7A3, 0xA7A5, 0xA7AB,
    0xA7AC, 0xA7AD, 0xA7AE, 0xA7AF, 0xA7B0, 0xA7B1, 0xA7B2, 0xA7B3,
    0xA7B4, 0xA7A7, 0xA7A8, 0xA7A9, 0xA7AA, 0xA7BD, 0xA7BE, 0xA7E5,
    0xA7E6, 0xA7E7, 0xA7E8, 0xA7E1, 0xA7E2, 0xA7E3, 0xA7BF, 0xA7C0,
    0xA7C1, 0xA7C2, 0xA7C3, 0xA7C4, 0xA7C5, 0xA7C6, 0xA7C7, 0xA7C8,
    0xA7CE, 0xA7CF, 0xA7D0, 0xA7D1, 0xA7D2, 0xA7D3, 0xA7DA, 0xA7DB,
    0xA2E3, 0xA7EC, 0xA7A6, 0xA7E0, 0xA7EF, 0xA2E1, 0xA7BC, 0xA7ED,
    0xA7B5, 0xA7B9, 0xA7EA, 0xA7EB, 0xA7DF, 0xA2E4, 0xA7E4, 0xA7EE,
    0xA7E9, 0xECE9, 0xEFCB, 0xF6D2, 0xD8B2, 0xEDDB, 0xDFB2, 0xDFBE,
    0xF9BB, 0xDCF4, 0xF5E4, 0xF3A6, 0xDDE0, 0xE1A6, 0xCEF8, 0xDCB0,
    0xE3AA, 0xF1E9, 0xCDFA, 0xFCAF, 0xD3A1, 0xF1AB, 0xE7D1, 0xD2AC,
    0xCEF9, 0xF1FD, 0xDEBF, 0xFBBA, 0xF9B9, 0xCED2, 0xE3AB, 0xEBE0,
    0xCEFA, 0xCBF7, 0xE5A5, 0xCAE1, 0xD4CC, 0xEAE1, 0xDCE3, 0xDFAD,
    0xCBEB, 0xD5AF, 0xD6F5, 0xE5F8, 0xDEC0, 0xECA3, 0xE9CD, 0xEAA7,
    0xE9F6, 0xFBBB, 0xE7E9, 0xEFCC, 0xD0E6, 0xDEC1, 0xE4AC, 0xD8CC,
    0xF9F1, 0xCEDF, 0xFAA4, 0xE6B2, 0xFAFB, 0xFABD, 0xCCC8, 0xEFCD,
    0xD5D5, 0xD3A2, 0xECD1, 0xE4A7, 0xECD2, 0xF6B1, 0xCEFB, 0xD0D1,
    0xCBBF, 0xEDA4, 0xEDA8, 0xDEC2, 0xF6E2, 0xEDDC, 0xDCF5, 0xE0B9,
    0xD4CE, 0xF4B5, 0xD3DB, 0xD6B5, 0xECA4, 0xE4E6, 0xF1EA, 0xCBEC,
    0xCBC0, 0xECF2, 0xD0EA, 0xF9F2, 0xECA5, 0xD0DF, 0xE7EA, 0xD0EB,
    0xDCD1, 0xDBE9, 0xFDCC, 0xDBD7, 0xDAE1, 0xD6B6, 0xE3DF, 0xDEC3,
    0xDEC4, 0xCAA1, 0xEEEC, 0xD3A3, 0xEEB7, 0xF8CF, 0xEAC8, 0xEEB8,
    0xF1AC, 0xF1A5, 0xE9CE, 0xF9BC, 0xE5F9, 0xECEA, 0xDDD6, 0xEDC2,
    0xF8A5, 0xE5BA, 0xDBD8, 0xCAA2, 0xD1CD, 0xEEED, 0xECEB, 0xDEC5,
    0xE3E0, 0xCAC9, 0xF2E9, 0xD5CE, 0xF6B6, 0xCEC2, 0xD6C7, 0xE3B4,
    0xF1AD, 0xEAE2, 0xD7C2, 0xF3A7, 0xCDEA, 0xEBEE, 0xD9B2, 0xFDA5,
    0xF6D5, 0xD5E2, 0xF8B5, 0xCCF5, 0xF5B5, 0xE4AD, 0xE7EB, 0xF1D5,
    0xF0BB, 0xE9B5, 0xCCC9, 0xFAD5, 0xE1D4, 0xD7D6, 0xDCC1, 0xDEC6,
    0xFAEF, 0xE3E1, 0xE1F3, 0xDCF6, 0xCEFC, 0xDBC4, 0xF8F1, 0xDCE4,
    0xE5EF, 0xDCB1, 0xD5D6, 0xF3DA, 0xCBC1, 0xDBC3, 0xD9FA, 0xD3EE,
    0xFAB8, 0xFDA6, 0xEBEF, 0xF4A6, 0xCCCA, 0xF3A8, 0xF3DB, 0xDBA7,
    0xF6B7, 0xCFE6, 0xF0F2, 0xCBDA, 0xE7D2, 0xD7C3, 0xF6F0, 0xE8DE,
    0xE5A6, 0xE5E7, 0xCAA3, 0xCCA7, 0xEAC9, 0xF8B6, 0xFAA5, 0xF1AE,
    0xEFCE, 0xCBED, 0xF6B0, 0xEFCF, 0xE9CF, 0xF7DE, 0xCED3, 0xDCF7,
    0xDBA8, 0xCBF8, 0xDFA1, 0xDDE1, 0xF5CA, 0xE9B6, 0xE7EC, 0xEEEE,
    0xF3F0, 0xDFBF, 0xCCCB, 0xD0C1, 0xF4D2, 0xE0BA, 0xDFC0, 0xCEE0,
    0xDCD2, 0xFDEA, 0xD6F6, 0xEACA, 0xE8E9, 0xE3AC, 0xF3D0, 0xCAA4,
    0xDBF8, 0xDEC7, 0xEBF0, 0xF1D6, 0xE5E2, 0xCCCC, 0xCBFB, 0xEAE3,
    0xDFC1, 0xD6ED, 0xE9D0, 0xEEB9, 0xD5E3, 0xD1D3, 0xE5F0, 0xE8B4,
    0xEBC3, 0xEAAA, 0xFAFC, 0xF5F6, 0xF0BC, 0xFDD4, 0xE0BB, 0xCEC3,
    0xD0BA, 0xF7BA, 0xD8F3, 0xF7CD, 0xE4AE, 0xD4DF, 0xD0E7, 0xECFD,
    0xD2AE, 0xEEEF, 0xD5D7, 0xEAE4, 0xF8A2, 0xCDEB, 0xD7BF, 0xFBB1,
    0xCDEC, 0xDCB2, 0xD0EC, 0xCEFD, 0xEEF0, 0xCCC2, 0xD0ED, 0xE5F7,
    0xF3FC, 0xEEA2, 0xD9B3, 0xD8F4, 0xE9B7, 0xCEAE, 0xD9A2, 0xD8F1,
    0xD4CF, 0xE5A7, 0xD5D2, 0xD6A9, 0xF4A2, 0xF1D7, 0xD5D8, 0xF0BD,
    0xD7D0, 0xD4D0, 0xD7CF, 0xEBEA, 0xFDEB, 0xDBED, 0xFCC5, 0xCBC2,
    0xFDD5, 0xF4C8, 0xE8EA, 0xF5F3, 0xF9DE, 0xD3EF, 0xECD3, 0xDDC2,
    0xEFB7, 0xE7D4, 0xCACA, 0xD9FB, 0xFAFD, 0xD6AA, 0xF4F8, 0xF7F7,
    0xDCAC, 0xD7D7, 0xDFA2, 0xCEBE, 0xD3F0, 0xF0A4, 0xE1EC, 0xCFE7,
    0xF3CB, 0xEDA9, 0xCABE, 0xF4EF, 0xF6CE, 0xDEFB, 0xD0BB, 0xD5B7,
    0xEEF1, 0xF4A8, 0xDCF8, 0xCBA7, 0xDACE, 0xE0E6, 0xEDA5, 0xEEF2,
    0xDCF9, 0xF9DC, 0xF3DC, 0xF8F2, 0xF4F9, 0xFCF1, 0xD0BC, 0xDBF9,
    0xD7B1, 0xCBFC, 0xF0A5, 0xCBFD, 0xD5F4, 0xCDED, 0xCAA5, 0xD6AB,
    0xD0C2, 0xF0BE, 0xD2BD, 0xCCA4, 0xFAB6, 0xCCCD, 0xDAFA, 0xF6CF,
    0xE9B8, 0xD8F5, 0xCCCE, 0xD7CD, 0xD4D1, 0xE9ED, 0xCAEB, 0xD9E2,
    0xFDB2, 0xE3AD, 0xD6CC, 0xD9B4, 0xE1A7, 0xEED3, 0xD0C3, 0xFDB3,
    0xD5E4, 0xCFE8, 0xEDC3, 0xD0B2, 0xCEFE, 0xDAA8, 0xF8D0, 0xFDD6,
    0xF8D1, 0xF8D2, 0xDCD3, 0xDDE2, 0xFBF9, 0xDDC1, 0xE3B5, 0xEDDD,
    0xCEC4, 0xCBA1, 0xDDE3, 0xFCDD, 0xF9AF, 0xD2FB, 0xCFA1, 0xE4A8,
    0xF4B6, 0xECFE, 0xE3AE, 0xE7ED, 0xFDC1, 0xDAE2, 0xD8B3, 0xDDE4,
    0xF0EF, 0xF6F1, 0xFAF0, 0xD1F5, 0xDACF, 0xDCD4, 0xDCA6, 0xEFBF,
    0xCECF, 0xE0D9, 0xD9D6, 0xECD4, 0xEACB, 0xCABF, 0xD5B0, 0xCFE9,
    0xF1ED, 0xCCCF, 0xE4F8, 0xE4ED, 0xD7D8, 0xFDA7, 0xEAAB, 0xF6B2,
    0xCFF0, 0xF9BD, 0xE6F4, 0xCBDB, 0xF3D1, 0xE9D1, 0xF3A9, 0xD0E0,
    0xE9D2, 0xDAE3, 0xE2D2, 0xF6A2, 0xE1F4, 0xDAE4, 0xE7D5, 0xF5BF,
    0xCFA2, 0xCDAF, 0xCFA3, 0xCDB0, 0xF1FE, 0xD0A3, 0xE1AF, 0xF8A3,
    0xCAA6, 0xF7BB, 0xF2EA, 0xDEC8, 0xE9D3, 0xDEC9, 0xFDDE, 0xCAC0,
    0xF9EA, 0xD1CE, 0xEED4, 0xD4D2, 0xD9A3, 0xFDA8, 0xD7D9, 0xF7CE,
    0xFABE, 0xCFD6, 0xD7F0, 0xEBE1, 0xF8C5, 0xDCFA, 0xDDC3, 0xF9DF,
    0xE7EF, 0xFDE5, 0xF6A3, 0xD9FC, 0xFDA9, 0xE7EE, 0xD5E5, 0xEFD0,
    0xCDB1, 0xF7A2, 0xF1B2, 0xF1B1, 0xCDB2, 0xDAAB, 0xCAA7, 0xE3E2,
    0xFBBC, 0xD9A4, 0xEEBA, 0xF8D3, 0xFBFA, 0xCFA4, 0xDCFB, 0xF6E3,
    0xEDAA, 0xF2A1, 0xCEE1, 0xFAA6, 0xF9E0, 0xECD6, 0xE4EE, 0xF9A1,
    0xFBEF, 0xF9EB, 0xEEA3, 0xEAAC, 0xCAA8, 0xF4FA, 0xCDD6, 0xFCF6,
    0xF4C9, 0xF8D4, 0xF8A6, 0xDECA, 0xF2C6, 0xD7DA, 0xD3D0, 0xD8C5,
    0xEAE6, 0xF3DD, 0xE4DA, 0xF6E4, 0xF6F2, 0xDFC2, 0xD9FD, 0xCCF6,
    0xD3BA, 0xE4AF, 0xF9E1, 0xF0A6, 0xCBD3, 0xE0BC, 0xF4CA, 0xD4FA,
    0xFDAA, 0xF9E2, 0xF4B7, 0xFDC2, 0xFCB0, 0xFDEC, 0xCAE2, 0xFDBD,
    0xEAE7, 0xDFC3, 0xD1D2, 0xCEE2, 0xD3A4, 0xFDAB, 0xDFE0, 0xF2C7,
    0xE7F0, 0xD0EE, 0xF3AA, 0xDECB, 0xF6B8, 0xE1F5, 0xF1B3, 0xF7A3,
    0xCAA9, 0xCFA5, 0xDFC4, 0xE1B0, 0xF0BF, 0xF6A4, 0xE3B6, 0xFAC6,
    0xD0EF, 0xFDED, 0xDDC4, 0xFCF7, 0xE6BF, 0xDEAD, 0xFABF, 0xE5F1,
    0xEDC4, 0xD2A5, 0xFDEE, 0xF5B6, 0xE1F6, 0xDECC, 0xFCDE, 0xECD7,
    0xCDDD, 0xD6B7, 0xCDB3, 0xF8D5, 0xE5D8, 0xCFEA, 0xCFD0, 0xEACC,
    0xEAAE, 0xEAAD, 0xD3F1, 0xD3A5, 0xF7CF, 0xEEA4, 0xD0A4, 0xF2A2,
    0xD0F0, 0xF2A3, 0xF7F8, 0xD0B3, 0xDBA9, 0xD3BB, 0xCAEC, 0xF1A6,
    0xCBD5, 0xF7E7, 0xCDDE, 0xF7A4, 0xF8C0, 0xD3DD, 0xCCD0, 0xCFA6,
    0xF6F3, 0xE1F7, 0xD3DC, 0xFAFE, 0xFAA7, 0xEBD9, 0xCFA7, 0xEAAF,
    0xE4EF, 0xE9B9, 0xF1D8, 0xD8D8, 0xE0F2, 0xE6B4, 0xDCFC, 0xF3F1,
    0xE3D0, 0xF2FB, 0xDBC6, 0xD0F1, 0xD0F2, 0xCFDC, 0xD3D1, 0xCCB1,
    0xF7D8, 0xCBA8, 0xEBBC, 0xE4BE, 0xF4DC, 0xDCC2, 0xF0A7, 0xE6C0,
    0xCAED, 0xE8EB, 0xE5E8, 0xDCC3, 0xEDDE, 0xD3F2, 0xCCF7, 0xCED4,
    0xE7AB, 0xCBC3, 0xE1B1, 0xF7B2, 0xD3F3, 0xD3D2, 0xF5C0, 0xDFDD,
    0xEEF3, 0xE7F1, 0xFDB4, 0xF2C8, 0xF3D2, 0xEEF4, 0xE2D3, 0xCCD1,
    0xDFEA, 0xE9BA, 0xD9D7, 0xF5CD, 0xF1F2, 0xFAC7, 0xD9F8, 0xD4C2,
    0xF6E5, 0xDDC5, 0xE7F2, 0xEDDF, 0xCACB, 0xDBFA, 0xE8B5, 0xD3A6,
    0xFDB5, 0xF9C9, 0xE4E2, 0xFBBD, 0xD7A4, 0xCEC5, 0xCED5, 0xD6E6,
    0xE5BD, 0xDECD, 0xECF3, 0xEDE0, 0xECEC, 0xFBBE, 0xDFEB, 0xE1F8,
    0xF9BE, 0xD0F3, 0xE0AA, 0xE8E2, 0xE2D4, 0xD2FD, 0xE5A8, 0xD9D3,
    0xD3DE, 0xF4B8, 0xF7BC, 0xDCFD, 0xE8EC, 0xE4E7, 0xE3F7, 0xECA8,
    0xFAF1, 0xE5F2, 0xD0F4, 0xD2AF, 0xDCE5, 0xD0A5, 0xF1B4, 0xFCB1,
    0xCCF8, 0xDDC6, 0xFAD1, 0xF7DF, 0xFAA8, 0xEEF5, 0xDECE, 0xE7F3,
    0xF7AC, 0xEBC4, 0xEDE1, 0xE0AB, 0xDDC7, 0xD2B3, 0xD2BF, 0xCACC,
    0xFBBF, 0xE5FD, 0xDDE5, 0xD8CD, 0xECF4, 0xD0F5, 0xE8ED, 0xD0D2,
    0xD9D8, 0xF6E6, 0xDBAA, 0xF7E0, 0xD8D9, 0xF4A3, 0xF4DD, 0xEFD1,
    0xD9B5, 0xEDAB, 0xE3B7, 0xEEBB, 0xCDB4, 0xE0F3, 0xEACD, 0xECF5,
    0xE8EE, 0xCBA9, 0xF1AF, 0xCACD, 0xECA9, 0xF2EB, 0xFDEF, 0xF9F3,
    0xE6C1, 0xECD8, 0xEDAC, 0xEACE, 0xE8DF, 0xDECF, 0xD2A6, 0xE7F4,
    0xD1D6, 0xE6C2, 0xE3E3, 0xE4B0, 0xD8B4, 0xF6A5, 0xF3DE, 0xD7A5,
    0xF7E8, 0xE8C6, 0xFBE6, 0xDDE6, 0xDCFE, 0xD8DA, 0xDAAC, 0xEAB0,
    0xE3B8, 0xCAAA, 0xE1F9, 0xEAB1, 0xF2EC, 0xFAEE, 0xEED5, 0xF9F4,
    0xD2EC, 0xFBFB, 0xFDF0, 0xE0BD, 0xCEE3, 0xF8C6, 0xDEAE, 0xDFC5,
    0xE5BE, 0xEDAD, 0xFAEA, 0xCDEE, 0xEDA6, 0xEDAE, 0xF0ED, 0xDDA1,
    0xEDAF, 0xFCF8, 0xD8EB, 0xCCF9, 0xCDB5, 0xFAA9, 0xE1DD, 0xE2D5,
    0xEDCF, 0xDDA2, 0xF9CA, 0xEAE8, 0xE5ED, 0xD3EB, 0xE9D4, 0xE1FA,
    0xE4CC, 0xE1E4, 0xE8C7, 0xCEDB, 0xDCD5, 0xF7B5, 0xFCF3, 0xF0F3,
    0xCEAF, 0xF1B5, 0xEFD2, 0xE8C8, 0xEBF1, 0xCBD4, 0xE0BE, 0xE3F8,
    0xEAE9, 0xFCB2, 0xE0F4, 0xCFE0, 0xEEA5, 0xFAAA, 0xE6C3, 0xE1B2,
    0xCAAB, 0xE3E4, 0xE9BB, 0xE2D6, 0xF3F2, 0xEED6, 0xEAB2, 0xD0F6,
    0xECD9, 0xDACB, 0xCFA8, 0xDDA3, 0xD8DB, 0xF9CE, 0xE9D5, 0xE3D1,
    0xD2BC, 0xD8AC, 0xF3CC, 0xCDFB, 0xF6D6, 0xE7F5, 0xE8EF, 0xE3F9,
    0xD2BB, 0xF3F3, 0xE3FB, 0xDED0, 0xCEB0, 0xD6F7, 0xF1D9, 0xF5C1,
    0xDCC4, 0xF5BB, 0xDED1, 0xDCE6, 0xDED2, 0xEDE2, 0xEEF6, 0xEACF,
    0xF0EE, 0xE3FC, 0xD3DF, 0xD3F4, 0xE1B3, 0xE1B4, 0xF4D3, 0xDFC6,
    0xE9D6, 0xDBAB, 0xF6A6, 0xE3B9, 0xEBC5, 0xF4A9, 0xCDB6, 0xD2F9,
    0xDAAD, 0xD2E3, 0xCFD1, 0xCBDC, 0xCCFA, 0xCFDD, 0xE8A9, 0xE3BB,
    0xE3BA, 0xE0DA, 0xEEF7, 0xDCB3, 0xD3F5, 0xD7A6, 0xF6B5, 0xD7DB,
    0xE1D5, 0xD4EA, 0xDFA3, 0xFDDF, 0xD0F7, 0xEDD4, 0xCBAA, 0xE4DB,
    0xE1FB, 0xCBA2, 0xD3E0, 0xE4BF, 0xFBC0, 0xDABE, 0xE4CD, 0xD6B9,
    0xEFC0, 0xE1FC, 0xF6B9, 0xDFC7, 0xE4B1, 0xDCE7, 0xDCE8, 0xFAD6,
    0xD3F6, 0xF1DA, 0xFAF2, 0xE2FD, 0xD5CF, 0xD0F8, 0xCDDF, 0xF5CB,
    0xE4F0, 0xCBAB, 0xD7C4, 0xE2FE, 0xDDDA, 0xDAAE, 0xCAEE, 0xD5B9,
    0xE3A1, 0xE8E3, 0xF3AB, 0xCFA9, 0xD3F7, 0xD4F1, 0xCEE4, 0xE8F2,
    0xE5F5, 0xE7AE, 0xD6BA, 0xDFEC, 0xE4C0, 0xE8E4, 0xD8B5, 0xE4DC,
    0xF4B9, 0xF1B6, 0xE2DE, 0xE1B5, 0xCDEF, 0xF1A7, 0xCEE5, 0xCBDD,
    0xD9E3, 0xF3AC, 0xD0F9, 0xECAB, 0xDED3, 0xF7E9, 0xF9F5, 0xE1DE,
    0xCBEE, 0xE3BC, 0xF8D6, 0xDBEE, 0xFDF1, 0xF7B6, 0xF4DE, 0xF2ED,
    0xDBD9, 0xF0A8, 0xE1FD, 0xDED4, 0xE0AC, 0xEDE3, 0xD3E1, 0xDFC8,
    0xD9B6, 0xFDAC, 0xEFD3, 0xE4C1, 0xF8EB, 0xDBAC, 0xFCC6, 0xD8AD,
    0xF6BA, 0xDBDF, 0xD3D3, 0xF8C7, 0xCACE, 0xF8C1, 0xD2B4, 0xDCB4,
    0xFAB9, 0xCACF, 0xFCB3, 0xEAEA, 0xEAEB, 0xD0FA, 0xEDE4, 0xDDE7,
    0xDFC9, 0xDFED, 0xEEBC, 0xEFC1, 0xCCD2, 0xDDA4, 0xDFCA, 0xD3F8,
    0xF1A8, 0xCDB7, 0xEFD4, 0xE4DD, 0xDFEE, 0xCBAC, 0xE9BC, 0xEAEC,
    0xDFCB, 0xF9BF, 0xD6AF, 0xD5C6, 0xCFAA, 0xCEA9, 0xD6F8, 0xF1B7,
    0xEEF8, 0xD9D9, 0xF3DF, 0xF8C8, 0xCEC6, 0xD5E6, 0xF4E6, 0xE6C5,
    0xEFD5, 0xCBEF, 0xFCDF, 0xDCA7, 0xD6E7, 0xF8C9, 0xE3D2, 0xE3BD,
    0xCFE1, 0xF0C0, 0xECDA, 0xDDD7, 0xFBF0, 0xECAC, 0xF0A9, 0xFAD7,
    0xFBC1, 0xD2C0, 0xE5B0, 0xEDE5, 0xCBAD, 0xF9B0, 0xF7A5, 0xCBAE,
    0xDAAF, 0xD8B6, 0xD3A7, 0xFBB2, 0xFDC4, 0xECAD, 0xFBA1, 0xE5E9,
    0xE9EE, 0xF3F4, 0xF8F3, 0xF0C1, 0xDEAF, 0xF8B0, 0xF3E0, 0xE7AF,
    0xDBAD, 0xE6B5, 0xF9A8, 0xDDD8, 0xE8D9, 0xEFD6, 0xD3E2, 0xE2DF,
    0xFCE0, 0xD7C8, 0xFDAD, 0xDFEF, 0xCCD3, 0xD3F9, 0xD4F0, 0xDBC7,
    0xDED5, 0xF0F4, 0xD5D0, 0xE5D9, 0xFCC7, 0xDCD6, 0xE2E0, 0xDAB0,
    0xF3A3, 0xD3EC, 0xF4CB, 0xFDC5, 0xE3FD, 0xF9B1, 0xD0FB, 0xECDB,
    0xF5BC, 0xF2A4, 0xD8CE, 0xD8CF, 0xF5F7, 0xF6E1, 0xD2B7, 0xFBEC,
    0xDDC8, 0xE4E8, 0xD2C1, 0xF8D7, 0xD6BB, 0xDED6, 0xF7BD, 0xECAE,
    0xD0E1, 0xE0F5, 0xEAB3, 0xCED6, 0xCCA5, 0xECF6, 0xE2E1, 0xE3BE,
    0xFCC8, 0xCDF0, 0xF9F6, 0xDFF0, 0xE5BF, 0xCEBF, 0xFCE1, 0xEDB0,
    0xFDD1, 0xF6BB, 0xF9CF, 0xEBDA, 0xCAC1, 0xD2B8, 0xCDF1, 0xE3D3,
    0xFDE6, 0xE6ED, 0xE3FA, 0xF0AA, 0xF9D0, 0xFCE2, 0xF8A7, 0xE1E5,
    0xEEF9, 0xE7F6, 0xEAED, 0xFCB4, 0xF5C2, 0xD7DC, 0xF0F5, 0xDDE8,
    0xD3ED, 0xF5FC, 0xDABF, 0xCCFB, 0xD3FA, 0xF4A4, 0xEFD7, 0xD4C3,
    0xFBE3, 0xFBED, 0xE0AD, 0xEAEE, 0xFBB3, 0xE4C2, 0xF6E7, 0xD2DD,
    0xDFCC, 0xFCC9, 0xE5A9, 0xE0F6, 0xF6B3, 0xE1FE, 0xCBF0, 0xEAEF,
    0xEAF0, 0xDAC0, 0xF8B4, 0xEBF2, 0xE4C3, 0xE9D7, 0xE4F1, 0xCAEF,
    0xCED7, 0xFCCA, 0xF3E1, 0xCBC4, 0xE3E5, 0xCBC5, 0xEAB4, 0xE9BD,
    0xD7C9, 0xEBDB, 0xEDB1, 0xCCC3, 0xF7BE, 0xFCCB, 0xF8F4, 0xD9B7,
    0xF3D3, 0xF3D4, 0xF7E4, 0xF7D1, 0xD8B7, 0xCEB1, 0xCAC2, 0xFBB4,
    0xCBC6, 0xF0F6, 0xD5E7, 0xEAD0, 0xCCD4, 0xCBAF, 0xF4AA, 0xE9AF,
    0xF5C3, 0xE9D8, 0xDDE9, 0xF1F3, 0xD5FB, 0xDEBB, 0xF4FB, 0xFDF3,
    0xFDF2, 0xF7A6, 0xDDC9, 0xD4D3, 0xCCA8, 0xDAC1, 0xCCD5, 0xD9E4,
    0xFACA, 0xE5E3, 0xD3BC, 0xCAF0, 0xD0C4, 0xCAD0, 0xFAAB, 0xEBEB,
    0xE7F8, 0xD9E5, 0xD1D7, 0xF3A4, 0xD4FB, 0xFCE3, 0xFAD8, 0xF3D5,
    0xCFAB, 0xEBF3, 0xD5FC, 0xD3D4, 0xCDFC, 0xD9E6, 0xE2F9, 0xE2A1,
    0xEBD4, 0xE0F7, 0xE4B2, 0xCCFC, 0xFBE4, 0xF4AB, 0xD0BD, 0xCAF1,
    0xEFB8, 0xD7C0, 0xEEFA, 0xFDF4, 0xD3E3, 0xFBC2, 0xD5E8, 0xDBAE,
    0xE1B6, 0xF8B7, 0xE0BF, 0xFBC3, 0xDDEA, 0xE2A2, 0xEEA6, 0xF6E8,
    0xF6F5, 0xDDCA, 0xD0E2, 0xDDA6, 0xDDEB, 0xE4F9, 0xE3AF, 0xD0FC,
    0xF4FC, 0xCCBC, 0xF7EA, 0xE5E4, 0xDFF1, 0xF7E1, 0xF9F7, 0xEFB9,
    0xF8D8, 0xF9A9, 0xF8D9, 0xEEBD, 0xD8C6, 0xE4E3, 0xF5CE, 0xDDD9,
    0xD9E7, 0xD2B9, 0xD5C3, 0xDAE5, 0xDAD0, 0xD1D9, 0xCED8, 0xCBDE,
    0xF4AC, 0xDAFB, 0xF6E9, 0xE8F3, 0xCFAC, 0xF0F0, 0xF4FD, 0xDBC8,
    0xCEC0, 0xE3D4, 0xD1CF, 0xF1F5, 0xCDF2, 0xCFEB, 0xCDB8, 0xE3A6,
    0xD1DA, 0xF2A5, 0xF2A6, 0xE4CE, 0xD3FB, 0xF1A9, 0xF2C9, 0xEFD8,
    0xE6C9, 0xD8B8, 0xFAF3, 0xF3B5, 0xF8A4, 0xD1F3, 0xE6C8, 0xF8DA,
    0xDCE9, 0xDED7, 0xCBDF, 0xCFEC, 0xF4DF, 0xD1F4, 0xD2BA, 0xDFF2,
    0xE1B7, 0xE2A3, 0xD3FC, 0xEDE6, 0xDBC9, 0xE4FA, 0xCFDE, 0xCED0,
    0xD5D3, 0xF3F5, 0xF7AE, 0xEFC8, 0xCDF3, 0xF5CF, 0xE5F3, 0xF0C2,
    0xCAD1, 0xEAF1, 0xD0A6, 0xD9DA, 0xF0AB, 0xEBE7, 0xE5C0, 0xFCB5,
    0xE4C4, 0xCCA9, 0xFDC6, 0xEAB5, 0xE5AA, 0xDFBA, 0xE1DF, 0xDAD1,
    0xE1B8, 0xE8F4, 0xD3FD, 0xE2A4, 0xF2CA, 0xDAE6, 0xF7B3, 0xFDCD,
    0xF3B6, 0xEED7, 0xF5C4, 0xD8A4, 0xF2A7, 0xD9B8, 0xD9B9, 0xEFC9,
    0xD6CE, 0xF7CB, 0xDFAE, 0xE8F5, 0xD2B5, 0xD3D5, 0xF4CC, 0xDAFC,
    0xD9E8, 0xF7EB, 0xF5C9, 0xF3BC, 0xDAD2, 0xD3B5, 0xE8B6, 0xD6CF,
    0xF4BA, 0xF7C9, 0xCCAA, 0xF0C3, 0xCCD6, 0xD0D3, 0xD3BD, 0xDBFB,
    0xCBE0, 0xD3E4, 0xF6F7, 0xD5BA, 0xF3CD, 0xCBE1, 0xEBF4, 0xF4AD,
    0xFCAA, 0xF7EC, 0xE8F6, 0xDAE7, 0xF7CC, 0xE5C1, 0xE0EE, 0xD5FD,
    0xCEE6, 0xFCAB, 0xD5BB, 0xF2A8, 0xE2A5, 0xCDB9, 0xEAF2, 0xCBC7,
    0xCDF4, 0xDBAF, 0xEFD9, 0xCDBA, 0xFCF9, 0xDFF3, 0xCEE7, 0xDAC2,
    0xCFAD, 0xE7F9, 0xF8A8, 0xF3E2, 0xCAF2, 0xDFA4, 0xD4C4, 0xCCD7,
    0xE5C2, 0xCDBB, 0xEFDA, 0xEED8, 0xDDA7, 0xE2A6, 0xE0C0, 0xD6B0,
    0xF8CA, 0xFCFA, 0xD9FE, 0xDEB0, 0xDDEC, 0xDAE8, 0xD4E0, 0xD6F9,
    0xCDD7, 0xDED8, 0xF2F8, 0xE4D6, 0xD0C5, 0xF4AE, 0xDDA8, 0xEDC5,
    0xF3D6, 0xDED9, 0xE3E6, 0xD3A8, 0xDBB0, 0xE5DA, 0xE3BF, 0xDBB1,
    0xD5E9, 0xE0C1, 0xEFDB, 0xF0E9, 0xD7B2, 0xD0FD, 0xD9E9, 0xD0FE,
    0xECED, 0xD3A9, 0xF2A9, 0xF0C4, 0xE2E2, 0xE9EF, 0xF9D1, 0xE9D9,
    0xE8DA, 0xDAC3, 0xDAC4, 0xD4C5, 0xE7FA, 0xCDE0, 0xE3B0, 0xDBB2,
    0xFBC4, 0xF3E3, 0xD9A5, 0xFBE7, 0xDDCB, 0xD0D4, 0xE6B6, 0xE0AE,
    0xFDDA, 0xDCB5, 0xE0F8, 0xE7B1, 0xF5F0, 0xD8DC, 0xEDC6, 0xE1B9,
    0xE3C0, 0xF9C0, 0xE9F0, 0xD9DB, 0xF3E4, 0xDCB6, 0xE4E9, 0xF0C5,
    0xE3C1, 0xFCCC, 0xFCCD, 0xF2CB, 0xF2CC, 0xE4CF, 0xF1DB, 0xFAD9,
    0xF1B8, 0xFDF5, 0xE0F9, 0xE7FB, 0xFCB7, 0xFCE4, 0xFBC5, 0xE3E7,
    0xD8B9, 0xF6F8, 0xDCC5, 0xCCD8, 0xE0AF, 0xF4E7, 0xEFDC, 0xCFFC,
    0xEFDD, 0xF2AA, 0xFDBE, 0xCAAC, 0xFDBB, 0xFDC7, 0xE7B2, 0xEAD1,
    0xDFF4, 0xD1EC, 0xE4DE, 0xE5C3, 0xD9A6, 0xCDBC, 0xF3E5, 0xEDD5,
    0xD9BA, 0xEDE7, 0xFBB5, 0xF8EC, 0xE0E7, 0xCCD9, 0xD4C6, 0xE7A5,
    0xD5F5, 0xD3BE, 0xFCFB, 0xE4F2, 0xDFF5, 0xE8F8, 0xF8ED, 0xCEC7,
    0xFDF6, 0xE8D8, 0xCDD8, 0xE7D6, 0xCCDA, 0xCAE3, 0xDFF6, 0xF0C7,
    0xF0C6, 0xD8BA, 0xF1F4, 0xF4F0, 0xF5CC, 0xFCE5, 0xEAC5, 0xEAF3,
    0xDDDB, 0xDCD7, 0xDEFD, 0xF2F9, 0xD5C7, 0xD8D0, 0xF0C8, 0xD1A1,
    0xD1A2, 0xD9D4, 0xD6E8, 0xD9CA, 0xDAB1, 0xD8C7, 0xDCE2, 0xF3CE,
    0xF5F4, 0xF1B9, 0xDAD3, 0xF6EA, 0xCFF5, 0xFDAE, 0xCAD2, 0xDFB4,
    0xD7DD, 0xFABA, 0xEEA7, 0xF5BD, 0xF8F5, 0xEDE8, 0xD4E1, 0xD1A3,
    0xE1D6, 0xF9F8, 0xDBCA, 0xCBF9, 0xD4D4, 0xD9DC, 0xEEBE, 0xF7ED,
    0xD2EE, 0xE1E6, 0xF7F9, 0xDDED, 0xE8DB, 0xDBB3, 0xD1F7, 0xE0B0,
    0xD4E2, 0xF6D7, 0xD7F9, 0xD8DD, 0xCDFD, 0xF2AB, 0xCDBD, 0xF8C2,
    0xF2AC, 0xCAAD, 0xCAAE, 0xCFAE, 0xE3C2, 0xDCB7, 0xDBDA, 0xD9BB,
    0xCAF3, 0xF6D3, 0xE6F8, 0xEAF5, 0xEAF6, 0xF6F9, 0xCFAF, 0xCAD3,
    0xCAAF, 0xD2B0, 0xF1BA, 0xD7B3, 0xE3C3, 0xF3FD, 0xDEDA, 0xDEDB,
    0xEFDE, 0xE2E3, 0xEEFB, 0xDFF7, 0xD7CA, 0xCEE8, 0xDBDB, 0xF1BB,
    0xE9F1, 0xFAB7, 0xD0C6, 0xCCAB, 0xEEA8, 0xCBFA, 0xF9F9, 0xCCFD,
    0xD3FE, 0xE4D0, 0xF2EE, 0xD4D5, 0xDFCD, 0xFCB8, 0xD1D0, 0xF2CD,
    0xF7D2, 0xCAD4, 0xD5D9, 0xD8DE, 0xCDD9, 0xEEA9, 0xF6BC, 0xCCDB,
    0xF0C9, 0xFCFC, 0xE8C9, 0xF4FE, 0xE7FC, 0xD7DE, 0xDEDC, 0xF0AC,
    0xCCFE, 0xCDE1, 0xE1BA, 0xDBEF, 0xDAB2, 0xD1A5, 0xDCB8, 0xD8F6,
    0xD1A4, 0xCDE2, 0xDCEA, 0xF0F7, 0xF0CA, 0xD0BE, 0xDDDC, 0xD4D6,
    0xD3D6, 0xEDD0, 0xCDA1, 0xDFB5, 0xDFF8, 0xD4A1, 0xCEB2, 0xE8CA,
    0xEBF5, 0xE3D5, 0xF5D0, 0xF5A1, 0xD9A7, 0xE5AB, 0xE6CB, 0xF5F1,
    0xE5C5, 0xF9A3, 0xE0DB, 0xF6EB, 0xCBF1, 0xD9EA, 0xF5A2, 0xD7D1,
    0xD1F8, 0xEAF8, 0xEAF9, 0xDAB3, 0xEFDF, 0xF1EF, 0xE5F6, 0xEEBF,
    0xE2E4, 0xD0BF, 0xFAAC, 0xF5D1, 0xE7B3, 0xE9BE, 0xF2CE, 0xDBB4,
    0xFCCE, 0xDDEE, 0xE7B4, 0xD7B4, 0xF7B4, 0xCDBE, 0xDAE9, 0xCFB0,
    0xF7D9, 0xF3E6, 0xCED9, 0xCEAA, 0xCBC8, 0xD0A7, 0xF0CB, 0xD0C7,
    0xE4C5, 0xDBE0, 0xD5DA, 0xD7A7, 0xEEC0, 0xF8F6, 0xF5D2, 0xEDE9,
    0xD9BC, 0xE5C6, 0xF5A3, 0xDAD4, 0xE2A7, 0xFBFC, 0xF1DC, 0xCAF4,
    0xE8FA, 0xCEE9, 0xE9F8, 0xE2E5, 0xD0B9, 0xD4F2, 0xD1A6, 0xDFCE,
    0xFCF4, 0xD3AA, 0xCCAC, 0xEFE0, 0xE5E5, 0xD0D5, 0xDBFC, 0xFCE6,
    0xCBFE, 0xEDEA, 0xDEB1, 0xF9E3, 0xD4A2, 0xCFF6, 0xD6D0, 0xD5EA,
    0xF1EE, 0xFACB, 0xE5A1, 0xD5B1, 0xCFED, 0xEDEB, 0xD5B2, 0xD5BC,
    0xFDE2, 0xF3AD, 0xFDDB, 0xE9B0, 0xD1A7, 0xFDE3, 0xCEB3, 0xFDE4,
    0xFACE, 0xCAB0, 0xF7A7, 0xCFB1, 0xE6A2, 0xFCB6, 0xF2AD, 0xEFE1,
    0xF3AE, 0xDCC6, 0xD9EB, 0xE8E0, 0xE1A8, 0xD5F6, 0xCFFD, 0xDEDD,
    0xD9D1, 0xE4EA, 0xF2CF, 0xF7BF, 0xE2E6, 0xE2A8, 0xE3D6, 0xEDD1,
    0xE9F9, 0xD6B1, 0xDEB2, 0xE0E8, 0xD3AB, 0xEBDC, 0xDFAF, 0xCAC3,
    0xEEFC, 0xFDC3, 0xEBF6, 0xCFB2, 0xD9EC, 0xD9BD, 0xD8DF, 0xD4B8,
    0xEBBE, 0xDDEF, 0xDDF0, 0xDDF1, 0xDDF2, 0xD9BE, 0xFBC6, 0xCFB3,
    0xEEFD, 0xE4AB, 0xDAC5, 0xD8EC, 0xD1A8, 0xE2A9, 0xDEBC, 0xE7B5,
    0xDBF0, 0xEFE2, 0xF1F0, 0xCFB4, 0xDBF1, 0xE0B1, 0xDFA5, 0xF9D2,
    0xE7FD, 0xE6A3, 0xFBF1, 0xCBB0, 0xF2AE, 0xCDE7, 0xE8DC, 0xE7D7,
    0xF7C0, 0xD0E3, 0xDAA1, 0xCCBD, 0xD1A9, 0xDDCC, 0xE3FE, 0xD1AA,
    0xE8AA, 0xEAB6, 0xF9FA, 0xE6CC, 0xF6D8, 0xD4C7, 0xD9CB, 0xD9D2,
    0xD3CB, 0xD8F7, 0xDAA9, 0xF5F8, 0xDEDE, 0xF2AF, 0xF8A9, 0xD8C8,
    0xEEC1, 0xF9C1, 0xDDF3, 0xEAFA, 0xF6BD, 0xE1BB, 0xCDBF, 0xF4D4,
    0xE6CD, 0xFCCF, 0xFBA2, 0xE0DC, 0xF4BB, 0xDAD5, 0xF9B2, 0xFBF2,
    0xDBF6, 0xDEDF, 0xDBF2, 0xF8DC, 0xF7EE, 0xEBE8, 0xD2FA, 0xF1BC,
    0xFADA, 0xDAEA, 0xDAC6, 0xF7C1, 0xE7B6, 0xE5C7, 0xD6AC, 0xDCC7,
    0xE1A9, 0xE2AA, 0xD5A6, 0xD4D7, 0xF2D0, 0xEAFB, 0xE0DD, 0xFBF3,
    0xF1BD, 0xE2E7, 0xFDD7, 0xCEC8, 0xEAB7, 0xFCC0, 0xFDE7, 0xF7EF,
    0xD7B5, 0xEFBA, 0xF1DD, 0xDEB3, 0xE8CB, 0xF8DD, 0xFBC7, 0xD5C8,
    0xD7DF, 0xDDA9, 0xE9B1, 0xFAAD, 0xF6D9, 0xFAF4, 0xF8AA, 0xE6EE,
    0xCCDC, 0xE1BC, 0xE0EF, 0xE9BF, 0xFCFD, 0xE6CE, 0xE1D7, 0xE6CF,
    0xF4F1, 0xE4F3, 0xE4FB, 0xF9E4, 0xEFE3, 0xCFEE, 0xF6BE, 0xE0B2,
    0xFCFE, 0xD1AB, 0xD7FA, 0xFBC8, 0xE2D7, 0xD4A3, 0xF0F8, 0xD7A8,
    0xE1E7, 0xD3BF, 0xEFE4, 0xD7C5, 0xEBE2, 0xFCE7, 0xE4A2, 0xE2E8,
    0xE6D0, 0xFBE8, 0xF4E8, 0xE5F4, 0xF4BC, 0xF4D5, 0xDFB6, 0xFCB9,
    0xEEC2, 0xCAF5, 0xEFE5, 0xCBE2, 0xD4A4, 0xDEE0, 0xDAFD, 0xE4C6,
    0xE8BE, 0xE0DE, 0xF6B4, 0xEAD2, 0xF9FB, 0xE0C2, 0xCAE4, 0xE7B7,
    0xEAFD, 0xD9DD, 0xDAB4, 0xEEAA, 0xFBE9, 0xDBCB, 0xDAB5, 0xF1BE,
    0xD3AC, 0xFBC9, 0xDFCF, 0xD3C0, 0xE3D7, 0xEFE6, 0xFCD0, 0xE9C0,
    0xF5D3, 0xECDC, 0xF7B7, 0xEAB8, 0xD1F9, 0xDCC8, 0xEAB9, 0xF1DE,
    0xD7B6, 0xCFB5, 0xD9A8, 0xECEE, 0xDDAA, 0xCDA2, 0xE8AE, 0xE1BD,
    0xF2D1, 0xE9C1, 0xD2FC, 0xDBB5, 0xF3E7, 0xD8FE, 0xFCD1, 0xEDB2,
    0xF4AF, 0xFBA3, 0xFCC1, 0xEEAB, 0xD4A5, 0xF4F2, 0xEED9, 0xFBCA,
    0xCDE3, 0xD8BB, 0xE5DB, 0xF8F7, 0xF6D4, 0xD7A9, 0xCBC9, 0xE6D1,
    0xF0CC, 0xD8AE, 0xF9D3, 0xD5FE, 0xD8BC, 0xF2B0, 0xE2AB, 0xF3E8,
    0xEFC2, 0xEDEC, 0xE7B8, 0xDAFE, 0xCCBE, 0xF2FC, 0xDAEB, 0xE2D8,
    0xEDD6, 0xD6D1, 0xE0B3, 0xFCD2, 0xEBC8, 0xD3C1, 0xF0CD, 0xCFF7,
    0xEDD2, 0xD4D8, 0xDCC9, 0xD7F1, 0xDFBB, 0xF3A5, 0xF4CD, 0xF1BF,
    0xF8B1, 0xE9FA, 0xFBCB, 0xCAD5, 0xF9D4, 0xF7CA, 0xD6C8, 0xFCE8,
    0xF3BD, 0xEEFE, 0xE7FE, 0xD3C2, 0xD3B6, 0xCCAD, 0xF6FA, 0xD6B2,
    0xD2D8, 0xE7D8, 0xE3A5, 0xE7B9, 0xF0AD, 0xFBCC, 0xEBA1, 0xD4A6,
    0xFBCD, 0xD5BD, 0xF1DF, 0xF6FB, 0xDEB4, 0xD5EB, 0xE5C8, 0xFBA4,
    0xD4B9, 0xDEE1, 0xE4A3, 0xD7B7, 0xF8EE, 0xDEB5, 0xD6D2, 0xF9D5,
    0xE7BA, 0xEBD5, 0xD5F7, 0xEFE7, 0xE1BE, 0xFAAE, 0xD6E9, 0xD6EE,
    0xE7BB, 0xECCB, 0xD5B3, 0xCEB4, 0xFBA5, 0xE1EE, 0xF7A8, 0xFBCE,
    0xD8BD, 0xFBFD, 0xFCE9, 0xCFB6, 0xEDC7, 0xEEAC, 0xCCDD, 0xF6A7,
    0xE6FA, 0xF5A4, 0xFDDC, 0xEDB3, 0xCEC9, 0xEFE8, 0xE1BF, 0xFADB,
    0xCBE3, 0xF7A9, 0xFBA6, 0xDCB9, 0xF1C0, 0xEDC8, 0xEFC3, 0xD6AD,
    0xFDCE, 0xE8A1, 0xFBF4, 0xD5A7, 0xF1F6, 0xE6D3, 0xCCDE, 0xF8B2,
    0xDCEB, 0xFDB6, 0xE5EA, 0xF1E0, 0xDBCC, 0xDDCD, 0xD4C8, 0xD9ED,
    0xF5A5, 0xE6FB, 0xE6D4, 0xFDC8, 0xD6A1, 0xFDBF, 0xFCD3, 0xEFA1,
    0xE7BC, 0xD1EE, 0xE6D5, 0xE9F2, 0xDFB0, 0xD8E0, 0xFCBA, 0xFDAF,
    0xF0CE, 0xDBE1, 0xE5C9, 0xEDB4, 0xE0C3, 0xE3D8, 0xE9FB, 0xEAA8,
    0xFDB7, 0xFBA7, 0xE9C2, 0xFDF7, 0xE2D9, 0xDCEC, 0xE8A2, 0xE6F0,
    0xFDF8, 0xFDF9, 0xF6BF, 0xE7A7, 0xE6D7, 0xD4F3, 0xD4C9, 0xD6FA,
    0xD7F2, 0xE1C0, 0xDBE2, 0xE6D8, 0xE7BD, 0xF0CF, 0xF3BE, 0xE2AC,
    0xF5B7, 0xE0F0, 0xFDB8, 0xE3E8, 0xD4A7, 0xE8FC, 0xFAD2, 0xF8EF,
    0xD6D3, 0xD5B4, 0xF0D0, 0xF7F0, 0xEEB3, 0xEABA, 0xEAD3, 0xEDC9,
    0xDDAB, 0xE5AC, 0xFDA1, 0xDFD0, 0xECB3, 0xDFD1, 0xEDED, 0xF8B8,
    0xF7FA, 0xF8AB, 0xF4E0, 0xD4BA, 0xE4B3, 0xE9DA, 0xDEB6, 0xD9BF,
    0xD9C0, 0xD6EF, 0xD9CC, 0xDAAA, 0xDFE5, 0xF7E5, 0xCCB2, 0xDFF9,
    0xD7E0, 0xD4BB, 0xFDFA, 0xCCB3, 0xDBF3, 0xDFD2, 0xCECA, 0xEEDA,
    0xE4E4, 0xFBCF, 0xCFB7, 0xEEC3, 0xCEEA, 0xE2AD, 0xD7E1, 0xFAF5,
    0xD5C9, 0xF8AC, 0xE7D9, 0xF3E9, 0xD8ED, 0xE3C4, 0xF0F1, 0xE8E5,
    0xE0FA, 0xEEC4, 0xD9DE, 0xEBA2, 0xEBA3, 0xFCC2, 0xEABB, 0xE8AB,
    0xDEE2, 0xEDEF, 0xE8A3, 0xCFF1, 0xD4BC, 0xFCEA, 0xE7BE, 0xFCF2,
    0xD6B4, 0xE2AE, 0xD3B7, 0xFACC, 0xFADC, 0xEDB5, 0xE1E3, 0xE8AC,
    0xE8DD, 0xEFE9, 0xF4BD, 0xCFB8, 0xE9DB, 0xD1AC, 0xDAC7, 0xEBC9,
    0xE8CC, 0xDEB7, 0xD6BC, 0xD3E5, 0xFADD, 0xDAD6, 0xCAB1, 0xDAC8,
    0xDFA6, 0xF9B3, 0xF2D2, 0xCAC4, 0xCECB, 0xCDF5, 0xFDB0, 0xD5A8,
    0xF1C1, 0xE2E9, 0xDCCA, 0xECB4, 0xFAC0, 0xFBA8, 0xD0A8, 0xDAEC,
    0xD9EE, 0xE0FB, 0xEFEA, 0xFADE, 0xE0C4, 0xCFB9, 0xD5CA, 0xD7E2,
    0xE2AF, 0xD7B8, 0xE8CD, 0xF6DA, 0xEFA2, 0xE2DA, 0xF6FC, 0xFBD0,
    0xD1AD, 0xCDE4, 0xD1AE, 0xDCED, 0xE8CE, 0xF0F9, 0xCEB5, 0xE6FC,
    0xD7FB, 0xD0D6, 0xDDF5, 0xF7F1, 0xF6FD, 0xDBF7, 0xFBEA, 0xE9DC,
    0xD9C1, 0xF5F2, 0xE0C5, 0xEAD4, 0xF9C2, 0xEABC, 0xD2C5, 0xFBD1,
    0xE7C0, 0xEBA5, 0xDFFA, 0xE3A2, 0xD7B9, 0xE9C3, 0xE8FD, 0xE8AF,
    0xF2D3, 0xFBA9, 0xD8A5, 0xD5CB, 0xD0C8, 0xD1AF, 0xD7E3, 0xE0C6,
    0xD6A2, 0xEDF0, 0xD7F3, 0xFCD4, 0xDAD7, 0xCCDF, 0xF2D4, 0xD1B0,
    0xCCE0, 0xDBFD, 0xF3BF, 0xF0D1, 0xFCBB, 0xE2B0, 0xE6A5, 0xE2DB,
    0xDFDE, 0xE0C7, 0xF2EF, 0xCCE1, 0xD6EA, 0xE7C2, 0xCEB6, 0xF3C0,
    0xCDFE, 0xFBD2, 0xF8F8, 0xF7FB, 0xE8BF, 0xE8B7, 0xEDB6, 0xDCBA,
    0xCCB4, 0xF1F7, 0xE8B8, 0xCAF6, 0xE4A4, 0xF4D6, 0xDFE6, 0xDFA7,
    0xDFE7, 0xE1C1, 0xE9C4, 0xDCCB, 0xE9C5, 0xEFA3, 0xEBA6, 0xCBA3,
    0xE3E9, 0xD1FB, 0xEFA4, 0xEFEB, 0xD0B4, 0xCDA3, 0xE8E6, 0xEFA5,
    0xD3CC, 0xDAED, 0xD7BA, 0xF2D5, 0xF5E5, 0xD9EF, 0xF9B4, 0xD5D4,
    0xFDCF, 0xDBE3, 0xF1E1, 0xECB6, 0xFBFE, 0xD3D7, 0xD1B1, 0xCBB1,
    0xD1B2, 0xCBB2, 0xF1C2, 0xF4E1, 0xF9B5, 0xE1C3, 0xE1C2, 0xEBF7,
    0xDFA8, 0xCBCA, 0xE6B9, 0xF8DE, 0xF9AA, 0xCAF7, 0xEDB7, 0xD3B8,
    0xF2D6, 0xD4D9, 0xEEC5, 0xF2F0, 0xCAB2, 0xDCBB, 0xF1F8, 0xECB7,
    0xE5CA, 0xF6C0, 0xFDDD, 0xD4E3, 0xCCE2, 0xF7D4, 0xD7E5, 0xD3C3,
    0xD8A6, 0xF6C1, 0xDDF6, 0xCDC0, 0xE5DC, 0xE5CB, 0xE1C4, 0xE8B0,
    0xF4B0, 0xF3EA, 0xDAEE, 0xD7BB, 0xE2B1, 0xD7AA, 0xD6FB, 0xE4DF,
    0xCAD6, 0xEBA8, 0xDBFE, 0xF6C2, 0xEFBB, 0xD4FD, 0xE0C8, 0xE8B9,
    0xEFA6, 0xCDA4, 0xD4F4, 0xDBA1, 0xDBDC, 0xDBDD, 0xEEDC, 0xCBCB,
    0xFCD5, 0xCEEB, 0xCDC1, 0xFBD3, 0xF9AB, 0xF5D4, 0xD9A9, 0xE9DD,
    0xDBCD, 0xDDCE, 0xE7C3, 0xECCC, 0xF9EC, 0xCBCC, 0xE0FC, 0xD4A8,
    0xEDD3, 0xD8EF, 0xF2D7, 0xCAF8, 0xDAEF, 0xD6D4, 0xD9CD, 0xD8EE,
    0xF2C1, 0xDFD3, 0xDAF0, 0xE2EA, 0xE0FD, 0xD8F8, 0xF7AF, 0xDAB6,
    0xCAD7, 0xF2D8, 0xD8F9, 0xFADF, 0xCFEF, 0xD9C2, 0xF0D2, 0xE4D1,
    0xF3B7, 0xFAE0, 0xEFEC, 0xE2B2, 0xD4BD, 0xD9CE, 0xF4E2, 0xD4A9,
    0xCDC2, 0xE7DA, 0xF2D9, 0xD9AA, 0xD8BE, 0xDCAD, 0xE2EB, 0xD6FC,
    0xCAF9, 0xD4DA, 0xF4D7, 0xCCA1, 0xCFBA, 0xF5B8, 0xD9C3, 0xD0E8,
    0xE3C5, 0xEBF8, 0xF2B1, 0xCFBB, 0xD3AD, 0xE8E1, 0xCEEC, 0xE0B4,
    0xDEE3, 0xDDF7, 0xF2B2, 0xF3F6, 0xF6DB, 0xD7FE, 0xF8DF, 0xF7F2,
    0xD0A9, 0xE6DA, 0xF5A6, 0xD7BC, 0xCCE3, 0xE6DB, 0xDDDD, 0xD1B3,
    0xEFED, 0xD6DE, 0xE4F4, 0xE1EF, 0xDDF8, 0xE8CF, 0xCAE5, 0xDCA1,
    0xE0B5, 0xFCAC, 0xFCAD, 0xD8A7, 0xEDB8, 0xDBB6, 0xD6F0, 0xF3AF,
    0xCDA5, 0xDAF1, 0xD8A8, 0xCCE4, 0xD1B4, 0xCAD8, 0xDAF2, 0xF5A7,
    0xF5A8, 0xE6A6, 0xD5EC, 0xD5F8, 0xDAF3, 0xE3C6, 0xDEE4, 0xDEE5,
    0xD1B5, 0xD1B6, 0xD1B7, 0xF2B3, 0xE9DE, 0xF0D3, 0xF2B4, 0xF0D4,
    0xCBE4, 0xFBD4, 0xF5E6, 0xE3EA, 0xDEE6, 0xDFD4, 0xF8F9, 0xF0AE,
    0xD1B8, 0xD6DF, 0xD0D7, 0xFCA1, 0xEFEE, 0xDCD8, 0xE9DF, 0xE5DD,
    0xFDFB, 0xE0C9, 0xD6C9, 0xD4AA, 0xE5CC, 0xE9E0, 0xD0D8, 0xFCA2,
    0xD4BE, 0xE2B3, 0xDEE7, 0xDCBC, 0xD2B6, 0xF5D5, 0xCEA1, 0xF5A9,
    0xDDF9, 0xDDFA, 0xF0D5, 0xF6DF, 0xF2DA, 0xE4EB, 0xF2F1, 0xECB9,
    0xFDFC, 0xE1AA, 0xCAD9, 0xEFEF, 0xF5AA, 0xECF9, 0xF8AD, 0xF2C2,
    0xF6C3, 0xD7D2, 0xF9A2, 0xF0D6, 0xF0FA, 0xF6E0, 0xE9F3, 0xF2C3,
    0xD4AB, 0xCAB3, 0xCDA6, 0xCDC3, 0xCDDA, 0xD9CF, 0xF6C4, 0xEEDD,
    0xE7C4, 0xE2B4, 0xDFE2, 0xE7DB, 0xE8B1, 0xFCAE, 0xE5CD, 0xFAEB,
    0xCFBC, 0xCFE2, 0xCDF6, 0xEFF0, 0xF4BE, 0xD4CD, 0xF3B8, 0xE9A1,
    0xF2F2, 0xF3EB, 0xF0D7, 0xCFD7, 0xCFDF, 0xE8C0, 0xE8C1, 0xCFE3,
    0xE9A2, 0xD0AA, 0xF3C1, 0xD0AB, 0xD4E4, 0xEFBC, 0xD8A1, 0xD9DF,
    0xF3D7, 0xDCBD, 0xCCE5, 0xEDF1, 0xF1E2, 0xD4DB, 0xE2B5, 0xCAE6,
    0xD3AE, 0xCCE6, 0xF1D3, 0xF5E7, 0xCADA, 0xFBEE, 0xE1C5, 0xDFE9,
    0xEEDE, 0xF7C2, 0xD8A2, 0xDDAC, 0xF0AF, 0xD6BD, 0xE1AB, 0xF9B6,
    0xD4F5, 0xD0C9, 0xEFA7, 0xE2EC, 0xDBEA, 0xCECC, 0xF5E8, 0xF7D5,
    0xD3CD, 0xF3FE, 0xD0B5, 0xE0FE, 0xDFFB, 0xE6DD, 0xE8A4, 0xCBCD,
    0xEFA8, 0xEEB4, 0xDAD8, 0xD1B9, 0xDFA9, 0xF3B0, 0xCCC4, 0xCEB7,
    0xEFA9, 0xDFD5, 0xEDD7, 0xEEC6, 0xEFBD, 0xFCD6, 0xDBF4, 0xEFAA,
    0xF8B9, 0xF5E9, 0xE3D9, 0xE1C6, 0xD4BF, 0xDEE8, 0xF0EA, 0xF3C2,
    0xD3AF, 0xCADB, 0xFCD7, 0xEDD8, 0xE1C7, 0xF4D8, 0xD6B3, 0xDDAD,
    0xD5BE, 0xF1C3, 0xEEDF, 0xD6EB, 0xF4D9, 0xD7E6, 0xDAB7, 0xDDFB,
    0xDDCF, 0xD8A3, 0xDAD9, 0xF0D8, 0xEFC4, 0xE1D8, 0xF1D4, 0xEDF2,
    0xD5DB, 0xD5DC, 0xF3C4, 0xCBD7, 0xE2B6, 0xEFF1, 0xFBD5, 0xD3D8,
    0xDDD0, 0xF0D9, 0xCBB3, 0xD5DD, 0xCDA7, 0xD0AC, 0xD1BA, 0xF1C4,
    0xE5B3, 0xFBF5, 0xE9E1, 0xFDE0, 0xFCBC, 0xDAA2, 0xDAA3, 0xD2A1,
    0xD2EF, 0xE2ED, 0xDEE9, 0xCEDC, 0xF2B5, 0xD0E4, 0xDDD1, 0xE1C8,
    0xDBB7, 0xDFE3, 0xEDB9, 0xF1C5, 0xF3CF, 0xD7AB, 0xE1AC, 0xE3EB,
    0xEEC7, 0xE1C9, 0xCAFA, 0xF0FB, 0xFAE1, 0xF0DA, 0xCCE7, 0xDAF4,
    0xCCBF, 0xCEED, 0xD5A9, 0xFAE2, 0xD0E5, 0xEBD6, 0xECDF, 0xDFFC,
    0xF7D6, 0xDEEA, 0xCBB4, 0xEFBE, 0xCCB5, 0xCFBD, 0xEFF2, 0xE2B7,
    0xCCE8, 0xF0FC, 0xD6E0, 0xF1C6, 0xE2B8, 0xEBAB, 0xCBB5, 0xD8D1,
    0xF4CE, 0xF3F7, 0xD7C6, 0xD1BB, 0xF7AA, 0xEDCA, 0xD7D3, 0xD8FA,
    0xF6C5, 0xD1CC, 0xDDFC, 0xDFFD, 0xF9E5, 0xE0CA, 0xF2FD, 0xD3B0,
    0xF4F3, 0xDAC9, 0xE6DE, 0xF8BA, 0xE8D0, 0xD8FB, 0xEAD5, 0xD6A3,
    0xF6C6, 0xF2DB, 0xE4FC, 0xE8B2, 0xDADA, 0xF2DC, 0xFBD6, 0xE9B2,
    0xEEAD, 0xFAE3, 0xDCEE, 0xF5EA, 0xE6E0, 0xF0FD, 0xD7AC, 0xF5C5,
    0xEEE0, 0xDBE5, 0xDDDE, 0xD9F0, 0xE9A3, 0xF1F9, 0xF2C4, 0xE0CB,
    0xE9A4, 0xE2B9, 0xE3B1, 0xFCEB, 0xCDA8, 0xCCB6, 0xF0DB, 0xE6BA,
    0xCDA9, 0xF3C3, 0xE1D9, 0xEFAB, 0xE7C5, 0xE0E9, 0xF3C5, 0xD4C0,
    0xD5BF, 0xDDAE, 0xF9FC, 0xCCC0, 0xE5A2, 0xCEB8, 0xD8D2, 0xF9D6,
    0xF1AA, 0xCED1, 0xF6C7, 0xDBEB, 0xDFFE, 0xD8E1, 0xF7F3, 0xD7E7,
    0xD4FE, 0xD1BC, 0xE5CF, 0xCBB6, 0xDAB8, 0xCDC4, 0xD6BE, 0xE2BA,
    0xCFD8, 0xE0CC, 0xEBF9, 0xFDFD, 0xD7E8, 0xCBD8, 0xE9E2, 0xE8BA,
    0xE3C7, 0xECCD, 0xECCE, 0xD6BF, 0xE3A7, 0xDFD6, 0xFDE8, 0xEEE1,
    0xF6A8, 0xDDFD, 0xF8BB, 0xE8D1, 0xF9D7, 0xCEEE, 0xECCF, 0xE9A5,
    0xD6D5, 0xCDC5, 0xEDBA, 0xD1BD, 0xCFBE, 0xECBB, 0xD2B1, 0xCCE9,
    0xD9C4, 0xE9FC, 0xD1BE, 0xECBC, 0xE5AD, 0xF7B0, 0xCCEA, 0xD3C4,
    0xD6C0, 0xD6FD, 0xE1A1, 0xDEBD, 0xF6A9, 0xDAA4, 0xD6A4, 0xF5C6,
    0xE1A2, 0xE9C6, 0xF2C5, 0xF4E9, 0xD6EC, 0xEBD3, 0xECBD, 0xE2DC,
    0xDEEB, 0xF0DC, 0xEBBF, 0xD7CE, 0xD1BF, 0xF5AB, 0xF9FD, 0xCADC,
    0xCDC6, 0xF2B6, 0xDDFE, 0xCCB7, 0xDBB8, 0xD0E9, 0xCEDD, 0xEBC0,
    0xFDA2, 0xF8CB, 0xEAD6, 0xF1B0, 0xDBCE, 0xF7C3, 0xDBCF, 0xCBA4,
    0xF8E0, 0xFBD7, 0xEBCA, 0xE0A1, 0xCECD, 0xD4DC, 0xFDD8, 0xD2F6,
    0xF2B7, 0xFAF6, 0xF6AA, 0xFAF7, 0xD8E6, 0xF4B1, 0xE8D2, 0xCAC5,
    0xCCEB, 0xE2EE, 0xE2BB, 0xF7AD, 0xF8E1, 0xF3EC, 0xDEA1, 0xE4FD,
    0xE3EC, 0xDDAF, 0xDDB0, 0xCBB7, 0xE8D3, 0xE1A3, 0xD2E0, 0xF0FE,
    0xE9A6, 0xCBF2, 0xEDF3, 0xDCD9, 0xE0CD, 0xF7DA, 0xDBB9, 0xCCAE,
    0xDADB, 0xCDC7, 0xDDB1, 0xD8AF, 0xE3A3, 0xCEEF, 0xF2F3, 0xF8B3,
    0xE0CE, 0xF5FD, 0xEBEC, 0xD3C5, 0xFCEC, 0xD2DB, 0xD4EB, 0xDEA2,
    0xE5E6, 0xF0B0, 0xD5C4, 0xEDF4, 0xE3ED, 0xE8C2, 0xEDF5, 0xD7FC,
    0xEDBB, 0xF6AB, 0xF2B8, 0xF6C8, 0xD3E6, 0xF2DD, 0xCFBF, 0xEBAC,
    0xCFC0, 0xE6A8, 0xFDE9, 0xCFC1, 0xE0DF, 0xDEEC, 0xE0A2, 0xF4BF,
    0xE2EF, 0xD9F1, 0xF1C7, 0xCBB8, 0xF9FE, 0xDBBA, 0xDAF5, 0xF6EC,
    0xDADC, 0xFAE4, 0xE0CF, 0xDDB2, 0xE6A9, 0xEFF3, 0xF3ED, 0xEBFA,
    0xF9E6, 0xCADD, 0xD5DE, 0xCADE, 0xDFE4, 0xE6FD, 0xF5AC, 0xE4F5,
    0xE9E3, 0xEDCB, 0xCFE4, 0xD8D3, 0xDDB3, 0xD4EC, 0xF2B9, 0xDFB7,
    0xCBCE, 0xFBD8, 0xD0D9, 0xDDD2, 0xF7F4, 0xE7DC, 0xE4A5, 0xFCA3,
    0xDBBB, 0xF2BA, 0xE9FD, 0xD0CA, 0xF5D6, 0xD9C5, 0xE4B4, 0xEDA7,
    0xEABD, 0xE6FE, 0xF7C4, 0xF5AD, 0xD9E0, 0xCAB4, 0xF8E2, 0xCFC2,
    0xECBE, 0xE5B4, 0xCDC8, 0xEEC8, 0xE7C8, 0xCDC9, 0xF9B7, 0xF1E8,
    0xD9F2, 0xDBF5, 0xCAB5, 0xD9C6, 0xD8C9, 0xD9AB, 0xEDBC, 0xD8D4,
    0xDCDA, 0xE2BC, 0xFCED, 0xECE0, 0xD2FE, 0xE9C7, 0xE6AA, 0xE2F0,
    0xFABB, 0xF5AE, 0xFBAA, 0xECFB, 0xECBF, 0xFCD8, 0xD4E5, 0xF9C3,
    0xEEE2, 0xD7E9, 0xEDF6, 0xDEED, 0xCCEC, 0xE3EE, 0xE8D4, 0xFAF8,
    0xDDB4, 0xE4B5, 0xD8B0, 0xD8D5, 0xF4EA, 0xCEB9, 0xD6E1, 0xCFD2,
    0xD0B6, 0xCEA2, 0xF3EE, 0xF3F8, 0xDCCC, 0xD0CB, 0xFCA4, 0xCDCA,
    0xD7D4, 0xDEA3, 0xE4E0, 0xEEC9, 0xE2DD, 0xF5FE, 0xD4AC, 0xD5D1,
    0xD8F0, 0xF8C3, 0xEAD7, 0xF5D7, 0xD8BF, 0xFDC0, 0xEBAD, 0xD5AA,
    0xE7A8, 0xEECA, 0xCAE7, 0xF8E3, 0xD4DD, 0xEAD8, 0xFBD9, 0xEDF7,
    0xE5B5, 0xD0AD, 0xF1F1, 0xE2BD, 0xE3C8, 0xD9D5, 0xDFAA, 0xDBBC,
    0xF8E4, 0xF1FA, 0xE5B6, 0xF3EF, 0xFBDA, 0xE1E0, 0xD9AC, 0xF5EB,
    0xE0B6, 0xE9C8, 0xCBCF, 0xE3C9, 0xDEEE, 0xE2BE, 0xDCEF, 0xD6A5,
    0xE2F1, 0xD6FE, 0xD9A1, 0xD8C0, 0xDCDB, 0xEDBD, 0xDFB8, 0xEAA5,
    0xD7AD, 0xF3F9, 0xEDF8, 0xF5C7, 0xE1CA, 0xEBE3, 0xF2DE, 0xF8CC,
    0xEAD9, 0xD3C6, 0xDBE6, 0xF5AF, 0xCEF0, 0xE9FE, 0xFBB6, 0xE2F2,
    0xCFF2, 0xF7B9, 0xD9F3, 0xE1CB, 0xDADD, 0xDAB9, 0xEBFB, 0xCBB9,
    0xEDF9, 0xE0E0, 0xF4C0, 0xFDBC, 0xDFB1, 0xE3EF, 0xE0A3, 0xFDB9,
    0xF0B1, 0xCDCB, 0xEDBE, 0xD5C0, 0xE3F0, 0xEDFA, 0xE9E4, 0xD5ED,
    0xE7DD, 0xD4F6, 0xE5B7, 0xDBE7, 0xE2BF, 0xEECB, 0xD7F4, 0xF0DD,
    0xCEAB, 0xE7DE, 0xD6D6, 0xE1CC, 0xE8B3, 0xE5EE, 0xDCA2, 0xE0D0,
    0xD5B5, 0xD5A1, 0xFBDB, 0xF9CB, 0xCBF3, 0xF4A5, 0xFAC8, 0xD6D7,
    0xE9E5, 0xFBDC, 0xFDD0, 0xFBF6, 0xDAA5, 0xDBBD, 0xECE2, 0xCDF7,
    0xF0DE, 0xF6C9, 0xDEEF, 0xD3B1, 0xFCEE, 0xE8C3, 0xF1C8, 0xCEF1,
    0xF9ED, 0xF2F4, 0xE4B6, 0xF5B9, 0xDCF0, 0xE3F1, 0xE8A5, 0xF2BB,
    0xDEA4, 0xDACC, 0xCAE9, 0xE3DA, 0xFCD9, 0xEADA, 0xF9C4, 0xE3A4,
    0xFBDD, 0xEFCA, 0xE8C4, 0xD5CC, 0xEBD7, 0xD9AD, 0xFBAB, 0xD3D9,
    0xD5A2, 0xF6DE, 0xDAF6, 0xE0D1, 0xE9A8, 0xF5F9, 0xFAAF, 0xEBFC,
    0xE0EA, 0xE3B2, 0xD5C5, 0xF1E3, 0xD5EE, 0xCDCC, 0xEDD9, 0xD8C1,
    0xFAEC, 0xF1EB, 0xFABC, 0xE6E2, 0xFAE5, 0xE2FA, 0xCAB6, 0xE4B7,
    0xEADB, 0xF5FA, 0xFBAC, 0xCFC3, 0xEBFD, 0xF8FA, 0xDFB9, 0xE1F1,
    0xD2A4, 0xF5FB, 0xD0DA, 0xD0DB, 0xEABE, 0xD9B1, 0xCAB7, 0xD3E7,
    0xF8E5, 0xD3B2, 0xE2C0, 0xF2DF, 0xCDE5, 0xF9AC, 0xCDCD, 0xEEAE,
    0xD6AE, 0xD7EA, 0xE7E0, 0xEBAE, 0xCFD9, 0xDCCD, 0xEDFB, 0xDEF0,
    0xD7EB, 0xDEA5, 0xDFD7, 0xDBD0, 0xDBD1, 0xD5A3, 0xF0B2, 0xDCDC,
    0xCAE8, 0xF8E6, 0xDCCE, 0xEADC, 0xDBD2, 0xE9B3, 0xF7DB, 0xE3A8,
    0xD7AE, 0xE0E1, 0xCBBA, 0xE5D1, 0xD0DC, 0xD5C1, 0xD8CA, 0xE3A9,
    0xE0A4, 0xE9A9, 0xD3C7, 0xDCDD, 0xF8AE, 0xCCB8, 0xD0AE, 0xD8F2,
    0xE3CA, 0xCCAF, 0xD4AD, 0xF6D1, 0xD0CC, 0xCAC6, 0xD5C2, 0xCEBA,
    0xCAC7, 0xFAB0, 0xDFD8, 0xF5BA, 0xE5EB, 0xEFF4, 0xDDB5, 0xCDAA,
    0xE3F2, 0xFBF7, 0xF7D0, 0xFDBA, 0xFDE1, 0xF6FE, 0xD1C0, 0xE8C5,
    0xE4B8, 0xE1E8, 0xCCC1, 0xD2ED, 0xDBBE, 0xE0E2, 0xFAC9, 0xE1CD,
    0xCAB8, 0xF2E0, 0xF1C9, 0xDEF1, 0xF0DF, 0xF8C4, 0xEECC, 0xDEF2,
    0xE7C9, 0xE2F3, 0xE7E1, 0xE3CB, 0xE3CC, 0xCFF8, 0xEFAC, 0xFDFE,
    0xFCA5, 0xFAB1, 0xDFD9, 0xE0D2, 0xF4DA, 0xF1CA, 0xCEA3, 0xF2BC,
    0xECE3, 0xE0A5, 0xF7AB, 0xEBAF, 0xE5DE, 0xE1A4, 0xCDAB, 0xD9F4,
    0xE8A6, 0xCDCE, 0xE1E9, 0xFCEF, 0xE0E3, 0xE2C1, 0xCEA4, 0xDEA6,
    0xEBFE, 0xEBDD, 0xF0E0, 0xF4DB, 0xE2F4, 0xD3C8, 0xF4EB, 0xEEB5,
    0xF5D8, 0xD5DF, 0xD6E5, 0xEBB0, 0xF4E3, 0xE3CD, 0xF4F4, 0xFAB2,
    0xEFF5, 0xCADF, 0xEBB1, 0xEDBF, 0xFDC9, 0xE4A6, 0xF9A4, 0xF0B3,
    0xE5EC, 0xD1E7, 0xD9C7, 0xE4D7, 0xEADD, 0xD4F7, 0xDABA, 0xDACD,
    0xF9CC, 0xE1DA, 0xDBBF, 0xCCC5, 0xECD0, 0xCBBB, 0xDEF3, 0xE9AA,
    0xD9C8, 0xEEE3, 0xD7BD, 0xCFC4, 0xD0CD, 0xFCA6, 0xF1FB, 0xFDD2,
    0xD1C1, 0xE3DB, 0xD3C9, 0xDCCF, 0xCCED, 0xDEA7, 0xE6BB, 0xECA1,
    0xCCB9, 0xFBDE, 0xE7E2, 0xD4C1, 0xDCA8, 0xE2C2, 0xF3D8, 0xE5D3,
    0xF3D9, 0xF3C6, 0xCDDB, 0xCDAC, 0xFCC3, 0xD4E7, 0xD1C2, 0xF9A5,
    0xE8D5, 0xE3CE, 0xD4CA, 0xDFDA, 0xFBDF, 0xE7E3, 0xF8FB, 0xE3CF,
    0xF5B0, 0xD8E7, 0xD9C9, 0xF8AF, 0xEFF6, 0xDDB6, 0xEEAF, 0xCDF8,
    0xDEB8, 0xFCA7, 0xF7FC, 0xF7B1, 0xCEBB, 0xF4A1, 0xEECD, 0xE1AE,
    0xECC3, 0xCFFE, 0xF8BF, 0xD8E2, 0xD3E8, 0xDEA8, 0xF4E4, 0xECC2,
    0xD9F5, 0xF9C5, 0xDDD3, 0xD6F1, 0xECFC, 0xFCF0, 0xEDC0, 0xCAB9,
    0xEEE4, 0xF2E1, 0xDEB9, 0xD6F2, 0xDEF4, 0xDFDB, 0xDBD3, 0xFAE7,
    0xD8E3, 0xF4C1, 0xDDB7, 0xF2F5, 0xD4AE, 0xD6F3, 0xDDB8, 0xCFC5,
    0xDFDF, 0xF2BE, 0xF6A1, 0xEBCB, 0xF1FC, 0xF3C7, 0xE0EB, 0xEDFC,
    0xE1DB, 0xEEE5, 0xDEF5, 0xFAD3, 0xF1CB, 0xD0AF, 0xDDB9, 0xD1C3,
    0xF5B1, 0xEAC6, 0xF0E1, 0xF6AC, 0xF5D9, 0xF0EB, 0xDDBA, 0xF2BF,
    0xF7C5, 0xDBA2, 0xF2F6, 0xCABA, 0xF7F5, 0xCBE5, 0xEEE6, 0xE0D3,
    0xCEA5, 0xD6D8, 0xD4AF, 0xE9C9, 0xD3CE, 0xF4C2, 0xCBE6, 0xF1A1,
    0xEBB2, 0xF1A2, 0xEBB3, 0xF0B4, 0xCBF4, 0xD4B0, 0xF3B2, 0xFBB7,
    0xF5EC, 0xEEE7, 0xF4B2, 0xF5ED, 0xCFF3, 0xF0E2, 0xEECE, 0xF1CC,
    0xE5B8, 0xD7F5, 0xE3F3, 0xCFE5, 0xCFC6, 0xF3B3, 0xE4D8, 0xCFF9,
    0xCFDA, 0xFACD, 0xE6E3, 0xF2E2, 0xF5EE, 0xCABB, 0xE3DC, 0xCEF2,
    0xD6D9, 0xEEB0, 0xF4E5, 0xD8C2, 0xDCD0, 0xCCEE, 0xD5E0, 0xF6CA,
    0xFDCA, 0xD8D6, 0xF4CF, 0xD6A6, 0xDCBE, 0xDBD4, 0xD7C7, 0xF2FE,
    0xF1CD, 0xE2C3, 0xDCDE, 0xDCDF, 0xEFAD, 0xE6AB, 0xF9DD, 0xEABF,
    0xEFAE, 0xF4D0, 0xCEF3, 0xE6AC, 0xCEDE, 0xD5F9, 0xE3F4, 0xCDD0,
    0xD5B8, 0xF7FD, 0xDCA9, 0xDEF6, 0xDCAA, 0xF2E3, 0xE9B4, 0xD2DC,
    0xE9E6, 0xE3F6, 0xE7CA, 0xD0CE, 0xDAF7, 0xCABC, 0xEEE8, 0xDADE,
    0xF2F7, 0xE2FB, 0xCCA6, 0xDABB, 0xEEE9, 0xF5DA, 0xF7DC, 0xE1EA,
    0xCEC1, 0xD4B1, 0xFDB1, 0xE6BD, 0xFBAD, 0xF8E7, 0xE1CE, 0xF7E2,
    0xF5EF, 0xCFC7, 0xD4B2, 0xCCEF, 0xD4E8, 0xEECF, 0xF7D7, 0xE0A6,
    0xD6C1, 0xE1DC, 0xF0E3, 0xF1E4, 0xDCF1, 0xD6A7, 0xF4F5, 0xF1CE,
    0xF2E4, 0xD0B0, 0xECEF, 0xF9BA, 0xEBB5, 0xD4ED, 0xE2C4, 0xE9E7,
    0xEBB4, 0xEAA1, 0xF8BC, 0xCEA6, 0xF9C6, 0xFCDA, 0xD4B3, 0xD3B9,
    0xEADE, 0xE9AB, 0xE1E1, 0xD3CF, 0xF4F6, 0xEAC0, 0xE1CF, 0xCCBA,
    0xEEEA, 0xF0E4, 0xF3B4, 0xD4EE, 0xF2C0, 0xF1E5, 0xF4C3, 0xE0D4,
    0xEBB6, 0xD7A1, 0xCBE8, 0xF9AD, 0xE9AD, 0xD8E4, 0xFAB3, 0xE2C5,
    0xFCBD, 0xECC4, 0xD8B1, 0xDCAB, 0xD5A4, 0xEBE9, 0xE8BB, 0xD8D7,
    0xFBAE, 0xD1E1, 0xDBC0, 0xF5BE, 0xDEF7, 0xCAFB, 0xF7C6, 0xCFC8,
    0xE1D0, 0xEED0, 0xE9F4, 0xCEF4, 0xD5CD, 0xCFDB, 0xDDBB, 0xCEAC,
    0xE9E8, 0xD4B4, 0xE4C7, 0xF5DB, 0xFAC1, 0xDEA9, 0xD4F8, 0xEFF7,
    0xD3B3, 0xEBB7, 0xEFF8, 0xF5DC, 0xEDCC, 0xDBD5, 0xF1CF, 0xF1D0,
    0xF5B2, 0xD9AE, 0xD5AC, 0xE2C6, 0xFDA3, 0xFBE5, 0xDFAB, 0xE2F5,
    0xF6AD, 0xF5B3, 0xF0B5, 0xE1A5, 0xF5DD, 0xECA2, 0xEDFD, 0xF5B4,
    0xFBB8, 0xDBA3, 0xD6CA, 0xCBD9, 0xE5D4, 0xF3FA, 0xEBB8, 0xE0B7,
    0xD7EC, 0xF1EC, 0xE5AF, 0xD5E1, 0xD7ED, 0xD1D1, 0xE1F2, 0xEFF9,
    0xDDBC, 0xF6DC, 0xF0E5, 0xF4C4, 0xE9E9, 0xF3FB, 0xD4EF, 0xCCA2,
    0xF7FE, 0xDFBC, 0xEBCD, 0xD0B7, 0xD6C2, 0xE8AD, 0xEFAF, 0xCBA5,
    0xCBE9, 0xFAE8, 0xCCC6, 0xE6E7, 0xEAC7, 0xDBA4, 0xCFC9, 0xE2FC,
    0xEFFA, 0xEBDE, 0xF5C8, 0xD4DE, 0xE0D5, 0xEFB0, 0xE2C7, 0xD9AF,
    0xF9E7, 0xE7E5, 0xCFCA, 0xE1D1, 0xE2C8, 0xEFFB, 0xFAF9, 0xDCF2,
    0xE0A7, 0xF8E8, 0xCBEA, 0xCBBC, 0xD6E2, 0xF5DE, 0xF5DF, 0xEEB6,
    0xE2F6, 0xD3CA, 0xEFFC, 0xD1C4, 0xEFB1, 0xD1C5, 0xD0DE, 0xD9E1,
    0xE0B8, 0xCDD1, 0xF3B9, 0xE7CC, 0xD6A8, 0xCEA7, 0xD4B5, 0xE4C8,
    0xD3B4, 0xEBB9, 0xCBF5, 0xF6DD, 0xF1A3, 0xCCC7, 0xE9CA, 0xE1F0,
    0xF5E0, 0xFBAF, 0xCBD1, 0xFBE0, 0xF2E5, 0xECF0, 0xF0EC, 0xEEEB,
    0xE9CB, 0xCCF0, 0xD7AF, 0xF3A1, 0xFCF5, 0xF1A4, 0xE0D6, 0xEFB2,
    0xF4D1, 0xF7A1, 0xF1D1, 0xCAFC, 0xCAFD, 0xCECE, 0xF3C8, 0xF3BA,
    0xEDFE, 0xDAA6, 0xE0EC, 0xF8CD, 0xCBD2, 0xEBCE, 0xF9D8, 0xF9D9,
    0xCAE0, 0xDACA, 0xCBA6, 0xCAC8, 0xF9EE, 0xDBEC, 0xD0B1, 0xD5EF,
    0xE6F3, 0xE7A2, 0xE4D9, 0xE4E1, 0xFCC4, 0xF9EF, 0xCFF4, 0xF7E6,
    0xCEBC, 0xF4C5, 0xDCA3, 0xDDBD, 0xF4C6, 0xF8A1, 0xE8D6, 0xDBC1,
    0xF0E6, 0xE4B9, 0xF6ED, 0xF9AE, 0xDDBE, 0xD7B0, 0xD8E8, 0xCBBD,
    0xF9DA, 0xF8CE, 0xF9F0, 0xE0ED, 0xE3B3, 0xF4B3, 0xEAC2, 0xF2E6,
    0xF0B6, 0xDBD6, 0xEBE4, 0xF2E7, 0xD7D5, 0xD4B6, 0xF9E8, 0xD7C1,
    0xE5D5, 0xE9EA, 0xD7CC, 0xD3E9, 0xE2C9, 0xFCDB, 0xCDAD, 0xCCB0,
    0xEAA2, 0xE4F6, 0xD0C0, 0xF0B7, 0xEEA1, 0xD7F6, 0xE2CA, 0xE2CB,
    0xFACF, 0xEBDF, 0xD6CB, 0xF4B4, 0xEDCD, 0xE4D2, 0xEAA9, 0xE4BA,
    0xF3A2, 0xCDD2, 0xF6CB, 0xF1E6, 0xEDC1, 0xE8BC, 0xEED1, 0xF0E7,
    0xE2CC, 0xE4AA, 0xF5E1, 0xEDDA, 0xD7EE, 0xD1F1, 0xE9EB, 0xE9EC,
    0xE0E4, 0xDAA7, 0xDDD4, 0xEAA3, 0xD6C3, 0xD6F4, 0xDADF, 0xEFB3,
    0xE2CD, 0xEFFD, 0xF2E8, 0xEFC5, 0xE7E7, 0xD7FD, 0xE7CE, 0xDFDC,
    0xF9C7, 0xD9F6, 0xDFAC, 0xD6DA, 0xDCA4, 0xF0B8, 0xD5FA, 0xE4F7,
    0xD6C4, 0xF4EC, 0xEFFE, 0xF0A1, 0xDEAA, 0xDABC, 0xD8FC, 0xFAD4,
    0xECE5, 0xFCA8, 0xECE6, 0xD8CB, 0xFBB9, 0xE4D3, 0xCDF9, 0xCFD3,
    0xCAEA, 0xCFD4, 0xF8BD, 0xF4C7, 0xEADF, 0xF9DB, 0xD4B7, 0xEBE5,
    0xE1D2, 0xEAA4, 0xFAC2, 0xFBE1, 0xFAED, 0xF0A2, 0xCCF1, 0xFAA3,
    0xE2F7, 0xE2CE, 0xE9F5, 0xE1EB, 0xE7E8, 0xE8D7, 0xDAF8, 0xD4CB,
    0xF7F6, 0xD6C5, 0xD4E9, 0xFAFA, 0xCCF2, 0xF7DD, 0xDEBA, 0xCEA8,
    0xF0B9, 0xE4FE, 0xE4C9, 0xE4D4, 0xEAC3, 0xEFB4, 0xD7BE, 0xFBE2,
    0xCDD3, 0xEFB5, 0xFAE9, 0xF9A6, 0xDFBD, 0xF7C7, 0xF8FD, 0xF8FC,
    0xDEAB, 0xDBE8, 0xE3DD, 0xE1E2, 0xD1C6, 0xF6D0, 0xEBE6, 0xDAF9,
    0xECC7, 0xDEF8, 0xF8E9, 0xE3DE, 0xCEF5, 0xFAC3, 0xE5D7, 0xECC8,
    0xF3C9, 0xE4BB, 0xE6AE, 0xEFB6, 0xDCBF, 0xCEBD, 0xD8C3, 0xD0CF,
    0xCFFA, 0xF3CA, 0xE0D7, 0xD1C7, 0xE9AE, 0xE8BD, 0xFAC4, 0xE2CF,
    0xFAC5, 0xF9B8, 0xDCE0, 0xFBB0, 0xD8A9, 0xE5DF, 0xF9A7, 0xF6EE,
    0xF6CC, 0xE2F8, 0xECF1, 0xDAE0, 0xF1D2, 0xD2CC, 0xCFCB, 0xCABD,
    0xDDBF, 0xF6EF, 0xDEF9, 0xFAB4, 0xD5AD, 0xF1E7, 0xDEBE, 0xDCC0,
    0xD1C8, 0xD1C9, 0xF8BE, 0xCBF6, 0xD4F9, 0xF5E2, 0xE1D3, 0xD8E9,
    0xF8FE, 0xCFCC, 0xFDA4, 0xCEF6, 0xFAD0, 0xCCF3, 0xE6BE, 0xF6AE,
    0xD5F0, 0xD1CA, 0xFCBE, 0xD5F1, 0xCDE9, 0xFAB5, 0xE2D0, 0xF4F7,
    0xCDD4, 0xE7A3, 0xDBA5, 0xE2D1, 0xD7A2, 0xF7E3, 0xEAA6, 0xD0A1,
    0xCEDA, 0xFBEB, 0xDBA6, 0xDBDE, 0xD8E5, 0xEAE0, 0xD8AA, 0xE5E0,
    0xD6DB, 0xEFC6, 0xF8EA, 0xE4D5, 0xCEF7, 0xE0D8, 0xD7EF, 0xF4ED,
    0xCDE6, 0xCCF4, 0xF5E3, 0xE4CA, 0xDCE1, 0xF9C8, 0xFCBF, 0xE8A7,
    0xD8C4, 0xCBBE, 0xDCAE, 0xD7F7, 0xF0E8, 0xDDC0, 0xCFCD, 0xDCF3,
    0xD9B0, 0xE6E9, 0xE4BC, 0xEAC4, 0xE4EC, 0xE4E5, 0xFBF8, 0xCCBB,
    0xE4BD, 0xCDDC, 0xD9F7, 0xDDDF, 0xEDCE, 0xD9D0, 0xE5A3, 0xF9CD,
    0xCDAE, 0xCFCE, 0xF6AF, 0xFDD3, 0xEBED, 0xD6DC, 0xE5A4, 0xD5B6,
    0xD6DD, 0xF9E9, 0xE7A4, 0xD6E3, 0xD1CB, 0xD6E4, 0xD5F2, 0xDEFA,
    0xD7F8, 0xD8EA, 0xCFD5, 0xD8FD, 0xD8AB, 0xFDCB, 0xFCDC, 0xE0A8,
    0xD5F3, 0xFDD9, 0xCCA3, 0xD9F9, 0xD3EA, 0xF5F5, 0xEFC7, 0xD3DA,
    0xDABD, 0xE8A8, 0xDCAF, 0xF0A3, 0xCDD5, 0xE0A9, 0xDEAC, 0xF0BA,
    0xEEB1, 0xEEB2, 0xF6CD, 0xEED2, 0xD6C6, 0xE0E5, 0xF3BB, 0xE5E1,
    0xE4CB, 0xD7A3, 0xDBC2, 0xCAFE, 0xCFCF, 0xB0A1, 0xB0A2, 0xB0A3,
    0xB0A4, 0xB0A5, 0xB0A6, 0xB0A7, 0xB0A8, 0xB0A9, 0xB0AA, 0xB0AB,
    0xB0AC, 0xB0AD, 0xB0AE, 0xB0AF, 0xB0B0, 0xB0B1, 0xB0B2, 0xB0B3,
    0xB0B4, 0xB0B5, 0xB0B6, 0xB0B7, 0xB0B8, 0xB0B9, 0xB0BA, 0xB0BB,
    0xB0BC, 0xB0BD, 0xB0BE, 0xB0BF, 0xB0C0, 0xB0C1, 0xB0C2, 0xB0C3,
    0xB0C4, 0xB0C5, 0xB0C6, 0xB0C7, 0xB0C8, 0xB0C9, 0xB0CA, 0xB0CB,
    0xB0CC, 0xB0CD, 0xB0CE, 0xB0CF, 0xB0D0, 0xB0D1, 0xB0D2, 0xB0D3,
    0xB0D4, 0xB0D5, 0xB0D6, 0xB0D7, 0xB0D8, 0xB0D9, 0xB0DA, 0xB0DB,
    0xB0DC, 0xB0DD, 0xB0DE, 0xB0DF, 0xB0E0, 0xB0E1, 0xB0E2, 0xB0E3,
    0xB0E4, 0xB0E5, 0xB0E6, 0xB0E7, 0xB0E8, 0xB0E9, 0xB0EA, 0xB0EB,
    0xB0EC, 0xB0ED, 0xB0EE, 0xB0EF, 0xB0F0, 0xB0F1, 0xB0F2, 0xB0F3,
    0xB0F4, 0xB0F5, 0xB0F6, 0xB0F7, 0xB0F8, 0xB0F9, 0xB0FA, 0xB0FB,
    0xB0FC, 0xB0FD, 0xB0FE, 0xB1A1, 0xB1A2, 0xB1A3, 0xB1A4, 0xB1A5,
    0xB1A6, 0xB1A7, 0xB1A8, 0xB1A9, 0xB1AA, 0xB1AB, 0xB1AC, 0xB1AD,
    0xB1AE, 0xB1AF, 0xB1B0, 0xB1B1, 0xB1B2, 0xB1B3, 0xB1B4, 0xB1B5,
    0xB1B6, 0xB1B7, 0xB1B8, 0xB1B9, 0xB1BA, 0xB1BB, 0xB1BC, 0xB1BD,
    0xB1BE, 0xB1BF, 0xB1C0, 0xB1C1, 0xB1C2, 0xB1C3, 0xB1C4, 0xB1C5,
    0xB1C6, 0xB1C7, 0xB1C8, 0xB1C9, 0xB1CA, 0xB1CB, 0xB1CC, 0xB1CD,
    0xB1CE, 0xB1CF, 0xB1D0, 0xB1D1, 0xB1D2, 0xB1D3, 0xB1D4, 0xB1D5,
    0xB1D6, 0xB1D7, 0xB1D8, 0xB1D9, 0xB1DA, 0xB1DB, 0xB1DC, 0xB1DD,
    0xB1DE, 0xB1DF, 0xB1E0, 0xB1E1, 0xB1E2, 0xB1E3, 0xB1E4, 0xB1E5,
    0xB1E6, 0xB1E7, 0xB1E8, 0xB1E9, 0xB1EA, 0xB1EB, 0xB1EC, 0xB1ED,
    0xB1EE, 0xB1EF, 0xB1F0, 0xB1F1, 0xB1F2, 0xB1F3, 0xB1F4, 0xB1F5,
    0xB1F6, 0xB1F7, 0xB1F8, 0xB1F9, 0xB1FA, 0xB1FB, 0xB1FC, 0xB1FD,
    0xB1FE, 0xB2A1, 0xB2A2, 0xB2A3, 0xB2A4, 0xB2A5, 0xB2A6, 0xB2A7,
    0xB2A8, 0xB2A9, 0xB2AA, 0xB2AB, 0xB2AC, 0xB2AD, 0xB2AE, 0xB2AF,
    0xB2B0, 0xB2B1, 0xB2B2, 0xB2B3, 0xB2B4, 0xB2B5, 0xB2B6, 0xB2B7,
    0xB2B8, 0xB2B9, 0xB2BA, 0xB2BB, 0xB2BC, 0xB2BD, 0xB2BE, 0xB2BF,
    0xB2C0, 0xB2C1, 0xB2C2, 0xB2C3, 0xB2C4, 0xB2C5, 0xB2C6, 0xB2C7,
    0xB2C8, 0xB2C9, 0xB2CA, 0xB2CB, 0xB2CC, 0xB2CD, 0xB2CE, 0xB2CF,
    0xB2D0, 0xB2D1, 0xB2D2, 0xB2D3, 0xB2D4, 0xB2D5, 0xB2D6, 0xB2D7,
    0xB2D8, 0xB2D9, 0xB2DA, 0xB2DB, 0xB2DC, 0xB2DD, 0xB2DE, 0xB2DF,
    0xB2E0, 0xB2E1, 0xB2E2, 0xB2E3, 0xB2E4, 0xB2E5, 0xB2E6, 0xB2E7,
    0xB2E8, 0xB2E9, 0xB2EA, 0xB2EB, 0xB2EC, 0xB2ED, 0xB2EE, 0xB2EF,
    0xB2F0, 0xB2F1, 0xB2F2, 0xB2F3, 0xB2F4, 0xB2F5, 0xB2F6, 0xB2F7,
    0xB2F8, 0xB2F9, 0xB2FA, 0xB2FB, 0xB2FC, 0xB2FD, 0xB2FE, 0xB3A1,
    0xB3A2, 0xB3A3, 0xB3A4, 0xB3A5, 0xB3A6, 0xB3A7, 0xB3A8, 0xB3A9,
    0xB3AA, 0xB3AB, 0xB3AC, 0xB3AD, 0xB3AE, 0xB3AF, 0xB3B0, 0xB3B1,
    0xB3B2, 0xB3B3, 0xB3B4, 0xB3B5, 0xB3B6, 0xB3B7, 0xB3B8, 0xB3B9,
    0xB3BA, 0xB3BB, 0xB3BC, 0xB3BD, 0xB3BE, 0xB3BF, 0xB3C0, 0xB3C1,
    0xB3C2, 0xB3C3, 0xB3C4, 0xB3C5, 0xB3C6, 0xB3C7, 0xB3C8, 0xB3C9,
    0xB3CA, 0xB3CB, 0xB3CC, 0xB3CD, 0xB3CE, 0xB3CF, 0xB3D0, 0xB3D1,
    0xB3D2, 0xB3D3, 0xB3D4, 0xB3D5, 0xB3D6, 0xB3D7, 0xB3D8, 0xB3D9,
    0xB3DA, 0xB3DB, 0xB3DC, 0xB3DD, 0xB3DE, 0xB3DF, 0xB3E0, 0xB3E1,
    0xB3E2, 0xB3E3, 0xB3E4, 0xB3E5, 0xB3E6, 0xB3E7, 0xB3E8, 0xB3E9,
    0xB3EA, 0xB3EB, 0xB3EC, 0xB3ED, 0xB3EE, 0xB3EF, 0xB3F0, 0xB3F1,
    0xB3F2, 0xB3F3, 0xB3F4, 0xB3F5, 0xB3F6, 0xB3F7, 0xB3F8, 0xB3F9,
    0xB3FA, 0xB3FB, 0xB3FC, 0xB3FD, 0xB3FE, 0xB4A1, 0xB4A2, 0xB4A3,
    0xB4A4, 0xB4A5, 0xB4A6, 0xB4A7, 0xB4A8, 0xB4A9, 0xB4AA, 0xB4AB,
    0xB4AC, 0xB4AD, 0xB4AE, 0xB4AF, 0xB4B0, 0xB4B1, 0xB4B2, 0xB4B3,
    0xB4B4, 0xB4B5, 0xB4B6, 0xB4B7, 0xB4B8, 0xB4B9, 0xB4BA, 0xB4BB,
    0xB4BC, 0xB4BD, 0xB4BE, 0xB4BF, 0xB4C0, 0xB4C1, 0xB4C2, 0xB4C3,
    0xB4C4, 0xB4C5, 0xB4C6, 0xB4C7, 0xB4C8, 0xB4C9, 0xB4CA, 0xB4CB,
    0xB4CC, 0xB4CD, 0xB4CE, 0xB4CF, 0xB4D0, 0xB4D1, 0xB4D2, 0xB4D3,
    0xB4D4, 0xB4D5, 0xB4D6, 0xB4D7, 0xB4D8, 0xB4D9, 0xB4DA, 0xB4DB,
    0xB4DC, 0xB4DD, 0xB4DE, 0xB4DF, 0xB4E0, 0xB4E1, 0xB4E2, 0xB4E3,
    0xB4E4, 0xB4E5, 0xB4E6, 0xB4E7, 0xB4E8, 0xB4E9, 0xB4EA, 0xB4EB,
    0xB4EC, 0xB4ED, 0xB4EE, 0xB4EF, 0xB4F0, 0xB4F1, 0xB4F2, 0xB4F3,
    0xB4F4, 0xB4F5, 0xB4F6, 0xB4F7, 0xB4F8, 0xB4F9, 0xB4FA, 0xB4FB,
    0xB4FC, 0xB4FD, 0xB4FE, 0xB5A1, 0xB5A2, 0xB5A3, 0xB5A4, 0xB5A5,
    0xB5A6, 0xB5A7, 0xB5A8, 0xB5A9, 0xB5AA, 0xB5AB, 0xB5AC, 0xB5AD,
    0xB5AE, 0xB5AF, 0xB5B0, 0xB5B1, 0xB5B2, 0xB5B3, 0xB5B4, 0xB5B5,
    0xB5B6, 0xB5B7, 0xB5B8, 0xB5B9, 0xB5BA, 0xB5BB, 0xB5BC, 0xB5BD,
    0xB5BE, 0xB5BF, 0xB5C0, 0xB5C1, 0xB5C2, 0xB5C3, 0xB5C4, 0xB5C5,
    0xB5C6, 0xB5C7, 0xB5C8, 0xB5C9, 0xB5CA, 0xB5CB, 0xB5CC, 0xB5CD,
    0xB5CE, 0xB5CF, 0xB5D0, 0xB5D1, 0xB5D2, 0xB5D3, 0xB5D4, 0xB5D5,
    0xB5D6, 0xB5D7, 0xB5D8, 0xB5D9, 0xB5DA, 0xB5DB, 0xB5DC, 0xB5DD,
    0xB5DE, 0xB5DF, 0xB5E0, 0xB5E1, 0xB5E2, 0xB5E3, 0xB5E4, 0xB5E5,
    0xB5E6, 0xB5E7, 0xB5E8, 0xB5E9, 0xB5EA, 0xB5EB, 0xB5EC, 0xB5ED,
    0xB5EE, 0xB5EF, 0xB5F0, 0xB5F1, 0xB5F2, 0xB5F3, 0xB5F4, 0xB5F5,
    0xB5F6, 0xB5F7, 0xB5F8, 0xB5F9, 0xB5FA, 0xB5FB, 0xB5FC, 0xB5FD,
    0xB5FE, 0xB6A1, 0xB6A2, 0xB6A3, 0xB6A4, 0xB6A5, 0xB6A6, 0xB6A7,
    0xB6A8, 0xB6A9, 0xB6AA, 0xB6AB, 0xB6AC, 0xB6AD, 0xB6AE, 0xB6AF,
    0xB6B0, 0xB6B1, 0xB6B2, 0xB6B3, 0xB6B4, 0xB6B5, 0xB6B6, 0xB6B7,
    0xB6B8, 0xB6B9, 0xB6BA, 0xB6BB, 0xB6BC, 0xB6BD, 0xB6BE, 0xB6BF,
    0xB6C0, 0xB6C1, 0xB6C2, 0xB6C3, 0xB6C4, 0xB6C5, 0xB6C6, 0xB6C7,
    0xB6C8, 0xB6C9, 0xB6CA, 0xB6CB, 0xB6CC, 0xB6CD, 0xB6CE, 0xB6CF,
    0xB6D0, 0xB6D1, 0xB6D2, 0xB6D3, 0xB6D4, 0xB6D5, 0xB6D6, 0xB6D7,
    0xB6D8, 0xB6D9, 0xB6DA, 0xB6DB, 0xB6DC, 0xB6DD, 0xB6DE, 0xB6DF,
    0xB6E0, 0xB6E1, 0xB6E2, 0xB6E3, 0xB6E4, 0xB6E5, 0xB6E6, 0xB6E7,
    0xB6E8, 0xB6E9, 0xB6EA, 0xB6EB, 0xB6EC, 0xB6ED, 0xB6EE, 0xB6EF,
    0xB6F0, 0xB6F1, 0xB6F2, 0xB6F3, 0xB6F4, 0xB6F5, 0xB6F6, 0xB6F7,
    0xB6F8, 0xB6F9, 0xB6FA, 0xB6FB, 0xB6FC, 0xB6FD, 0xB6FE, 0xB7A1,
    0xB7A2, 0xB7A3, 0xB7A4, 0xB7A5, 0xB7A6, 0xB7A7, 0xB7A8, 0xB7A9,
    0xB7AA, 0xB7AB, 0xB7AC, 0xB7AD, 0xB7AE, 0xB7AF, 0xB7B0, 0xB7B1,
    0xB7B2, 0xB7B3, 0xB7B4, 0xB7B5, 0xB7B6, 0xB7B7, 0xB7B8, 0xB7B9,
    0xB7BA, 0xB7BB, 0xB7BC, 0xB7BD, 0xB7BE, 0xB7BF, 0xB7C0, 0xB7C1,
    0xB7C2, 0xB7C3, 0xB7C4, 0xB7C5, 0xB7C6, 0xB7C7, 0xB7C8, 0xB7C9,
    0xB7CA, 0xB7CB, 0xB7CC, 0xB7CD, 0xB7CE, 0xB7CF, 0xB7D0, 0xB7D1,
    0xB7D2, 0xB7D3, 0xB7D4, 0xB7D5, 0xB7D6, 0xB7D7, 0xB7D8, 0xB7D9,
    0xB7DA, 0xB7DB, 0xB7DC, 0xB7DD, 0xB7DE, 0xB7DF, 0xB7E0, 0xB7E1,
    0xB7E2, 0xB7E3, 0xB7E4, 0xB7E5, 0xB7E6, 0xB7E7, 0xB7E8, 0xB7E9,
    0xB7EA, 0xB7EB, 0xB7EC, 0xB7ED, 0xB7EE, 0xB7EF, 0xB7F0, 0xB7F1,
    0xB7F2, 0xB7F3, 0xB7F4, 0xB7F5, 0xB7F6, 0xB7F7, 0xB7F8, 0xB7F9,
    0xB7FA, 0xB7FB, 0xB7FC, 0xB7FD, 0xB7FE, 0xB8A1, 0xB8A2, 0xB8A3,
    0xB8A4, 0xB8A5, 0xB8A6, 0xB8A7, 0xB8A8, 0xB8A9, 0xB8AA, 0xB8AB,
    0xB8AC, 0xB8AD, 0xB8AE, 0xB8AF, 0xB8B0, 0xB8B1, 0xB8B2, 0xB8B3,
    0xB8B4, 0xB8B5, 0xB8B6, 0xB8B7, 0xB8B8, 0xB8B9, 0xB8BA, 0xB8BB,
    0xB8BC, 0xB8BD, 0xB8BE, 0xB8BF, 0xB8C0, 0xB8C1, 0xB8C2, 0xB8C3,
    0xB8C4, 0xB8C5, 0xB8C6, 0xB8C7, 0xB8C8, 0xB8C9, 0xB8CA, 0xB8CB,
    0xB8CC, 0xB8CD, 0xB8CE, 0xB8CF, 0xB8D0, 0xB8D1, 0xB8D2, 0xB8D3,
    0xB8D4, 0xB8D5, 0xB8D6, 0xB8D7, 0xB8D8, 0xB8D9, 0xB8DA, 0xB8DB,
    0xB8DC, 0xB8DD, 0xB8DE, 0xB8DF, 0xB8E0, 0xB8E1, 0xB8E2, 0xB8E3,
    0xB8E4, 0xB8E5, 0xB8E6, 0xB8E7, 0xB8E8, 0xB8E9, 0xB8EA, 0xB8EB,
    0xB8EC, 0xB8ED, 0xB8EE, 0xB8EF, 0xB8F0, 0xB8F1, 0xB8F2, 0xB8F3,
    0xB8F4, 0xB8F5, 0xB8F6, 0xB8F7, 0xB8F8, 0xB8F9, 0xB8FA, 0xB8FB,
    0xB8FC, 0xB8FD, 0xB8FE, 0xB9A1, 0xB9A2, 0xB9A3, 0xB9A4, 0xB9A5,
    0xB9A6, 0xB9A7, 0xB9A8, 0xB9A9, 0xB9AA, 0xB9AB, 0xB9AC, 0xB9AD,
    0xB9AE, 0xB9AF, 0xB9B0, 0xB9B1, 0xB9B2, 0xB9B3, 0xB9B4, 0xB9B5,
    0xB9B6, 0xB9B7, 0xB9B8, 0xB9B9, 0xB9BA, 0xB9BB, 0xB9BC, 0xB9BD,
    0xB9BE, 0xB9BF, 0xB9C0, 0xB9C1, 0xB9C2, 0xB9C3, 0xB9C4, 0xB9C5,
    0xB9C6, 0xB9C7, 0xB9C8, 0xB9C9, 0xB9CA, 0xB9CB, 0xB9CC, 0xB9CD,
    0xB9CE, 0xB9CF, 0xB9D0, 0xB9D1, 0xB9D2, 0xB9D3, 0xB9D4, 0xB9D5,
    0xB9D6, 0xB9D7, 0xB9D8, 0xB9D9, 0xB9DA, 0xB9DB, 0xB9DC, 0xB9DD,
    0xB9DE, 0xB9DF, 0xB9E0, 0xB9E1, 0xB9E2, 0xB9E3, 0xB9E4, 0xB9E5,
    0xB9E6, 0xB9E7, 0xB9E8, 0xB9E9, 0xB9EA, 0xB9EB, 0xB9EC, 0xB9ED,
    0xB9EE, 0xB9EF, 0xB9F0, 0xB9F1, 0xB9F2, 0xB9F3, 0xB9F4, 0xB9F5,
    0xB9F6, 0xB9F7, 0xB9F8, 0xB9F9, 0xB9FA, 0xB9FB, 0xB9FC, 0xB9FD,
    0xB9FE, 0xBAA1, 0xBAA2, 0xBAA3, 0xBAA4, 0xBAA5, 0xBAA6, 0xBAA7,
    0xBAA8, 0xBAA9, 0xBAAA, 0xBAAB, 0xBAAC, 0xBAAD, 0xBAAE, 0xBAAF,
    0xBAB0, 0xBAB1, 0xBAB2, 0xBAB3, 0xBAB4, 0xBAB5, 0xBAB6, 0xBAB7,
    0xBAB8, 0xBAB9, 0xBABA, 0xBABB, 0xBABC, 0xBABD, 0xBABE, 0xBABF,
    0xBAC0, 0xBAC1, 0xBAC2, 0xBAC3, 0xBAC4, 0xBAC5, 0xBAC6, 0xBAC7,
    0xBAC8, 0xBAC9, 0xBACA, 0xBACB, 0xBACC, 0xBACD, 0xBACE, 0xBACF,
    0xBAD0, 0xBAD1, 0xBAD2, 0xBAD3, 0xBAD4, 0xBAD5, 0xBAD6, 0xBAD7,
    0xBAD8, 0xBAD9, 0xBADA, 0xBADB, 0xBADC, 0xBADD, 0xBADE, 0xBADF,
    0xBAE0, 0xBAE1, 0xBAE2, 0xBAE3, 0xBAE4, 0xBAE5, 0xBAE6, 0xBAE7,
    0xBAE8, 0xBAE9, 0xBAEA, 0xBAEB, 0xBAEC, 0xBAED, 0xBAEE, 0xBAEF,
    0xBAF0, 0xBAF1, 0xBAF2, 0xBAF3, 0xBAF4, 0xBAF5, 0xBAF6, 0xBAF7,
    0xBAF8, 0xBAF9, 0xBAFA, 0xBAFB, 0xBAFC, 0xBAFD, 0xBAFE, 0xBBA1,
    0xBBA2, 0xBBA3, 0xBBA4, 0xBBA5, 0xBBA6, 0xBBA7, 0xBBA8, 0xBBA9,
    0xBBAA, 0xBBAB, 0xBBAC, 0xBBAD, 0xBBAE, 0xBBAF, 0xBBB0, 0xBBB1,
    0xBBB2, 0xBBB3, 0xBBB4, 0xBBB5, 0xBBB6, 0xBBB7, 0xBBB8, 0xBBB9,
    0xBBBA, 0xBBBB, 0xBBBC, 0xBBBD, 0xBBBE, 0xBBBF, 0xBBC0, 0xBBC1,
    0xBBC2, 0xBBC3, 0xBBC4, 0xBBC5, 0xBBC6, 0xBBC7, 0xBBC8, 0xBBC9,
    0xBBCA, 0xBBCB, 0xBBCC, 0xBBCD, 0xBBCE, 0xBBCF, 0xBBD0, 0xBBD1,
    0xBBD2, 0xBBD3, 0xBBD4, 0xBBD5, 0xBBD6, 0xBBD7, 0xBBD8, 0xBBD9,
    0xBBDA, 0xBBDB, 0xBBDC, 0xBBDD, 0xBBDE, 0xBBDF, 0xBBE0, 0xBBE1,
    0xBBE2, 0xBBE3, 0xBBE4, 0xBBE5, 0xBBE6, 0xBBE7, 0xBBE8, 0xBBE9,
    0xBBEA, 0xBBEB, 0xBBEC, 0xBBED, 0xBBEE, 0xBBEF, 0xBBF0, 0xBBF1,
    0xBBF2, 0xBBF3, 0xBBF4, 0xBBF5, 0xBBF6, 0xBBF7, 0xBBF8, 0xBBF9,
    0xBBFA, 0xBBFB, 0xBBFC, 0xBBFD, 0xBBFE, 0xBCA1, 0xBCA2, 0xBCA3,
    0xBCA4, 0xBCA5, 0xBCA6, 0xBCA7, 0xBCA8, 0xBCA9, 0xBCAA, 0xBCAB,
    0xBCAC, 0xBCAD, 0xBCAE, 0xBCAF, 0xBCB0, 0xBCB1, 0xBCB2, 0xBCB3,
    0xBCB4, 0xBCB5, 0xBCB6, 0xBCB7, 0xBCB8, 0xBCB9, 0xBCBA, 0xBCBB,
    0xBCBC, 0xBCBD, 0xBCBE, 0xBCBF, 0xBCC0, 0xBCC1, 0xBCC2, 0xBCC3,
    0xBCC4, 0xBCC5, 0xBCC6, 0xBCC7, 0xBCC8, 0xBCC9, 0xBCCA, 0xBCCB,
    0xBCCC, 0xBCCD, 0xBCCE, 0xBCCF, 0xBCD0, 0xBCD1, 0xBCD2, 0xBCD3,
    0xBCD4, 0xBCD5, 0xBCD6, 0xBCD7, 0xBCD8, 0xBCD9, 0xBCDA, 0xBCDB,
    0xBCDC, 0xBCDD, 0xBCDE, 0xBCDF, 0xBCE0, 0xBCE1, 0xBCE2, 0xBCE3,
    0xBCE4, 0xBCE5, 0xBCE6, 0xBCE7, 0xBCE8, 0xBCE9, 0xBCEA, 0xBCEB,
    0xBCEC, 0xBCED, 0xBCEE, 0xBCEF, 0xBCF0, 0xBCF1, 0xBCF2, 0xBCF3,
    0xBCF4, 0xBCF5, 0xBCF6, 0xBCF7, 0xBCF8, 0xBCF9, 0xBCFA, 0xBCFB,
    0xBCFC, 0xBCFD, 0xBCFE, 0xBDA1, 0xBDA2, 0xBDA3, 0xBDA4, 0xBDA5,
    0xBDA6, 0xBDA7, 0xBDA8, 0xBDA9, 0xBDAA, 0xBDAB, 0xBDAC, 0xBDAD,
    0xBDAE, 0xBDAF, 0xBDB0, 0xBDB1, 0xBDB2, 0xBDB3, 0xBDB4, 0xBDB5,
    0xBDB6, 0xBDB7, 0xBDB8, 0xBDB9, 0xBDBA, 0xBDBB, 0xBDBC, 0xBDBD,
    0xBDBE, 0xBDBF, 0xBDC0, 0xBDC1, 0xBDC2, 0xBDC3, 0xBDC4, 0xBDC5,
    0xBDC6, 0xBDC7, 0xBDC8, 0xBDC9, 0xBDCA, 0xBDCB, 0xBDCC, 0xBDCD,
    0xBDCE, 0xBDCF, 0xBDD0, 0xBDD1, 0xBDD2, 0xBDD3, 0xBDD4, 0xBDD5,
    0xBDD6, 0xBDD7, 0xBDD8, 0xBDD9, 0xBDDA, 0xBDDB, 0xBDDC, 0xBDDD,
    0xBDDE, 0xBDDF, 0xBDE0, 0xBDE1, 0xBDE2, 0xBDE3, 0xBDE4, 0xBDE5,
    0xBDE6, 0xBDE7, 0xBDE8, 0xBDE9, 0xBDEA, 0xBDEB, 0xBDEC, 0xBDED,
    0xBDEE, 0xBDEF, 0xBDF0, 0xBDF1, 0xBDF2, 0xBDF3, 0xBDF4, 0xBDF5,
    0xBDF6, 0xBDF7, 0xBDF8, 0xBDF9, 0xBDFA, 0xBDFB, 0xBDFC, 0xBDFD,
    0xBDFE, 0xBEA1, 0xBEA2, 0xBEA3, 0xBEA4, 0xBEA5, 0xBEA6, 0xBEA7,
    0xBEA8, 0xBEA9, 0xBEAA, 0xBEAB, 0xBEAC, 0xBEAD, 0xBEAE, 0xBEAF,
    0xBEB0, 0xBEB1, 0xBEB2, 0xBEB3, 0xBEB4, 0xBEB5, 0xBEB6, 0xBEB7,
    0xBEB8, 0xBEB9, 0xBEBA, 0xBEBB, 0xBEBC, 0xBEBD, 0xBEBE, 0xBEBF,
    0xBEC0, 0xBEC1, 0xBEC2, 0xBEC3, 0xBEC4, 0xBEC5, 0xBEC6, 0xBEC7,
    0xBEC8, 0xBEC9, 0xBECA, 0xBECB, 0xBECC, 0xBECD, 0xBECE, 0xBECF,
    0xBED0, 0xBED1, 0xBED2, 0xBED3, 0xBED4, 0xBED5, 0xBED6, 0xBED7,
    0xBED8, 0xBED9, 0xBEDA, 0xBEDB, 0xBEDC, 0xBEDD, 0xBEDE, 0xBEDF,
    0xBEE0, 0xBEE1, 0xBEE2, 0xBEE3, 0xBEE4, 0xBEE5, 0xBEE6, 0xBEE7,
    0xBEE8, 0xBEE9, 0xBEEA, 0xBEEB, 0xBEEC, 0xBEED, 0xBEEE, 0xBEEF,
    0xBEF0, 0xBEF1, 0xBEF2, 0xBEF3, 0xBEF4, 0xBEF5, 0xBEF6, 0xBEF7,
    0xBEF8, 0xBEF9, 0xBEFA, 0xBEFB, 0xBEFC, 0xBEFD, 0xBEFE, 0xBFA1,
    0xBFA2, 0xBFA3, 0xBFA4, 0xBFA5, 0xBFA6, 0xBFA7, 0xBFA8, 0xBFA9,
    0xBFAA, 0xBFAB, 0xBFAC, 0xBFAD, 0xBFAE, 0xBFAF, 0xBFB0, 0xBFB1,
    0xBFB2, 0xBFB3, 0xBFB4, 0xBFB5, 0xBFB6, 0xBFB7, 0xBFB8, 0xBFB9,
    0xBFBA, 0xBFBB, 0xBFBC, 0xBFBD, 0xBFBE, 0xBFBF, 0xBFC0, 0xBFC1,
    0xBFC2, 0xBFC3, 0xBFC4, 0xBFC5, 0xBFC6, 0xBFC7, 0xBFC8, 0xBFC9,
    0xBFCA, 0xBFCB, 0xBFCC, 0xBFCD, 0xBFCE, 0xBFCF, 0xBFD0, 0xBFD1,
    0xBFD2, 0xBFD3, 0xBFD4, 0xBFD5, 0xBFD6, 0xBFD7, 0xBFD8, 0xBFD9,
    0xBFDA, 0xBFDB, 0xBFDC, 0xBFDD, 0xBFDE, 0xBFDF, 0xBFE0, 0xBFE1,
    0xBFE2, 0xBFE3, 0xBFE4, 0xBFE5, 0xBFE6, 0xBFE7, 0xBFE8, 0xBFE9,
    0xBFEA, 0xBFEB, 0xBFEC, 0xBFED, 0xBFEE, 0xBFEF, 0xBFF0, 0xBFF1,
    0xBFF2, 0xBFF3, 0xBFF4, 0xBFF5, 0xBFF6, 0xBFF7, 0xBFF8, 0xBFF9,
    0xBFFA, 0xBFFB, 0xBFFC, 0xBFFD, 0xBFFE, 0xC0A1, 0xC0A2, 0xC0A3,
    0xC0A4, 0xC0A5, 0xC0A6, 0xC0A7, 0xC0A8, 0xC0A9, 0xC0AA, 0xC0AB,
    0xC0AC, 0xC0AD, 0xC0AE, 0xC0AF, 0xC0B0, 0xC0B1, 0xC0B2, 0xC0B3,
    0xC0B4, 0xC0B5, 0xC0B6, 0xC0B7, 0xC0B8, 0xC0B9, 0xC0BA, 0xC0BB,
    0xC0BC, 0xC0BD, 0xC0BE, 0xC0BF, 0xC0C0, 0xC0C1, 0xC0C2, 0xC0C3,
    0xC0C4, 0xC0C5, 0xC0C6, 0xC0C7, 0xC0C8, 0xC0C9, 0xC0CA, 0xC0CB,
    0xC0CC, 0xC0CD, 0xC0CE, 0xC0CF, 0xC0D0, 0xC0D1, 0xC0D2, 0xC0D3,
    0xC0D4, 0xC0D5, 0xC0D6, 0xC0D7, 0xC0D8, 0xC0D9, 0xC0DA, 0xC0DB,
    0xC0DC, 0xC0DD, 0xC0DE, 0xC0DF, 0xC0E0, 0xC0E1, 0xC0E2, 0xC0E3,
    0xC0E4, 0xC0E5, 0xC0E6, 0xC0E7, 0xC0E8, 0xC0E9, 0xC0EA, 0xC0EB,
    0xC0EC, 0xC0ED, 0xC0EE, 0xC0EF, 0xC0F0, 0xC0F1, 0xC0F2, 0xC0F3,
    0xC0F4, 0xC0F5, 0xC0F6, 0xC0F7, 0xC0F8, 0xC0F9, 0xC0FA, 0xC0FB,
    0xC0FC, 0xC0FD, 0xC0FE, 0xC1A1, 0xC1A2, 0xC1A3, 0xC1A4, 0xC1A5,
    0xC1A6, 0xC1A7, 0xC1A8, 0xC1A9, 0xC1AA, 0xC1AB, 0xC1AC, 0xC1AD,
    0xC1AE, 0xC1AF, 0xC1B0, 0xC1B1, 0xC1B2, 0xC1B3, 0xC1B4, 0xC1B5,
    0xC1B6, 0xC1B7, 0xC1B8, 0xC1B9, 0xC1BA, 0xC1BB, 0xC1BC, 0xC1BD,
    0xC1BE, 0xC1BF, 0xC1C0, 0xC1C1, 0xC1C2, 0xC1C3, 0xC1C4, 0xC1C5,
    0xC1C6, 0xC1C7, 0xC1C8, 0xC1C9, 0xC1CA, 0xC1CB, 0xC1CC, 0xC1CD,
    0xC1CE, 0xC1CF, 0xC1D0, 0xC1D1, 0xC1D2, 0xC1D3, 0xC1D4, 0xC1D5,
    0xC1D6, 0xC1D7, 0xC1D8, 0xC1D9, 0xC1DA, 0xC1DB, 0xC1DC, 0xC1DD,
    0xC1DE, 0xC1DF, 0xC1E0, 0xC1E1, 0xC1E2, 0xC1E3, 0xC1E4, 0xC1E5,
    0xC1E6, 0xC1E7, 0xC1E8, 0xC1E9, 0xC1EA, 0xC1EB, 0xC1EC, 0xC1ED,
    0xC1EE, 0xC1EF, 0xC1F0, 0xC1F1, 0xC1F2, 0xC1F3, 0xC1F4, 0xC1F5,
    0xC1F6, 0xC1F7, 0xC1F8, 0xC1F9, 0xC1FA, 0xC1FB, 0xC1FC, 0xC1FD,
    0xC1FE, 0xC2A1, 0xC2A2, 0xC2A3, 0xC2A4, 0xC2A5, 0xC2A6, 0xC2A7,
    0xC2A8, 0xC2A9, 0xC2AA, 0xC2AB, 0xC2AC, 0xC2AD, 0xC2AE, 0xC2AF,
    0xC2B0, 0xC2B1, 0xC2B2, 0xC2B3, 0xC2B4, 0xC2B5, 0xC2B6, 0xC2B7,
    0xC2B8, 0xC2B9, 0xC2BA, 0xC2BB, 0xC2BC, 0xC2BD, 0xC2BE, 0xC2BF,
    0xC2C0, 0xC2C1, 0xC2C2, 0xC2C3, 0xC2C4, 0xC2C5, 0xC2C6, 0xC2C7,
    0xC2C8, 0xC2C9, 0xC2CA, 0xC2CB, 0xC2CC, 0xC2CD, 0xC2CE, 0xC2CF,
    0xC2D0, 0xC2D1, 0xC2D2, 0xC2D3, 0xC2D4, 0xC2D5, 0xC2D6, 0xC2D7,
    0xC2D8, 0xC2D9, 0xC2DA, 0xC2DB, 0xC2DC, 0xC2DD, 0xC2DE, 0xC2DF,
    0xC2E0, 0xC2E1, 0xC2E2, 0xC2E3, 0xC2E4, 0xC2E5, 0xC2E6, 0xC2E7,
    0xC2E8, 0xC2E9, 0xC2EA, 0xC2EB, 0xC2EC, 0xC2ED, 0xC2EE, 0xC2EF,
    0xC2F0, 0xC2F1, 0xC2F2, 0xC2F3, 0xC2F4, 0xC2F5, 0xC2F6, 0xC2F7,
    0xC2F8, 0xC2F9, 0xC2FA, 0xC2FB, 0xC2FC, 0xC2FD, 0xC2FE, 0xC3A1,
    0xC3A2, 0xC3A3, 0xC3A4, 0xC3A5, 0xC3A6, 0xC3A7, 0xC3A8, 0xC3A9,
    0xC3AA, 0xC3AB, 0xC3AC, 0xC3AD, 0xC3AE, 0xC3AF, 0xC3B0, 0xC3B1,
    0xC3B2, 0xC3B3, 0xC3B4, 0xC3B5, 0xC3B6, 0xC3B7, 0xC3B8, 0xC3B9,
    0xC3BA, 0xC3BB, 0xC3BC, 0xC3BD, 0xC3BE, 0xC3BF, 0xC3C0, 0xC3C1,
    0xC3C2, 0xC3C3, 0xC3C4, 0xC3C5, 0xC3C6, 0xC3C7, 0xC3C8, 0xC3C9,
    0xC3CA, 0xC3CB, 0xC3CC, 0xC3CD, 0xC3CE, 0xC3CF, 0xC3D0, 0xC3D1,
    0xC3D2, 0xC3D3, 0xC3D4, 0xC3D5, 0xC3D6, 0xC3D7, 0xC3D8, 0xC3D9,
    0xC3DA, 0xC3DB, 0xC3DC, 0xC3DD, 0xC3DE, 0xC3DF, 0xC3E0, 0xC3E1,
    0xC3E2, 0xC3E3, 0xC3E4, 0xC3E5, 0xC3E6, 0xC3E7, 0xC3E8, 0xC3E9,
    0xC3EA, 0xC3EB, 0xC3EC, 0xC3ED, 0xC3EE, 0xC3EF, 0xC3F0, 0xC3F1,
    0xC3F2, 0xC3F3, 0xC3F4, 0xC3F5, 0xC3F6, 0xC3F7, 0xC3F8, 0xC3F9,
    0xC3FA, 0xC3FB, 0xC3FC, 0xC3FD, 0xC3FE, 0xC4A1, 0xC4A2, 0xC4A3,
    0xC4A4, 0xC4A5, 0xC4A6, 0xC4A7, 0xC4A8, 0xC4A9, 0xC4AA, 0xC4AB,
    0xC4AC, 0xC4AD, 0xC4AE, 0xC4AF, 0xC4B0, 0xC4B1, 0xC4B2, 0xC4B3,
    0xC4B4, 0xC4B5, 0xC4B6, 0xC4B7, 0xC4B8, 0xC4B9, 0xC4BA, 0xC4BB,
    0xC4BC, 0xC4BD, 0xC4BE, 0xC4BF, 0xC4C0, 0xC4C1, 0xC4C2, 0xC4C3,
    0xC4C4, 0xC4C5, 0xC4C6, 0xC4C7, 0xC4C8, 0xC4C9, 0xC4CA, 0xC4CB,
    0xC4CC, 0xC4CD, 0xC4CE, 0xC4CF, 0xC4D0, 0xC4D1, 0xC4D2, 0xC4D3,
    0xC4D4, 0xC4D5, 0xC4D6, 0xC4D7, 0xC4D8, 0xC4D9, 0xC4DA, 0xC4DB,
    0xC4DC, 0xC4DD, 0xC4DE, 0xC4DF, 0xC4E0, 0xC4E1, 0xC4E2, 0xC4E3,
    0xC4E4, 0xC4E5, 0xC4E6, 0xC4E7, 0xC4E8, 0xC4E9, 0xC4EA, 0xC4EB,
    0xC4EC, 0xC4ED, 0xC4EE, 0xC4EF, 0xC4F0, 0xC4F1, 0xC4F2, 0xC4F3,
    0xC4F4, 0xC4F5, 0xC4F6, 0xC4F7, 0xC4F8, 0xC4F9, 0xC4FA, 0xC4FB,
    0xC4FC, 0xC4FD, 0xC4FE, 0xC5A1, 0xC5A2, 0xC5A3, 0xC5A4, 0xC5A5,
    0xC5A6, 0xC5A7, 0xC5A8, 0xC5A9, 0xC5AA, 0xC5AB, 0xC5AC, 0xC5AD,
    0xC5AE, 0xC5AF, 0xC5B0, 0xC5B1, 0xC5B2, 0xC5B3, 0xC5B4, 0xC5B5,
    0xC5B6, 0xC5B7, 0xC5B8, 0xC5B9, 0xC5BA, 0xC5BB, 0xC5BC, 0xC5BD,
    0xC5BE, 0xC5BF, 0xC5C0, 0xC5C1, 0xC5C2, 0xC5C3, 0xC5C4, 0xC5C5,
    0xC5C6, 0xC5C7, 0xC5C8, 0xC5C9, 0xC5CA, 0xC5CB, 0xC5CC, 0xC5CD,
    0xC5CE, 0xC5CF, 0xC5D0, 0xC5D1, 0xC5D2, 0xC5D3, 0xC5D4, 0xC5D5,
    0xC5D6, 0xC5D7, 0xC5D8, 0xC5D9, 0xC5DA, 0xC5DB, 0xC5DC, 0xC5DD,
    0xC5DE, 0xC5DF, 0xC5E0, 0xC5E1, 0xC5E2, 0xC5E3, 0xC5E4, 0xC5E5,
    0xC5E6, 0xC5E7, 0xC5E8, 0xC5E9, 0xC5EA, 0xC5EB, 0xC5EC, 0xC5ED,
    0xC5EE, 0xC5EF, 0xC5F0, 0xC5F1, 0xC5F2, 0xC5F3, 0xC5F4, 0xC5F5,
    0xC5F6, 0xC5F7, 0xC5F8, 0xC5F9, 0xC5FA, 0xC5FB, 0xC5FC, 0xC5FD,
    0xC5FE, 0xC6A1, 0xC6A2, 0xC6A3, 0xC6A4, 0xC6A5, 0xC6A6, 0xC6A7,
    0xC6A8, 0xC6A9, 0xC6AA, 0xC6AB, 0xC6AC, 0xC6AD, 0xC6AE, 0xC6AF,
    0xC6B0, 0xC6B1, 0xC6B2, 0xC6B3, 0xC6B4, 0xC6B5, 0xC6B6, 0xC6B7,
    0xC6B8, 0xC6B9, 0xC6BA, 0xC6BB, 0xC6BC, 0xC6BD, 0xC6BE, 0xC6BF,
    0xC6C0, 0xC6C1, 0xC6C2, 0xC6C3, 0xC6C4, 0xC6C5, 0xC6C6, 0xC6C7,
    0xC6C8, 0xC6C9, 0xC6CA, 0xC6CB, 0xC6CC, 0xC6CD, 0xC6CE, 0xC6CF,
    0xC6D0, 0xC6D1, 0xC6D2, 0xC6D3, 0xC6D4, 0xC6D5, 0xC6D6, 0xC6D7,
    0xC6D8, 0xC6D9, 0xC6DA, 0xC6DB, 0xC6DC, 0xC6DD, 0xC6DE, 0xC6DF,
    0xC6E0, 0xC6E1, 0xC6E2, 0xC6E3, 0xC6E4, 0xC6E5, 0xC6E6, 0xC6E7,
    0xC6E8, 0xC6E9, 0xC6EA, 0xC6EB, 0xC6EC, 0xC6ED, 0xC6EE, 0xC6EF,
    0xC6F0, 0xC6F1, 0xC6F2, 0xC6F3, 0xC6F4, 0xC6F5, 0xC6F6, 0xC6F7,
    0xC6F8, 0xC6F9, 0xC6FA, 0xC6FB, 0xC6FC, 0xC6FD, 0xC6FE, 0xC7A1,
    0xC7A2, 0xC7A3, 0xC7A4, 0xC7A5, 0xC7A6, 0xC7A7, 0xC7A8, 0xC7A9,
    0xC7AA, 0xC7AB, 0xC7AC, 0xC7AD, 0xC7AE, 0xC7AF, 0xC7B0, 0xC7B1,
    0xC7B2, 0xC7B3, 0xC7B4, 0xC7B5, 0xC7B6, 0xC7B7, 0xC7B8, 0xC7B9,
    0xC7BA, 0xC7BB, 0xC7BC, 0xC7BD, 0xC7BE, 0xC7BF, 0xC7C0, 0xC7C1,
    0xC7C2, 0xC7C3, 0xC7C4, 0xC7C5, 0xC7C6, 0xC7C7, 0xC7C8, 0xC7C9,
    0xC7CA, 0xC7CB, 0xC7CC, 0xC7CD, 0xC7CE, 0xC7CF, 0xC7D0, 0xC7D1,
    0xC7D2, 0xC7D3, 0xC7D4, 0xC7D5, 0xC7D6, 0xC7D7, 0xC7D8, 0xC7D9,
    0xC7DA, 0xC7DB, 0xC7DC, 0xC7DD, 0xC7DE, 0xC7DF, 0xC7E0, 0xC7E1,
    0xC7E2, 0xC7E3, 0xC7E4, 0xC7E5, 0xC7E6, 0xC7E7, 0xC7E8, 0xC7E9,
    0xC7EA, 0xC7EB, 0xC7EC, 0xC7ED, 0xC7EE, 0xC7EF, 0xC7F0, 0xC7F1,
    0xC7F2, 0xC7F3, 0xC7F4, 0xC7F5, 0xC7F6, 0xC7F7, 0xC7F8, 0xC7F9,
    0xC7FA, 0xC7FB, 0xC7FC, 0xC7FD, 0xC7FE, 0xC8A1, 0xC8A2, 0xC8A3,
    0xC8A4, 0xC8A5, 0xC8A6, 0xC8A7, 0xC8A8, 0xC8A9, 0xC8AA, 0xC8AB,
    0xC8AC, 0xC8AD, 0xC8AE, 0xC8AF, 0xC8B0, 0xC8B1, 0xC8B2, 0xC8B3,
    0xC8B4, 0xC8B5, 0xC8B6, 0xC8B7, 0xC8B8, 0xC8B9, 0xC8BA, 0xC8BB,
    0xC8BC, 0xC8BD, 0xC8BE, 0xC8BF, 0xC8C0, 0xC8C1, 0xC8C2, 0xC8C3,
    0xC8C4, 0xC8C5, 0xC8C6, 0xC8C7, 0xC8C8, 0xC8C9, 0xC8CA, 0xC8CB,
    0xC8CC, 0xC8CD, 0xC8CE, 0xC8CF, 0xC8D0, 0xC8D1, 0xC8D2, 0xC8D3,
    0xC8D4, 0xC8D5, 0xC8D6, 0xC8D7, 0xC8D8, 0xC8D9, 0xC8DA, 0xC8DB,
    0xC8DC, 0xC8DD, 0xC8DE, 0xC8DF, 0xC8E0, 0xC8E1, 0xC8E2, 0xC8E3,
    0xC8E4, 0xC8E5, 0xC8E6, 0xC8E7, 0xC8E8, 0xC8E9, 0xC8EA, 0xC8EB,
    0xC8EC, 0xC8ED, 0xC8EE, 0xC8EF, 0xC8F0, 0xC8F1, 0xC8F2, 0xC8F3,
    0xC8F4, 0xC8F5, 0xC8F6, 0xC8F7, 0xC8F8, 0xC8F9, 0xC8FA, 0xC8FB,
    0xC8FC, 0xC8FD, 0xC8FE, 0xCBD0, 0xCBD6, 0xCBE7, 0xCDCF, 0xCDE8,
    0xCEAD, 0xCFFB, 0xD0A2, 0xD0B8, 0xD0D0, 0xD0DD, 0xD1D4, 0xD1D5,
    0xD1D8, 0xD1DB, 0xD1DC, 0xD1DD, 0xD1DE, 0xD1DF, 0xD1E0, 0xD1E2,
    0xD1E3, 0xD1E4, 0xD1E5, 0xD1E6, 0xD1E8, 0xD1E9, 0xD1EA, 0xD1EB,
    0xD1ED, 0xD1EF, 0xD1F0, 0xD1F2, 0xD1F6, 0xD1FA, 0xD1FC, 0xD1FD,
    0xD1FE, 0xD2A2, 0xD2A3, 0xD2A7, 0xD2A8, 0xD2A9, 0xD2AA, 0xD2AB,
    0xD2AD, 0xD2B2, 0xD2BE, 0xD2C2, 0xD2C3, 0xD2C4, 0xD2C6, 0xD2C7,
    0xD2C8, 0xD2C9, 0xD2CA, 0xD2CB, 0xD2CD, 0xD2CE, 0xD2CF, 0xD2D0,
    0xD2D1, 0xD2D2, 0xD2D3, 0xD2D4, 0xD2D5, 0xD2D6, 0xD2D7, 0xD2D9,
    0xD2DA, 0xD2DE, 0xD2DF, 0xD2E1, 0xD2E2, 0xD2E4, 0xD2E5, 0xD2E6,
    0xD2E7, 0xD2E8, 0xD2E9, 0xD2EA, 0xD2EB, 0xD2F0, 0xD2F1, 0xD2F2,
    0xD2F3, 0xD2F4, 0xD2F5, 0xD2F7, 0xD2F8, 0xD4E6, 0xD4FC, 0xD5A5,
    0xD5AB, 0xD5AE, 0xD6B8, 0xD6CD, 0xD7CB, 0xD7E4, 0xDBC5, 0xDBE4,
    0xDCA5, 0xDDA5, 0xDDD5, 0xDDF4, 0xDEFC, 0xDEFE, 0xDFB3, 0xDFE1,
    0xDFE8, 0xE0F1, 0xE1AD, 0xE1ED, 0xE3F5, 0xE4A1, 0xE4A9, 0xE5AE,
    0xE5B1, 0xE5B2, 0xE5B9, 0xE5BB, 0xE5BC, 0xE5C4, 0xE5CE, 0xE5D0,
    0xE5D2, 0xE5D6, 0xE5FA, 0xE5FB, 0xE5FC, 0xE5FE, 0xE6A1, 0xE6A4,
    0xE6A7, 0xE6AD, 0xE6AF, 0xE6B0, 0xE6B1, 0xE6B3, 0xE6B7, 0xE6B8,
    0xE6BC, 0xE6C4, 0xE6C6, 0xE6C7, 0xE6CA, 0xE6D2, 0xE6D6, 0xE6D9,
    0xE6DC, 0xE6DF, 0xE6E1, 0xE6E4, 0xE6E5, 0xE6E6, 0xE6E8, 0xE6EA,
    0xE6EB, 0xE6EC, 0xE6EF, 0xE6F1, 0xE6F2, 0xE6F5, 0xE6F6, 0xE6F7,
    0xE6F9, 0xE7A1, 0xE7A6, 0xE7A9, 0xE7AA, 0xE7AC, 0xE7AD, 0xE7B0,
    0xE7BF, 0xE7C1, 0xE7C6, 0xE7C7, 0xE7CB, 0xE7CD, 0xE7CF, 0xE7D0,
    0xE7D3, 0xE7DF, 0xE7E4, 0xE7E6, 0xE7F7, 0xE8E7, 0xE8E8, 0xE8F0,
    0xE8F1, 0xE8F7, 0xE8F9, 0xE8FB, 0xE8FE, 0xE9A7, 0xE9AC, 0xE9CC,
    0xE9F7, 0xEAC1, 0xEAE5, 0xEAF4, 0xEAF7, 0xEAFC, 0xEAFE, 0xEBA4,
    0xEBA7, 0xEBA9, 0xEBAA, 0xEBBA, 0xEBBB, 0xEBBD, 0xEBC1, 0xEBC2,
    0xEBC6, 0xEBC7, 0xEBCC, 0xEBCF, 0xEBD0, 0xEBD1, 0xEBD2, 0xEBD8,
    0xECA6, 0xECA7, 0xECAA, 0xECAF, 0xECB0, 0xECB1, 0xECB2, 0xECB5,
    0xECB8, 0xECBA, 0xECC0, 0xECC1, 0xECC5, 0xECC6, 0xECC9, 0xECCA,
    0xECD5, 0xECDD, 0xECDE, 0xECE1, 0xECE4, 0xECE7, 0xECE8, 0xECF7,
    0xECF8, 0xECFA, 0xEDA1, 0xEDA2, 0xEDA3, 0xEDEE, 0xEEDB, 0xF2BD,
    0xF2FA, 0xF3B1, 0xF4A7, 0xF4EE, 0xF6F4, 0xF6F6, 0xF7B8, 0xF7C8,
    0xF7D3, 0xF8DB, 0xF8F0, 0xFAA1, 0xFAA2, 0xFAE6, 0xFCA9, 0xA3A1,
    0xA3A2, 0xA3A3, 0xA3A4, 0xA3A5, 0xA3A6, 0xA3A7, 0xA3A8, 0xA3A9,
    0xA3AA, 0xA3AB, 0xA3AC, 0xA3AD, 0xA3AE, 0xA3AF, 0xA3B0, 0xA3B1,
    0xA3B2, 0xA3B3, 0xA3B4, 0xA3B5, 0xA3B6, 0xA3B7, 0xA3B8, 0xA3B9,
    0xA3BA, 0xA3BB, 0xA3BC, 0xA3BD, 0xA3BE, 0xA3BF, 0xA3C0, 0xA3C1,
    0xA3C2, 0xA3C3, 0xA3C4, 0xA3C5, 0xA3C6, 0xA3C7, 0xA3C8, 0xA3C9,
    0xA3CA, 0xA3CB, 0xA3CC, 0xA3CD, 0xA3CE, 0xA3CF, 0xA3D0, 0xA3D1,
    0xA3D2, 0xA3D3, 0xA3D4, 0xA3D5, 0xA3D6, 0xA3D7, 0xA3D8, 0xA3D9,
    0xA3DA, 0xA3DB, 0xA1AC, 0xA3DD, 0xA3DE, 0xA3DF, 0xA3E0, 0xA3E1,
    0xA3E2, 0xA3E3, 0xA3E4, 0xA3E5, 0xA3E6, 0xA3E7, 0xA3E8, 0xA3E9,
    0xA3EA, 0xA3EB, 0xA3EC, 0xA3ED, 0xA3EE, 0xA3EF, 0xA3F0, 0xA3F1,
    0xA3F2, 0xA3F3, 0xA3F4, 0xA3F5, 0xA3F6, 0xA3F7, 0xA3F8, 0xA3F9,
    0xA3FA, 0xA3FB, 0xA3FC, 0xA3FD, 0xA2A6, 0xA1CB, 0xA1CC, 0xA1FE,
    0xA3FE, 0xA1CD, 0xA3DC,
};

/* Indexes into Unicode `ksx1001_u[]` array in blocks of 0x100 */
static const unsigned short ksx1001_u_ind[256] = {
        0,    50,    50,    73,   171,   171,   171,   171,
      171,   171,   171,   171,   171,   171,   171,   171,
      171,   171,   171,   171,   171,   171,   171,   171,
      171,   171,   171,   171,   171,   171,   171,   171,
      190,   235,   273,   275,   310,   427,   470,   470,
      470,   470,   470,   470,   470,   470,   470,   470,
      570,   750,   809,   839,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   889,   889,   889,   889,
      889,   889,   889,   889,   947,  1025,  1084,  1133,
     1186,  1259,  1303,  1376,  1416,  1469,  1504,  1551,
     1603,  1654,  1720,  1768,  1832,  1888,  1942,  1969,
     1990,  2075,  2136,  2187,  2219,  2281,  2370,  2458,
     2525,  2572,  2621,  2653,  2697,  2741,  2792,  2841,
     2878,  2931,  2967,  3028,  3071,  3116,  3174,  3239,
     3239,  3239,  3239,  3239,  3239,  3239,  3239,  3239,
     3239,  3239,  3239,  3239,  3239,  3239,  3239,  3239,
     3239,  3239,  3239,  3239,  3239,  3239,  3239,  3239,
     3239,  3239,  3239,  3239,  3239,  3239,  3239,  3239,
     3239,  3400,  3507,  3507,  3507,  3507,  3507,  3601,
};

#endif /* Z_KSX1001_H */
