/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ExpressionObject;

public class ExpressionConstructor
extends ObjectConstructor {
    ExpressionObject O;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        ExpressionObject expressionObject = new ExpressionObject(zirkelCanvas.getConstruction(), d2, d3);
        zirkelCanvas.addObject(expressionObject);
        expressionObject.setShowName(false);
        expressionObject.setDefaults();
        zirkelCanvas.repaint();
        this.Dragging = true;
        this.O = expressionObject;
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        this.O.move(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
        zirkelCanvas.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.O.edit(zirkelCanvas);
    }

    public boolean waitForPoint() {
        return false;
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.expression", "Expression: Choose a place!"));
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Expression")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("x") || !xmlTag.hasParam("y")) {
            throw new ConstructionException("Expression coordinates missing!");
        }
        if (!xmlTag.hasParam("value")) {
            throw new ConstructionException(Zirkel.name("exception.expression"));
        }
        ExpressionObject expressionObject = new ExpressionObject(construction, 0.0, 0.0);
        try {
            double d2 = new Expression(xmlTag.getValue("x"), construction, expressionObject).getValue();
            double d3 = new Expression(xmlTag.getValue("y"), construction, expressionObject).getValue();
            expressionObject.move(d2, d3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        expressionObject.setDefaults();
        if (xmlTag.hasParam("prompt")) {
            expressionObject.setPrompt(xmlTag.getValue("prompt"));
        }
        if (xmlTag.hasParam("fixed")) {
            expressionObject.setFixed(xmlTag.getValue("x"), xmlTag.getValue("y"));
        }
        expressionObject.setShowValue(xmlTag.hasParam("showvalue"));
        this.setName(xmlTag, expressionObject);
        this.set(xmlTree, expressionObject);
        construction.add(expressionObject);
        try {
            expressionObject.setExpression(xmlTag.getValue("value"), construction);
        }
        catch (Exception exception) {
            throw new ConstructionException(Zirkel.name("exception.expression"));
        }
        this.setConditionals(xmlTree, construction, expressionObject);
        if (xmlTag.hasTrueParam("slider")) {
            try {
                expressionObject.setSlider(xmlTag.getValue("min"), xmlTag.getValue("max"));
            }
            catch (Exception exception) {
                throw new ConstructionException(Zirkel.name("exception.expression"));
            }
        }
        return true;
    }

    public String getTag() {
        return "Expression";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n == 1) {
            ExpressionObject expressionObject = new ExpressionObject(construction, construction.getX() + (Math.random() - 0.5) * construction.getW(), construction.getY() + (Math.random() - 0.5) * construction.getW());
            if (!string.equals("")) {
                expressionObject.setNameCheck(string);
            }
            construction.add(expressionObject);
            expressionObject.setDefaults();
            try {
                expressionObject.setExpression(stringArray[0], construction);
            }
            catch (Exception exception) {
                throw new ConstructionException(Zirkel.name("exception.expression"));
            }
        } else {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
    }

    public boolean useSmartBoard() {
        return false;
    }
}

