/* Dirty system-dependent hacks.
   Copyright (C) 1996-2011, 2015, 2018-2024 Free Software Foundation,
   Inc.

This file is part of GNU Wget.

GNU Wget is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at
your option) any later version.

GNU Wget is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Wget.  If not, see <http://www.gnu.org/licenses/>.

Additional permission under GNU GPL version 3 section 7

If you modify this program, or any covered work, by linking or
combining it with the OpenSSL project's OpenSSL library (or a
modified version of that library), containing parts covered by the
terms of the OpenSSL or SSLeay licenses, the Free Software Foundation
grants you additional permission to convey the resulting work.
Corresponding Source for a non-source form of such a combination
shall include the source code for the parts of OpenSSL used as well
as that of the covered work.  */

/* This file is included by wget.h.  Random .c files need not include
   it.  */

#ifndef SYSDEP_H
#define SYSDEP_H

/* Provided by gnulib on systems that don't have it: */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdint.h>
#include <inttypes.h>

#ifdef WINDOWS
/* Windows doesn't have some functions normally found on Unix-like
   systems, such as strcasecmp, strptime, etc.  Include mswindows.h so
   we get the declarations for their replacements in mswindows.c, as
   well as to pick up Windows-specific includes and constants.  To be
   able to test for such features, the file must be included as early
   as possible.  */
# include "mswindows.h"
#endif

#include <stdbool.h>
#include <limits.h>
#include <fnmatch.h>
#include "intprops.h"

#endif /* SYSDEP_H */
