/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.7
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/eventbox.h>

VDKEventBox::VDKEventBox(VDKForm* owner, int mode):
  VDKObjectContainer(owner),mode(mode)
{
widget = sigwid = gtk_event_box_new(); 
switch(mode)
    {
    case v_box:
      box = gtk_vbox_new(FALSE,0);
      break;
    case h_box:
      box = gtk_hbox_new(FALSE,0);
      break;
    default:
      box = gtk_vbox_new(FALSE,0);
    }
gtk_container_add(GTK_CONTAINER(widget),box);
}

void VDKEventBox::Add(VDKObject* obj, int justify,
		 int expand, int fill , int padding)
{
  switch(justify)
    {
    case l_justify:
      gtk_box_pack_start(GTK_BOX(box), obj->Widget(),expand,fill,padding);
      break;
    case r_justify:
      gtk_box_pack_end(GTK_BOX(box), obj->Widget(),expand,fill,padding);
      break;
    default:
      gtk_box_pack_start(GTK_BOX(box), obj->Widget(),expand,fill,padding);
    }
  gtk_widget_show(box);
  // calls ancestor (B.Liskov docet...)
  VDKObjectContainer::Add(obj,0,0,0,0);
  
}

/*
returns event box position relative
to his outmost parent
 */
VDKPoint 
VDKEventBox::FormPosition()
{
  int x = Widget()->allocation.x;
  int y = Widget()->allocation.y;
  VDKObject* p ;
  for( p = Parent(); p; p = p->Parent())
    {
      x += p->Widget()->allocation.x ;
      y += p->Widget()->allocation.y ;
    }
  return VDKPoint(x,y);
}


