/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef UTILSFORUSERINFO_H
#define UTILSFORUSERINFO_H

#include <QObject>
#include <QMap>
#include <QVariant>
#include <QPainter>
#include <QPainterPath>
#include "ukcccommon.h"
using namespace ukcc;
#include "ukccframe.h"

class QFrame;
class QPushButton;
class QVBoxLayout;
class QHBoxLayout;
class QLabel;

class UtilsForUserinfo : public QObject
{
    Q_OBJECT
public:
    explicit UtilsForUserinfo(QObject *parent = nullptr);

public:
    UkccFrame * buildItemForUsers();

    void refreshUserLogo(QString logo);
    void refreshUserNickname(QString name);
    void refreshUserType(int type);
    void refreshDelStatus(bool enabled);
    void refreshTypeStatus(bool enabled);
    void refreshPwdStatus(bool enabled);
    void setObjectPathData(QString op);

public:
    UkccFrame * mainItemFrame;

    QPushButton * logoBtn;
    QPushButton * changeTypeBtn;
    QPushButton * changePwdBtn;
    QPushButton * delUserBtn;

    QLabel * nickNameLabel;
    QLabel * typeLabel;

    QVBoxLayout * mainUserVerLayout;
    QVBoxLayout * subUserInfoVerLayout;
    QHBoxLayout * mUserInfoHorLayout;

protected:
    QFrame * createHLine(QFrame * f, int len = 0);
    QFrame * createVLine(QFrame * f, int len = 0);
    bool setUtilsTextDynamic(QLabel * label, QString string);

private:
    QString _accountTypeIntToString(int type);
    QPixmap makeRoundLogo(QString logo, int wsize, int hsize, int radius);

public slots:
    void userPropertyChangedSlot(QString, QMap<QString, QVariant>, QStringList);

signals:
    void changePwdBtnPressed();
    void changeLogoBtnPressed();
    void changeTypeBtnPressed();
    void deleteUserBtnPressed();

};

#endif // UTILSFORUSERINFO_H
