## TFSA-2021-192: Uninitialized access in `EinsumHelper::ParseEquation`

### CVE Number
CVE-2021-41201

### Impact
During execution, [`EinsumHelper::ParseEquation()`](https://github.com/tensorflow/tensorflow/blob/e0b6e58c328059829c3eb968136f17aa72b6c876/tensorflow/core/kernels/linalg/einsum_op_impl.h#L126-L181) is supposed to set the flags in `input_has_ellipsis` vector and `*output_has_ellipsis` boolean to indicate whether there is ellipsis in the corresponding inputs and output.

However, the code only changes these flags to `true` and never assigns `false`.

```cc
for (int i = 0; i < num_inputs; ++i) {
  input_label_counts->at(i).resize(num_labels);
  for (const int label : input_labels->at(i)) {
    if (label != kEllipsisLabel)
      input_label_counts->at(i)[label] += 1;
    else
      input_has_ellipsis->at(i) = true;
  }
}
output_label_counts->resize(num_labels);
for (const int label : *output_labels) {
  if (label != kEllipsisLabel)
    output_label_counts->at(label) += 1;
  else
    *output_has_ellipsis = true;
}
```

This results in unitialized variable access if callers assume that `EinsumHelper::ParseEquation()` always sets these flags.


### Patches
We have patched the issue in GitHub commit [f09caa532b6e1ac8d2aa61b7832c78c5b79300c6](https://github.com/tensorflow/tensorflow/commit/f09caa532b6e1ac8d2aa61b7832c78c5b79300c6).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
