## TFSA-2021-186: FPE in `ParallelConcat`

### CVE Number
CVE-2021-41207

### Impact
The [implementation of `ParallelConcat`](https://github.com/tensorflow/tensorflow/blob/8d72537c6abf5a44103b57b9c2e22c14f5f49698/tensorflow/core/kernels/inplace_ops.cc#L72-L97) misses some input validation and can produce a division by 0:

```python
import tensorflow as tf

@tf.function
def test():
  y = tf.raw_ops.ParallelConcat(values=[['tf']],shape=0)
  return y

test()
```

### Patches
We have patched the issue in GitHub commit [f2c3931113eaafe9ef558faaddd48e00a6606235](https://github.com/tensorflow/tensorflow/commit/f2c3931113eaafe9ef558faaddd48e00a6606235).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
