# v0.10.0

Silkaj team is pleased to announce the stable release of Silkaj version 0.10.0

The most important changes are highlighted in this article, if you are looking for a comprehensive list of changes, check out the [changelog](CHANGELOG.md).

## Introduction

This release comes with the handling of the complete life cycle of the revocation file,
the ability to read transaction amounts and recipients listing from a file, convenient for recurrent transaction.
Last but not least, the code handling Ğ1 monetary license has been refactored.
The upstream changes have been retrieved and now features the license into six languages.

Under the hood, Silkaj codebase has been updated to use DuniterPy v1.0,
which comes with breaking backward compatible changes on the `Documents` classes and
the drop of the asynchronous property.

As always, this release also comes with an emphasis on the development environment,
with `pre-commit` usage generalization with the introduction of new hooks.

## Revocation

The complete lifecycle of the revocation document and its storage in a file is now supported!

The `revocation` command comes with four sub-commands:

```bash
silkaj revocation --help
Usage: silkaj revocation [OPTIONS] COMMAND [ARGS]...

  Create, save, verify or publish revocation document. Subcommands optionally
  take the path to the revocation document.

Options:
  -h, --help  Show this message and exit.

Commands:
  publish  Publish revocation document.
  revoke   Create and publish revocation document.
  save     Create and save a revocation document.
  verify   Verifies that a revocation document is correctly formatted and...
```

With these command, you can generate a revocation file, verify its integrity and publish to actually revoke an identity.

For the first time we implemented sub-subcommands thanks to Click.
In the future, we will implement more commands using this feature, since we now know how to implement it.

## Read transaction recipients and amounts from a file

You can now define a file following this format. For instance, a file named `recipients.txt`:

```txt
<ABSOLUTE|RELATIVE>

# comment 1
<amount1> <pubkey1>

# comment 2
<amount2> <pubkey2>:[<checksum2>]
```

It lists the amounts and the recipients’ pubkeys for which the multi-recipients transaction will be issued.
The checksum can be append to the pubkey to have its integrity checked.

And pass it to `silkaj tx` command as follow:

```bash
silkaj --gtest tx -f recipients.txt
```

It will generate a multi-recipients transaction with the amounts in absolute or relative reference depending of the setted header (`ABSOLUTE` or `RELATIVE`).

## Ḡ1 Monetary license

The upstream repository containing the licenses has been updated.
This update brings fixes and improvements on the existing languages and brings additional new languages: Esperanto, Espagnol, Italian, and Portuguese

The display is now only displaying the embedded license files in the console, since it’s available in six up-to-date languages.

```bash
silkaj license
In which language would you like to display Ğ1 monetary license? (es, en, eo, it, fr, pt) [en]: fr
```

The display in the browser has been removed since there were just two websites links to outdated licences in French and English.

## DeathReaper

If you missed DeathReaper crowdfunding completion, you can check this [message](https://forum.duniter.org/t/je-me-presente-je-suis-deathreaper-alias-la-faucheuse/6539/83) or the complete post if you have not been aware of.

## Silkaj Docker image

The automated generation of Silkaj Docker images has been implemented in the first place to distribute DeathReaper.
This is a new way to install Silkaj and its environment. This is convenient to distribute non-stable releases.
You can find the [documentation on how to use these images](doc/docker.md).

## Network

- The asynchronous property has been dropped. The HTTP library usage has been migrated from `asyncio` to `urllib`
- The global option to specify a custom endpoint has been renamed from `-p/--peer` to `-ep/--endpoint`
- Silkaj network layer has been refactored, bringing a more robust code

## DuniterPy v1.0

Support have been added to support DuniterPy v1.0 which came with many breaking backward compatible changes in the `Documents` classes.

## Meta

This release introduces support for Python v3.10 and drops support for Python v3.6.

## Development Environment

`pre-commit` usage has been generalized with `black`, `isort`, `pyupgrade`, `insert-license`, and `gitlab-ci-linter` hooks.
These hooks are run as jobs into the CI.

## Thanks

@moul, @matograine

## Outlook

New `pre-commit` hooks (`pylint`, `flake8`, `mypy`) will be introduced to have more guardrails in order to ensure that future implementations will allow to reach higher code quality.
Then, it’s planned to migrate from `tabulate` to `Texttable`, and then restructure the repository.
Once these prerequisites have been completed, the emphasis will be put onto migrating to Duniter v2 using Substrate.
This means using new APIs: RPC, Subsquid, Using new documents called extrinsincs, and probably other changes.
