#version 330

in vec3       Normal;
in vec4       color;
in float distfrommit;

uniform vec3  lightPos=vec3(1,1,1);

layout( location = 0 ) out vec4 fragColor;


vec3 blinnPhongDirectional( vec3 n , vec3 kd) {
    vec3 ambient = kd.xyz*0.5;//Light.La * Material.Ka;
    vec3 intensity = vec3(0.8, 0.8, 0.8);//specular and diffuse
    vec3 s = normalize(lightPos);// directional light
    float sDotN = dot(s,n);
    float abssDotN = abs(sDotN);
    vec3 diffuse = kd * abssDotN;
    vec3 spec = vec3( 0.0, 0.0, 0.0);
    float Shininess = 48.0;
    if ((sDotN > 0.1)) {
      spec = vec3(1,1,1) * pow(sDotN, Shininess);
    }
    return ambient + intensity * (diffuse + spec);
}

void main(void){
    int st = 10;
    float drawit = fract(distfrommit * st);
    if (drawit>0.5) discard;
    if (gl_FrontFacing) fragColor = vec4(blinnPhongDirectional(Normal, color.rgb),1); //vec4(1,0,0,1);
    else fragColor = vec4(blinnPhongDirectional(-Normal, color.rgb),color.a*0.5);//,vec4(0,1,0,1),0.5);
}
