/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * AtFStk -- Attribute Filesystem Toolkit Library
 *
 * user.c -- AtFS toolkit library
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: user.c[7.0] Fri Jun 25 16:38:54 1993 andy@cs.tu-berlin.de frozen $
 */

#include <pwd.h>
#include "atfs.h"
#include "atfstk.h"

/*=======
 * user
 *=======*/

EXPORT int atUserValid (user)
     Af_user *user;
{
  if (!user)
    return (FALSE);;
  return (user->af_username[0]);
}

EXPORT void atScanUser (userName, resultUser)
     char    *userName;
     Af_user *resultUser;
{
  char fullName[USER_MAX+HOST_MAX+DOMAIN_MAX+2];
  char *hostPtr, *domainPtr;
  
  resultUser->af_username[0] = resultUser->af_username[USER_MAX-1] = '\0';
  resultUser->af_userhost[0] = resultUser->af_userhost[HOST_MAX-1] = '\0';
  resultUser->af_userdomain[0] = resultUser->af_userdomain[DOMAIN_MAX-1] = '\0';

  if (!(userName && userName[0]))
    return;

  strcpy (fullName, userName);

  /* no host and no domain name */
  if ((hostPtr = strrchr (fullName, '@')) == NULL) {
    strncpy (resultUser->af_username, fullName, USER_MAX);
    strcpy (resultUser->af_userdomain, af_getdomain());
    return;
  }

  *(hostPtr++) = '\0';
  strncpy (resultUser->af_username, fullName, USER_MAX);

  /* only domain name */
  if (!strcmp (hostPtr, af_getdomain())) {
    strncpy (resultUser->af_userdomain, hostPtr, DOMAIN_MAX);
    return;
  }

  /* only host name */
  if ((domainPtr = strchr (hostPtr, '.')) == NULL) {
    strncpy (resultUser->af_userhost, hostPtr, HOST_MAX);
    strcpy (resultUser->af_userdomain, af_getdomain());
    return;
  }

  /* host and domain */
  if (!strcmp (domainPtr+1, af_getdomain())) {
    *(domainPtr++) = '\0';
    strncpy (resultUser->af_userhost, hostPtr, HOST_MAX);
    strncpy (resultUser->af_userdomain, domainPtr, DOMAIN_MAX);
    return;
  }

  /* An user identification string with a domain name different to the
   *  local domain is treated as user@domain (without host) */
  (void) strncpy (resultUser->af_userdomain, hostPtr, DOMAIN_MAX);
}

EXPORT char *atUserName (user)
     Af_user *user;
{
  static char result[USER_MAX+HOST_MAX+DOMAIN_MAX+2];

  result[0] = '\0';
  if (user) {
    if (user->af_userdomain[0])
      sprintf (result, "%s@%s", user->af_username, user->af_userdomain);
    else if (user->af_userhost[0])
      sprintf (result, "%s@%s", user->af_username, user->af_userhost);
    else
      strcpy (result, user->af_username);
  }
  return (result);
}

EXPORT uid_t atUserUid (user)
     Af_user *user;
{
  struct passwd *pw;

  if (!user) return (-1);

  if (!strcmp (user->af_userdomain, af_getdomain())) {
    pw = getpwnam (user->af_username);
    if (pw)
      return pw->pw_uid;
    else 
      return (-1);
  }
  else 
    return (-1);
}
