/**

SFSEXP: Small, Fast S-Expression Library version 1.3
Written by Matthew Sottile (mjsottile@gmail.com)

Copyright (2003-2006). The Regents of the University of California. This
material was produced under U.S. Government contract W-7405-ENG-36 for Los
Alamos National Laboratory, which is operated by the University of
California for the U.S. Department of Energy. The U.S. Government has rights
to use, reproduce, and distribute this software. NEITHER THE GOVERNMENT NOR
THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED, OR ASSUMES ANY
LIABILITY FOR THE USE OF THIS SOFTWARE. If software is modified to produce
derivative works, such modified software should be clearly marked, so as not
to confuse it with the version available from LANL.

Additionally, this library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 2.1 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
for more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, U SA

LA-CC-04-094

**/

#ifndef WIN32
# include <unistd.h>
#else
# define ssize_t int
# include <io.h>
# include <sys/types.h>
#endif
#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include "sexp.h"
#include "sexp_vis.h"

/**
 * default behavior: read file "vis.in", write DOT representation of s-expression structure
 * as "sexpexample.dot".
 *
 * if one argument provided, read filename specified in first argument, write DOT
 * representation to "sexpexample.dot"
 *
 * if two arguments provided, read filename specified in first argument, write DOT
 * representation to filename specified in second argument.
 */
int main(int argc, char **argv) {
  sexp_t *a;
  int fd;
  sexp_iowrap_t *iow;

  if (argc == 1) {
    fd = open("vis.in",O_RDONLY);
  } else {
    fd = open(argv[1],O_RDONLY);
  }

  iow = init_iowrap(fd);

  a = read_one_sexp(iow);

  while (a != NULL) {
    if (argc != 3) {
      sexp_to_dotfile(a,"sexpexample.dot");
    } else {
      sexp_to_dotfile(a,argv[2]);
    }

    destroy_sexp(a);
    a = read_one_sexp(iow);
  }

  destroy_iowrap(iow);
  sexp_cleanup();
  close(fd);


  exit(EXIT_SUCCESS);
}
