/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_DIVE_SETTINGS_MESG_HPP)
#define FIT_DIVE_SETTINGS_MESG_HPP

#include "fit_mesg.hpp"

namespace fit
{

class DiveSettingsMesg : public Mesg
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 Timestamp = 253;
       static const FIT_UINT8 MessageIndex = 254;
       static const FIT_UINT8 Name = 0;
       static const FIT_UINT8 Model = 1;
       static const FIT_UINT8 GfLow = 2;
       static const FIT_UINT8 GfHigh = 3;
       static const FIT_UINT8 WaterType = 4;
       static const FIT_UINT8 WaterDensity = 5;
       static const FIT_UINT8 Po2Warn = 6;
       static const FIT_UINT8 Po2Critical = 7;
       static const FIT_UINT8 Po2Deco = 8;
       static const FIT_UINT8 SafetyStopEnabled = 9;
       static const FIT_UINT8 BottomDepth = 10;
       static const FIT_UINT8 BottomTime = 11;
       static const FIT_UINT8 ApneaCountdownEnabled = 12;
       static const FIT_UINT8 ApneaCountdownTime = 13;
       static const FIT_UINT8 BacklightMode = 14;
       static const FIT_UINT8 BacklightBrightness = 15;
       static const FIT_UINT8 BacklightTimeout = 16;
       static const FIT_UINT8 RepeatDiveInterval = 17;
       static const FIT_UINT8 SafetyStopTime = 18;
       static const FIT_UINT8 HeartRateSourceType = 19;
       static const FIT_UINT8 HeartRateSource = 20;
       static const FIT_UINT8 TravelGas = 21;
       static const FIT_UINT8 CcrLowSetpointSwitchMode = 22;
       static const FIT_UINT8 CcrLowSetpoint = 23;
       static const FIT_UINT8 CcrLowSetpointDepth = 24;
       static const FIT_UINT8 CcrHighSetpointSwitchMode = 25;
       static const FIT_UINT8 CcrHighSetpoint = 26;
       static const FIT_UINT8 CcrHighSetpointDepth = 27;
       static const FIT_UINT8 GasConsumptionDisplay = 29;
       static const FIT_UINT8 UpKeyEnabled = 30;
       static const FIT_UINT8 DiveSounds = 35;
       static const FIT_UINT8 LastStopMultiple = 36;
       static const FIT_UINT8 NoFlyTimeMode = 37;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    DiveSettingsMesg(void) : Mesg(Profile::MESG_DIVE_SETTINGS)
    {
    }

    DiveSettingsMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of timestamp field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimestampValid() const
    {
        const Field* field = GetField(253);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns timestamp field
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetTimestamp(void) const
    {
        return GetFieldUINT32Value(253, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set timestamp field
    ///////////////////////////////////////////////////////////////////////
    void SetTimestamp(FIT_DATE_TIME timestamp)
    {
        SetFieldUINT32Value(253, timestamp, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of message_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMessageIndexValid() const
    {
        const Field* field = GetField(254);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns message_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetMessageIndex(void) const
    {
        return GetFieldUINT16Value(254, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set message_index field
    ///////////////////////////////////////////////////////////////////////
    void SetMessageIndex(FIT_MESSAGE_INDEX messageIndex)
    {
        SetFieldUINT16Value(254, messageIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of name field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNameValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns name field
    ///////////////////////////////////////////////////////////////////////
    FIT_WSTRING GetName(void) const
    {
        return GetFieldSTRINGValue(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set name field
    ///////////////////////////////////////////////////////////////////////
    void SetName(FIT_WSTRING name)
    {
        SetFieldSTRINGValue(0, name, 0);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of model field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsModelValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns model field
    ///////////////////////////////////////////////////////////////////////
    FIT_TISSUE_MODEL_TYPE GetModel(void) const
    {
        return GetFieldENUMValue(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set model field
    ///////////////////////////////////////////////////////////////////////
    void SetModel(FIT_TISSUE_MODEL_TYPE model)
    {
        SetFieldENUMValue(1, model, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of gf_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGfLowValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns gf_low field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetGfLow(void) const
    {
        return GetFieldUINT8Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set gf_low field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetGfLow(FIT_UINT8 gfLow)
    {
        SetFieldUINT8Value(2, gfLow, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of gf_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGfHighValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns gf_high field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetGfHigh(void) const
    {
        return GetFieldUINT8Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set gf_high field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetGfHigh(FIT_UINT8 gfHigh)
    {
        SetFieldUINT8Value(3, gfHigh, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of water_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsWaterTypeValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns water_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_WATER_TYPE GetWaterType(void) const
    {
        return GetFieldENUMValue(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set water_type field
    ///////////////////////////////////////////////////////////////////////
    void SetWaterType(FIT_WATER_TYPE waterType)
    {
        SetFieldENUMValue(4, waterType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of water_density field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsWaterDensityValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns water_density field
    // Units: kg/m^3
    // Comment: Fresh water is usually 1000; salt water is usually 1025
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetWaterDensity(void) const
    {
        return GetFieldFLOAT32Value(5, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set water_density field
    // Units: kg/m^3
    // Comment: Fresh water is usually 1000; salt water is usually 1025
    ///////////////////////////////////////////////////////////////////////
    void SetWaterDensity(FIT_FLOAT32 waterDensity)
    {
        SetFieldFLOAT32Value(5, waterDensity, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of po2_warn field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPo2WarnValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns po2_warn field
    // Units: percent
    // Comment: Typically 1.40
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetPo2Warn(void) const
    {
        return GetFieldFLOAT32Value(6, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set po2_warn field
    // Units: percent
    // Comment: Typically 1.40
    ///////////////////////////////////////////////////////////////////////
    void SetPo2Warn(FIT_FLOAT32 po2Warn)
    {
        SetFieldFLOAT32Value(6, po2Warn, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of po2_critical field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPo2CriticalValid() const
    {
        const Field* field = GetField(7);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns po2_critical field
    // Units: percent
    // Comment: Typically 1.60
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetPo2Critical(void) const
    {
        return GetFieldFLOAT32Value(7, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set po2_critical field
    // Units: percent
    // Comment: Typically 1.60
    ///////////////////////////////////////////////////////////////////////
    void SetPo2Critical(FIT_FLOAT32 po2Critical)
    {
        SetFieldFLOAT32Value(7, po2Critical, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of po2_deco field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPo2DecoValid() const
    {
        const Field* field = GetField(8);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns po2_deco field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetPo2Deco(void) const
    {
        return GetFieldFLOAT32Value(8, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set po2_deco field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetPo2Deco(FIT_FLOAT32 po2Deco)
    {
        SetFieldFLOAT32Value(8, po2Deco, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of safety_stop_enabled field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSafetyStopEnabledValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns safety_stop_enabled field
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL GetSafetyStopEnabled(void) const
    {
        return GetFieldENUMValue(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set safety_stop_enabled field
    ///////////////////////////////////////////////////////////////////////
    void SetSafetyStopEnabled(FIT_BOOL safetyStopEnabled)
    {
        SetFieldENUMValue(9, safetyStopEnabled, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of bottom_depth field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBottomDepthValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns bottom_depth field
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetBottomDepth(void) const
    {
        return GetFieldFLOAT32Value(10, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set bottom_depth field
    ///////////////////////////////////////////////////////////////////////
    void SetBottomDepth(FIT_FLOAT32 bottomDepth)
    {
        SetFieldFLOAT32Value(10, bottomDepth, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of bottom_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBottomTimeValid() const
    {
        const Field* field = GetField(11);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns bottom_time field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetBottomTime(void) const
    {
        return GetFieldUINT32Value(11, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set bottom_time field
    ///////////////////////////////////////////////////////////////////////
    void SetBottomTime(FIT_UINT32 bottomTime)
    {
        SetFieldUINT32Value(11, bottomTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of apnea_countdown_enabled field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsApneaCountdownEnabledValid() const
    {
        const Field* field = GetField(12);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns apnea_countdown_enabled field
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL GetApneaCountdownEnabled(void) const
    {
        return GetFieldENUMValue(12, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set apnea_countdown_enabled field
    ///////////////////////////////////////////////////////////////////////
    void SetApneaCountdownEnabled(FIT_BOOL apneaCountdownEnabled)
    {
        SetFieldENUMValue(12, apneaCountdownEnabled, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of apnea_countdown_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsApneaCountdownTimeValid() const
    {
        const Field* field = GetField(13);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns apnea_countdown_time field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetApneaCountdownTime(void) const
    {
        return GetFieldUINT32Value(13, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set apnea_countdown_time field
    ///////////////////////////////////////////////////////////////////////
    void SetApneaCountdownTime(FIT_UINT32 apneaCountdownTime)
    {
        SetFieldUINT32Value(13, apneaCountdownTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of backlight_mode field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBacklightModeValid() const
    {
        const Field* field = GetField(14);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns backlight_mode field
    ///////////////////////////////////////////////////////////////////////
    FIT_DIVE_BACKLIGHT_MODE GetBacklightMode(void) const
    {
        return GetFieldENUMValue(14, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set backlight_mode field
    ///////////////////////////////////////////////////////////////////////
    void SetBacklightMode(FIT_DIVE_BACKLIGHT_MODE backlightMode)
    {
        SetFieldENUMValue(14, backlightMode, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of backlight_brightness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBacklightBrightnessValid() const
    {
        const Field* field = GetField(15);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns backlight_brightness field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetBacklightBrightness(void) const
    {
        return GetFieldUINT8Value(15, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set backlight_brightness field
    ///////////////////////////////////////////////////////////////////////
    void SetBacklightBrightness(FIT_UINT8 backlightBrightness)
    {
        SetFieldUINT8Value(15, backlightBrightness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of backlight_timeout field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBacklightTimeoutValid() const
    {
        const Field* field = GetField(16);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns backlight_timeout field
    ///////////////////////////////////////////////////////////////////////
    FIT_BACKLIGHT_TIMEOUT GetBacklightTimeout(void) const
    {
        return GetFieldUINT8Value(16, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set backlight_timeout field
    ///////////////////////////////////////////////////////////////////////
    void SetBacklightTimeout(FIT_BACKLIGHT_TIMEOUT backlightTimeout)
    {
        SetFieldUINT8Value(16, backlightTimeout, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repeat_dive_interval field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepeatDiveIntervalValid() const
    {
        const Field* field = GetField(17);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns repeat_dive_interval field
    // Units: s
    // Comment: Time between surfacing and ending the activity
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetRepeatDiveInterval(void) const
    {
        return GetFieldUINT16Value(17, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repeat_dive_interval field
    // Units: s
    // Comment: Time between surfacing and ending the activity
    ///////////////////////////////////////////////////////////////////////
    void SetRepeatDiveInterval(FIT_UINT16 repeatDiveInterval)
    {
        SetFieldUINT16Value(17, repeatDiveInterval, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of safety_stop_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSafetyStopTimeValid() const
    {
        const Field* field = GetField(18);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns safety_stop_time field
    // Units: s
    // Comment: Time at safety stop (if enabled)
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetSafetyStopTime(void) const
    {
        return GetFieldUINT16Value(18, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set safety_stop_time field
    // Units: s
    // Comment: Time at safety stop (if enabled)
    ///////////////////////////////////////////////////////////////////////
    void SetSafetyStopTime(FIT_UINT16 safetyStopTime)
    {
        SetFieldUINT16Value(18, safetyStopTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of heart_rate_source_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsHeartRateSourceTypeValid() const
    {
        const Field* field = GetField(19);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns heart_rate_source_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_SOURCE_TYPE GetHeartRateSourceType(void) const
    {
        return GetFieldENUMValue(19, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set heart_rate_source_type field
    ///////////////////////////////////////////////////////////////////////
    void SetHeartRateSourceType(FIT_SOURCE_TYPE heartRateSourceType)
    {
        SetFieldENUMValue(19, heartRateSourceType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of heart_rate_source field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsHeartRateSourceValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns heart_rate_source field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetHeartRateSource(void) const
    {
        return GetFieldUINT8Value(20, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set heart_rate_source field
    ///////////////////////////////////////////////////////////////////////
    void SetHeartRateSource(FIT_UINT8 heartRateSource)
    {
        SetFieldUINT8Value(20, heartRateSource, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of heart_rate_antplus_device_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsHeartRateAntplusDeviceTypeValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_ANTPLUS_DEVICE_TYPE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_ANTPLUS_DEVICE_TYPE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns heart_rate_antplus_device_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_ANTPLUS_DEVICE_TYPE GetHeartRateAntplusDeviceType(void) const
    {
        return GetFieldUINT8Value(20, 0, (FIT_UINT16) Profile::DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_ANTPLUS_DEVICE_TYPE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set heart_rate_antplus_device_type field
    ///////////////////////////////////////////////////////////////////////
    void SetHeartRateAntplusDeviceType(FIT_ANTPLUS_DEVICE_TYPE heartRateAntplusDeviceType)
    {
        SetFieldUINT8Value(20, heartRateAntplusDeviceType, 0, (FIT_UINT16) Profile::DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_ANTPLUS_DEVICE_TYPE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of heart_rate_local_device_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsHeartRateLocalDeviceTypeValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_LOCAL_DEVICE_TYPE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_LOCAL_DEVICE_TYPE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns heart_rate_local_device_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_LOCAL_DEVICE_TYPE GetHeartRateLocalDeviceType(void) const
    {
        return GetFieldUINT8Value(20, 0, (FIT_UINT16) Profile::DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_LOCAL_DEVICE_TYPE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set heart_rate_local_device_type field
    ///////////////////////////////////////////////////////////////////////
    void SetHeartRateLocalDeviceType(FIT_LOCAL_DEVICE_TYPE heartRateLocalDeviceType)
    {
        SetFieldUINT8Value(20, heartRateLocalDeviceType, 0, (FIT_UINT16) Profile::DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_LOCAL_DEVICE_TYPE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of travel_gas field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTravelGasValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns travel_gas field
    // Comment: Index of travel dive_gas message
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetTravelGas(void) const
    {
        return GetFieldUINT16Value(21, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set travel_gas field
    // Comment: Index of travel dive_gas message
    ///////////////////////////////////////////////////////////////////////
    void SetTravelGas(FIT_MESSAGE_INDEX travelGas)
    {
        SetFieldUINT16Value(21, travelGas, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ccr_low_setpoint_switch_mode field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCcrLowSetpointSwitchModeValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ccr_low_setpoint_switch_mode field
    // Comment: If low PO2 should be switched to automatically
    ///////////////////////////////////////////////////////////////////////
    FIT_CCR_SETPOINT_SWITCH_MODE GetCcrLowSetpointSwitchMode(void) const
    {
        return GetFieldENUMValue(22, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ccr_low_setpoint_switch_mode field
    // Comment: If low PO2 should be switched to automatically
    ///////////////////////////////////////////////////////////////////////
    void SetCcrLowSetpointSwitchMode(FIT_CCR_SETPOINT_SWITCH_MODE ccrLowSetpointSwitchMode)
    {
        SetFieldENUMValue(22, ccrLowSetpointSwitchMode, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ccr_low_setpoint field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCcrLowSetpointValid() const
    {
        const Field* field = GetField(23);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ccr_low_setpoint field
    // Units: percent
    // Comment: Target PO2 when using low setpoint
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCcrLowSetpoint(void) const
    {
        return GetFieldFLOAT32Value(23, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ccr_low_setpoint field
    // Units: percent
    // Comment: Target PO2 when using low setpoint
    ///////////////////////////////////////////////////////////////////////
    void SetCcrLowSetpoint(FIT_FLOAT32 ccrLowSetpoint)
    {
        SetFieldFLOAT32Value(23, ccrLowSetpoint, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ccr_low_setpoint_depth field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCcrLowSetpointDepthValid() const
    {
        const Field* field = GetField(24);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ccr_low_setpoint_depth field
    // Units: m
    // Comment: Depth to switch to low setpoint in automatic mode
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCcrLowSetpointDepth(void) const
    {
        return GetFieldFLOAT32Value(24, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ccr_low_setpoint_depth field
    // Units: m
    // Comment: Depth to switch to low setpoint in automatic mode
    ///////////////////////////////////////////////////////////////////////
    void SetCcrLowSetpointDepth(FIT_FLOAT32 ccrLowSetpointDepth)
    {
        SetFieldFLOAT32Value(24, ccrLowSetpointDepth, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ccr_high_setpoint_switch_mode field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCcrHighSetpointSwitchModeValid() const
    {
        const Field* field = GetField(25);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ccr_high_setpoint_switch_mode field
    // Comment: If high PO2 should be switched to automatically
    ///////////////////////////////////////////////////////////////////////
    FIT_CCR_SETPOINT_SWITCH_MODE GetCcrHighSetpointSwitchMode(void) const
    {
        return GetFieldENUMValue(25, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ccr_high_setpoint_switch_mode field
    // Comment: If high PO2 should be switched to automatically
    ///////////////////////////////////////////////////////////////////////
    void SetCcrHighSetpointSwitchMode(FIT_CCR_SETPOINT_SWITCH_MODE ccrHighSetpointSwitchMode)
    {
        SetFieldENUMValue(25, ccrHighSetpointSwitchMode, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ccr_high_setpoint field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCcrHighSetpointValid() const
    {
        const Field* field = GetField(26);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ccr_high_setpoint field
    // Units: percent
    // Comment: Target PO2 when using high setpoint
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCcrHighSetpoint(void) const
    {
        return GetFieldFLOAT32Value(26, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ccr_high_setpoint field
    // Units: percent
    // Comment: Target PO2 when using high setpoint
    ///////////////////////////////////////////////////////////////////////
    void SetCcrHighSetpoint(FIT_FLOAT32 ccrHighSetpoint)
    {
        SetFieldFLOAT32Value(26, ccrHighSetpoint, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ccr_high_setpoint_depth field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCcrHighSetpointDepthValid() const
    {
        const Field* field = GetField(27);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ccr_high_setpoint_depth field
    // Units: m
    // Comment: Depth to switch to high setpoint in automatic mode
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCcrHighSetpointDepth(void) const
    {
        return GetFieldFLOAT32Value(27, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ccr_high_setpoint_depth field
    // Units: m
    // Comment: Depth to switch to high setpoint in automatic mode
    ///////////////////////////////////////////////////////////////////////
    void SetCcrHighSetpointDepth(FIT_FLOAT32 ccrHighSetpointDepth)
    {
        SetFieldFLOAT32Value(27, ccrHighSetpointDepth, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of gas_consumption_display field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGasConsumptionDisplayValid() const
    {
        const Field* field = GetField(29);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns gas_consumption_display field
    // Comment: Type of gas consumption rate to display. Some values are only valid if tank volume is known.
    ///////////////////////////////////////////////////////////////////////
    FIT_GAS_CONSUMPTION_RATE_TYPE GetGasConsumptionDisplay(void) const
    {
        return GetFieldENUMValue(29, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set gas_consumption_display field
    // Comment: Type of gas consumption rate to display. Some values are only valid if tank volume is known.
    ///////////////////////////////////////////////////////////////////////
    void SetGasConsumptionDisplay(FIT_GAS_CONSUMPTION_RATE_TYPE gasConsumptionDisplay)
    {
        SetFieldENUMValue(29, gasConsumptionDisplay, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of up_key_enabled field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsUpKeyEnabledValid() const
    {
        const Field* field = GetField(30);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns up_key_enabled field
    // Comment: Indicates whether the up key is enabled during dives
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL GetUpKeyEnabled(void) const
    {
        return GetFieldENUMValue(30, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set up_key_enabled field
    // Comment: Indicates whether the up key is enabled during dives
    ///////////////////////////////////////////////////////////////////////
    void SetUpKeyEnabled(FIT_BOOL upKeyEnabled)
    {
        SetFieldENUMValue(30, upKeyEnabled, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of dive_sounds field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDiveSoundsValid() const
    {
        const Field* field = GetField(35);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns dive_sounds field
    // Comment: Sounds and vibration enabled or disabled in-dive
    ///////////////////////////////////////////////////////////////////////
    FIT_TONE GetDiveSounds(void) const
    {
        return GetFieldENUMValue(35, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set dive_sounds field
    // Comment: Sounds and vibration enabled or disabled in-dive
    ///////////////////////////////////////////////////////////////////////
    void SetDiveSounds(FIT_TONE diveSounds)
    {
        SetFieldENUMValue(35, diveSounds, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of last_stop_multiple field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLastStopMultipleValid() const
    {
        const Field* field = GetField(36);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns last_stop_multiple field
    // Comment: Usually 1.0/1.5/2.0 representing 3/4.5/6m or 10/15/20ft
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetLastStopMultiple(void) const
    {
        return GetFieldFLOAT32Value(36, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set last_stop_multiple field
    // Comment: Usually 1.0/1.5/2.0 representing 3/4.5/6m or 10/15/20ft
    ///////////////////////////////////////////////////////////////////////
    void SetLastStopMultiple(FIT_FLOAT32 lastStopMultiple)
    {
        SetFieldFLOAT32Value(36, lastStopMultiple, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of no_fly_time_mode field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNoFlyTimeModeValid() const
    {
        const Field* field = GetField(37);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns no_fly_time_mode field
    // Comment: Indicates which guidelines to use for no-fly surface interval.
    ///////////////////////////////////////////////////////////////////////
    FIT_NO_FLY_TIME_MODE GetNoFlyTimeMode(void) const
    {
        return GetFieldENUMValue(37, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set no_fly_time_mode field
    // Comment: Indicates which guidelines to use for no-fly surface interval.
    ///////////////////////////////////////////////////////////////////////
    void SetNoFlyTimeMode(FIT_NO_FLY_TIME_MODE noFlyTimeMode)
    {
        SetFieldENUMValue(37, noFlyTimeMode, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_DIVE_SETTINGS_MESG_HPP)
