#include "ipbase.ih"

    // logs TCP and UDP records
void IPbase::logConnection(Record const &record) const
{
    if (record.viaIP() != 0)
    {
          d_stdMsg << "from " << record.beginTime() << 
            " thru " << record.endTime() << 
            ShowSeconds::utcMarker() << ": " << 
            record.protocolStr() << ' ' <<
            record.sourceIPstr() << ',' << 
                                left << setw(5) << record.sourcePort() << 
            " (via: " << record.viaIPstr()  << ',' << 
                                setw(5) << record.viaPort() << ") "
            "to " << record.destIPstr() << ',' <<  
                                showLeft(record.destPort()) << right << 
            "sent: "     << setw(10) << record.sentBytes() << ", "
            "received: " << setw(10) << record.receivedBytes() << 
            s_logTypeText[s_logType].first << endl;

        logCSV(record);
    }
}

