%define name      libppd
%define version   0.10
%define rel       1
%define prefix    /usr

Name: %{name}
Version: %{version}
Release: %{rel}
Summary: Library to manipulate PostScript files based upon PPD information.
License: GPL
Group: System Environment/Libraries
BuildRoot: /tmp/%{name}-root

Source0: %{name}-%{version}.tar.gz

%package devel
Summary: Headers and additional files to develop programs using libppd.
Group: Development/Libraries
Requires: libppd

%package -n ppdfilt
Summary: Insert printer specific commands into PostScript print jobs.
Group: System Environment/Daemons
Requires: libppd

%description
PostScript was designed as a device independent language. To be able
to access device specific features like selecting different paper
trays and turning on different imaging models, each printer vendor
supplies a PostScript Printer Definition, PPD file. This library reads
those PPD files and provides functions that allow a program to modify
the PostScript print jobs to acces these special features.

%description devel
To develop programs based upon the libppd library, the system needs to 
have these header and object files available for creating the executables.

%description -n ppdfilt
ppdfilt is a filter program designed to either be within a filter
script or from the command line tool to insert printer specific
commands to a PostScript print job. This allows people to tell the
printer to duplex or staple the print job, or tell it what  paper tray
to draw paper from.

%prep
%setup

%build
./configure --prefix=%{_prefix} \
            --exec-prefix=%{_exec_prefix} \
            --bindir=%{_bindir} \
            --sbindir=%{_sbindir} \
            --sysconfdir=%{_sysconfdir} \
            --datadir=%{_datadir} \
            --includedir=%{_includedir} \
            --libdir=%{_libdir} \
            --libexecdir=%{_libexecdir} \
            --localstatedir=%{_localstatedir} \
            --sharedstatedir=%{_sharedstatedir} \
            --mandir=%{_mandir} \
            --infodir=%{_infodir}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_prefix}
make DESTDIR="$RPM_BUILD_ROOT" install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{_libdir}/*.so.*
%doc README ChangeLog AUTHORS COPYING NEWS TODO 

%files devel
%defattr(-, root, root)
%{_libdir}/lib*.so
%{_libdir}/*.a
%{_libdir}/*.la
%{_includedir}/*
%{_mandir}/man3/*

%files -n ppdfilt
%{_mandir}/man1/ppdfilt*
%{_bindir}/ppdfilt

%changelog
* Wed Nov 15 2000 Tom Dyas <tdyas@valinux.com>
- Use the macros that RPM provides to make the spec file more portable.

* Thu Nov 09 2000 Tom Dyas <tdyas@valinux.com>
- Converted so that the name and version are filled in by configure.
- Use BuildRoot so the build machine's normal file tree is untouched.
- Use /sbin/ldconfig after install and remove so the ld.so cache is updated.

* Tue Jul 25 2000 Mark Fasheh <mfasheh@valinux.com>
- revised spec to handle libppd >= .5

* Mon May 22 2000 Ben Woodard <ben@valinux.com>
- changed semantics on ppd-emit it now handles PPD_ANY properly.
