/* ----- encode/1013xint16, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1013xint16_checksums[] = {
  "5938f68c9c3c3631517ca16dcadd1e96b2553bd6b494161c901c1db455e21173",
  "fe23340654861a9e08289b59a9901d646fd8b2cd98b628e8f34889763b7c2a91",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1013xint16_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1013xint16_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1013xint16_ITEMBYTES

static void *storage_encode_1013xint16_s;
static unsigned char *test_encode_1013xint16_s;
static void *storage_encode_1013xint16_x;
static unsigned char *test_encode_1013xint16_x;
static void *storage_encode_1013xint16_s2;
static unsigned char *test_encode_1013xint16_s2;
static void *storage_encode_1013xint16_x2;
static unsigned char *test_encode_1013xint16_x2;

#define precomputed_encode_1013xint16_NUM 4

static const unsigned char precomputed_encode_1013xint16_s[precomputed_encode_1013xint16_NUM][crypto_encode_STRBYTES] = {
  {245,70,36,53,7,223,0,37,148,115,89,215,253,96,202,246,30,77,118,29,141,194,234,228,30,206,163,195,176,9,229,55,34,194,143,142,12,172,108,223,58,91,75,151,208,72,223,200,26,175,110,173,190,163,186,220,249,5,161,142,174,67,234,40,93,140,105,205,45,126,26,208,5,31,132,93,11,104,96,163,138,158,9,101,188,116,218,197,160,155,74,110,98,167,143,39,231,21,253,241,109,118,22,207,49,157,128,38,71,7,101,92,137,169,105,15,13,148,248,246,118,140,237,110,244,66,231,231,214,122,158,164,190,5,227,162,106,218,21,245,198,183,248,12,255,212,94,59,70,234,124,115,182,10,200,1,67,67,206,223,205,89,11,150,110,92,179,189,195,201,199,0,82,98,172,104,194,13,182,155,211,206,243,71,106,163,237,227,117,254,114,157,202,104,31,233,126,31,191,180,254,73,225,208,14,44,24,252,38,69,68,1,75,139,80,142,121,188,59,113,166,140,76,181,175,15,219,180,82,75,53,165,224,58,59,110,170,195,16,173,97,84,93,39,250,239,236,102,146,224,210,126,98,64,134,245,111,46,100,82,218,242,11,173,12,167,207,244,185,163,104,160,56,139,3,0,149,234,68,4,156,198,52,54,138,124,71,147,230,73,80,252,244,33,223,70,183,221,254,182,195,123,45,149,155,254,119,53,3,154,10,201,46,236,148,142,129,173,15,70,162,132,138,230,10,110,46,186,79,96,222,127,181,42,247,62,218,35,234,156,51,130,212,255,127,4,20,104,210,158,185,147,17,240,240,53,52,222,106,94,251,178,102,218,58,53,29,228,118,50,151,253,228,45,158,121,206,80,185,215,19,255,226,109,165,164,51,221,46,163,97,10,6,62,148,241,69,98,31,172,232,128,38,144,249,91,81,18,55,79,60,40,30,105,16,209,159,193,44,193,151,147,118,129,17,145,238,240,196,175,59,176,235,154,230,252,161,126,249,149,165,171,248,14,35,6,179,110,251,16,208,25,243,192,243,19,16,68,205,64,179,72,160,63,124,67,141,135,127,53,129,228,110,232,93,34,43,206,6,5,236,186,19,47,47,56,234,149,12,106,209,197,193,25,56,139,91,197,69,47,19,5,182,20,129,174,110,20,53,153,60,96,155,36,221,1,23,33,42,130,147,150,54,94,152,244,68,215,252,50,88,13,192,69,12,249,222,138,161,240,185,4,6,10,85,176,182,180,236,75,222,217,26,100,76,247,80,37,161,141,138,4,52,168,112,1,66,60,114,53,69,28,110,18,27,60,204,132,136,22,5,93,66,250,211,173,147,58,69,13,40,227,56,94,233,45,143,203,104,89,85,181,36,253,17,170,11,132,125,109,32,91,186,226,226,63,244,102,96,94,115,150,51,194,78,17,194,19,89,69,99,202,244,28,147,111,126,236,73,213,8,227,51,81,100,112,183,190,32,152,211,39,13,85,130,197,141,188,17,114,213,147,75,114,8,202,58,102,157,187,219,14,128,204,220,188,14,137,136,225,37,77,71,181,230,179,175,70,22,213,72,34,175,64,167,192,111,29,119,83,179,180,238,41,164,63,157,90,77,198,116,21,78,126,230,251,60,11,55,214,235,144,56,188,245,249,201,18,26,194,51,15,92,225,41,203,238,52,241,128,239,208,120,76,125,168,136,116,13,250,2,226,153,135,170,246,124,72,228,82,210,33,145,190,235,129,138,105,51,225,69,104,54,236,42,241,43,151,2,103,172,234,81,213,242,68,50,95,239,199,28,146,160,218,101,232,105,226,226,55,57,230,224,108,103,149,26,90,7,30,180,61,204,210,152,149,196,174,226,128,77,35,251,47,185,97,149,24,92,17,64,142,93,32,45,60,131,18,56,219,82,66,73,193,67,232,211,78,156,79,41,199,136,60,14,177,14,95,153,174,215,188,150,221,102,148,3,112,223,207,145,106,242,223,146,108,217,119,32,71,253,233,253,169,163,185,96,41,0,159,254,241,48,133,40,229,206,123,164,174,29,13,110,106,5,17,0,98,3,127,128,126,167,136,10,104,20,244,33,22,46,96,95,80,93,184,75,0,37,251,219,230,255,81,37,33,73,157,136,94,149,36,72,204,145,60,226,183,172,58,113,2,189,47,102,144,77,102,105,50,240,189,145,88,139,60,183,41,15,110,38,49,134,167,230,233,128,130,3,64,248,92,191,217,191,14,44,174,128,67,63,12,114,158,32,38,252,90,190,18,202,17,18,218,50,223,11,185,232,249,100,232,81,198,58,11,214,184,155,168,102,162,162,49,109,196,126,203,133,174,226,126,187,10,0,19,121,209,225,81,124,157,251,138,81,252,119,87,20,231,206,18,163,165,17,142,201,106,95,164,51,126,244,53,13,151,64,2,171,253,79,220,220,225,7,15,245,228,52,249,167,242,245,116,50,126,142,46,174,127,112,70,215,207,8,229,205,31,2,50,245,108,152,77,174,214,38,211,7,209,103,209,68,222,94,207,172,45,122,63,157,29,160,38,191,184,188,237,122,238,97,43,144,137,214,110,55,116,250,184,13,8,217,81,249,138,229,21,244,222,199,14,163,227,123,117,118,237,74,210,229,0,221,133,84,195,222,113,227,78,3,27,253,65,72,15,160,104,208,13,119,154,174,89,103,80,132,28,134,75,139,22,64,251,16,5,134,205,117,190,77,199,77,241,102,160,61,135,166,56,232,19,46,182,21,26,163,72,119,10,251,156,98,131,161,246,40,41,152,95,52,255,161,145,175,61,152,96,246,206,99,210,214,238,122,158,70,147,141,80,120,107,246,208,96,184,150,161,122,111,61,68,126,107,121,140,69,47,153,125,16,162,193,209,170,204,215,71,23,185,199,226,180,225,3,247,61,207,235,74,232,213,73,184,165,226,11,54,103,104,21,252,118,98,148,41,5,106,123,116,141,161,123,95,4,181,134,243,75,134,223,161,177,244,212,106,155,2,216,125,66,65,52,104,67,57,230,179,177,42,97,244,19,69,129,162,157,21,233,192,93,79,188,251,157,180,177,83,135,43,72,40,182,128,206,152,228,38,184,34,9,183,228,182,151,233,195,76,197,2,52,225,179,224,170,104,211,234,37,100,66,63,252,103,145,9,249,228,231,88,194,88,213,108,125,39,250,117,27,171,219,71,95,115,83,153,232,238,159,72,10,57,5,190,63,102,237,46,186,36,231,176,86,118,241,60,100,93,193,91,12,8,151,89,102,89,185,89,151,222,99,40,6,173,10,246,184,200,29,41,136,179,223,54,114,113,167,254,46,87,13,139,195,39,119,213,195,141,185,107,143,191,138,142,42,67,175,14,228,0,242,183,253,169,64,12,187,192,98,162,221,68,130,47,128,60,95,107,232,180,57,5,170,230,163,143,218,223,189,150,136,86,138,243,241,121,13,7,179,40,222,239,139,181,176,174,106,92,11,224,145,196,57,251,202,137,84,212,179,165,231,15,106,159,220,171,56,248,153,34,88,212,166,90,201,4,200,255,50,142,250,233,135,184,161,122,6,120,10,129,54,214,21,160,1,67,225,187,177,83,179,3,182,141,118,223,175,68,14,138,73,87,14,150,246,240,54,58,137,241,9,153,66,8,241,131,167,182,246,174,237,31,82,103,214,41,28,32,59,118,175,64,14,95,138,151,133,254,15,252,48,36,167,223,140,87,22,231,174,96,171,206,134,158,232,208,73,26,177,206,77,116,36,131,224,221,202,130,98,4,242,73,234,208,255,105,113,200,231,250,166,170,158,94,45,71,167,74,97,142,213,248,251,187,94,130,127,106,196,106,86,124,21,224,41,99,84,153,26,18,213,52,95,205,4,186,241,112,160,50,189,209,172,122,198,252,80,71,64,125,47,75,45,46,20,74,3,188,2,145,46,241,236,130,15,94,13,139,185,59,32,241,72,87,249,128,23,57,203,168,126,166,45,146,217,230,227,225,22,221,127,197,110,14,55,38,215,146,253,186,124,64,24,73,184,108,126,206,181,48,104,219,159,50,107,122,110,37,154,63,78,147,211,99,41,16,10,77,45,110,182,100,9,229,197,153,20,86,179,143,246,255,23,152,63,26,167,153,9,193,157,8,166,151,63,214,118,255,21,74,158,228,38,92,188,151,240,151,12,235,185,107,244,222,74,16,59,136,9,146,233,161,155,245,27,113,47,164,104,142,172,217,152,240,57,126,7,179,96,236,72,150,91,88,245,134,195,120,13,250,210,141,128,7,215,150,234,231,247,181,49,93,60,172,243,29,24,86,97,17,75,47,1,111,142,146,34,68,62,135,191,165,193,9,118,6,52,54,162,137,104,210,113,170,209,17,222,21,222,168,23,223,173,98,150,248,94,52,43,10,225,203,214,38,171,158,38,173,213,107,230,195,206,78,73,123,43,109,35,183,154,179,247,82,203,152,139,174,119,205,195,93,138,233,52,167,185,204,207,249,255,151,81,91,150,250,200,112,127,189,2,60,80,50,59,114,79,89,215,114,199,197,90,208,75,55,17,169,244,50,140,220,70,53,127,144},
  {1,131,52,252,35,252,41,208,80,210,15,52,78,191,106,235,91,105,247,208,150,130,33,241,140,219,103,47,201,160,16,201,151,200,221,228,227,31,242,100,8,148,59,20,92,212,41,184,230,176,137,128,230,17,204,255,67,147,255,78,197,55,114,2,96,117,29,145,101,193,19,176,149,59,145,39,203,47,155,142,43,191,71,34,133,70,103,11,81,170,239,227,238,44,58,42,119,140,135,88,134,201,228,116,95,230,13,213,112,136,23,170,208,120,125,141,151,214,197,228,50,10,105,166,105,42,250,89,103,140,25,143,198,199,108,127,152,91,32,131,58,128,228,219,181,102,6,29,127,244,100,75,140,86,182,235,90,243,185,156,122,199,137,75,213,178,120,180,205,214,148,181,70,198,196,147,208,170,142,91,38,40,91,244,105,84,160,80,19,130,194,9,145,39,138,88,183,188,49,184,17,172,47,248,216,245,236,156,172,28,125,64,192,244,170,132,47,239,168,203,180,119,67,173,218,38,155,161,205,124,88,32,2,251,68,107,6,48,35,8,89,171,145,8,151,62,127,217,64,110,111,242,225,152,71,100,199,22,88,125,112,183,59,198,252,95,165,169,229,40,191,12,55,22,176,129,102,175,75,161,76,85,195,228,140,61,13,232,90,204,47,117,40,82,228,48,78,103,28,90,242,30,231,92,38,75,79,116,74,234,2,67,150,235,42,197,88,218,25,64,106,168,34,127,36,84,232,129,7,32,106,178,107,72,52,232,188,16,136,69,229,90,187,41,80,180,31,108,3,252,179,140,18,192,254,27,193,61,96,236,175,66,245,32,243,21,247,64,226,119,177,106,247,82,122,20,173,218,11,212,110,124,3,83,176,73,111,244,44,127,64,74,216,7,103,51,247,55,203,215,16,252,73,80,239,247,114,44,37,191,90,184,88,99,82,156,160,140,7,224,206,247,180,245,90,209,234,253,214,250,9,27,32,145,199,79,178,216,146,28,173,171,5,216,137,105,177,66,63,145,136,20,80,125,194,61,49,226,140,38,68,34,224,109,34,43,126,75,198,206,81,224,226,14,90,114,15,104,196,91,201,164,223,88,39,246,1,38,113,31,38,7,158,76,41,51,175,178,177,29,87,214,76,52,201,120,57,142,86,31,29,183,58,86,41,43,192,71,225,31,185,121,17,35,124,232,243,58,101,18,186,64,102,255,162,209,0,230,43,225,75,201,189,178,55,115,238,124,171,141,182,162,38,56,154,34,24,87,155,255,66,255,84,139,246,210,150,187,54,138,45,202,90,77,8,15,251,106,2,220,209,99,83,237,117,3,89,1,15,80,25,132,169,9,131,56,113,44,125,239,119,109,103,135,118,31,66,209,196,98,85,246,193,187,9,195,120,33,79,120,211,204,13,227,90,126,214,190,186,8,142,169,97,30,190,117,26,150,172,245,252,91,35,50,83,144,145,3,125,104,5,50,192,83,41,252,176,44,151,111,233,173,108,72,133,147,114,63,90,91,121,222,173,108,12,231,76,52,105,1,194,136,30,209,30,39,153,69,0,22,148,103,31,201,144,236,174,138,89,118,149,211,101,184,35,79,240,17,62,238,63,218,142,99,36,25,123,229,147,217,197,199,209,150,136,23,169,30,134,252,227,146,102,228,226,42,212,3,90,113,165,51,209,154,188,189,56,154,12,225,239,225,235,245,188,33,9,92,108,72,24,187,240,183,169,105,170,122,168,40,182,222,0,96,216,23,108,240,88,97,61,38,235,164,38,235,255,221,130,181,129,165,138,64,122,115,122,254,241,211,114,226,124,1,112,182,71,237,34,241,174,103,87,233,93,31,33,107,18,241,46,153,35,126,132,143,196,9,136,197,110,32,159,163,77,86,163,153,207,171,138,196,114,64,191,130,108,64,205,253,144,97,122,249,105,58,155,69,216,197,224,247,38,156,14,219,149,34,31,149,233,190,232,32,65,131,69,100,233,171,184,4,88,15,27,238,170,51,51,201,94,21,247,153,225,86,235,15,233,234,151,68,196,96,252,91,75,29,212,35,15,78,23,137,3,74,142,139,230,8,138,218,115,166,213,118,72,214,219,192,236,4,73,220,238,97,17,122,86,45,152,169,115,116,71,34,7,149,56,0,161,206,100,162,19,157,129,202,138,180,117,62,247,24,48,197,192,63,101,109,76,8,127,162,47,142,235,111,66,255,164,195,113,129,242,224,189,38,82,64,124,34,212,199,237,21,160,231,68,244,251,24,192,244,170,165,254,35,244,141,228,172,68,86,183,48,2,182,211,154,43,26,121,105,178,67,164,114,219,179,235,131,218,116,34,125,248,46,167,158,113,238,34,99,116,97,107,184,220,248,112,108,213,223,96,216,1,176,229,52,57,208,57,203,47,139,131,176,23,155,250,102,145,129,242,178,38,155,126,105,248,105,94,212,139,111,180,238,31,241,142,143,69,19,17,232,113,2,204,44,85,124,248,12,108,10,226,74,231,75,14,207,127,170,49,54,16,191,187,214,139,164,102,229,91,29,174,28,243,245,96,198,51,117,190,80,64,229,96,111,244,121,214,26,209,143,39,65,232,0,54,207,89,34,14,250,73,23,61,236,36,60,33,114,183,134,91,68,143,85,134,227,93,57,172,10,216,168,139,60,119,172,109,231,26,240,7,36,1,169,29,115,187,206,72,74,36,112,119,101,82,225,131,54,29,35,116,51,119,69,108,129,113,30,56,39,65,9,167,55,62,203,168,224,14,51,203,178,76,92,70,10,223,57,192,83,130,116,191,62,27,1,60,194,95,46,114,190,94,165,140,130,39,162,169,56,88,47,239,139,169,238,213,165,100,21,73,244,138,50,93,60,208,197,92,161,238,191,110,142,97,5,232,253,124,133,17,75,230,233,6,228,34,195,242,140,95,133,132,70,16,237,145,19,188,180,121,73,186,58,23,22,237,203,224,183,13,34,35,111,186,199,218,175,71,248,95,242,55,187,221,255,226,222,145,108,124,200,90,101,33,143,218,230,10,108,67,142,84,52,213,160,186,213,32,93,85,202,242,85,82,73,26,129,18,57,19,122,233,106,94,156,255,91,41,216,145,82,246,133,102,70,163,168,45,221,165,17,173,126,172,242,65,95,92,224,164,95,57,13,143,241,196,168,207,68,212,215,206,147,246,247,243,48,240,111,244,57,247,134,95,51,77,239,77,112,154,167,19,239,130,34,16,122,234,194,67,45,104,85,250,182,159,159,253,34,229,188,204,120,119,227,246,98,107,109,44,58,35,170,68,228,135,127,175,170,105,75,212,9,235,48,45,7,61,211,113,112,107,49,192,177,187,0,198,140,172,90,23,34,91,3,118,68,185,149,152,139,185,58,122,119,55,10,188,38,112,0,188,66,87,146,237,172,91,34,155,204,14,26,93,79,168,10,54,185,192,215,73,65,150,253,209,47,4,27,125,45,202,123,119,72,137,11,140,130,210,144,0,6,228,49,67,120,24,74,255,163,108,250,131,243,150,63,68,113,141,150,77,216,247,203,29,24,169,148,212,66,232,153,206,23,37,12,211,107,191,43,182,90,241,42,83,175,233,3,204,196,105,162,194,215,159,206,100,227,31,200,230,85,180,108,135,223,96,217,250,235,78,215,67,243,201,28,152,117,243,144,53,74,7,122,182,150,253,19,5,218,85,254,33,196,42,145,148,50,102,45,110,211,8,163,224,201,219,15,233,62,196,183,237,222,249,20,11,170,242,212,196,204,74,166,110,102,86,75,115,82,15,45,103,42,210,157,198,26,243,164,167,217,64,216,52,214,108,130,157,220,176,91,73,129,119,90,75,42,33,145,153,119,74,45,212,232,180,65,12,31,43,203,0,170,30,211,124,92,210,136,18,191,126,152,238,6,53,152,109,36,11,135,129,219,60,117,180,236,181,168,216,30,251,51,225,251,125,97,187,239,0,2,243,253,78,28,62,191,80,107,115,21,144,186,130,179,111,165,65,168,100,129,62,178,121,105,131,176,223,136,95,63,118,107,122,52,252,164,248,177,231,160,60,237,68,65,9,72,133,50,60,61,252,218,129,164,35,141,32,33,135,127,139,44,165,86,6,123,158,249,196,235,55,183,96,20,26,53,223,97,65,247,111,110,182,152,225,159,72,7,112,185,88,175,79,115,66,5,221,23,190,180,27,24,245,97,131,202,81,200,37,102,117,192,120,101,226,179,112,180,107,44,105,23,1,153,117,121,87,246,52,64,253,203,58,255,127,78,183,170,116,225,67,81,79,154,206,220,242,238,151,164,25,14,114,15,79,88,24,216,238,160,152,132,99,169,66,80,145,121,62,255,149,102,152,213,84,150,53,205,179,215,83,133,36,242,12,115,244,164,153,210,57,25,157,91,140,51,63,184,124,139,28,234,238,66,181,61,192,97,146,153,90,53,100,233,94,239,174,91,168,198,103,38,74,41,9,153,103,218,242,77,34,254,202,107,4,248,51,105,65,178,146,63,127,204,180,156,102,20,232,127,246,89,86,255,211,33,158,155,240,204,56,57,233,101,222,10},
  {80,151,32,37,178,194,160,77,85,168,121,5,127,16,85,56,72,167,42,195,193,109,178,98,144,251,224,109,127,52,127,66,175,153,210,41,66,113,24,149,96,50,137,121,197,140,193,150,76,187,54,164,207,70,17,64,53,112,232,193,153,177,101,27,81,73,151,16,150,76,66,240,98,59,130,119,250,89,203,139,144,23,162,203,137,26,181,119,77,13,210,65,45,41,213,9,73,217,224,212,30,124,157,120,111,244,116,175,94,241,27,103,196,10,178,92,179,126,252,227,87,194,196,112,251,13,121,225,135,47,104,115,18,192,11,22,10,255,167,93,44,225,131,179,65,124,231,132,220,26,91,144,66,243,233,78,196,0,196,40,118,198,227,201,204,148,55,72,71,245,182,5,204,16,41,114,79,1,2,179,92,235,168,84,222,196,16,250,217,184,23,119,91,225,102,238,243,100,243,88,120,232,36,137,87,90,173,94,193,3,138,46,16,50,97,152,217,242,107,126,164,69,153,83,0,30,177,207,88,167,141,61,154,243,7,238,226,165,45,45,62,163,239,255,35,216,28,14,44,1,165,121,92,34,196,75,201,199,114,70,71,170,194,156,77,247,19,247,152,87,16,143,29,156,28,1,159,234,217,224,97,30,97,205,149,19,144,85,146,100,152,182,111,71,126,253,235,212,185,19,155,67,104,252,117,232,247,120,10,118,241,83,62,98,203,35,38,245,168,20,0,75,42,19,247,163,9,72,159,156,202,240,174,65,33,105,49,81,218,115,115,122,42,37,220,252,98,46,125,83,231,144,13,25,134,170,62,109,186,128,160,132,50,174,1,109,104,220,27,74,162,217,67,98,184,145,246,185,84,165,6,254,186,134,183,145,147,87,53,88,225,232,10,47,19,126,62,202,235,137,80,88,167,5,215,41,186,47,23,248,244,58,188,55,181,95,22,51,105,152,219,41,69,50,253,253,225,69,127,204,181,114,105,15,98,33,149,155,39,25,64,153,0,171,75,148,208,148,181,218,170,233,232,115,71,182,221,221,247,59,223,220,63,2,12,226,27,132,207,209,131,54,142,181,213,251,108,142,231,83,221,172,71,75,75,187,109,30,101,237,5,132,227,222,171,78,132,44,225,91,237,36,255,90,205,60,48,8,48,91,231,209,209,16,192,248,230,186,57,202,8,105,171,191,133,190,185,209,166,44,59,184,41,207,48,94,228,144,165,142,173,0,30,247,224,39,232,146,208,130,145,26,140,75,88,178,113,215,48,63,100,201,87,241,60,246,204,25,15,255,123,125,167,201,230,128,89,78,213,181,59,85,85,60,246,23,0,96,201,162,120,215,175,217,243,29,4,150,86,47,206,243,16,196,181,225,43,121,72,2,140,218,189,50,97,88,12,227,96,117,209,102,174,108,28,39,157,53,91,238,249,154,166,22,220,100,54,218,162,235,14,176,83,242,162,202,155,200,64,30,86,77,65,58,159,163,47,155,152,142,183,67,232,55,22,248,21,102,214,241,170,238,251,173,225,171,107,239,12,231,74,113,106,111,218,245,156,8,144,134,231,235,156,89,203,91,22,121,255,23,196,135,119,132,190,99,51,124,139,112,191,211,51,211,36,223,74,186,141,55,211,20,118,11,32,249,167,76,46,174,206,97,69,202,5,98,165,68,173,20,226,119,118,29,48,139,33,33,226,221,179,203,214,57,103,214,251,210,69,195,187,244,227,123,73,209,108,217,116,130,183,65,122,106,4,105,112,120,220,207,124,234,4,188,252,233,67,232,107,224,168,145,149,213,85,42,128,112,160,190,133,65,209,119,47,243,197,150,128,129,51,76,222,193,113,54,161,239,207,81,130,255,64,205,46,203,56,97,178,198,112,242,66,159,113,72,53,122,150,177,252,163,194,252,39,84,201,75,108,204,198,230,67,59,189,139,6,119,209,171,188,153,89,112,150,35,69,163,118,58,17,233,242,13,9,16,223,213,66,21,36,50,200,243,231,180,233,27,255,244,35,160,209,108,124,146,125,165,254,168,23,236,149,227,230,121,98,50,87,109,201,130,205,183,74,250,189,107,225,245,19,233,209,178,231,78,3,120,255,249,17,245,48,149,88,6,153,133,129,112,156,155,193,36,48,90,31,2,75,49,5,185,41,63,192,4,227,39,95,186,193,74,5,184,160,87,250,159,200,173,166,254,143,221,66,194,201,186,17,28,208,97,246,17,25,197,210,216,174,148,45,169,106,207,244,197,214,224,82,66,26,216,26,27,65,68,128,42,108,138,75,46,144,162,244,240,95,78,251,23,111,119,175,10,237,51,137,65,166,184,154,189,45,243,192,126,114,162,80,245,213,195,150,23,219,35,153,175,66,236,41,230,0,191,48,79,160,131,114,94,160,191,198,98,45,173,249,152,78,67,131,148,129,102,217,54,5,20,28,0,20,147,83,217,134,96,132,181,102,154,85,61,204,222,99,127,97,182,109,81,34,253,115,124,202,123,241,157,28,176,121,81,62,246,89,251,188,118,25,90,242,143,171,190,203,146,38,96,32,149,157,186,120,176,22,3,138,199,217,124,112,65,170,20,232,225,158,41,209,248,212,168,243,46,100,109,41,13,14,143,100,141,180,108,59,253,156,207,136,85,10,121,109,254,216,2,234,140,170,7,239,0,94,53,153,158,98,34,81,165,13,152,82,78,97,19,155,48,124,22,185,62,149,241,77,207,29,77,153,118,64,55,150,127,37,204,0,20,113,192,113,138,92,175,153,188,79,179,250,123,125,59,217,95,109,71,121,170,66,17,109,34,6,124,236,105,149,158,65,172,14,170,46,212,81,96,211,207,97,202,226,83,143,42,13,153,48,88,247,243,145,5,199,202,170,54,6,189,255,94,68,252,160,18,238,210,145,6,121,199,217,124,165,179,131,164,172,228,20,87,124,30,162,239,85,38,44,150,251,46,24,29,61,176,33,142,226,160,229,208,119,188,179,114,87,133,85,128,122,206,40,46,154,247,88,156,181,0,216,174,164,235,241,104,203,14,73,65,26,25,47,108,151,236,254,254,89,159,97,35,228,184,11,52,46,119,81,226,219,98,190,212,84,20,160,24,206,51,98,243,230,169,192,190,231,139,85,83,252,61,208,63,58,183,91,128,116,215,81,29,30,164,234,207,198,108,38,6,95,118,35,105,86,224,6,253,0,233,175,182,33,116,14,9,33,17,254,192,50,214,218,181,123,66,69,234,162,30,114,170,8,53,243,97,171,47,56,224,79,117,68,121,169,110,175,146,69,4,211,154,64,156,232,240,168,233,5,55,164,191,133,85,48,242,214,169,121,54,142,41,140,16,224,36,244,229,128,150,3,244,24,252,47,10,117,82,214,47,177,175,191,139,245,97,85,214,10,59,69,96,75,208,238,66,155,206,65,110,56,97,97,114,93,25,72,8,160,113,240,91,205,40,7,83,104,85,24,124,127,183,124,69,125,166,54,192,121,95,254,131,72,170,109,38,149,210,251,45,113,171,85,16,147,47,165,47,170,215,109,132,43,65,212,135,245,241,249,252,16,152,117,150,243,102,102,180,44,223,53,101,252,167,34,255,157,248,245,136,232,252,7,226,128,126,198,246,212,84,110,201,216,178,64,108,217,213,58,74,235,103,46,87,43,230,165,218,235,64,72,204,128,13,111,250,4,78,116,143,228,74,23,156,198,89,220,58,7,52,68,191,20,12,17,207,252,114,175,181,91,236,164,32,67,102,113,216,218,31,150,22,68,65,20,140,215,99,196,203,202,171,128,22,79,255,144,213,208,159,244,141,126,190,14,105,52,215,126,68,218,58,49,144,59,148,116,139,60,223,214,255,32,240,187,47,234,130,255,250,246,149,221,247,74,156,113,137,234,46,177,19,2,204,108,83,155,164,180,205,239,54,135,52,134,192,0,90,11,110,33,31,242,47,229,200,148,178,228,43,154,29,95,234,217,53,64,224,204,82,252,235,254,47,90,220,70,144,129,54,62,254,67,23,127,204,243,228,38,90,145,218,222,111,118,253,106,160,115,211,137,29,63,224,167,15,176,106,203,95,224,234,199,149,211,103,210,183,129,253,13,161,53,41,111,98,74,187,225,22,101,103,75,215,117,107,240,159,156,51,11,78,75,134,246,3,228,138,165,218,165,190,228,31,76,215,210,212,159,42,30,240,201,54,204,244,41,128,84,52,168,46,78,74,220,19,174,27,97,192,132,140,243,5,26,137,141,114,202,207,147,75,92,41,139,228,186,211,49,4,122,219,112,63,174,46,204,232,172,29,83,66,171,184,211,134,146,88,217,188,214,172,213,125,158,94,30,103,118,152,36,35,121,28,248,123,189,95,10,4,214,37,4,77,192,190,81,27,2,141,7,42,63,41,63,51,69,122,78,47,221,37,188,27,124,142,222,164,57,49,239,165,156,184,110,200,169,125,17,109,228,202,13,169,98,21,221,84,187,146,249,221,233,157,6,14,245,107,130,163,55,239,6,225,171,107,117,250,176,120,117,134,202,114,91,161,146,18,179,224,222,40,148,1,19,80,65,13},
  {41,8,7,56,5,39,77,4,29,70,152,45,162,18,28,228,223,29,253,202,95,85,33,215,4,164,214,56,10,238,154,94,107,64,186,53,142,103,208,70,89,118,229,56,219,76,186,65,251,171,19,166,203,6,82,140,108,60,158,41,232,246,139,82,199,11,92,25,19,104,138,252,30,171,242,106,11,167,134,96,222,88,74,68,241,196,193,12,141,244,211,0,34,165,240,20,127,115,53,47,197,37,145,202,163,29,24,59,198,3,227,181,29,92,109,197,89,123,181,38,252,64,46,110,66,78,20,236,96,149,164,102,61,136,54,103,70,109,23,167,119,202,161,244,210,174,11,67,27,160,141,137,100,99,23,42,221,171,196,80,95,12,95,235,112,170,205,20,51,248,81,69,82,117,76,101,51,163,179,155,85,112,24,159,237,0,118,34,132,176,106,240,110,0,13,144,186,26,245,169,198,210,94,73,191,251,109,212,138,241,165,8,248,130,160,236,72,81,67,254,168,90,60,14,129,228,72,77,96,190,149,84,117,175,185,255,127,135,160,215,185,2,133,235,207,32,66,169,250,6,31,182,131,251,129,33,200,47,247,33,100,217,114,24,212,61,183,111,187,165,66,17,231,15,191,23,182,113,232,233,95,170,67,12,166,102,120,56,247,246,214,169,126,150,101,122,125,155,142,178,239,13,27,225,221,89,250,205,229,135,141,225,243,247,36,119,1,253,161,163,124,103,112,121,57,68,72,6,154,254,60,239,160,117,144,92,89,74,233,152,241,184,193,208,108,132,131,133,219,235,180,138,207,222,11,142,34,86,224,174,169,135,27,231,71,202,211,126,109,33,219,112,237,186,216,245,217,114,225,29,139,153,184,175,112,132,243,58,64,75,110,74,113,239,4,233,86,170,194,236,124,163,246,130,190,158,53,29,152,97,100,38,107,129,50,54,148,89,64,149,8,25,35,127,199,169,247,58,255,157,233,173,100,123,198,133,184,237,228,38,9,125,2,87,136,243,34,152,234,138,215,42,56,83,4,133,106,101,143,104,189,123,217,213,199,251,33,204,60,29,218,115,195,27,215,239,216,114,117,207,105,143,206,125,20,78,250,214,127,230,213,76,174,63,227,185,15,29,139,123,164,99,103,201,19,68,88,149,23,161,241,207,157,167,149,186,185,123,117,21,76,142,102,137,109,229,156,74,196,198,6,78,40,248,62,161,243,124,156,182,48,111,129,54,196,197,38,122,127,27,243,55,147,56,183,24,211,174,148,25,26,172,81,177,5,65,120,224,35,107,215,83,121,170,190,32,77,245,19,1,245,121,44,0,234,6,92,232,246,70,142,83,187,48,173,172,67,220,112,252,122,238,146,194,130,34,10,168,50,232,160,146,35,79,222,132,20,254,41,27,133,247,246,143,173,62,50,85,234,78,64,244,214,108,104,26,103,197,86,50,157,120,30,32,157,99,93,42,29,72,39,182,181,99,191,227,143,97,175,65,27,118,65,101,224,240,212,181,151,240,24,36,163,252,179,234,196,39,99,141,139,117,43,10,60,41,105,179,59,54,81,112,25,15,211,222,13,205,144,5,9,48,107,35,172,140,174,236,80,212,27,220,188,31,191,24,71,3,118,164,207,80,160,212,43,46,135,125,191,171,165,44,104,187,67,181,83,147,166,5,59,40,203,23,189,16,64,18,41,45,214,129,119,102,174,189,203,7,209,155,199,78,7,96,177,5,134,11,206,143,15,55,220,26,73,20,253,246,147,36,248,209,209,224,107,132,153,152,226,125,206,235,124,184,78,170,105,24,235,129,118,230,133,50,55,74,217,77,69,85,247,56,67,35,31,231,162,152,92,245,121,155,138,239,34,146,136,172,184,171,59,212,192,11,177,42,220,74,198,40,29,194,250,78,103,251,48,76,92,229,8,224,18,70,123,75,254,138,25,18,81,51,98,64,60,47,115,230,118,88,88,160,131,41,3,37,33,235,81,224,209,147,203,89,15,30,45,216,73,37,89,91,198,169,2,118,145,171,91,81,48,184,16,70,18,218,222,213,14,26,104,134,198,16,176,21,214,198,190,188,65,134,233,219,12,68,46,164,129,124,100,185,132,44,27,218,247,238,243,50,107,12,14,81,150,242,59,105,193,69,4,73,101,228,183,154,48,243,186,67,233,26,223,185,89,8,39,173,32,18,188,168,87,186,174,168,38,112,241,43,145,215,190,158,204,54,37,13,105,204,196,171,104,148,211,15,167,59,248,167,209,84,52,12,221,190,129,96,220,60,129,192,53,168,247,155,49,20,93,130,158,219,107,58,59,86,119,29,173,208,55,100,34,71,196,254,254,214,110,222,230,168,203,183,46,5,52,46,184,214,122,198,86,75,179,147,110,142,229,226,15,22,86,251,154,20,137,52,4,106,248,161,23,149,65,105,244,189,243,252,202,156,191,9,39,116,229,126,153,31,201,109,172,1,64,133,61,29,14,39,138,16,186,229,64,165,120,242,204,196,193,49,123,97,237,141,238,116,32,54,225,52,97,31,36,84,85,120,101,203,78,236,172,125,153,137,171,24,170,95,52,76,246,230,104,62,16,20,81,74,124,71,200,209,29,12,94,20,165,160,226,162,171,31,181,250,1,192,11,60,26,228,80,111,164,173,64,229,30,193,157,227,78,189,234,220,255,2,3,251,159,118,183,74,49,7,56,103,213,150,244,18,107,237,169,246,213,95,70,61,136,217,111,163,56,171,21,120,37,247,211,3,170,158,103,42,225,20,250,13,255,48,182,63,2,6,152,189,56,4,114,162,25,48,95,138,176,197,100,124,104,75,184,38,214,168,179,241,21,31,147,111,115,81,159,149,143,9,250,165,33,123,47,146,152,204,27,233,223,192,34,216,127,113,14,100,87,179,156,191,154,8,161,236,79,25,149,156,153,77,136,203,47,203,235,114,40,124,81,44,190,118,155,251,159,73,88,61,85,177,41,96,235,73,97,213,87,172,17,50,126,115,226,145,128,244,115,12,48,232,85,62,224,248,61,29,26,125,52,244,171,109,39,146,21,110,77,176,161,254,67,121,221,30,176,230,236,183,13,10,234,190,56,240,255,147,248,238,86,75,137,21,155,51,1,91,118,50,176,209,228,132,79,124,138,231,100,156,194,125,139,213,179,49,99,118,156,43,21,216,245,168,226,40,74,165,240,195,213,60,20,19,6,115,52,20,156,217,86,155,145,64,64,209,43,90,138,58,227,193,28,208,237,208,67,94,127,207,169,237,11,206,210,80,147,216,187,190,122,165,32,163,111,213,156,254,199,241,6,62,250,223,194,20,214,165,69,218,161,107,67,119,44,135,154,79,101,176,116,198,135,48,147,138,190,182,227,129,47,207,239,248,87,183,122,118,117,151,206,115,250,40,43,50,126,22,13,245,79,7,154,150,167,40,85,246,141,61,34,23,51,86,178,36,68,20,58,108,84,154,91,14,184,143,252,43,244,78,182,101,21,171,146,231,214,142,207,81,158,170,149,72,131,176,138,246,0,146,74,215,180,85,98,106,117,46,66,226,160,129,205,206,138,223,64,225,180,219,238,178,234,112,129,183,12,113,51,172,180,242,44,211,60,159,96,200,133,152,24,250,69,174,42,245,215,255,94,248,152,193,199,184,164,176,228,141,229,60,66,111,206,45,105,138,216,31,237,44,101,157,155,250,158,59,74,253,69,13,137,196,162,112,206,29,57,203,49,98,78,19,218,206,99,117,172,7,105,245,31,88,230,17,83,220,73,178,212,108,191,181,149,252,171,170,47,114,19,191,84,227,91,70,187,3,70,84,60,144,204,119,247,7,96,227,83,38,242,76,91,69,84,6,145,11,173,167,111,202,48,83,19,24,76,39,152,14,216,60,189,112,25,79,31,193,96,5,52,82,69,53,32,41,30,109,207,68,150,82,171,113,182,233,109,185,228,166,241,103,218,99,1,86,192,142,21,13,58,177,87,103,76,120,143,44,177,52,232,35,115,38,42,51,141,51,180,49,83,88,22,106,8,245,189,168,112,180,225,10,187,78,59,83,61,193,38,163,33,215,69,120,30,159,36,207,19,226,177,89,190,52,114,52,39,229,17,100,175,157,80,25,52,160,235,120,165,98,33,233,138,107,5,42,104,69,58,136,240,53,210,203,200,246,235,227,251,161,54,119,74,80,167,192,68,247,147,112,84,182,107,227,90,119,45,175,113,200,204,225,107,46,33,178,41,18,125,38,16,177,116,134,63,22,92,186,78,60,99,195,247,251,214,251,47,166,158,47,90,41,53,67,169,234,72,93,46,24,165,56,250,69,210,248,73,38,178,70,164,82,234,47,244,81,126,244,42,200,122,244,93,119,57,240,53,232,13,48,218,62,239,140,120,171,89,34,225,196,45,253,83,106,246,253,124,234,240,170,227,149,221,102,187,199,28,224,131,247,169,17,174,215,188,239,220,49,120,233,149,174,72,215,37,53,153,32,242,56,175,219,245,10,105,3,178,100,246,208,206,191,181,207,23,233,68,122,20,57,5,35,178,221,228,105,68,147,216,19},
} ;

static const uint16_t precomputed_encode_1013xint16_x[precomputed_encode_1013xint16_NUM][crypto_encode_ITEMS] = {
  {18165,13604,57095,9472,29588,55129,24829,63178,19742,7542,49805,58602,52766,50083,2480,14309,49698,36495,44044,57196,23354,38731,18640,51423,44826,44398,41918,56506,1529,36513,17326,10474,35933,52585,32301,53274,7941,23940,26635,41824,40586,25865,29884,50650,39840,28234,42850,10127,5607,61949,30317,53014,40241,9856,1863,23653,43401,3945,37901,63224,35958,28397,17140,59367,31446,42142,1470,41699,55914,62741,47046,3320,54527,15198,59974,29564,2742,456,17219,57294,22989,38411,23662,48563,51651,199,25170,26796,3522,39862,52947,18419,41834,58349,65141,40306,26826,59679,8062,46271,18942,53473,11278,64536,17702,324,35659,36432,48249,28987,36006,46412,4015,46299,19282,42293,15072,28219,50090,44304,21601,10077,61434,26348,57490,32466,16482,62854,11887,21092,62170,44299,42764,62671,41913,41064,35640,3,60053,1092,50844,13876,31882,37703,18918,64592,8692,18143,56759,46846,31683,38189,65179,13687,39427,51466,60462,36500,44417,17935,33954,59018,28170,47662,24655,32734,10933,16119,9178,40170,33331,65492,1151,26644,40658,37817,61457,13808,56884,24170,45819,55910,13626,58397,12918,64919,11748,31134,20686,55225,65299,28130,42149,56627,41774,2657,15878,61844,25157,44063,33000,36902,23545,4689,20279,10300,26910,53520,49567,49452,37783,33142,37137,61678,44996,45115,39659,64742,32417,38393,43941,3832,1571,28339,4347,6608,49395,5107,17424,16589,18611,16288,17276,34701,13695,58497,59502,8797,52779,1286,47852,12051,14383,38378,27148,50641,6593,35640,50523,12101,1299,5302,44673,5230,39221,24636,9371,477,8471,33322,38547,24118,62616,55108,13052,3416,17856,63756,35550,61601,1209,2566,45141,46262,19436,55774,25626,63308,9552,36257,1162,43060,368,15426,13682,7237,4718,15387,33996,5768,23813,64066,44499,14995,3397,58152,24120,11753,52111,22888,46421,64804,43537,33803,28029,23328,58042,16354,26356,24160,38515,49715,4430,5058,17753,51811,7412,28563,60542,54601,58120,20787,28772,48823,38944,10195,21773,50562,48269,29201,37845,29259,51720,26170,48029,3803,52352,48348,35086,57736,19749,46407,46054,18095,54550,8776,16559,49319,7535,21367,46259,10734,16292,23197,50765,5492,32334,64486,2876,54839,37099,48184,63989,4809,49690,3891,57692,52009,13550,33009,53487,19576,43133,29832,64013,57858,34713,63146,18556,21220,8658,48785,33259,27018,57651,26693,60470,61738,38699,26370,60076,54609,17650,24370,51183,37404,55968,59493,57961,14306,58937,27872,38247,23066,7687,15796,53964,38296,44740,32994,9037,12283,25017,6293,4444,36416,8285,15405,4739,56120,16978,49481,59459,20179,20380,50985,15496,45326,24334,44697,48343,56726,37990,28675,53215,27281,57330,27794,30681,18208,59901,43517,47523,10592,40704,61950,34096,58664,31694,44708,3357,27246,4357,25088,32515,32384,34983,26634,62484,5665,24622,20575,47197,75,64293,59099,20991,8485,40265,24200,9365,52296,15505,47074,15020,625,12221,36966,26189,12905,48624,22673,15499,10679,28175,12582,42886,59878,33408,16387,23800,55743,3775,44588,17280,3135,40562,9760,23292,4798,4554,55826,57138,47371,63976,59492,50769,2874,47318,43163,41574,12706,50285,52094,44677,32482,2747,4864,53625,20961,40316,35579,64593,22391,59156,4814,42403,36369,27337,42079,32307,13812,38669,576,64939,56399,57820,3847,58613,63796,62119,29941,32306,11918,32686,18032,53207,58632,8141,12802,27893,19864,54958,54054,53511,53607,56900,53086,11692,16250,7581,9888,47295,60860,61050,11105,35216,28374,29751,47354,2061,20953,35577,5605,57076,3783,58275,30075,60790,53834,229,34269,50004,29150,20195,6915,16893,3912,26784,3536,39543,22958,20583,7300,19334,5771,64320,1296,52614,48757,51021,61773,41062,34621,14502,5096,46638,6677,18595,2679,40187,33634,63137,10536,24472,65332,37281,15791,24728,52982,53859,61142,40570,37702,20621,27512,53494,47200,41366,28538,17469,27518,35961,12101,32153,41488,53697,52394,18391,47383,58055,57780,63235,53053,19179,54760,47177,58021,13835,26727,64533,25206,10644,27141,29819,41357,24443,46340,62342,34379,41439,62641,27348,667,32216,16706,26676,14659,46054,10929,62561,17683,41601,5533,49385,20317,64444,46237,21425,11143,10312,32950,39118,9956,8888,46857,46820,59799,19651,709,57652,57523,26794,60115,25637,16194,26620,2449,58617,22759,22722,27861,10109,30202,43803,18395,29535,39251,61160,18591,14602,48645,26175,12013,9402,45287,30294,15601,23908,23489,2060,22935,22886,22969,56983,10339,44294,62986,51384,10525,45960,14047,29042,65191,22318,35597,10179,54647,36291,27577,49039,36490,17194,3759,228,47090,43517,3136,49339,41570,17629,12162,15488,27487,46312,1337,59050,36771,57306,38589,22152,62346,31217,1805,10419,61406,46475,44720,23658,57355,50321,64313,35274,54356,42419,4071,40810,43996,63544,8857,54360,23206,1225,65480,36402,59898,47239,31393,30726,33034,54838,40981,17153,48097,21425,947,36278,57206,17583,35342,22345,38414,61686,14902,61833,39177,2114,33777,46759,44790,8173,26450,10710,8220,30267,16559,24334,38794,65157,64527,9264,57255,22412,59158,24750,52907,40582,53480,6729,52913,29773,33572,56800,33482,1122,18930,53482,27135,51313,64231,43686,24222,18221,19111,36449,63701,48123,33374,27263,27332,31830,57365,25385,39252,4634,13525,52575,47620,28913,12960,53693,31404,64710,18256,32064,19247,11821,18964,48131,37122,61742,33516,24079,35597,15289,61728,22344,33017,14615,43211,42622,37421,59097,57827,56598,50559,3694,9783,37591,47869,16508,18712,27832,52862,12469,56168,12959,31339,9582,16282,37710,25555,4137,19722,28205,25782,58633,39365,22036,36787,65526,38935,6719,39335,49417,2205,38822,54847,65398,18965,58526,23590,38844,38896,60172,27577,57076,4170,34875,37385,41449,62875,28955,42031,36456,55724,61592,32313,45831,60512,38472,22619,34549,30915,64013,36306,1920,38615,59370,46583,23857,44092,7667,22040,4449,12107,28417,37518,17442,34622,42431,2497,1654,13876,35234,53864,43633,4561,5598,43230,57111,25261,63638,13406,2603,52193,9942,40619,44326,27605,50150,20174,31561,27947,46883,45978,21239,39115,44683,52599,24003,59786,42804,52409,63951,38911,23377,64150,28872,48511,15362,12880,29243,22863,29399,50631,53338,14155,43281,13044,56460,13638,36991},
  {33537,64564,64547,53289,53840,13327,48974,60266,26971,53495,33430,61729,56204,12135,41161,51472,51351,58589,8163,25842,37896,5179,54364,47145,45286,32905,4582,65484,37699,20223,14277,626,30048,37149,49509,45075,15253,10129,12235,36507,48939,8775,18053,2919,43601,58351,11502,10810,35959,22663,51590,29924,58975,54541,34928,43543,30928,36221,54935,58565,2610,42601,10857,23034,35943,36633,51142,32620,23448,33568,32826,56292,26293,7430,62591,19300,22156,60342,62298,40121,51066,19337,45781,46200,54989,46484,50758,37828,43728,23438,10278,62555,21609,20640,33299,2498,10129,22666,48311,47153,44049,63535,62936,40172,7340,16509,62656,33962,61231,52136,30644,44355,9946,41371,31949,8280,64258,27460,12294,2083,43865,2193,16023,55679,28224,62063,39137,25671,5831,32088,46960,50747,24572,43429,10469,3263,5687,33200,44902,41291,21836,58563,15756,59405,52314,29999,21032,12516,26446,23068,7922,23783,19238,29775,59978,17154,60310,50474,55896,16409,43114,32546,21540,33256,8199,45674,18539,59444,4284,17800,23269,10683,46160,27679,64515,36019,49170,7166,15809,60512,17071,8437,5619,16631,30690,27313,21239,5242,55981,54283,31854,21251,18864,62575,32556,19008,2008,13159,14327,55243,64528,20553,63471,11378,48933,47194,25432,40018,36000,57351,63438,62900,53594,65002,64214,6921,37152,20423,55474,7314,43949,55301,27017,17073,37183,5256,32080,15810,57905,9868,8772,28128,11042,19326,52934,57425,3810,29274,26639,23492,42185,22751,63015,9729,8049,1830,19614,13097,45743,7601,54871,13388,30921,36409,8022,46877,22074,11049,18368,8161,31161,8977,59516,15091,4709,16570,65382,53666,58880,57643,51531,45757,29495,31982,36267,41654,14374,8858,22296,65435,65346,35668,54006,48022,35382,51757,19802,3848,27387,56322,25553,60755,885,345,20495,33817,2473,14467,11377,61309,28023,34663,8054,53570,25284,63061,48065,49929,8568,30799,52435,58125,32346,48854,2234,43406,7777,30142,38426,62892,23548,12835,36947,913,26749,12805,21440,64553,11440,28567,44521,18540,37765,16242,23386,56953,27821,59148,13388,361,35010,53534,10014,17817,5632,26516,51487,60560,35502,30297,54165,47205,20259,4592,60990,55871,25486,6436,58747,55699,51141,38609,6024,7849,64646,37603,58470,10978,980,29018,13221,39633,48572,39480,57612,57839,62955,8636,23561,18540,47896,47088,27049,31402,10408,57014,24576,6104,61548,24920,9789,42219,60198,56831,46466,42369,16522,29562,65146,54257,57970,380,46704,60743,61730,26542,59735,8029,27425,61714,39214,32291,36740,2500,50568,8302,41887,22093,39331,43983,50314,16498,33471,16492,64973,24976,63866,14953,17819,50648,63456,39974,56078,8853,38175,48873,8424,33601,25669,44009,1208,3928,60955,13226,51507,5470,39415,22241,4075,60137,17559,24772,23548,7499,9172,19983,35095,18947,35726,2278,55946,42611,30421,54856,49371,1260,56393,25070,31249,11606,43416,29811,8775,38151,56,52897,41572,40211,51841,46218,15989,6391,50480,16320,28005,2124,41599,36399,28651,65346,50084,33137,57586,9917,16466,8828,51156,5613,59296,62532,6395,62656,42410,9214,36340,44260,22084,12471,46594,39635,6699,27001,17330,29348,46043,33771,29914,32034,12024,40615,61041,25378,24948,47211,63708,27760,57301,55392,45057,13541,53305,52025,35631,45187,39703,26362,33169,45810,39718,27006,27128,54366,28555,61108,61727,36750,4933,59409,625,11468,31829,3320,2668,19170,19431,53006,43647,13873,48912,54971,42123,58726,7515,7342,62963,50784,30003,20670,58688,28512,31220,6870,36817,16679,232,53046,8793,64014,5961,60477,15396,29217,34487,17499,21903,58246,14685,2732,43224,15499,44151,59245,61466,9223,43265,29469,52923,19016,28708,25975,57682,13955,8989,13172,17783,33132,7793,10040,2369,14247,52030,57512,13070,45771,23628,2630,14815,21440,29826,16063,283,49724,11871,48754,42334,33420,41511,14505,12120,35823,61097,42453,5476,62537,12938,15453,50640,41308,49134,36462,1377,65000,34172,19217,59878,58374,49954,36082,34143,18052,60688,5009,46268,18809,15034,5655,52205,47072,8717,28451,51130,45018,63559,62047,47927,65501,57058,27793,51324,25946,36641,59098,27658,36419,13396,41173,54714,23840,51797,22002,18770,33050,14610,31251,27369,40030,23551,55337,21137,34294,18022,43171,56621,4517,32429,62124,24385,57436,24484,3385,61839,43204,17615,55252,37838,63478,12531,28656,14836,34551,13151,61261,28749,42906,61203,8834,31248,49898,11587,21864,46842,40863,8957,48357,30924,58231,25334,28011,14892,43555,58436,32647,43695,19305,2516,12523,1837,54077,28785,12651,45504,187,36038,23212,8727,859,17526,38329,35736,15033,30586,2615,9916,112,17084,37463,44269,8795,52379,6670,20317,2728,47414,55232,16713,64918,12241,6916,11645,31690,18551,2953,33420,37074,1536,12772,30787,18968,41983,64108,62339,16278,28996,38541,55373,52215,6173,38057,17108,39400,6094,3109,27603,11199,23222,10993,44883,1001,50380,41577,55234,52895,58212,51231,21990,27828,57223,55648,60410,55118,62275,7369,30104,37107,18997,31239,38582,5117,55813,65109,50209,37162,12948,11622,54126,41736,51680,4059,16105,47044,57069,5369,43531,54514,52420,42570,26222,19286,21107,11535,10855,40402,6854,42227,55719,55360,54836,33388,56477,23472,33097,23159,10827,37153,30617,11594,59604,16820,7948,52011,43520,54046,23676,35026,48914,39038,1774,38965,9325,34571,56193,30012,60596,43189,7896,13307,64481,24957,61371,512,65011,7246,48958,27472,5491,47760,45954,42351,43073,33124,45630,27001,45187,35039,16223,27510,13434,42236,45560,41191,60732,16708,18441,12933,15676,56060,42113,36131,8480,32647,11403,22181,31494,63902,60356,46903,5216,13594,25055,63297,28271,39094,40929,1864,47472,44888,29519,1346,6109,46270,6171,25077,51843,51281,26149,49269,25976,46050,46192,11371,5993,39169,31093,63063,16436,52221,65338,20095,43703,57716,20803,39503,56526,61170,42135,3609,3954,22607,55320,41198,33944,43363,20546,31121,65342,26261,54680,38484,52533,55219,34131,61988,29452,42228,53913,6457,23453,13196,47167,35708,59932,17134,15797,25024,39314,13658,59748,61278,23470,50856,9831,10570,39177,55911,19954,65058,27594,63492,26931,45633,16274,52351,40116,5222,32744,23030,65366,8659,39838,52464,14648,26089,2782},
  {38736,9504,49842,19872,43093,1401,4223,14421,42824,49962,28097,25266,64400,28128,13439,17023,39343,10706,28994,38168,12896,31113,36037,38593,47948,42038,18127,16401,28725,49640,45465,7013,18769,4247,19606,61506,15202,30594,23034,35787,6032,52130,6793,30645,3405,16850,10541,2517,55625,54496,31774,30877,62575,44916,61790,26395,2756,23730,32435,58364,49751,28868,3579,57721,12167,29544,49170,5643,65290,23975,57644,45955,31809,34023,6876,36955,62274,20201,196,10436,50806,51683,38092,18487,62791,1462,4300,29225,335,45826,60252,21672,50398,64016,47321,30487,57691,61030,25843,22771,59512,35108,23127,24237,961,11914,12816,39009,62169,32363,17828,21401,7680,53169,42840,15757,62362,60935,42466,11565,41790,65519,55331,3612,300,31141,8796,19396,51145,18034,43591,40130,63309,63251,22424,36624,39965,284,60063,57561,7777,52577,5013,21904,25746,46744,18287,64894,54507,5049,17307,64616,59509,30967,30218,21489,25150,9163,62758,5288,19200,4906,41975,18441,40095,61642,16814,26913,20785,29658,31347,9514,64732,11874,21373,37095,6413,43654,27966,32954,33952,44594,27905,56424,18971,55714,25155,37304,47606,42324,65030,34490,37303,22419,22581,59617,12042,32275,51774,35307,22608,1447,10711,12218,63511,15092,14268,24501,13078,39017,10715,12869,65021,17889,52351,29365,3945,8546,39829,6439,39232,43776,37963,38096,55989,59818,29672,46663,56797,15351,56543,575,57868,33819,53711,13955,46478,64469,36460,21479,44253,19271,47947,7789,60773,33797,57059,20139,11396,23521,9453,23295,15565,2096,23344,53735,4305,63680,47846,51769,26888,49067,48773,53689,11430,47163,53033,24112,37092,36517,173,63262,10208,37608,33488,6801,19340,45656,55153,16176,51556,61783,63036,6604,65295,32123,51623,32998,20057,46549,21819,15445,6134,24576,41673,55160,55727,7667,38404,12118,62414,50192,57781,31019,584,55948,12989,22625,58124,30048,26321,27822,10012,13725,61019,39673,5798,25820,55862,60322,45070,62035,51874,51355,7744,19798,14913,41887,39727,36504,17335,14312,63510,26133,61910,61098,44539,44001,61291,59148,29002,28522,62938,2204,34448,60391,22940,23499,30998,6143,34756,33911,25534,31795,28811,54207,54067,57124,47690,14221,5331,2934,63776,19623,44590,25038,51781,25093,17573,5293,30690,7542,35632,8481,56802,52147,14806,54887,54011,49989,62651,31715,53577,55660,33396,16823,27258,26884,30832,53212,60028,48132,59900,59459,57451,37288,54677,10837,28800,48800,16773,30673,62255,38597,33152,19507,49630,13937,61345,20943,65410,52544,52014,24888,50866,62064,40770,18545,31285,45462,41980,64706,21543,19401,52332,59078,15171,35773,30470,43985,39356,28761,9110,41797,14966,59665,3570,4105,54751,5442,12836,62408,46311,7145,62719,40995,27857,37500,42365,43262,60439,58261,31206,12898,27991,33481,47053,64074,27581,62945,59667,45777,20199,30723,63999,62737,38192,1624,34201,28801,39836,9409,23088,543,12619,47365,16169,1216,10211,47711,19137,47109,22432,40954,44488,65190,56719,49730,47817,7185,25040,4598,50457,55506,38062,43309,53098,50676,57558,16978,55322,6938,17473,10880,35436,11851,41616,61684,20063,6139,30575,2735,13293,16777,47270,48538,62253,32448,41586,62800,50133,6038,9179,44953,60482,58921,48896,20272,33696,24178,49056,25286,44333,39161,17230,38019,26241,14041,5125,28,37652,55635,24710,46468,39526,15701,57036,32611,46689,20845,64802,31859,31690,40433,45084,20857,63038,64345,30396,23065,36850,48811,37579,24614,38176,47773,45176,790,51082,31961,16752,5290,57832,10654,63697,43220,12019,28004,3369,36622,36196,27828,64827,53148,21896,30986,65133,728,36074,1962,239,13662,40601,8802,42321,38925,20050,4961,12443,5756,16057,61845,53069,19741,30361,14144,32662,52261,5120,49265,35441,44892,48281,45903,31738,15229,24537,18285,43641,4418,8813,31750,27116,40597,44097,43534,54318,24657,53203,51809,21474,10895,39181,22576,62455,1425,51911,13994,48390,24319,64580,4768,53998,1681,51065,31961,45989,42115,58540,22292,7804,61346,9813,38444,12027,7448,45117,36385,41186,53477,48247,29363,34135,32853,52858,11816,63386,40024,181,44760,60324,26865,3787,16713,6426,27695,60567,65278,40793,9057,47332,13323,30510,57937,25307,54462,5204,6304,13262,62306,43494,48832,35815,21333,15868,16336,46906,32859,55156,7505,42014,53226,27846,1574,30303,26915,57430,64774,59648,46767,29729,2318,4385,49406,54834,46554,17019,59973,7842,43634,13576,25075,12203,57400,30031,31044,28329,37551,1093,39635,40000,61672,59816,14085,49060,21893,62000,43478,13945,10638,4236,9440,58868,38528,62467,64536,2607,21109,12246,44977,35775,25077,54869,15114,24645,53323,17134,52891,28225,24888,29281,6493,2120,29088,23536,10445,21255,21864,31768,46975,17788,42621,49206,24441,33790,43592,9837,53909,11771,43889,4181,12179,12197,55210,33901,16683,34772,61941,64761,38928,38517,26355,46182,57132,25909,43004,65314,63645,35061,64744,57863,32384,63174,21716,51566,45784,27712,54745,19002,26603,22318,58923,55973,16619,52296,3456,64111,19972,36724,19172,39959,22982,15068,13319,48964,3092,53009,29436,46511,60507,8356,26179,55409,8154,5782,16708,35860,25559,52164,43978,5760,65359,54672,40912,36340,48766,26894,55092,17534,15066,36913,37947,35700,57148,65494,61472,12219,33514,64255,38390,63453,40010,35185,12010,5041,52226,21356,42139,52660,14063,13447,49286,23040,28171,7969,12274,51429,45716,11236,7578,59999,13785,57408,21196,60412,12286,56410,36934,13953,65086,5955,52351,58611,23078,55953,28638,64886,41066,54131,7561,57407,4007,27312,24523,60128,38343,26579,47058,64897,41229,10549,25199,47946,5857,26469,55115,27509,40944,13212,19979,34379,1014,35556,55973,48805,8164,55116,54482,10911,61470,14025,62668,32809,13396,11944,19022,5084,7086,49249,35972,1523,35098,29325,53194,19347,10588,58507,54202,1073,56186,16240,11950,59596,7596,16979,47275,34515,22674,48345,44246,32213,24222,26398,39030,8996,7289,31736,24509,1034,9686,19716,48832,6993,36098,10759,10559,13119,31301,12110,9693,7100,36476,42206,12601,42479,47260,51310,32169,27921,51940,43277,5474,21725,37563,56825,40425,3590,27637,41858,61239,57606,27563,64117,30896,34421,29386,41307,4754,57523,10462,404,20499,3393},
  {2089,14343,9989,1101,17949,11672,4770,58396,7647,51965,21855,55073,41988,14550,60938,24218,16491,13754,26510,18128,30297,14565,19675,16826,44027,42515,1739,35922,15468,10654,63208,21131,3015,6492,26643,64650,43806,27378,42763,24710,22750,17482,50417,3265,62605,211,42274,5360,29567,12085,9669,51857,7587,15128,966,46563,23581,50541,31577,9909,16636,28206,20034,60436,38240,26276,34877,26422,27974,42775,51831,62625,44754,17163,40987,35213,25444,10775,43997,20676,3167,60255,43632,5325,63539,17745,30034,25932,41779,39859,28757,40728,237,8822,45188,61546,110,36877,6842,43509,53958,18782,64447,54381,61834,2213,33528,60576,20808,65091,23208,3644,58497,19784,48736,21653,44917,65465,34687,55200,697,60293,8399,43330,1786,46623,64387,8577,12232,8695,55652,6258,15828,28599,42427,4418,4071,6079,29110,59880,43615,3139,26278,14456,63223,43478,38526,31333,39805,45710,3567,57627,23005,52730,34789,57741,63475,30500,64769,41889,26492,31088,17465,1608,65178,61244,30112,23696,19033,39145,47345,53441,33900,34179,60379,35508,57039,36363,22050,44768,34729,59163,51783,32467,8557,28891,47853,62936,29401,7649,39307,44984,33904,15091,19264,19054,61297,59652,43606,60610,41852,33526,40638,7477,24984,9828,33131,13874,22932,38208,6408,32547,43463,15095,40447,44521,31588,34246,60856,9956,32009,22274,62344,38946,35562,10967,21304,34052,25962,26767,31677,54745,64455,52257,7484,29658,7107,61399,29400,53109,36713,32206,19988,55034,59007,19669,16302,47587,7439,31627,25508,51559,17427,38232,41239,53233,42909,47765,31673,5493,36428,35174,58733,19100,50884,19974,63528,41278,31987,46748,28464,13953,50628,31270,7039,14323,14483,6327,44755,6548,44058,45393,16645,57464,27427,21463,43641,8382,62797,275,31221,44,1770,59484,18166,21390,12475,44205,56387,64624,61050,49810,8834,43018,59442,37536,20259,34014,65044,6953,63365,36854,16045,21810,20202,62528,27862,6760,50535,12886,30877,8222,25501,10845,18461,46631,25525,58303,24975,16815,30235,25921,61664,46548,61591,9240,64675,60083,10180,36195,30091,2603,10556,45929,13883,28753,3865,57043,52493,1424,12297,9067,36012,60590,54352,56347,8124,6335,839,42102,20687,54432,11819,32135,43967,11429,47976,46403,37715,1446,10299,6091,4285,4672,11561,33238,26231,48558,1995,39889,20167,24583,1457,2950,36814,14095,6876,5193,63229,9363,53752,57553,33899,39065,32226,60366,47228,43598,6249,33259,58998,12933,18999,19929,21829,14583,9027,59167,39074,62812,39801,61322,37410,44168,43960,54331,3008,10929,19164,10438,49693,20218,64359,19504,58716,57352,17938,19323,35582,4633,13137,16482,12092,58995,22646,41048,10627,9475,60193,57425,37841,22987,7695,55341,9545,23385,43462,30210,43921,20827,47152,17936,55826,54750,6670,34408,4294,5552,50902,48318,34369,56297,17420,42030,31873,47460,11396,55835,61175,13043,3179,20750,62102,26939,17857,18692,58469,39607,62256,17338,6889,47583,2137,44327,4640,43196,47703,43182,28710,11249,55185,40638,14028,3365,52329,43972,37992,4051,15271,43000,21713,3124,48861,24705,15580,49281,43061,39927,5169,33373,56222,14955,22075,7543,53421,25655,18210,65220,55038,56942,43238,47051,1326,11828,54968,50810,19286,37811,36462,58085,5647,64342,5274,13449,27140,41464,38167,26945,48628,64755,40138,2495,29735,32485,8089,28105,428,34112,7485,9998,4234,58810,42304,62072,50380,12737,24955,36333,29934,13856,13537,8033,21540,30805,52069,60494,32172,35225,6315,24490,19508,59126,15976,5136,19025,18300,53704,3101,5214,41125,41698,8107,64181,49153,15371,58394,28496,44452,58688,49438,58269,48462,56554,767,64259,30367,19127,1841,26424,38613,4852,60779,63145,24533,15686,55688,41839,43832,30741,63269,979,40618,10855,5345,3578,12543,16310,1538,48536,1080,41586,12313,35423,50608,31844,19304,9912,43222,61875,7957,28563,20851,38303,2447,42490,31521,37423,52376,59675,49375,55330,29055,25614,45911,49052,2202,60577,6479,40085,19865,52104,52015,29419,31784,11345,30398,64411,18847,15704,45397,24617,18923,54625,44119,12817,29566,37346,62592,3187,59440,15957,63712,7485,32026,62516,28075,37415,28181,45133,65185,31043,7901,59056,47084,2573,48874,61496,37887,61176,19286,5513,13211,23297,12918,53680,34020,31823,59274,40036,32194,54667,12723,30307,11164,55317,43253,10466,42314,50160,15573,4884,29446,5172,55708,39766,16529,53568,23083,14986,49635,53276,53485,24131,53119,60841,52747,20690,55443,48827,42362,41760,54639,65180,61895,15878,57338,5314,42454,55877,27553,30531,34604,20378,45157,50804,12423,35475,46782,33251,53039,63727,46935,30330,38773,29646,10490,12843,5758,62733,1871,38554,10407,63061,15757,5922,22067,9394,5188,27706,39508,3675,36792,11260,20212,26038,43797,59282,36566,20943,43678,18581,45187,63114,37376,55114,21940,27234,11893,57922,33184,52941,57226,57664,56244,45806,28906,46977,28940,44083,62132,54060,40764,51296,39045,64024,44613,62762,65495,63582,49560,47303,45220,36324,15589,28482,11726,35433,8152,11501,40293,64155,15262,64842,3397,50313,28834,7630,52025,25137,4942,52954,30051,1964,62825,22559,4582,56403,45641,27860,46527,64661,43691,29231,48915,58196,18011,955,21574,36924,30668,2039,58208,9811,19698,17755,1620,2961,42925,51823,21296,6163,10060,3736,15576,28861,20249,49439,1376,21044,13637,10528,27934,17615,21142,29099,59830,47469,42724,26609,25562,22017,36544,3349,45370,26455,30796,11407,13489,9192,9843,13098,13197,12724,22611,27158,62728,43197,46192,2785,20155,21307,49469,41766,55073,30789,40734,53028,57875,22961,13502,13426,58663,25617,40367,6480,41012,30955,25253,59681,27530,10757,17768,34874,13808,52178,63176,58347,41467,30518,20554,49319,63300,28819,46676,58219,30554,44845,51313,57804,11883,45601,4649,9853,45328,34420,5695,47708,15438,50019,64503,64470,42543,12190,10586,17205,60073,23880,6190,14501,17914,63698,9801,18098,21156,12266,20980,62590,51242,62586,30557,61497,59445,12301,16090,36079,43896,8793,50401,64813,27219,65014,60028,43760,38371,26333,51131,57372,63363,4521,55214,61372,12764,59768,44693,55112,13605,8345,14578,56239,2805,873,25778,53494,49102,53173,59671,31300,14612,8965,56754,27108,37700,5080},
} ;

static void test_encode_1013xint16_impl(long long impl)
{
  unsigned char *s = test_encode_1013xint16_s;
  unsigned char *x = test_encode_1013xint16_x;
  unsigned char *s2 = test_encode_1013xint16_s2;
  unsigned char *x2 = test_encode_1013xint16_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1013xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1013xint16(impl);
    printf("encode_1013xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013xint16_implementation(impl),ntruprime_dispatch_encode_1013xint16_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1013xint16;
    printf("encode_1013xint16 selected implementation %s compiler %s\n",ntruprime_encode_1013xint16_implementation(),ntruprime_encode_1013xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1013xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1013xint16_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1013xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1013xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1013xint16_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1013xint16_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1013xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013xint16")) return;
  storage_encode_1013xint16_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1013xint16_s = aligned(storage_encode_1013xint16_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1013xint16_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1013xint16_x = aligned(storage_encode_1013xint16_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1013xint16_s2 = callocplus(maxalloc);
  test_encode_1013xint16_s2 = aligned(storage_encode_1013xint16_s2,crypto_encode_STRBYTES);
  storage_encode_1013xint16_x2 = callocplus(maxalloc);
  test_encode_1013xint16_x2 = aligned(storage_encode_1013xint16_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1013xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1013xint16();++impl)
      forked(test_encode_1013xint16_impl,impl);
    ++test_encode_1013xint16_s;
    ++test_encode_1013xint16_x;
    ++test_encode_1013xint16_s2;
    ++test_encode_1013xint16_x2;
  }
  free(storage_encode_1013xint16_x2);
  free(storage_encode_1013xint16_s2);
  free(storage_encode_1013xint16_x);
  free(storage_encode_1013xint16_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

