Name: libcaes
Version: 20240413
Release: 1
Summary: Library to support cross-platform AES encryption
Group: System Environment/Libraries
License: LGPL-3.0-or-later
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libcaes
Requires:  openssl
BuildRequires: gcc  openssl-devel

%description -n libcaes
Library to support cross-platform AES encryption

%package -n libcaes-static
Summary: Library to support cross-platform AES encryption
Group: Development/Libraries
Requires: libcaes = %{version}-%{release}

%description -n libcaes-static
Static library version of libcaes.

%package -n libcaes-devel
Summary: Header files and libraries for developing applications for libcaes
Group: Development/Libraries
Requires: libcaes = %{version}-%{release}

%description -n libcaes-devel
Header files and libraries for developing applications for libcaes.

%package -n libcaes-python3
Summary: Python 3 bindings for libcaes
Group: System Environment/Libraries
Requires: libcaes = %{version}-%{release} python3
BuildRequires: python3-devel python3-setuptools

%description -n libcaes-python3
Python 3 bindings for libcaes

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libcaes
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so.*

%files -n libcaes-static
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.a

%files -n libcaes-devel
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so
%{_libdir}/pkgconfig/libcaes.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libcaes-python3
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.so

%changelog
* Sat Apr 13 2024 Joachim Metz <joachim.metz@gmail.com> 20240413-1
- Auto-generated

