#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER1="mailto:resource-car-porsche911@example.com"
USER2="mailto:resource-car-fiat500@example.com"
SENDER1="mailto:paul.boddie@example.com"
SENDER2="mailto:vincent.vole@example.com"
SENDERADDRESS1="paul.boddie@example.com"
SENDERADDRESS2="vincent.vole@example.com"
QUOTA=cars

# Test quota enforcement on two resources, first checking whether the resources
# can schedule an incoming reservation, then checking whether the reservation
# would exceed the organiser's quota applying collectively to both resources.

# The result should be the first scheduling attempt being declined because it
# attempts to reserve an indefinite amount of time that obviously exceeds the
# quota, with the second attempt succeeding but only for one resource because
# the quota is used up reserving one of the two resources requested. This
# reservation is then cancelled.

# Another attempt is made by a user with a larger quota, and this succeeds in
# reserving both resources.

mkdir -p "$PREFS/$USER1"
echo 'Europe/Oslo' > "$PREFS/$USER1/TZID"
echo 'share' > "$PREFS/$USER1/freebusy_sharing"
cat > "$PREFS/$USER1/scheduling_function" <<EOF
schedule_in_freebusy
check_quota $QUOTA
EOF

mkdir -p "$PREFS/$USER2"
echo 'Europe/Oslo' > "$PREFS/$USER2/TZID"
echo 'share' > "$PREFS/$USER2/freebusy_sharing"
cat > "$PREFS/$USER2/scheduling_function" <<EOF
schedule_in_freebusy
check_quota $QUOTA
EOF

cat <<EOF | "$SET_QUOTA_LIMITS" "$QUOTA" $SET_QUOTA_LIMITS_ARGS
mailto:vincent.vole@example.com PT10H
* PT5H
EOF

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-car-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-cars-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER1" "freebusy" \
>  out0f.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out0f.tmp" \
&& grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out0f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-cars-recurring.txt" 2>> $ERROR \
| tee out1r.tmp \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out1f.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out1f2.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out1f.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out1f.tmp" \
&& ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out1f2.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out1f2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is not confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER1" \
>  out1e.tmp

   ! grep -q "event25@example.com" "out1e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Modify the event and attempt to schedule it again.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=5/;' "$TEMPLATES/event-request-cars-recurring.txt" \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER1" "freebusy" \
>  out1s.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out1s.tmp" \
&& grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out1s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=5/;' "$TEMPLATES/event-request-cars-recurring.txt" \
| "$RESOURCE_SCRIPT" $ARGS 2>> $ERROR \
| tee out2r.tmp \
| "$SHOWMAIL" \
> out2.tmp

# Since the email module used by showmail.py cannot stop after reading a single
# message, the second message is obtained.

  "$SHOWMAIL" 1 < out2r.tmp \
>> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out2.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out2f.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out2f2.tmp

    ( ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f.tmp" \
   && ! grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out2f.tmp" \
   && grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f2.tmp" \
   && grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out2f2.tmp" ) \
||  ( ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f2.tmp" \
   && ! grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out2f2.tmp" \
   && grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f.tmp" \
   && grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out2f.tmp" ) \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed for one resource).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER1" \
>  out2e.tmp

   grep -q "event25@example.com" "out2e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Cancel the event.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=5/;' "$TEMPLATES/event-cancel-cars-recurring.txt" \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER1" "freebusy" \
>  out2s.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2s.tmp" \
&& ! grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out2s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=5/;' "$TEMPLATES/event-cancel-cars-recurring.txt" \
| "$RESOURCE_SCRIPT" $ARGS 2>> $ERROR \
| tee out3r.tmp \
| "$SHOWMAIL" \
> out3.tmp

   ! grep -q 'METHOD:REPLY' out3.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out3f.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out3f2.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out3f.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out3f.tmp" \
&& ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out3f2.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out3f2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is retracted).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER1" \
>  out3e.tmp

   ! grep -q "event25@example.com" "out3e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Modify the event and attempt to schedule it again.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=5/;' "$TEMPLATES/event-request-cars-recurring.txt" \
| sed "s/$SENDERADDRESS1/$SENDERADDRESS2/;" \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER2" "freebusy" \
>  out3s.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out3s.tmp" \
&& grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out3s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=5/;' "$TEMPLATES/event-request-cars-recurring.txt" \
| sed "s/$SENDERADDRESS1/$SENDERADDRESS2/;" \
| "$RESOURCE_SCRIPT" $ARGS 2>> $ERROR \
| tee out4r.tmp \
| "$SHOWMAIL" \
> out4.tmp

# Since the email module used by showmail.py cannot stop after reading a single
# message, the second message is obtained.

  "$SHOWMAIL" 1 < out4r.tmp \
>> out4.tmp

   grep -q 'METHOD:REPLY' out4.tmp \
&& [ `grep 'ATTENDEE.*;PARTSTAT=ACCEPTED' out4.tmp | wc -l` = '2' ] \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out4f.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out4f2.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out4f.tmp" \
&& grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out4f.tmp" \
&& grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out4f2.tmp" \
&& grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out4f2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed for both resources).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER2" \
>  out4e.tmp

   grep -q "event25@example.com" "out4e.tmp" \
&& echo "Success" \
|| echo "Failed"
