/* SPDX-License-Identifier: GPL-2.0-only */

External(\_SB.DTTB, MethodObj)
External(\_SB.DTTC, MethodObj)
External(\_SB.DTTD, MethodObj)
External(\_SB.DTTE, MethodObj)
External(\_SB.DTTF, MethodObj)

Scope (\_SB)
{
    //---------------------------------------------
    // Table | A | B | C | D | E | F | First boot |
    //---------------------------------------------
    // PRTN  | 0 | 1 | 2 | 3 | 4 | 5 |     7      |
    //---------------------------------------------
    Name (PRTN, 7)

    Method (DTTS, 0, Serialized)
    {
        // Set table A as default table after power on device
        If (\_SB.PRTN == 7)
        {
            \_SB.DDEF()
            \_SB.PRTN = 0
            Return (0)
        }

        If (\_SB.PCI0.LPCB.EC0.STTB == 0) { // Desktop
            If (\_SB.PCI0.LPCB.EC0.LIDS == 1) { // Lid-open
                // Table A/B
                If ((\_SB.PRTN == 0) || (\_SB.PRTN == 1)) {
                    // AMB sensor trigger point
                    // 43C will store 116(0x74) in mapped memory
                    // 43C=316K, 316-200(offset)=116(0x74)
                    If (\_SB.PCI0.LPCB.EC0.TIN4 >= 116) {
                        \_SB.DTTB()
                        \_SB.PRTN = 1
                        Return (0)
                    }
                    // AMB sensor release point
                    If ((\_SB.PCI0.LPCB.EC0.TIN4 <= 112)) {
                        \_SB.DDEF()
                        \_SB.PRTN = 0
                        Return (0)
                    }
                    // Keep tht previous thermal table
                    Return (0)
                } Else {
                    If (\_SB.PRTN == 3 || \_SB.PRTN == 5) {
                        \_SB.DTTB()
                        \_SB.PRTN = 1
                        Return (0)
                    } Else {
                        \_SB.DDEF()
                        \_SB.PRTN = 0
                        Return (0)
                    }
                }
            } Else { // Lid-close
                // Table C/D
                If (\_SB.PRTN == 2 || \_SB.PRTN == 3) {
                    If (\_SB.PCI0.LPCB.EC0.TIN4 >= 116) {
                        \_SB.DTTD()
                        \_SB.PRTN = 3
                        Return (0)
                    }
                    If(\_SB.PCI0.LPCB.EC0.TIN4 <= 112) {
                        \_SB.DTTC()
                        \_SB.PRTN = 2
                        Return (0)
                    }
                    // Keep tht previous thermal table
                    Return (0)
                } Else {
                    If (\_SB.PRTN == 1 || \_SB.PRTN == 5) {
                        \_SB.DTTD()
                        \_SB.PRTN = 3
                        Return (0)
                    } Else {
                        \_SB.DTTC()
                        \_SB.PRTN = 2
                        Return (0)
                    }
                }
            }
        } Else { // Laptop
            // Table E/F
            If (\_SB.PRTN == 4 || \_SB.PRTN == 5) {
                // AMB sensor trigger point
                If (\_SB.PCI0.LPCB.EC0.TIN4 >= 115) {
                    \_SB.DTTF()
                    \_SB.PRTN = 5
                    Return (0)
                }
                // AMB sensor release point
                If ((\_SB.PCI0.LPCB.EC0.TIN4 <= 111)) {
                    \_SB.DTTE()
                    \_SB.PRTN = 4
                    Return (0)
                }
                // Keep tht previous thermal table
                Return (0)
            } Else {
                If (\_SB.PRTN == 1 || \_SB.PRTN == 3) {
                    \_SB.DTTF()
                    \_SB.PRTN = 5
                    Return (0)
                } Else {
                    \_SB.DTTE()
                    \_SB.PRTN = 4
                    Return (0)
                }
            }
        } // Desktop/Laptop End
    }
}
