## Books

There are a number of excellent resources to help you get started with CoffeeScript, some of which are freely available online.

*   [The Little Book on CoffeeScript](http://arcturo.github.io/library/coffeescript/) is a brief 5-chapter introduction to CoffeeScript, written with great clarity and precision by [Alex MacCaw](http://alexmaccaw.co.uk/).
*   [Smooth CoffeeScript](http://autotelicum.github.io/Smooth-CoffeeScript/) is a reimagination of the excellent book [Eloquent JavaScript](http://eloquentjavascript.net/), as if it had been written in CoffeeScript instead. Covers language features as well as the functional and object oriented programming styles. By [E. Hoigaard](https://github.com/autotelicum).
*   [CoffeeScript: Accelerated JavaScript Development](http://pragprog.com/book/tbcoffee/coffeescript) is [Trevor Burnham](http://trevorburnham.com/)’s thorough introduction to the language. By the end of the book, you’ll have built a fast-paced multiplayer word game, writing both the client-side and Node.js portions in CoffeeScript.
*   [CoffeeScript Programming with jQuery, Rails, and Node.js](https://www.packtpub.com/web-development/coffeescript-programming-jquery-rails-and-nodejs) is a new book by Michael Erasmus that covers CoffeeScript with an eye towards real-world usage both in the browser (jQuery) and on the server-side (Rails, Node).
*   [CoffeeScript Ristretto](https://leanpub.com/coffeescript-ristretto/read) is a deep dive into CoffeeScript’s semantics from simple functions up through closures, higher-order functions, objects, classes, combinators, and decorators. By [Reg Braithwaite](http://braythwayt.com/).
*   [Testing with CoffeeScript](https://efendibooks.com/minibooks/testing-with-coffeescript) is a succinct and freely downloadable guide to building testable applications with CoffeeScript and Jasmine.
*   [CoffeeScript Application Development](https://www.packtpub.com/web-development/coffeescript-application-development) from Packt, introduces CoffeeScript while walking through the process of building a demonstration web application. A [CoffeeScript Application Development Coookbook](https://www.packtpub.com/web-development/coffeescript-application-development-cookbook) with over 90 “recipes” is also available.
*   [CoffeeScript in Action](https://www.manning.com/books/coffeescript-in-action) from Manning Publications, covers CoffeeScript syntax, composition techniques and application development.
*   [CoffeeScript: Die Alternative zu JavaScript](https://www.dpunkt.de/buecher/4021/coffeescript.html) from dpunkt.verlag, is the first CoffeeScript book in Deutsch.
