# CiviCRM 4.7.23

Released August 2, 2017

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                           |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   | no      |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-20830](https://issues.civicrm.org/jira/browse/CRM-20830) Improve
  handling of overdue activities
  ([10618](https://github.com/civicrm/civicrm-core/pull/10618))**

  Activity statuses can now be edited to denote whether activities with a given
  status should be considered "complete" or not.  This attribute is now the
  basis for determining whether an activity is overdue.  In addition to UI
  indications of being overdue, the API can return this value for each activity.

- **[CRM-20803](https://issues.civicrm.org/jira/browse/CRM-20803) Enable Farsi
  (fa_IR), Serbian (sr_RS), Ukrainian (uk_UA) in the languages option group so
  that we can install in those languages
  ([10667](https://github.com/civicrm/civicrm-core/pull/10667))**

  These languages can now be used for installation of CiviCRM.

- **[CRM-20759](https://issues.civicrm.org/jira/browse/CRM-20759) Import, add
  'Primary' as an address location
  ([10738](https://github.com/civicrm/civicrm-core/pull/10738),
  [10565](https://github.com/civicrm/civicrm-core/pull/10565),
  [10594](https://github.com/civicrm/civicrm-core/pull/10594),
  [10554](https://github.com/civicrm/civicrm-core/pull/10554), and
  [10547](https://github.com/civicrm/civicrm-core/pull/10547))**

  Columns in imports can now import to fields in the matching contact's primary
  address, regardless of location type.

- **[CRM-20793](https://issues.civicrm.org/jira/browse/CRM-20793) Add filter -
  activity date and status on search criteria of activity listing
  ([10588](https://github.com/civicrm/civicrm-core/pull/10588))**

  The activity tab on a contact record now allows filtering by date and status
  besides just activity type.  In addition, a site-wide option toggles whether a
  user's filters on one contact's activities persist as they visit other
  contacts.

- **[CRM-20847](https://issues.civicrm.org/jira/browse/CRM-20847) Support custom
  api with composite primary keys
  ([10599](https://github.com/civicrm/civicrm-core/pull/10599))**

  This change adds testing for custom APIs using the basic get function and
  avoids automatically selecting the `id` field if there is no such field in the
  spec.

- **[CRM-20842](https://issues.civicrm.org/jira/browse/CRM-20842) Change api
  explorer page title
  ([10633](https://github.com/civicrm/civicrm-core/pull/10633))**

  The API Explorer now explicitly states it is demonstrating API v3.

- **[CRM-20780](https://issues.civicrm.org/jira/browse/CRM-20780) Add settings
  file option to define CMS_ROOT
  ([10574](https://github.com/civicrm/civicrm-core/pull/10574))**

  The CiviCRM settings file can now explicitly set the path to the CMS root.

- **[CRM-20169](https://issues.civicrm.org/jira/browse/CRM-20169) Add support
  for alterReportVar hook in Activity Report
  ([9886](https://github.com/civicrm/civicrm-core/pull/9886))**

  Extensions can now modify the SQL of the Activity Report.

- **[CRM-20721](https://issues.civicrm.org/jira/browse/CRM-20721) Add parameter
  to dateQueryBuilder fn to change date value to desired format
  ([10497](https://github.com/civicrm/civicrm-core/pull/10497))**

  Queries on fields formatted in ways other than the typical MySQL date format
  can now use the standard date query builder method in the contact BAO.

- **[CRM-20600](https://issues.civicrm.org/jira/browse/CRM-20600) Expose
  AngularJS screens to hooks
  ([10644](https://github.com/civicrm/civicrm-core/pull/10644)) (follow-up
  work)**

  A message now displays both before and after upgrade if a site's configuration
  is likely to prevent successful asset-caching.

- **[CRM-20673](https://issues.civicrm.org/jira/browse/CRM-20673) Tag and group
  edit form: implement Select2 for tags
  ([10634](https://github.com/civicrm/civicrm-core/pull/10634)) (completes
  previous work)**

  Tags are now listed in the widget in the same order as they are displayed for
  management.

- **[CRM-20622](https://issues.civicrm.org/jira/browse/CRM-20622) contact edit:
  tags and groups panel layout/styling
  ([10429](https://github.com/civicrm/civicrm-core/pull/10429))**

  The tag and group editing interface now uses standard markup rather than
  unique, outdated approaches.

### CiviCase

- **[CRM-19778](https://issues.civicrm.org/jira/browse/CRM-19778) Allowed
  statuses per case-type
  ([10552](https://github.com/civicrm/civicrm-core/pull/10552))**

  The available options in the API for case status can now be filtered to those
  appropriate for a given case type.

- **[CRM-20794](https://issues.civicrm.org/jira/browse/CRM-20794) Colors for
  case status ([10586](https://github.com/civicrm/civicrm-core/pull/10586))
  (preliminary work)**

  When editing case statuses, you may now select a color.  However, case display
  does not yet show the status colors.

- **[CRM-20756](https://issues.civicrm.org/jira/browse/CRM-20756) Multi tab
  structure ([10545](https://github.com/civicrm/civicrm-core/pull/10545))
  (preliminary work)**

  The AngularJS `ui.bootstrap` library is now included in CiviCRM.

- **[CRM-20816](https://issues.civicrm.org/jira/browse/CRM-20816) Case
  multi/single client settings
  ([10609](https://github.com/civicrm/civicrm-core/pull/10609))**

  Settings for redacting activity emails, allowing multiple clients per case,
  and the sort order of activity types can now be modified in an administrative
  form rather than exclusively in XML files defining case types.

### CiviContribute

- **[CRM-20778](https://issues.civicrm.org/jira/browse/CRM-20778) Use
  civicontribute permission for contribution recur.cancel
  ([10569](https://github.com/civicrm/civicrm-core/pull/10569))**

  The permissions to view, modify, cancel, and delete recurring contributions
  now mirror the corresponding permissions needed for working with payments.

- **[CRM-20682](https://issues.civicrm.org/jira/browse/CRM-20682) Include human
  readable contribution's custom field label in token widget for Thankyou letter
  ([10467](https://github.com/civicrm/civicrm-core/pull/10467))**

  Contribution custom field tokens are now listed among the available tokens in
  the Thank-you Letter form.  They had been processed, but there was no
  indication that they were available.

- **[CRM-20860](https://issues.civicrm.org/jira/browse/CRM-20860) Add in
  password type field availability and apply to payment processor fields
  ([10649](https://github.com/civicrm/civicrm-core/pull/10649))**

  Field metadata can now specify the HTML field type of `Password` which adds a
  `HTML_QuickForm_password` field element.  This is implemented on payment
  processor settings fields.

### CiviMember

- **[CRM-20901](https://issues.civicrm.org/jira/browse/CRM-20901) Add submit
  credit card membership link on membership form
  ([10689](https://github.com/civicrm/civicrm-core/pull/10689))**

  The backend add membership form now has a link to the backend credit card
  membership form.

### Backdrop Integration

- **Port of civicrm_engage to Backdrop
  ([28](https://github.com/civicrm/civicrm-backdrop/pull/28))**

### Drupal Integration

- **[CRM-20751](https://issues.civicrm.org/jira/browse/CRM-20751) Support Drupal
  aliases for event links in Views
  ([456](https://github.com/civicrm/civicrm-drupal/pull/456) and
  [455](https://github.com/civicrm/civicrm-drupal/pull/455))**

  If a CiviCRM event has a Drupal alias set for it, views linking to the event
  will now link to the alias rather than the CiviCRM URL.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-20873](https://issues.civicrm.org/jira/browse/CRM-20873) CIVICRM-118 DB
  Error: no such field / Unknown column 'civicrm_custom_group.is_public' breaks
  CiviCRM database update process
  ([10662](https://github.com/civicrm/civicrm-core/pull/10662))**

  This fixes a bug in upgrading from 4.7.18 or earlier to 4.7.19 or later.  Code
  used by the upgrade to load the available custom data for an entity relies
  upon a field that is not made available until after the upgrade.

- **[CRM-20849](https://issues.civicrm.org/jira/browse/CRM-20849) Multiple
  extensions using the same autoloader prefix will overwrite previous
  ([10637](https://github.com/civicrm/civicrm-core/pull/10637))**

- **[CRM-20739](https://issues.civicrm.org/jira/browse/CRM-20739) contact import
  doesn't add to group on fill if matching without ID
  ([10507](https://github.com/civicrm/civicrm-core/pull/10507))**

- **[CRM-20666](https://issues.civicrm.org/jira/browse/CRM-20666) enable
  uploading of files to activities that are up to 255 characters in length
  ([10449](https://github.com/civicrm/civicrm-core/pull/10449))**

  File names of activity uploads had previously been capped at 60 characters.

- **[CRM-20776](https://issues.civicrm.org/jira/browse/CRM-20776) Menu structure
  ([10573](https://github.com/civicrm/civicrm-core/pull/10573))**

  This fixes incorrect handling of URL paths, queries and fragments in the
  navigation menu.  This was a particular problem for AngularJS pages.

- **[CRM-20640](https://issues.civicrm.org/jira/browse/CRM-20640) contribution
  summary report: duplicates values with group filter
  ([10603](https://github.com/civicrm/civicrm-core/pull/10603) and
  [10596](https://github.com/civicrm/civicrm-core/pull/10596))**

  Reports with group filters would display rows twice if multiple groups were
  selected in the filter and contacts were in more than one of those groups.

- **[CRM-20953](https://issues.civicrm.org/jira/browse/CRM-20953) Importing
  contacts with deceased_date not setting is_deceased
  ([10742](https://github.com/civicrm/civicrm-core/pull/10742))**

- **[CRM-20871](https://issues.civicrm.org/jira/browse/CRM-20871) crmUiSelect
  fails to update when model changes
  ([10659](https://github.com/civicrm/civicrm-core/pull/10659))**

- **[CRM-20809](https://issues.civicrm.org/jira/browse/CRM-20809) Move
  extensions cache from $extensionsDir to $uploadDir
  ([10604](https://github.com/civicrm/civicrm-core/pull/10604))**

  Cached data about extensions was stored in the extensions directory, which may
  not be an appropriate place and may not be writable.  It is now stored in the
  upload directory.

- **[CRM-20828](https://issues.civicrm.org/jira/browse/CRM-20828) Saved field
  mappings drop down is limited to 1
  ([10615](https://github.com/civicrm/civicrm-core/pull/10615))**

- **[CRM-20509](https://issues.civicrm.org/jira/browse/CRM-20509) Checking
  Contribution Note field in reports results in no rows
  ([10631](https://github.com/civicrm/civicrm-core/pull/10631))**

  When displaying note fields in reports, the query would limit the results to
  rows that had notes.

- **[CRM-20351](https://issues.civicrm.org/jira/browse/CRM-20351)
  hook_civicrm_buildForm invoked twice on a bunch of forms
  ([10068](https://github.com/civicrm/civicrm-core/pull/10068))**

- **[CRM-20774](https://issues.civicrm.org/jira/browse/CRM-20774) Add check for
  existing index keys(different values) while creating missing indices.
  ([10572](https://github.com/civicrm/civicrm-core/pull/10572) and
  [10566](https://github.com/civicrm/civicrm-core/pull/10566))**

  The check and resolution for missing indexes would previously be unaware of
  variations in the keys for equivalent indexes.

- **[CRM-20722](https://issues.civicrm.org/jira/browse/CRM-20722) 'Lock wait
  timeout exceeded' error triggered on smart group cache rebuild
  ([10498](https://github.com/civicrm/civicrm-core/pull/10498))**

  This avoids an error when rebuilding the smart group cache on sites that have
  a very large number of smart groups.

- **[CRM-20443](https://issues.civicrm.org/jira/browse/CRM-20443) SQL syntax
  error creating logging triggers if column name is reserved word
  ([10530](https://github.com/civicrm/civicrm-core/pull/10530))**

- **[CRM-20950](https://issues.civicrm.org/jira/browse/CRM-20950) Contact import
  mapping to wrong location type (unreleased regression)
  ([10736](https://github.com/civicrm/civicrm-core/pull/10736) and
  [10735](https://github.com/civicrm/civicrm-core/pull/10735))**

- **[CRM-20754](https://issues.civicrm.org/jira/browse/CRM-20754) memory leak in
  CLI CSV import ([10537](https://github.com/civicrm/civicrm-core/pull/10537))**

  This resolves a problem of accumulating too much data in the
  `PEAR_DB_DATAOBJECT` cache on large imports.

- **[CRM-19702](https://issues.civicrm.org/jira/browse/CRM-19702) Fatal error
  when merging contact records with custom file fields
  ([9784](https://github.com/civicrm/civicrm-core/pull/9784))**

- **[CRM-19653](https://issues.civicrm.org/jira/browse/CRM-19653) Custom field
  checkboxes migrated incorrectly on merge (part deux)
  ([10407](https://github.com/civicrm/civicrm-core/pull/10407))**

- **[CRM-19821](https://issues.civicrm.org/jira/browse/CRM-19821) Remove
  performance degrading joins from activity search (& api calls)
  ([10274](https://github.com/civicrm/civicrm-core/pull/10274))**

- **[CRM-20743](https://issues.civicrm.org/jira/browse/CRM-20743) users without
  reserved tag permission may still modify the tag
  ([10522](https://github.com/civicrm/civicrm-core/pull/10522))**

  While users lacking the "Administer reserved tags" permission were barred from
  deleting or moving reserved tags, this prevents them from editing the tag name
  and description.

- **[CRM-20621](https://issues.civicrm.org/jira/browse/CRM-20621) manage tags:
  the tag usage count is not accurate
  ([10441](https://github.com/civicrm/civicrm-core/pull/10441))**

### CiviCase

- **[CRM-20802](https://issues.civicrm.org/jira/browse/CRM-20802)
  CaseType.create - Stale definition retained in memory
  ([10591](https://github.com/civicrm/civicrm-core/pull/10591))**

  Cached case type information was retained even after modifying the case type.

### CiviContribute

- **[CRM-20765](https://issues.civicrm.org/jira/browse/CRM-20765) Missing id for
  'onBehalfOfOrg' section
  ([10550](https://github.com/civicrm/civicrm-core/pull/10550))**

  The `<div>` containing on-behalf section on contribution pages lacks the
  `onBehalfOfOrg` ID attribute that it had in 4.6.

- **[CRM-20753](https://issues.civicrm.org/jira/browse/CRM-20753) Net amount
  doesn't respect localization
  ([10536](https://github.com/civicrm/civicrm-core/pull/10536))**

- **[CRM-20891](https://issues.civicrm.org/jira/browse/CRM-20891) Pay later
  option incorrectly shows as completed when combining membership and donation
  ([10683](https://github.com/civicrm/civicrm-core/pull/10683))**

  Using a contribution page with "separate membership payment" set, a pay-later
  contribution would incorrectly mark the membership contribution completed.

- **[CRM-20848](https://issues.civicrm.org/jira/browse/CRM-20848) Upgrade to
  4.7.19 sets price_field to inactive if default Financial Types are disabled
  ([10675](https://github.com/civicrm/civicrm-core/pull/10675))**

- **[CRM-20857](https://issues.civicrm.org/jira/browse/CRM-20857) Deferred
  Revenue report -  DB Error: unknown error
  ([10646](https://github.com/civicrm/civicrm-core/pull/10646))**

  The Deferred Revenue report would have an error on if a database server's
  `sql_mode` was set to `only_full_group_by`.

- **[CRM-20867](https://issues.civicrm.org/jira/browse/CRM-20867) Class not
  found ([10656](https://github.com/civicrm/civicrm-core/pull/10656))**

  This fixes a fatal error in the additional payment form due to a typo in the
  name of the `CRM_Contribute_BAO_Contribution` class.

- **[CRM-20649](https://issues.civicrm.org/jira/browse/CRM-20649) Notice error
  when creating Price set
  ([10431](https://github.com/civicrm/civicrm-core/pull/10431))**

  Validation of a price set name would generate a PHP notice if the name was
  blank.

- **[CRM-20823](https://issues.civicrm.org/jira/browse/CRM-20823) Price Set
  field with an Expiry Date still being 'required' after being expired.
  ([10613](https://github.com/civicrm/civicrm-core/pull/10613))**

- **[CRM-20752](https://issues.civicrm.org/jira/browse/CRM-20752) Editing a
  Cancelled Pledge updates the status of it to Pending/Inprogress
  ([10535](https://github.com/civicrm/civicrm-core/pull/10535))**

- **[CRM-20812](https://issues.civicrm.org/jira/browse/CRM-20812) Notice on live
  contribution when only pay later is selected
  ([10606](https://github.com/civicrm/civicrm-core/pull/10606))**

- **[CRM-20761](https://issues.civicrm.org/jira/browse/CRM-20761) Formrule error
  when priceset is selected on contribution page
  ([10549](https://github.com/civicrm/civicrm-core/pull/10549))**

  When enabling a contribution amounts section and selecting a price set on a
  contribution page's settings form, validation would fail, looking for a
  contribution amount label.

- **[CRM-20401](https://issues.civicrm.org/jira/browse/CRM-20401) Cancel/modify
  URL receipt links not correct for Paypal Website Payments Pro
  ([10424](https://github.com/civicrm/civicrm-core/pull/10424))**

- **[CRM-20745](https://issues.civicrm.org/jira/browse/CRM-20745) Post date of
  recur not respected in credit card pledge payment
  ([10524](https://github.com/civicrm/civicrm-core/pull/10524))**

- **[CRM-20773](https://issues.civicrm.org/jira/browse/CRM-20773) Contribution
  tab shows Receive Date twice instead of Thank You date
  ([10607](https://github.com/civicrm/civicrm-core/pull/10607))**

- **[CRM-20387](https://issues.civicrm.org/jira/browse/CRM-20387) Sales Tax and
  Invoicing code overwrites existing CiviCRM invoice ID
  ([10298](https://github.com/civicrm/civicrm-core/pull/10298))**

  A new `invoice_number` field is added to the `civicrm_contribution` table to
  record the ID of the manually-generated invoice.

- **[CRM-20488](https://issues.civicrm.org/jira/browse/CRM-20488) Lift
  restrictions for contact type soft credit
  ([10532](https://github.com/civicrm/civicrm-core/pull/10532) and
  [10419](https://github.com/civicrm/civicrm-core/pull/10419))**

  Users could not soft-credit an organization if the contribution originated
  from a contribution page where honor/memory is enabled.

- **[CRM-19478](https://issues.civicrm.org/jira/browse/CRM-19478) API not
  handling Paypal recurring IPN where p=null for Contribution Page
  ([10447](https://github.com/civicrm/civicrm-core/pull/10447))**

- **[CRM-20495](https://issues.civicrm.org/jira/browse/CRM-20495) "Contribution
  amounts section" checkbox setting on contribution pages always shows as
  checked. ([10521](https://github.com/civicrm/civicrm-core/pull/10521))**

- **[CRM-20747](https://issues.civicrm.org/jira/browse/CRM-20747)
  {contribution.campaign} token not working on Contribution ThankYou letter
  ([10533](https://github.com/civicrm/civicrm-core/pull/10533))**

### CiviMember

- **[CRM-19017](https://issues.civicrm.org/jira/browse/CRM-19017) Scheduled
  membership reminders have stopped working
  ([10652](https://github.com/civicrm/civicrm-core/pull/10652))**

- **[CRM-20716](https://issues.civicrm.org/jira/browse/CRM-20716) Array to
  string issue on php7 when creating membership activity
  ([10492](https://github.com/civicrm/civicrm-core/pull/10492))**

- **[CRM-20650](https://issues.civicrm.org/jira/browse/CRM-20650) Translate
  strings (ts) in CiviMember dashboard and Contribute manage
  ([10432](https://github.com/civicrm/civicrm-core/pull/10432))**

- **[CRM-18177](https://issues.civicrm.org/jira/browse/CRM-18177) When Renewing
  an existing membership, if CC details are incorrect, Membership is set to
  Cancelled preventing contact from trying again
  ([10770](https://github.com/civicrm/civicrm-core/pull/10770)) (fix to problem
  introduced in original bug fix)**

- **[CRM-20850](https://issues.civicrm.org/jira/browse/CRM-20850) Replace fatal
  with statusBounce in membership form
  ([10638](https://github.com/civicrm/civicrm-core/pull/10638))**

  When a user links to edit a linked contribution from a membership and they
  don't have permission to edit the contribution, they should be redirected with
  an error notice rather than being shown a fatal error.

- **[CRM-20667](https://issues.civicrm.org/jira/browse/CRM-20667) Additonal Line
  item created from Membership backoffice form
  ([10450](https://github.com/civicrm/civicrm-core/pull/10450))**

- **[CRM-20805](https://issues.civicrm.org/jira/browse/CRM-20805) Fatal Error
  when adding new membership type on a contribution page.
  ([10597](https://github.com/civicrm/civicrm-core/pull/10597))**

- **[CRM-20668](https://issues.civicrm.org/jira/browse/CRM-20668) Notice error
  ([10452](https://github.com/civicrm/civicrm-core/pull/10452))**

  This fixes a PHP notice when creating a membership using a price set on the
  backend.

- **[CRM-20675](https://issues.civicrm.org/jira/browse/CRM-20675) Membership
  status update creates renewal activity
  ([10457](https://github.com/civicrm/civicrm-core/pull/10457))**

- **[CRM-20567](https://issues.civicrm.org/jira/browse/CRM-20567) backoffice
  membership via price set errors with non-aggregated column
  ([10346](https://github.com/civicrm/civicrm-core/pull/10346))**

  This is one of several errors that appear when `sql_mode` was set to
  `only_full_group_by`.

- **[CRM-20720](https://issues.civicrm.org/jira/browse/CRM-20720) CIVICRM-128
  Unable to sort Price Options for Price Fieldset. Weight values are not being
  set at all in database.
  ([10542](https://github.com/civicrm/civicrm-core/pull/10542))**

- **[CRM-20670](https://issues.civicrm.org/jira/browse/CRM-20670) Cannot edit
  membership type if lots of members already exist
  ([10534](https://github.com/civicrm/civicrm-core/pull/10534) and
  [10455](https://github.com/civicrm/civicrm-core/pull/10455))**

### CiviEvent

- **[CRM-20741](https://issues.civicrm.org/jira/browse/CRM-20741) Cancellation
  message shown as error
  ([10515](https://github.com/civicrm/civicrm-core/pull/10515))**

- **[CRM-20633](https://issues.civicrm.org/jira/browse/CRM-20633) custom field
  set displayed twice on register event Participant
  ([10551](https://github.com/civicrm/civicrm-core/pull/10551))**

  When switching event types on the backend form to add an event participant,
  custom fields common to all event types would be added repeatedly.

- **[CRM-20775](https://issues.civicrm.org/jira/browse/CRM-20775) Wrong is full
  results for API event get
  ([10568](https://github.com/civicrm/civicrm-core/pull/10568))**

  When Max Number of Participants event field is left empty, the API would
  return `1` for the `is_full`property instead of `0`.

- **[CRM-19745](https://issues.civicrm.org/jira/browse/CRM-19745) Image URL
  field doesn't show up on CiviEvent Additional Participants Profile
  ([9777](https://github.com/civicrm/civicrm-core/pull/9777))**

### CiviMail

- **[CRM-20781](https://issues.civicrm.org/jira/browse/CRM-20781) Truncate long
  text in mail listing
  ([10576](https://github.com/civicrm/civicrm-core/pull/10576))**

  Long values in columns would crowd other columns off the screen or into
  illegibility.

- **[CRM-20902](https://issues.civicrm.org/jira/browse/CRM-20902) DB Syntax
  error on Mailing Opened Report
  ([10690](https://github.com/civicrm/civicrm-core/pull/10690))**

- **[CRM-20746](https://issues.civicrm.org/jira/browse/CRM-20746) CiviMail -
  text part of resubscribe confirmation mail contains html
  ([10528](https://github.com/civicrm/civicrm-core/pull/10528))**

- **[CRM-20412](https://issues.civicrm.org/jira/browse/CRM-20412) mailing
  report: unique opens detail view inaccurate
  ([10558](https://github.com/civicrm/civicrm-core/pull/10558))**

- **[CRM-20411](https://issues.civicrm.org/jira/browse/CRM-20411) mailing tab
  listing: MySQL 5.7 group by error
  ([10562](https://github.com/civicrm/civicrm-core/pull/10562) and
  [10541](https://github.com/civicrm/civicrm-core/pull/10541))**  

- **[CRM-20713](https://issues.civicrm.org/jira/browse/CRM-20713) db error when
  populating mailing recipients because sms_provider_id is 'null'
  ([10487](https://github.com/civicrm/civicrm-core/pull/10487))**

### Backdrop Integration

- **Fix spelling to canvass for civicrm_engage
  ([40](https://github.com/civicrm/civicrm-backdrop/pull/40))**

- **Bug fixes - issues #22, #31, #33
  ([39](https://github.com/civicrm/civicrm-backdrop/pull/39))**

- **Improve Views checkbox value handling
  ([37](https://github.com/civicrm/civicrm-backdrop/pull/37))**

- **add new views handlers to hook_autoload_info
  ([38](https://github.com/civicrm/civicrm-backdrop/pull/38))**

- **Merge in civicrm/drupal from Dec 15, 2015 to June 21, 2017
  ([36](https://github.com/civicrm/civicrm-backdrop/pull/36))**

### Drupal Integration

- **[CRM-20525](https://issues.civicrm.org/jira/browse/CRM-20525) Webform Pay
  later sends Receipt email rather than Invoice email
  ([10306](https://github.com/civicrm/civicrm-core/pull/10306))**

- **[CRM-19976](https://issues.civicrm.org/jira/browse/CRM-19976) Drush: cannot
  disable civicrm debug
  ([457](https://github.com/civicrm/civicrm-drupal/pull/457))**

  While `drush civicrm-enable-debug` was defined, this adds the
  `civicrm-disable-debug` command.

### Joomla Integration

- **[CRM-19914](https://issues.civicrm.org/jira/browse/CRM-19914)
  civicrmHooks.php issues on windows
  ([10571](https://github.com/civicrm/civicrm-core/pull/10571))**

  This resolves problems locating the `civicrmHooks.php` file on Joomla sites in
  Windows.

## <a name="misc"></a>Miscellany

- **[CRM-20837](https://issues.civicrm.org/jira/browse/CRM-20837) Make setting
  bug more explicit
  ([10627](https://github.com/civicrm/civicrm-core/pull/10627))**

- **[CRM-20677](https://issues.civicrm.org/jira/browse/CRM-20677) Use
  generalised function to retrieve financial account
  ([10463](https://github.com/civicrm/civicrm-core/pull/10463))**

- **[CRM-20786](https://issues.civicrm.org/jira/browse/CRM-20786) Move
  deprecated utils functions to the import classes
  ([10578](https://github.com/civicrm/civicrm-core/pull/10578),
  [10580](https://github.com/civicrm/civicrm-core/pull/10580),
  [10579](https://github.com/civicrm/civicrm-core/pull/10579), and
  [10581](https://github.com/civicrm/civicrm-core/pull/10581))**

- **[CRM-20771](https://issues.civicrm.org/jira/browse/CRM-20771) Ensure that
  AddColumn in CRM_Upgrade_Incremental_Base can support translatable columns
  ([10561](https://github.com/civicrm/civicrm-core/pull/10561))**

- **[CRM-20833](https://issues.civicrm.org/jira/browse/CRM-20833) Change
  namespace for APIv4 entities
  ([10632](https://github.com/civicrm/civicrm-core/pull/10632) and
  [10625](https://github.com/civicrm/civicrm-core/pull/10625))**

  The namespace is now `Civi\Api4\Entity` rather than `Civi\Api4`.

- **[CRM-19726](https://issues.civicrm.org/jira/browse/CRM-19726)
  `CiviMailUtils::clearMessages()` should clear all messages by default
  ([10669](https://github.com/civicrm/civicrm-core/pull/10669))**

- **Misspelling ([10619](https://github.com/civicrm/civicrm-core/pull/10619))**

- **[CRM-20797](https://issues.civicrm.org/jira/browse/CRM-20797) Use is_payment
  to retrieve payments
  ([10587](https://github.com/civicrm/civicrm-core/pull/10587))**

- **Replace a couple of calls to deprecated function
  ([10527](https://github.com/civicrm/civicrm-core/pull/10527))**

- **[CRM-20758](https://issues.civicrm.org/jira/browse/CRM-20758) Fix deprecated
  fn call on import screen
  ([10544](https://github.com/civicrm/civicrm-core/pull/10544))**

- **[CRM-20541](https://issues.civicrm.org/jira/browse/CRM-20541) Edge case
  where DB connection is not available
  ([447](https://github.com/civicrm/civicrm-drupal/pull/447))**

  Certain static variables now use Drupal's built-in system.

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Arun Singh; Australian Greens - Seamus Lee; Brooks
Digital - Spencer Brooks; CEDC - Laryn Kragt Bakker; Circle Interactive - Dave
Jenkins; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
CompuCorp - Michael Devery; Coop SymbioTIC - Mathieu Lutfy; Dave Greenberg;
Electronic Frontier Foundation - Mark Burdett; Francesc Bassas i Bullich;
Freeform Solutions - Herb van den Dool; Fuzion - Chris Burgess, Eileen
McNaughton, Jitendra Purohit; Gizra - Aron Novak; JMA Consulting - Edsel Lopez,
Monish Deb, Pradeep Nayak; John Kingsnorth; Joinery - Allen Shaw; Joost Fock;
Klaas Eikelboom; Lighthouse Design and Consulting - Brian Shaughnessy; Mattias
Michaux; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting -
Matthew Wire; Oxfam Germany - Thomas Schüttler; Progressive Technology Project -
Jamie McClelland; Squiffle Consulting - Aidan Saunders; Wikimedia Foundation -
Eileen McNaughton, Maggie Epps

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Agileware Team; Arkadiusz Rzadkowolski; Blackfly Solutions - Alan
Dixon; CiviDesk - Nicolas Ganivet; CompuCorp - Davi Alexandre, Guanhuan Chen,
Jamie Novick, Mirela Stanila; DevMate - Adam Kwiatkowski; Donald Hirst; DotPro -
Diego Viegas; F. M. Andrimont; Fuzion - Peter Davis, Torrance Hodgson; JMA
Consulting - Joe Murray, Pradeep Nayak; Johan Vervloet; Jvillage Network - Dina
London; Korlon - Stuart Gaston; Lueck Data Systems - Michael Lueck; MC3 - Graham
Mitchell; Nathan Brettell; Oxfam Germany - Thomas Schüttler; Peter Bull; Phil
McKerracher; Semper IT - Karin Gerritsen; Skvare - Mark Hanna; Stephen
Palmstrom; Tadpole Collective - Kevin Cristiano; Upleaf - Osvaldo Gomez;
Wikimedia Foundation - Elliott Eggleston

## <a name="feedback"></a>Feedback

These release notes have been made possible by the diligent curation of Andie Hunt.
If you'd like to provide feedback on them, please login to https://chat.civicrm.org/civicrm
and contact `@agh1`.
