{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetBody1: TRigidBodyNode;
    procedure SetBody1(const Value: TRigidBodyNode);
    function GetBody2: TRigidBodyNode;
    procedure SetBody2(const Value: TRigidBodyNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdBody1: TSFNode;
    { Internal wrapper for property @code(Body1). This wrapper API may change, we advise to access simpler @code(Body1) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBody1: TSFNode read FFdBody1;
    {  }
    property Body1: TRigidBodyNode read GetBody1 write SetBody1;

    strict private FFdBody2: TSFNode;
    { Internal wrapper for property @code(Body2). This wrapper API may change, we advise to access simpler @code(Body2) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBody2: TSFNode read FFdBody2;
    {  }
    property Body2: TRigidBodyNode read GetBody2 write SetBody2;

    strict private FFdForceOutput: TMFString;
    { Internal wrapper for property @code(ForceOutput). This wrapper API may change, we advise to access simpler @code(ForceOutput) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdForceOutput: TMFString read FFdForceOutput;
    {  }
    procedure SetForceOutput(const Value: array of string); overload;
    {  }
    procedure SetForceOutput(const Value: TCastleStringList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractRigidJointNode ----------------------------------------------- }

function TAbstractRigidJointNode.GetBody1: TRigidBodyNode;
begin
  if FdBody1.Value is TRigidBodyNode then
    Result := TRigidBodyNode(FdBody1.Value)
  else
    Result := nil;
end;

procedure TAbstractRigidJointNode.SetBody1(const Value: TRigidBodyNode);
begin
  FdBody1.Send(Value);
end;

function TAbstractRigidJointNode.GetBody2: TRigidBodyNode;
begin
  if FdBody2.Value is TRigidBodyNode then
    Result := TRigidBodyNode(FdBody2.Value)
  else
    Result := nil;
end;

procedure TAbstractRigidJointNode.SetBody2(const Value: TRigidBodyNode);
begin
  FdBody2.Send(Value);
end;

procedure TAbstractRigidJointNode.SetForceOutput(const Value: array of string);
begin
  FdForceOutput.Send(Value);
end;

procedure TAbstractRigidJointNode.SetForceOutput(const Value: TCastleStringList);
begin
  FdForceOutput.Send(Value);
end;

class function TAbstractRigidJointNode.ClassX3DType: String;
begin
  Result := 'X3DRigidJointNode';
end;

procedure TAbstractRigidJointNode.CreateNode;
begin
  inherited;

  FFdBody1 := TSFNode.Create(Self, True, 'body1', [TRigidBodyNode]);
   FdBody1.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBody1);

  FFdBody2 := TSFNode.Create(Self, True, 'body2', [TRigidBodyNode]);
   FdBody2.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBody2);

  FFdForceOutput := TMFString.Create(Self, True, 'forceOutput', ['NONE']);
   FdForceOutput.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdForceOutput);

  DefaultContainerField := 'joints';
end;

{$endif read_implementation}
