{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetLoa: Integer;
    procedure SetLoa(const Value: Integer);
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetSkeletalConfiguration: String;
    procedure SetSkeletalConfiguration(const Value: String);
    function GetSkinBindingCoord: TAbstractCoordinateNode;
    procedure SetSkinBindingCoord(const Value: TAbstractCoordinateNode);
    function GetSkinBindingNormal: TAbstractNormalNode;
    procedure SetSkinBindingNormal(const Value: TAbstractNormalNode);
    function GetSkinNormal: TAbstractNormalNode;
    procedure SetSkinNormal(const Value: TAbstractNormalNode);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
    function GetVersion: String;
    procedure SetVersion(const Value: String);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdCenter: TSFVec3f;
    { Internal wrapper for property @code(Center). This wrapper API may change, we advise to access simpler @code(Center) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCenter: TSFVec3f read FFdCenter;
    {  }
    property Center: TVector3 read GetCenter write SetCenter;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @code(Description). This wrapper API may change, we advise to access simpler @code(Description) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdInfo: TMFString;
    { Internal wrapper for property @code(Info). This wrapper API may change, we advise to access simpler @code(Info) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInfo: TMFString read FFdInfo;
    {  }
    procedure SetInfo(const Value: array of string); overload;
    {  }
    procedure SetInfo(const Value: TCastleStringList); overload;

    strict private FFdJoints: TMFNode;
    { Internal wrapper for property @code(Joints). This wrapper API may change, we advise to access simpler @code(Joints) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdJoints: TMFNode read FFdJoints;
    {  }
    procedure SetJoints(const Value: array of THAnimJointNode);

    strict private FFdJointBindingPositions: TMFVec3f;
    { Internal wrapper for property @code(JointBindingPositions). This wrapper API may change, we advise to access simpler @code(JointBindingPositions) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdJointBindingPositions: TMFVec3f read FFdJointBindingPositions;
    {  }
    procedure SetJointBindingPositions(const Value: array of TVector3); overload;
    {  }
    procedure SetJointBindingPositions(const Value: TVector3List); overload;

    strict private FFdJointBindingRotations: TMFRotation;
    { Internal wrapper for property @code(JointBindingRotations). This wrapper API may change, we advise to access simpler @code(JointBindingRotations) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdJointBindingRotations: TMFRotation read FFdJointBindingRotations;
    {  }
    procedure SetJointBindingRotations(const Value: array of TVector4); overload;
    {  }
    procedure SetJointBindingRotations(const Value: TVector4List); overload;

    strict private FFdJointBindingScales: TMFVec3f;
    { Internal wrapper for property @code(JointBindingScales). This wrapper API may change, we advise to access simpler @code(JointBindingScales) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdJointBindingScales: TMFVec3f read FFdJointBindingScales;
    {  }
    procedure SetJointBindingScales(const Value: array of TVector3); overload;
    {  }
    procedure SetJointBindingScales(const Value: TVector3List); overload;

    strict private FFdLoa: TSFInt32;
    { Internal wrapper for property @code(Loa). This wrapper API may change, we advise to access simpler @code(Loa) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLoa: TSFInt32 read FFdLoa;
    {  }
    property Loa: Integer read GetLoa write SetLoa;

    strict private FFdMotions: TMFNode;
    { Internal wrapper for property @code(Motions). This wrapper API may change, we advise to access simpler @code(Motions) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMotions: TMFNode read FFdMotions;
    {  }
    procedure SetMotions(const Value: array of THAnimMotionNode);

    strict private FFdMotionsEnabled: TMFBool;
    { Internal wrapper for property @code(MotionsEnabled). This wrapper API may change, we advise to access simpler @code(MotionsEnabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMotionsEnabled: TMFBool read FFdMotionsEnabled;
    {  }
    procedure SetMotionsEnabled(const Value: array of boolean); overload;
    {  }
    procedure SetMotionsEnabled(const Value: TBooleanList); overload;

    strict private FFdName: TSFString;
    { Internal wrapper for property @code(NameField). This wrapper API may change, we advise to access simpler @code(NameField) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdName: TSFString read FFdName;
    {  }
    property NameField: String read GetNameField write SetNameField;

    strict private FFdRotation: TSFRotation;
    { Internal wrapper for property @code(Rotation). This wrapper API may change, we advise to access simpler @code(Rotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRotation: TSFRotation read FFdRotation;
    {  }
    property Rotation: TVector4 read GetRotation write SetRotation;

    strict private FFdScale: TSFVec3f;
    { Internal wrapper for property @code(Scale). This wrapper API may change, we advise to access simpler @code(Scale) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdScale: TSFVec3f read FFdScale;
    {  }
    property Scale: TVector3 read GetScale write SetScale;

    strict private FFdScaleOrientation: TSFRotation;
    { Internal wrapper for property @code(ScaleOrientation). This wrapper API may change, we advise to access simpler @code(ScaleOrientation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdScaleOrientation: TSFRotation read FFdScaleOrientation;
    {  }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;

    strict private FFdSegments: TMFNode;
    { Internal wrapper for property @code(Segments). This wrapper API may change, we advise to access simpler @code(Segments) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSegments: TMFNode read FFdSegments;
    {  }
    procedure SetSegments(const Value: array of THAnimSegmentNode);

    strict private FFdSites: TMFNode;
    { Internal wrapper for property @code(Sites). This wrapper API may change, we advise to access simpler @code(Sites) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSites: TMFNode read FFdSites;
    {  }
    procedure SetSites(const Value: array of THAnimSiteNode);

    strict private FFdSkeletalConfiguration: TSFString;
    { Internal wrapper for property @code(SkeletalConfiguration). This wrapper API may change, we advise to access simpler @code(SkeletalConfiguration) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSkeletalConfiguration: TSFString read FFdSkeletalConfiguration;
    {  }
    property SkeletalConfiguration: String read GetSkeletalConfiguration write SetSkeletalConfiguration;

    strict private FFdSkeleton: TMFNode;
    { Internal wrapper for property @code(Skeleton). This wrapper API may change, we advise to access simpler @code(Skeleton) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSkeleton: TMFNode read FFdSkeleton;
    {  }
    procedure SetSkeleton(const Value: array of TX3DNode);

    strict private FFdSkin: TMFNode;
    { Internal wrapper for property @code(Skin). This wrapper API may change, we advise to access simpler @code(Skin) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSkin: TMFNode read FFdSkin;
    {  }
    procedure SetSkin(const Value: array of TAbstractChildNode);

    strict private FFdSkinBindingCoord: TSFNode;
    { Internal wrapper for property @code(SkinBindingCoord). This wrapper API may change, we advise to access simpler @code(SkinBindingCoord) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSkinBindingCoord: TSFNode read FFdSkinBindingCoord;
    {  }
    property SkinBindingCoord: TAbstractCoordinateNode read GetSkinBindingCoord write SetSkinBindingCoord;

    strict private FFdSkinBindingNormal: TSFNode;
    { Internal wrapper for property @code(SkinBindingNormal). This wrapper API may change, we advise to access simpler @code(SkinBindingNormal) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSkinBindingNormal: TSFNode read FFdSkinBindingNormal;
    {  }
    property SkinBindingNormal: TAbstractNormalNode read GetSkinBindingNormal write SetSkinBindingNormal;

    strict private FFdSkinCoord: TSFNode;
    { Internal wrapper for property @code(SkinCoord). This wrapper API may change, we advise to access simpler @code(SkinCoord) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSkinCoord: TSFNode read FFdSkinCoord;

    strict private FFdSkinNormal: TSFNode;
    { Internal wrapper for property @code(SkinNormal). This wrapper API may change, we advise to access simpler @code(SkinNormal) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSkinNormal: TSFNode read FFdSkinNormal;
    {  }
    property SkinNormal: TAbstractNormalNode read GetSkinNormal write SetSkinNormal;

    strict private FFdTranslation: TSFVec3f;
    { Internal wrapper for property @code(Translation). This wrapper API may change, we advise to access simpler @code(Translation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTranslation: TSFVec3f read FFdTranslation;
    {  }
    property Translation: TVector3 read GetTranslation write SetTranslation;

    strict private FFdVersion: TSFString;
    { Internal wrapper for property @code(Version). This wrapper API may change, we advise to access simpler @code(Version) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdVersion: TSFString read FFdVersion;
    {  }
    property Version: String read GetVersion write SetVersion;

    strict private FFdViewpoints: TMFNode;
    { Internal wrapper for property @code(Viewpoints). This wrapper API may change, we advise to access simpler @code(Viewpoints) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdViewpoints: TMFNode read FFdViewpoints;
    {  }
    procedure SetViewpoints(const Value: array of TX3DNode);

    strict private FFdBboxCenter: TSFVec3f;
    { Internal wrapper for property @code(BboxCenter). This wrapper API may change, we advise to access simpler @code(BboxCenter) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxCenter: TSFVec3f read FFdBboxCenter;
    {  }
    property BBox: TBox3D read GetBBox write SetBBox;

    strict private FFdBboxSize: TSFVec3f;
    { Internal wrapper for property @code(BboxSize). This wrapper API may change, we advise to access simpler @code(BboxSize) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxSize: TSFVec3f read FFdBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimHumanoidNode ----------------------------------------------- }

function THAnimHumanoidNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure THAnimHumanoidNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

function THAnimHumanoidNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure THAnimHumanoidNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

procedure THAnimHumanoidNode.SetInfo(const Value: array of string);
begin
  FdInfo.Send(Value);
end;

procedure THAnimHumanoidNode.SetInfo(const Value: TCastleStringList);
begin
  FdInfo.Send(Value);
end;

procedure THAnimHumanoidNode.SetJoints(const Value: array of THAnimJointNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimJointNode));
  FdJoints.Send(A);
end;

procedure THAnimHumanoidNode.SetJointBindingPositions(const Value: array of TVector3);
begin
  FdJointBindingPositions.Send(Value);
end;

procedure THAnimHumanoidNode.SetJointBindingPositions(const Value: TVector3List);
begin
  FdJointBindingPositions.Send(Value);
end;

procedure THAnimHumanoidNode.SetJointBindingRotations(const Value: array of TVector4);
begin
  FdJointBindingRotations.Send(Value);
end;

procedure THAnimHumanoidNode.SetJointBindingRotations(const Value: TVector4List);
begin
  FdJointBindingRotations.Send(Value);
end;

procedure THAnimHumanoidNode.SetJointBindingScales(const Value: array of TVector3);
begin
  FdJointBindingScales.Send(Value);
end;

procedure THAnimHumanoidNode.SetJointBindingScales(const Value: TVector3List);
begin
  FdJointBindingScales.Send(Value);
end;

function THAnimHumanoidNode.GetLoa: Integer;
begin
  Result := FdLoa.Value;
end;

procedure THAnimHumanoidNode.SetLoa(const Value: Integer);
begin
  FdLoa.Send(Value);
end;

procedure THAnimHumanoidNode.SetMotions(const Value: array of THAnimMotionNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimMotionNode));
  FdMotions.Send(A);
end;

procedure THAnimHumanoidNode.SetMotionsEnabled(const Value: array of boolean);
begin
  FdMotionsEnabled.Send(Value);
end;

procedure THAnimHumanoidNode.SetMotionsEnabled(const Value: TBooleanList);
begin
  FdMotionsEnabled.Send(Value);
end;

function THAnimHumanoidNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimHumanoidNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimHumanoidNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure THAnimHumanoidNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function THAnimHumanoidNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure THAnimHumanoidNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function THAnimHumanoidNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure THAnimHumanoidNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

procedure THAnimHumanoidNode.SetSegments(const Value: array of THAnimSegmentNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSegmentNode));
  FdSegments.Send(A);
end;

procedure THAnimHumanoidNode.SetSites(const Value: array of THAnimSiteNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSiteNode));
  FdSites.Send(A);
end;

function THAnimHumanoidNode.GetSkeletalConfiguration: String;
begin
  Result := FdSkeletalConfiguration.Value;
end;

procedure THAnimHumanoidNode.SetSkeletalConfiguration(const Value: String);
begin
  FdSkeletalConfiguration.Send(Value);
end;

procedure THAnimHumanoidNode.SetSkeleton(const Value: array of TX3DNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TX3DNode));
  FdSkeleton.Send(A);
end;

procedure THAnimHumanoidNode.SetSkin(const Value: array of TAbstractChildNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractChildNode));
  FdSkin.Send(A);
end;

function THAnimHumanoidNode.GetSkinBindingCoord: TAbstractCoordinateNode;
begin
  if FdSkinBindingCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdSkinBindingCoord.Value)
  else
    Result := nil;
end;

procedure THAnimHumanoidNode.SetSkinBindingCoord(const Value: TAbstractCoordinateNode);
begin
  FdSkinBindingCoord.Send(Value);
end;

function THAnimHumanoidNode.GetSkinBindingNormal: TAbstractNormalNode;
begin
  if FdSkinBindingNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdSkinBindingNormal.Value)
  else
    Result := nil;
end;

procedure THAnimHumanoidNode.SetSkinBindingNormal(const Value: TAbstractNormalNode);
begin
  FdSkinBindingNormal.Send(Value);
end;

function THAnimHumanoidNode.GetSkinNormal: TAbstractNormalNode;
begin
  if FdSkinNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdSkinNormal.Value)
  else
    Result := nil;
end;

procedure THAnimHumanoidNode.SetSkinNormal(const Value: TAbstractNormalNode);
begin
  FdSkinNormal.Send(Value);
end;

function THAnimHumanoidNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure THAnimHumanoidNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

function THAnimHumanoidNode.GetVersion: String;
begin
  Result := FdVersion.Value;
end;

procedure THAnimHumanoidNode.SetVersion(const Value: String);
begin
  FdVersion.Send(Value);
end;

procedure THAnimHumanoidNode.SetViewpoints(const Value: array of TX3DNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TX3DNode));
  FdViewpoints.Send(A);
end;

function THAnimHumanoidNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure THAnimHumanoidNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

class function THAnimHumanoidNode.ClassX3DType: String;
begin
  Result := 'HAnimHumanoid';
end;

procedure THAnimHumanoidNode.CreateNode;
begin
  inherited;

  FFdCenter := TSFVec3f.Create(Self, True, 'center', Vector3(0, 0, 0));
   FdCenter.ChangeAlways := chTransform;
  AddField(FFdCenter);

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chNone;
  AddField(FFdDescription);

  FFdInfo := TMFString.Create(Self, True, 'info', []);
   FdInfo.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInfo);

  FFdJoints := TMFNode.Create(Self, True, 'joints', [THAnimJointNode]);
   FdJoints.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdJoints);

  FFdJointBindingPositions := TMFVec3f.Create(Self, True, 'jointBindingPositions', []);
   FdJointBindingPositions.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdJointBindingPositions);

  FFdJointBindingRotations := TMFRotation.Create(Self, True, 'jointBindingRotations', []);
   FdJointBindingRotations.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdJointBindingRotations);

  FFdJointBindingScales := TMFVec3f.Create(Self, True, 'jointBindingScales', []);
   FdJointBindingScales.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdJointBindingScales);

  FFdLoa := TSFInt32.Create(Self, True, 'loa', -1);
   FdLoa.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLoa);

  FFdMotions := TMFNode.Create(Self, True, 'motions', [THAnimMotionNode]);
   FdMotions.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMotions);

  FFdMotionsEnabled := TMFBool.Create(Self, True, 'motionsEnabled', []);
   FdMotionsEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMotionsEnabled);

  FFdName := TSFString.Create(Self, True, 'name', '');
   FdName.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdName);

  FFdRotation := TSFRotation.Create(Self, True, 'rotation', Vector3(0, 0, 1), 0);
   FdRotation.ChangeAlways := chTransform;
  AddField(FFdRotation);

  FFdScale := TSFVec3f.Create(Self, True, 'scale', Vector3(1, 1, 1));
   FdScale.ChangeAlways := chTransform;
  AddField(FFdScale);

  FFdScaleOrientation := TSFRotation.Create(Self, True, 'scaleOrientation', Vector3(0, 0, 1), 0);
   FdScaleOrientation.ChangeAlways := chTransform;
  AddField(FFdScaleOrientation);

  FFdSegments := TMFNode.Create(Self, True, 'segments', [THAnimSegmentNode]);
   FdSegments.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSegments);

  FFdSites := TMFNode.Create(Self, True, 'sites', [THAnimSiteNode]);
   FdSites.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSites);

  FFdSkeletalConfiguration := TSFString.Create(Self, True, 'skeletalConfiguration', 'BASIC');
   FdSkeletalConfiguration.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkeletalConfiguration);

  FFdSkeleton := TMFNode.Create(Self, True, 'skeleton', [THAnimJointNode, THAnimSiteNode]);
   FdSkeleton.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkeleton);

  FFdSkin := TMFNode.Create(Self, True, 'skin', [TAbstractChildNode]);
   FdSkin.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkin);

  FFdSkinBindingCoord := TSFNode.Create(Self, True, 'skinBindingCoord', [TAbstractCoordinateNode]);
   FdSkinBindingCoord.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkinBindingCoord);

  FFdSkinBindingNormal := TSFNode.Create(Self, True, 'skinBindingNormal', [TAbstractNormalNode]);
   FdSkinBindingNormal.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkinBindingNormal);

  FFdSkinCoord := TSFNode.Create(Self, True, 'skinCoord', [TAbstractCoordinateNode]);
   FdSkinCoord.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkinCoord);

  FFdSkinNormal := TSFNode.Create(Self, True, 'skinNormal', [TAbstractNormalNode]);
   FdSkinNormal.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkinNormal);

  FFdTranslation := TSFVec3f.Create(Self, True, 'translation', Vector3(0, 0, 0));
   FdTranslation.ChangeAlways := chTransform;
  AddField(FFdTranslation);

  FFdVersion := TSFString.Create(Self, True, 'version', '');
   FdVersion.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdVersion);

  FFdViewpoints := TMFNode.Create(Self, True, 'viewpoints', [THAnimSiteNode, TAbstractViewpointNode, TViewpointGroupNode]);
   FdViewpoints.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdViewpoints);

  FFdBboxCenter := TSFVec3f.Create(Self, False, 'bboxCenter', Vector3(0, 0, 0));
   FdBboxCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxCenter);

  FFdBboxSize := TSFVec3f.Create(Self, False, 'bboxSize', Vector3(-1, -1, -1));
   FdBboxSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxSize);
end;

{$endif read_implementation}
