#|$ACL2s-Preamble$;
;; Julien Schmaltz
;; Generic Set of Nodes
;; June 17th 2005
;; File: GeNoC-nodeset.lisp
;; modified byAmr HELMY

;;31st october 2007
(begin-book);$ACL2s-Preamble$|#

;;use of Defspec
;; this allows us to removethe (defthm t) at the end of each instance file
(in-package "ACL2")
(include-book "make-event/defspec"  :dir :system)

(defspec GenericNodeSet
  ;; abstract set of nodes
  ;; the set is generated by the following function
  ;; its argument is the parameters
  (((NodesetGenerator *) => *)
   ;; the following predicate recognizes valid parameters
   ((ValidParamsp *) => *)
   ;; the following predicate recognizes a valid node
   ((Nodep *) => *)
   ((NodeSetp *) => *))

  ;; local witnesses
  (local (defun ValidParamsp (x)
           (declare (ignore x)) t))

  (local (defun NodesetGenerator (x)
           (if (zp x) nil
             (cons x (NodesetGenerator (1- x))))))

  (local (defun Nodep (n)
           (natp n)))

  (local (defun NodeSetp (l)
           (if (endp l) t
             (and (Nodep (car l))
                  (NodeSetp (cdr l))))))

  (defthm nodeset-generates-valid-nodes
    ;; the result of the nodesetgenerator is a valid list of nodes
    (implies (ValidParamsp params)
             (NodeSetp (NodesetGenerator params))))

  ;; we add a generic lemma
  (defthm subsets-are-valid
    ;; this lemma is used to prove that routes are made of valid nodes
    (implies (and (NodeSetp x)
                  (subsetp y x))
             (NodeSetp y)))


  (defthm true-listp-nodesetgenerator
    (implies (Validparamsp x)
             (true-listp (NodesetGenerator x))))

  ) ;; end GenericNodeSet

